#!/bin/sh
#
########################################
#
#       Backup Automation Script for Ovirt 
#       Author: Dariusz Kryszak
#       email: dariusz.kryszak@i-primus.pl
#       Comp: I-Primus Dariusz Kryszak
#
########################################

###
# Variables & Params
# 
#   Params:
# remember to change the oryginal path to scripts or make some variables
#
#
#                       
#
V_MAIL_TO="<your_email_address>"
#
export HOSTNAME=`/bin/hostname`

#@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

#------------------------------------------
#       START
#-----------------------------------------


VM=<your VM Name of the ovirt environemt>
V_DATE=`date +"%Y%m%d_%H%M%S"`

run="/usr/bin/python /scripts/backup/src/backup_cold.py $VM"
#run="hostname"

#LOG Dir
#
V_LOG_DIR="/scripts/backup/logs/`date +"%Y%m%d"`"
	if [ ! -e "$V_LOG_DIR" ] ; then 
		mkdir -p "$V_LOG_DIR"
		echo "`date +"%Y-%m-%d_%H:%M:%S"` : INFO : Log dir has been created" >> "$V_LOG_DIR/job_ovirt_bck_$VM_$V_DATE.log"
	fi

V_LOG_FILE="$V_LOG_DIR/job_ovirt_bck_$VM_$V_DATE.log"


#
# Mark job running
#

V_PROC_FLG=`echo $V_LOG_DIR`/flg_running_bck_$VM

		if [ ! -e "$V_PROC_FLG" ] ; then 
			echo $V_DATE > $V_PROC_FLG
			$run >> $V_LOG_FILE
			if [ "$?" == "0" ] ; then
				echo "`echo $V_DATE` : INFO : Backup call procedure has been started" >> $V_LOG_FILE
				rm -fr $V_PROC_FLG
				echo "`date +"%Y-%m-%d_%H:%M:%S"` : INFO : Backup call procedure has been finished" >> $V_LOG_FILE
				subject=`hostname`-`echo ovirt $VM backup procedure`-SUCCEEDED
				echo "`date +"%Y-%m-%d_%H:%M:%S"` : INFO : Backup call procedure has been finished" | mailx "-s $subject" $V_MAIL_TO				
			else
				rm -fr $V_PROC_FLG
				echo "`date +"%Y-%m-%d_%H:%M:%S"` : ERROR : Backup call procedure faild" >> $V_LOG_FILE
				subject=`hostname`-`echo ovirt $VM backup proedure`-ERROR
				echo "`date +"%Y-%m-%d_%H:%M:%S"` : ERROR : Backup call procedure faild" | mailx "-s $subject" $V_MAIL_TO
			fi
		else 
				echo "`date +"%Y-%m-%d_%H:%M:%S"` : ERROR : Backup call procedure is currently running" >> $V_LOG_FILE
				subject=`hostname`-`echo ovirt $VM backup proedure`-ERROR
				echo "`date +"%Y-%m-%d_%H:%M:%S"` : ERROR : Backup call procedure is currently running" | mailx "-s $subject" $V_MAIL_TO
				
		fi	


#------------------------------------------------------
#       End
#------------------------------------------------------
echo "\n********************************************" >> $V_LOG_FILE
echo "\n`date +"%H:%M:%S"` INFO     ovirt backup procedure has been ended ... " >> $V_LOG_FILE
echo "********************************************" >> $V_LOG_FILE
