#!/usr/bin/python
# -*- coding: utf-8 -*-

####
# This scripts performs a icleanup old backups of the argument-specified VM, to an export domain
# Usage : backup_cln_snap.py <vm_name>
# You need to modify the RHEV_URL, RHEV_USERNAME, RHEV_PASSWORD and
# EXPORT_DOMAIN_NAME variables below before use
###
import datetime
from ovirtsdk.api import API
from ovirtsdk.xml import params
from ovirtsdk import infrastructure
import sys
from time import sleep, gmtime, strftime


RHEV_URL = "https://<ip or url of the rhevm portal(main part)>"
RHEV_USERNAME = "usernam@<domain>"
RHEV_PASSWORD = ""
EXPORT_DOMAIN_NAME = "<exported type storage domain used as backup>"



try:

    ################################################################################ Check parameters
    if len(sys.argv) < 2:
        print "Usage : backup-vm.py <vm_name>"
        exit(2)


    ################################################################################ Connection to RHEV
    print strftime("%a, %d %b %Y %H:%M:%S", gmtime()) + " : Connecting to RHEV"
    api = API(url=RHEV_URL,
              username=RHEV_USERNAME,
              password=RHEV_PASSWORD,
              ca_file="/etc/pki/ovirt-engine/ca.pem")
    print "Connected to %s successfully!" % api.get_product_info().name


    ################################################################################ Display information about the VM
    print "\n" + strftime("%a, %d %b %Y %H:%M:%S",
                          gmtime()) + " : Gathering information about the virtual machine %s" % (sys.argv[1])
    vm_obj = api.vms.get(name=sys.argv[1])
    print "VM name : %s" % (vm_obj.name)
    initial_status = vm_obj.status.state
    print "Status : %s" % (initial_status)
    vm_cluster = api.clusters.get(id=vm_obj.cluster.id)
    print "Cluster : %s" % (vm_cluster.get_name())
    vm_dc = api.datacenters.get(id=vm_cluster.data_center.id)
    print "Datacenter : %s" % (vm_dc.get_name())
    ################################################################################ Check export domain availability
    print "\n" + strftime("%a, %d %b %Y %H:%M:%S",
                          gmtime()) + " : Ensuring that the export domain %s has been attached and activated on a datacenter" % (
        EXPORT_DOMAIN_NAME)


    try:
        ds_nm = []
        ds_nm_gl = []

        for i in range(len(vm_dc.storagedomains.list())):
            ds_nm.append(vm_dc.storagedomains.get(id=vm_dc.storagedomains.list()[i].id).name)

        for i in range(len(api.storagedomains.list())):
            ds_nm_gl.append(api.storagedomains.get(id=api.storagedomains.list()[i].id).name)

        if EXPORT_DOMAIN_NAME in ds_nm:
            ds_exp_stat=vm_dc.storagedomains.get(name=EXPORT_DOMAIN_NAME).get_status().get_state()
            if ds_exp_stat!='active':
                vm_dc.storagedomains.get(name=EXPORT_DOMAIN_NAME).activate()
            else:
                print "Domain storage "+ EXPORT_DOMAIN_NAME +" for backup is available."
        else:
            if EXPORT_DOMAIN_NAME in ds_nm_gl:
                    print "Add storage domain "+EXPORT_DOMAIN_NAME+" to "+ vm_dc.get_name()
                    sd_export = api.storagedomains.get(name=EXPORT_DOMAIN_NAME)
                    print "Activating "+EXPORT_DOMAIN_NAME
                    dc_export = vm_dc.storagedomains.add(sd_export)
                    vm_dc.storagedomains.get(name=EXPORT_DOMAIN_NAME).activate()
            else:
                    print "Domain storage "+ EXPORT_DOMAIN_NAME +" does not exists."
                    exit(1)

    except Exception as e:
         print 'Access to Backup storage problem:\n%s' % str(e)
         exit(1)

################ Cleanup old backups from backup export domain

    print "\n" + strftime("%a, %d %b %Y %H:%M:%S",
                          gmtime()) + " : Starting of the cleanup process for vm "+vm_obj.name+ " on the " + " "+EXPORT_DOMAIN_NAME
    try:
        str_dom_obj = api.storagedomains.get(name=EXPORT_DOMAIN_NAME)
        vm_exp_list = str_dom_obj.vms.list()

        vm_del_patt = vm_obj.name+"_BACKUP_"

        vm_del_arr_id = []
        oo = str_dom_obj.vms.list()
        for i in range(len(str_dom_obj.vms.list())):
            vm_del_obj = str_dom_obj.vms.get(id=vm_exp_list[i].id)
            vm_del_name = str_dom_obj.vms.get(id=vm_exp_list[i].id).name
            if vm_del_patt in vm_del_name:
               vm_del_arr_id.append(vm_del_obj.id)

        for i in range(len(vm_del_arr_id)):
             vm_del_id_run = vm_del_arr_id[i]
             vm_del_nm_run = str_dom_obj.vms.get(id=vm_del_arr_id[i]).name
             str_dom_obj.vms.get(id=vm_del_id_run).delete()
             while vm_del_id_run in [b.id for b in str_dom_obj.vms.list()]:
                sleep(3)
                sys.stdout.write('.')
             print "\n"+"VM exported backup  "+ vm_del_nm_run + " has been droped."

    except Exception as e:
         print 'Access to Backup storage problem:\n%s' % str(e)
         exit(1)

################ End - Cleanup old backups from backup export domain

################ Cleanup old snapshots from backup export domain

################################################################################ Shutdown the VM
    if api.vms.get(name=sys.argv[1]).status.state != 'down':
        print '\n"+strftime("%a, %d %b %Y %H:%M:%S", gmtime())+" : Shutdown VM'
        api.vms.get(name=sys.argv[1]).shutdown()
        print 'Waiting for VM to reach Down status'
        while api.vms.get(name=sys.argv[1]).status.state != 'down':
            sys.stdout.write('.')
            sleep(1)
        print '\nOK'
    else:
        print "\n"+strftime("%a, %d %b %Y %H:%M:%S", gmtime())+" : VM already down"
        
################################################################################ END - Shutdown the VM
################################################################################ Remove old snapshots

    try:
        snap_patt = "BACKUP_"
        vm_snam_list = vm_obj.snapshots.list()
        snap_arr_id = []
        for i in range(len(vm_obj.snapshots.list())):
            vm_obj_snp = vm_obj.snapshots.get(id=vm_obj.snapshots.list()[i].id)
            vm_snap_desc = vm_obj_snp.description
            if snap_patt in vm_snap_desc:
                snap_arr_id.append(vm_obj_snp.id)

        print "\n"+"Starting snapshot removing process."

        for i in range(len(snap_arr_id)):
            vm_obj.snapshots.get(id=snap_arr_id[i]).delete()
            vm_snap_status = vm_obj.snapshots.get(id=snap_arr_id[i]).snapshot_status
            vm_id = vm_obj.snapshots.get(id=snap_arr_id[i]).id
            vm_desc = vm_obj.snapshots.get(id=snap_arr_id[i]).description
            while vm_id in [b.id for b in api.vms.get(name=vm_obj.name).snapshots.list()]:
                sleep(3)
                sys.stdout.write('.')
            print "\n"+"Snapshot "+ vm_desc + " has been droped."
    except Exception as e:
         print 'Could not remove old snapshots:\n%s' % str(e)
         exit(1)

 ################################################################################ END - Remove old snapshots
 ################################################################################ Restart of the VM
    if initial_status == 'up':
        print "\n"+strftime("%a, %d %b %Y %H:%M:%S", gmtime())+" : Virtual machine was up before the backup. Restoring state to up."
        if api.vms.get(name=sys.argv[1]).status.state != 'up':
            print 'Starting VM'
            api.vms.get(name=sys.argv[1]).start()
            print 'Waiting for VM to reach Up status'
            while api.vms.get(name=sys.argv[1]).status.state != 'up':
                sleep(1)
                sys.stdout.write('.')
            print '\nOK'
        else:
            print 'VM is already up'
    else:
        print "\n"+strftime("%a, %d %b %Y %H:%M:%S", gmtime())+" : Virtual machine was down before the backup. Keeping it down."

################################################################################ END - Restart of the VM
    api.disconnect()
    print "\n" + strftime("%a, %d %b %Y %H:%M:%S", gmtime()) + " : BACKUP OK"
    exit(0)


except Exception as ex:
    print "\n" + strftime("%a, %d %b %Y %H:%M:%S", gmtime()) + " : Unexpected error: %s" % ex
exit(1)
