#!/usr/bin/python
# -*- coding: utf-8 -*-

####
# This scripts performs a cold-backup of the argument-specified VM, to an export domain
# Usage : backup_cold.py <vm_name>
# You need to modify the RHEV_URL, RHEV_USERNAME, RHEV_PASSWORD and
# EXPORT_DOMAIN_NAME variables below before use
###

from ovirtsdk.api import API
from ovirtsdk.xml import params
from time import sleep, gmtime, strftime
import sys
import datetime 

RHEV_URL = "https://<ip or url of the rhevm portal(main part)>"
RHEV_USERNAME = "usernam@<domain>"
RHEV_PASSWORD = ""
EXPORT_DOMAIN_NAME = "<exported type storage domain used as backup>"

RHEV_TMS = datetime.datetime.now().strftime("%Y%m%d_%H%M%S")


try:

    ################################################################################ Check parameters
    if len(sys.argv) < 2:
        print "Usage : backup-vm.py <vm_name>"
        exit(2)


    ################################################################################ Connection to RHEV
    print strftime("%a, %d %b %Y %H:%M:%S", gmtime())+" : Connecting to RHEV"
    api = API ( url=RHEV_URL,
                username=RHEV_USERNAME,
                password=RHEV_PASSWORD,
                ca_file="/etc/pki/ovirt-engine/ca.pem")
    print "Connected to %s successfully!" % api.get_product_info().name


    ################################################################################ Display information about the VM
    print "\n"+strftime("%a, %d %b %Y %H:%M:%S", gmtime())+" : Gathering information about the virtual machine %s" % (sys.argv[1])
    vm = api.vms.get(name=sys.argv[1])
    print "VM name : %s" % (vm.name)
    initial_status = vm.status.state
    print "Status : %s" % (initial_status)
    vm_cluster = api.clusters.get(id=vm.cluster.id)
    print "Cluster : %s" % (vm_cluster.get_name())
    vm_dc = api.datacenters.get(id=vm_cluster.data_center.id)
    print "Datacenter : %s" % (vm_dc.get_name())


        ################################################################################ Check export domain availability
    print "\n" + strftime("%a, %d %b %Y %H:%M:%S",
                          gmtime()) + " : Ensuring that the export domain %s has been attached and activated on a datacenter" % (
        EXPORT_DOMAIN_NAME)


    try:
        ds_nm = []
        ds_nm_gl = []

        for i in range(len(vm_dc.storagedomains.list())):
            ds_nm.append(vm_dc.storagedomains.get(id=vm_dc.storagedomains.list()[i].id).name)

        for i in range(len(api.storagedomains.list())):
            ds_nm_gl.append(api.storagedomains.get(id=api.storagedomains.list()[i].id).name)

        if EXPORT_DOMAIN_NAME in ds_nm:
            ds_exp_stat=vm_dc.storagedomains.get(name=EXPORT_DOMAIN_NAME).get_status().get_state()
            if ds_exp_stat!='active':
                vm_dc.storagedomains.get(name=EXPORT_DOMAIN_NAME).activate()
            else:
                print "Domain storage "+ EXPORT_DOMAIN_NAME +" for backup is available."
        else:
            if EXPORT_DOMAIN_NAME in ds_nm_gl:
                    print "Add storage domain "+EXPORT_DOMAIN_NAME+" to "+ vm_dc.get_name()
                    sd_export = api.storagedomains.get(name=EXPORT_DOMAIN_NAME)
                    print "Activating "+EXPORT_DOMAIN_NAME
                    dc_export = vm_dc.storagedomains.add(sd_export)
                    vm_dc.storagedomains.get(name=EXPORT_DOMAIN_NAME).activate()
            else:
                    print "Domain storage "+ EXPORT_DOMAIN_NAME +" does not exists."


    except Exception as e:
         print 'Access to Backup storage problem:\n%s' % str(e)
         exit(1)


    ################################################################################ Shutdown the VM
    if api.vms.get(name=sys.argv[1]).status.state != 'down':
        print '\n'+strftime("%a, %d %b %Y %H:%M:%S", gmtime())+" : Shutdown VM"
        api.vms.get(name=sys.argv[1]).shutdown()
        print 'Waiting for VM to reach Down status'
        while api.vms.get(name=sys.argv[1]).status.state != 'down':
            sys.stdout.write('.')
            sleep(1)
        print '\nOK'
    else:
        print "\n"+strftime("%a, %d %b %Y %H:%M:%S", gmtime())+" : VM already down"

    ################################################################################ Export the VM
    print "\n"+strftime("%a, %d %b %Y %H:%M:%S", gmtime())+" : Export of the virtual machine"
    api.vms.get(sys.argv[1]).export(params.Action(storage_domain=api.storagedomains.get(EXPORT_DOMAIN_NAME), exclusive='true', discard_snapshots='true'))
    print 'Waiting '
    print "Starting export process : %s" %(api.vms.get(sys.argv[1]).status.state)
    while api.vms.get(sys.argv[1]).status.state != 'down':
        sys.stdout.write('.')
        sleep(1)
    print "\n"+strftime("%a, %d %b %Y %H:%M:%S", gmtime())+" OK"


    ################################################################################ Restart of the VM
    if initial_status == 'up':
        print "\n"+strftime("%a, %d %b %Y %H:%M:%S", gmtime())+" : Virtual machine was up before the backup. Restoring state to up."
        if api.vms.get(name=sys.argv[1]).status.state != 'up':
            print 'Starting VM'
            api.vms.get(name=sys.argv[1]).start()
            print 'Waiting for VM to reach Up status'
            while api.vms.get(name=sys.argv[1]).status.state != 'up':
                sleep(1)
                sys.stdout.write('.')
            print '\nOK'
        else:
            print 'VM is already up'
    else:
        print "\n"+strftime("%a, %d %b %Y %H:%M:%S", gmtime())+" : Virtual machine was down before the backup. Keeping it down."



    ################################################################################ End
    api.disconnect()
    print "\n"+strftime("%a, %d %b %Y %H:%M:%S", gmtime())+" : BACKUP OK"
    exit(0)


except Exception as ex:
    print "\n"+strftime("%a, %d %b %Y %H:%M:%S", gmtime())+" : Unexpected error: %s" % ex
    exit(1)
