#!/usr/bin/python
# -*- coding: utf-8 -*-

####
# This scripts performs a hot-backup of the argument-specified VM, to an export domain
# Usage : backup_hot.py <vm_name>
# You need to modify the RHEV_URL, RHEV_USERNAME, RHEV_PASSWORD and
# EXPORT_DOMAIN_NAME variables below before use
###
import datetime
from ovirtsdk.api import API
from ovirtsdk.xml import params
from ovirtsdk import infrastructure
import sys
from time import sleep, gmtime, strftime

RHEV_URL = "https://<ip or url of the rhevm portal(main part)>"
RHEV_USERNAME = "usernam@<domain>"
RHEV_PASSWORD = ""
EXPORT_DOMAIN_NAME = "<exported type storage domain used as backup>"

try:

    ################################################################################ Check parameters
    if len(sys.argv) < 2:
        print "Usage : backup-vm.py <vm_name>"
        exit(2)


    ################################################################################ Connection to RHEV
    print strftime("%a, %d %b %Y %H:%M:%S", gmtime()) + " : Connecting to RHEV"
    api = API(url=RHEV_URL,
              username=RHEV_USERNAME,
              password=RHEV_PASSWORD,
              ca_file="/etc/pki/ovirt-engine/ca.pem")
    print "Connected to %s successfully!" % api.get_product_info().name


    ################################################################################ Display information about the VM
    print "\n" + strftime("%a, %d %b %Y %H:%M:%S",
                          gmtime()) + " : Gathering information about the virtual machine %s" % (sys.argv[1])
    vm_obj = api.vms.get(name=sys.argv[1])
    print "VM name : %s" % (vm_obj.name)
    initial_status = vm_obj.status.state
    print "Status : %s" % (initial_status)
    vm_cluster = api.clusters.get(id=vm_obj.cluster.id)
    print "Cluster : %s" % (vm_cluster.get_name())
    vm_dc = api.datacenters.get(id=vm_cluster.data_center.id)
    print "Datacenter : %s" % (vm_dc.get_name())
    ################################################################################ Check export domain availability
    print "\n" + strftime("%a, %d %b %Y %H:%M:%S",
                          gmtime()) + " : Ensuring that the export domain %s has been attached and activated on a datacenter" % (
        EXPORT_DOMAIN_NAME)


    try:
        ds_nm = []
        ds_nm_gl = []

        for i in range(len(vm_dc.storagedomains.list())):
            ds_nm.append(vm_dc.storagedomains.get(id=vm_dc.storagedomains.list()[i].id).name)

        for i in range(len(api.storagedomains.list())):
            ds_nm_gl.append(api.storagedomains.get(id=api.storagedomains.list()[i].id).name)

        if EXPORT_DOMAIN_NAME in ds_nm:
            ds_exp_stat=vm_dc.storagedomains.get(name=EXPORT_DOMAIN_NAME).get_status().get_state()
            if ds_exp_stat!='active':
                vm_dc.storagedomains.get(name=EXPORT_DOMAIN_NAME).activate()
            else:
                print "Domain storage "+ EXPORT_DOMAIN_NAME +" for backup is available."
        else:
            if EXPORT_DOMAIN_NAME in ds_nm_gl:
                    print "Add storage domain "+EXPORT_DOMAIN_NAME+" to "+ vm_dc.get_name()
                    sd_export = api.storagedomains.get(name=EXPORT_DOMAIN_NAME)
                    print "Activating "+EXPORT_DOMAIN_NAME
                    dc_export = vm_dc.storagedomains.add(sd_export)
                    vm_dc.storagedomains.get(name=EXPORT_DOMAIN_NAME).activate()
            else:
                    print "Domain storage "+ EXPORT_DOMAIN_NAME +" does not exists."
                    exit(1)

    except Exception as e:
         print 'Access to Backup storage problem:\n%s' % str(e)
         exit(1)


################################################################################ Create Snapshot
    try:
        snap = api.vms.get(name=vm_obj.name).snapshots.add(
            params.Snapshot(description=SNAPSHOT_NAME, vm=api.vms.get(name=vm_obj.name)))

        #
        print "Creating a Snapshot"
        print "Waiting for Snapshot creation to finish"
        b = 0
        while api.vms.get(name=vm_obj.name).snapshots.get(id=snap.id).snapshot_status != "ok":
            sleep(10)
            b += 1

        print "Snapshot has been created as " + SNAPSHOT_NAME

        print "I'm going to create VM to export it to exported DS."

        snap = api.vms.get(name=vm_obj.name).snapshots.list(description=SNAPSHOT_NAME)[0]
        snapshots = params.Snapshots(snapshot=[params.Snapshot(id=snap.id)])
        newname = sys.argv[1] + "_" + SNAPSHOT_NAME
        print("Creating new VM based on snapshot...")
        api.vms.add(
            params.VM(name=newname, snapshots=snapshots, cluster=vm_cluster, template=api.templates.get(name="Blank")))
        i = 0
        print("Waiting for creation to finish...")
        while api.vms.get(name=newname).status.state == "image_locked":
            i += 1
            sleep(10)
    except Exception as e:
        print 'Failed to create snapshot VM:\n%s' % str(e)
        exit(1)


###############  Export to shared DS ##################
    try:
        print "\n" + strftime("%a, %d %b %Y %H:%M:%S", gmtime()) + " : Export of the virtual machine"
        api.vms.get(newname).export(
            params.Action(storage_domain=api.storagedomains.get(EXPORT_DOMAIN_NAME), exclusive='true',
                          discard_snapshots='true'))
        print 'Waiting '
        print "Export in progress : %s" % (api.vms.get(newname).status.state)
        while api.vms.get(newname).status.state != 'down':
            sleep(5)
        print "\n" + strftime("%a, %d %b %Y %H:%M:%S", gmtime()) + " OK"
    except Exception as e:
        print 'Failed to export VM:\n%s' % str(e)
        exit(1)

#################   Drop duplicated VM   ################
    try:
        vm_bck_name_d = api.vms.get(newname).name
        api.vms.get(newname).delete()
        print 'VM was removed successfully'
        print 'Waiting for VM to be deleted'
        while newname in [newname.name for newname in api.vms.list()]:
            sleep(1)
        print "Backup machine " + vm_bck_name_d + " has been deleted."
    except Exception as e:
        print 'Failed to remove VM:\n%s' % str(e)
        exit(1)

################################################################################ Export the VM
    api.disconnect()
    print "\n" + strftime("%a, %d %b %Y %H:%M:%S", gmtime()) + " : BACKUP OK"
    exit(0)


except Exception as ex:
    print "\n" + strftime("%a, %d %b %Y %H:%M:%S", gmtime()) + " : Unexpected error: %s" % ex
exit(1)
