--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- Name: engine; Type: DATABASE; Schema: -; Owner: postgres
--

CREATE DATABASE engine WITH TEMPLATE = template0 ENCODING = 'UTF8' LC_COLLATE = 'en_US.UTF-8' LC_CTYPE = 'en_US.UTF-8';


ALTER DATABASE engine OWNER TO postgres;

\connect engine

SET statement_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


--
-- Name: uuid-ossp; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS "uuid-ossp" WITH SCHEMA public;


--
-- Name: EXTENSION "uuid-ossp"; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION "uuid-ossp" IS 'generate universally unique identifiers (UUIDs)';


SET search_path = public, pg_catalog;

--
-- Name: get_all_commands_rs; Type: TYPE; Schema: public; Owner: postgres
--

CREATE TYPE get_all_commands_rs AS (
	command_id uuid,
	command_type character varying(256)
);


ALTER TYPE public.get_all_commands_rs OWNER TO postgres;

--
-- Name: getallfromvm_pools_rs; Type: TYPE; Schema: public; Owner: postgres
--

CREATE TYPE getallfromvm_pools_rs AS (
	vm_pool_id uuid,
	assigned_vm_count integer,
	vm_running_count integer,
	vm_pool_description character varying(4000),
	vm_pool_name character varying(255),
	vm_pool_type integer,
	parameters character varying(200),
	vds_group_id uuid,
	vds_group_name character varying(40)
);


ALTER TYPE public.getallfromvm_pools_rs OWNER TO postgres;

--
-- Name: getnamesofvmstaticdedicatedtovds_rs; Type: TYPE; Schema: public; Owner: postgres
--

CREATE TYPE getnamesofvmstaticdedicatedtovds_rs AS (
	vm_name character varying
);


ALTER TYPE public.getnamesofvmstaticdedicatedtovds_rs OWNER TO postgres;

--
-- Name: getorderedvmguidsforrunmultipleactions_rs; Type: TYPE; Schema: public; Owner: postgres
--

CREATE TYPE getorderedvmguidsforrunmultipleactions_rs AS (
	vm_guid uuid
);


ALTER TYPE public.getorderedvmguidsforrunmultipleactions_rs OWNER TO postgres;

--
-- Name: getrepo_files_in_all_storage_pools_rs; Type: TYPE; Schema: public; Owner: postgres
--

CREATE TYPE getrepo_files_in_all_storage_pools_rs AS (
	storage_domain_id uuid,
	last_refreshed bigint,
	file_type integer
);


ALTER TYPE public.getrepo_files_in_all_storage_pools_rs OWNER TO postgres;

--
-- Name: getstorage_domainsid_by_imagegroupid_rs; Type: TYPE; Schema: public; Owner: postgres
--

CREATE TYPE getstorage_domainsid_by_imagegroupid_rs AS (
	storage_id uuid
);


ALTER TYPE public.getstorage_domainsid_by_imagegroupid_rs OWNER TO postgres;

--
-- Name: getstoragedomainidsbystoragepoolidandstatus_rs; Type: TYPE; Schema: public; Owner: postgres
--

CREATE TYPE getstoragedomainidsbystoragepoolidandstatus_rs AS (
	storage_id uuid
);


ALTER TYPE public.getstoragedomainidsbystoragepoolidandstatus_rs OWNER TO postgres;

--
-- Name: getsystem_statistics_rs; Type: TYPE; Schema: public; Owner: postgres
--

CREATE TYPE getsystem_statistics_rs AS (
	val integer
);


ALTER TYPE public.getsystem_statistics_rs OWNER TO postgres;

--
-- Name: idtexttype; Type: TYPE; Schema: public; Owner: postgres
--

CREATE TYPE idtexttype AS (
	id text
);


ALTER TYPE public.idtexttype OWNER TO postgres;

--
-- Name: iduuidtype; Type: TYPE; Schema: public; Owner: postgres
--

CREATE TYPE iduuidtype AS (
	id uuid
);


ALTER TYPE public.iduuidtype OWNER TO postgres;

--
-- Name: networkviewclustertype; Type: TYPE; Schema: public; Owner: postgres
--

CREATE TYPE networkviewclustertype AS (
	id uuid,
	name character varying(50),
	description character varying(4000),
	type integer,
	addr character varying(50),
	subnet character varying(20),
	gateway character varying(20),
	vlan_id integer,
	stp boolean,
	storage_pool_id uuid,
	network_id uuid,
	cluster_id uuid,
	status integer,
	is_display boolean
);


ALTER TYPE public.networkviewclustertype OWNER TO postgres;

--
-- Name: user_permissions; Type: TYPE; Schema: public; Owner: postgres
--

CREATE TYPE user_permissions AS (
	permission_id uuid,
	role_id uuid,
	user_id uuid
);


ALTER TYPE public.user_permissions OWNER TO postgres;

--
-- Name: attach_user_to_su_role(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION attach_user_to_su_role() RETURNS void
    LANGUAGE plpgsql
    AS '
   DECLARE
   v_user_entry VARCHAR(255);
   v_user_id  UUID;
   v_name  VARCHAR(255);
   v_domain  VARCHAR(255);
   v_user_name  VARCHAR(255);

   v_document  VARCHAR(64);
   v_index  INTEGER;
BEGIN

   select   option_value INTO v_user_entry from vdc_options where option_name = ''AdUserId'';
   select   option_value INTO v_name from vdc_options where option_name = ''AdUserName'';
   select   option_value INTO v_domain from vdc_options where option_name = ''DomainName'';

   v_index := POSITION('':'' IN v_user_entry);
   if ( v_index <> 0 ) then
      v_user_entry := substring( v_user_entry from v_index + 1 );
      v_user_id := CAST( v_user_entry AS uuid );
   end if;

   v_index := POSITION('':'' IN v_name);
   if ( v_index <> 0 ) then
      v_name := substring( v_name from v_index + 1 );
   end if;

-- find if name already includes domain (@)
   v_index := POSITION(''@'' IN v_name);

   if (v_index = 0) then
      v_user_name := coalesce(v_name,'''') || ''@'' || coalesce(v_domain,'''');
   else
      v_user_name := v_name;
   end if;


insert into users(user_id,name,domain,username,groups,status) select v_user_id, v_name, v_domain, v_user_name,'''',1 where not exists (select user_id,name,domain,username,groups,status from users where user_id = v_user_id and name = v_name and domain = v_domain and username = v_user_name and groups = '''' and status = 1);

insert into permissions(id,role_id,ad_element_id,object_id,object_type_id) select uuid_generate_v1(), ''00000000-0000-0000-0000-000000000001'', v_user_id, getGlobalIds(''system''), 1 where not exists(select role_id,ad_element_id,object_id,object_type_id from permissions where role_id = ''00000000-0000-0000-0000-000000000001'' and ad_element_id = v_user_id and object_id= getGlobalIds(''system'') and object_type_id = 1);
END; ';


ALTER FUNCTION public.attach_user_to_su_role() OWNER TO postgres;

--
-- Name: attach_user_to_su_role(character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION attach_user_to_su_role(v_user_id character varying, v_name character varying, v_domain character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
   DECLARE
   v_user_name VARCHAR(255);
   v_document  VARCHAR(64);
   v_index  INTEGER;
   input_uuid uuid;
BEGIN
   input_uuid = CAST( v_user_id AS uuid );
-- find if name already includes domain (@)
   v_index := POSITION(''@'' IN v_name);

   if (v_index = 0) then
      v_user_name := coalesce(v_name,'''') || ''@'' || coalesce(v_domain,'''');
   else
      v_user_name := v_name;
   end if;


insert into users(user_id,name,domain,username,groups,status) select input_uuid, v_name, v_domain, v_user_name,'''',1 where not exists (select user_id,name,domain,username,groups,status from users where user_id = input_uuid);

insert into permissions(id,role_id,ad_element_id,object_id,object_type_id) select uuid_generate_v1(), ''00000000-0000-0000-0000-000000000001'', input_uuid, getGlobalIds(''system''), 1 where not exists(select role_id,ad_element_id,object_id,object_type_id from permissions where role_id = ''00000000-0000-0000-0000-000000000001'' and ad_element_id = input_uuid and object_id= getGlobalIds(''system'') and object_type_id = 1);
END; ';


ALTER FUNCTION public.attach_user_to_su_role(v_user_id character varying, v_name character varying, v_domain character varying) OWNER TO postgres;

--
-- Name: checkdbconnection(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION checkdbconnection() RETURNS SETOF integer
    LANGUAGE plpgsql
    AS '
BEGIN
    RETURN QUERY SELECT 1;
END; ';


ALTER FUNCTION public.checkdbconnection() OWNER TO postgres;

--
-- Name: delete_entity_snapshot_by_command_id(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION delete_entity_snapshot_by_command_id(v_command_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
	BEGIN
		delete from business_entity_snapshot where command_id = v_command_id;
	END;
	RETURN;
END; ';


ALTER FUNCTION public.delete_entity_snapshot_by_command_id(v_command_id uuid) OWNER TO postgres;

--
-- Name: delete_roles_groups(integer, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION delete_roles_groups(v_action_group_id integer, v_role_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN

   DELETE FROM roles_groups
   WHERE action_group_id = v_action_group_id AND role_id = v_role_id;

END; ';


ALTER FUNCTION public.delete_roles_groups(v_action_group_id integer, v_role_id uuid) OWNER TO postgres;

--
-- Name: deleteaction_version_map(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deleteaction_version_map(v_action_type integer) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
	
   DELETE FROM action_version_map
   WHERE action_type = v_action_type;
    
END; ';


ALTER FUNCTION public.deleteaction_version_map(v_action_type integer) OWNER TO postgres;

--
-- Name: deletead_groups(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletead_groups(v_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      DELETE FROM tags_user_group_map
      WHERE group_id = v_id;
      DELETE FROM ad_groups
      WHERE id = v_id;
END; ';


ALTER FUNCTION public.deletead_groups(v_id uuid) OWNER TO postgres;

--
-- Name: deletealluser_sessions(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletealluser_sessions() RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      TRUNCATE TABLE user_sessions;
      UPDATE users
      SET session_count = 0
      WHERE
      session_count > 0;
END; ';


ALTER FUNCTION public.deletealluser_sessions() OWNER TO postgres;

--
-- Name: deleteasync_tasks(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deleteasync_tasks(v_task_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
	
   DELETE FROM async_tasks
   WHERE task_id = v_task_id;
    
END; ';


ALTER FUNCTION public.deleteasync_tasks(v_task_id uuid) OWNER TO postgres;

--
-- Name: deleteauditalertlogbyvdsidandtype(uuid, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deleteauditalertlogbyvdsidandtype(v_vds_id uuid, v_log_type integer) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      delete from audit_log where vds_id = v_vds_id and log_type = v_log_type;
END; ';


ALTER FUNCTION public.deleteauditalertlogbyvdsidandtype(v_vds_id uuid, v_log_type integer) OWNER TO postgres;

--
-- Name: deleteauditlog(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deleteauditlog(v_audit_log_id integer) RETURNS void
    LANGUAGE plpgsql
    AS '
   DECLARE
   v_val  INTEGER;
BEGIN
		-- Get (and keep) a shared lock with "right to upgrade to exclusive"
		-- in order to force locking parent before children 
      select   audit_log_id INTO v_val FROM audit_log  WHERE audit_log_id = v_audit_log_id     FOR UPDATE;
      DELETE FROM audit_log
      WHERE audit_log_id = v_audit_log_id;
END; ';


ALTER FUNCTION public.deleteauditlog(v_audit_log_id integer) OWNER TO postgres;

--
-- Name: deleteauditlogalertsbyvdsid(uuid, boolean); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deleteauditlogalertsbyvdsid(v_vds_id uuid, v_delete_config_alerts boolean DEFAULT true) RETURNS void
    LANGUAGE plpgsql
    AS '
   DECLARE
   v_min_alret_severity  INTEGER;
   v_no_config_alret_type  INTEGER;
BEGIN
      v_min_alret_severity := 10;
      v_no_config_alret_type := 9000;
      if (v_delete_config_alerts = true) then
         delete from audit_log where vds_id = v_vds_id and severity >= v_min_alret_severity;
      else
         delete from audit_log where vds_id = v_vds_id and severity >= v_min_alret_severity and log_type > v_no_config_alret_type;
      end if;
END; ';


ALTER FUNCTION public.deleteauditlogalertsbyvdsid(v_vds_id uuid, v_delete_config_alerts boolean) OWNER TO postgres;

--
-- Name: deleteauditlogolderthendate(timestamp with time zone); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deleteauditlogolderthendate(v_date timestamp with time zone) RETURNS void
    LANGUAGE plpgsql
    AS '
   DECLARE
   v_id  INTEGER;
   SWV_RowCount INTEGER;
BEGIN
        -- get first the id from which to remove in order to use index
      select   audit_log_id INTO v_id FROM audit_log WHERE LOG_TIME < v_date   order by audit_log_id desc LIMIT 1;
        -- check if there are candidates to remove
      GET DIAGNOSTICS SWV_RowCount = ROW_COUNT;
      if (SWV_RowCount > 0) then
         DELETE FROM audit_log
         WHERE audit_log_id <= v_id and processed = TRUE and
         audit_log_id not in(select audit_log_id from event_notification_hist);
      end if;
END; ';


ALTER FUNCTION public.deleteauditlogolderthendate(v_date timestamp with time zone) OWNER TO postgres;

--
-- Name: deletebookmark(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletebookmark(v_bookmark_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      DELETE FROM bookmarks
      WHERE bookmark_Id = v_bookmark_id;
END; ';


ALTER FUNCTION public.deletebookmark(v_bookmark_id uuid) OWNER TO postgres;

--
-- Name: deletecustom_actions(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletecustom_actions(v_action_id integer) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      DELETE FROM custom_actions
      WHERE action_id = v_action_id;
END; ';


ALTER FUNCTION public.deletecustom_actions(v_action_id integer) OWNER TO postgres;

--
-- Name: deletedisk(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletedisk(v_disk_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
DECLARE
    v_val  UUID;
BEGIN
    DELETE
    FROM   disks
    WHERE  disk_id = v_disk_id;
END; ';


ALTER FUNCTION public.deletedisk(v_disk_id uuid) OWNER TO postgres;

--
-- Name: deletedisk_image_dynamic(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletedisk_image_dynamic(v_image_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
	
   DELETE FROM disk_image_dynamic
   WHERE image_id = v_image_id;
    
END; ';


ALTER FUNCTION public.deletedisk_image_dynamic(v_image_id uuid) OWNER TO postgres;

--
-- Name: deleteevent_notification_hist(timestamp without time zone); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deleteevent_notification_hist(v_sent_at timestamp without time zone) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      DELETE FROM event_notification_hist WHERE sent_at < v_sent_at;
END; ';


ALTER FUNCTION public.deleteevent_notification_hist(v_sent_at timestamp without time zone) OWNER TO postgres;

--
-- Name: deleteevent_subscriber(character varying, integer, uuid, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deleteevent_subscriber(v_event_up_name character varying, v_method_id integer, v_subscriber_id uuid, v_tag_name character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      if (v_tag_name IS NULL) then
         delete from event_subscriber
         where event_up_name = v_event_up_name
         and method_id = v_method_id
         and subscriber_id = v_subscriber_id;
      else
         delete from event_subscriber
         where event_up_name = v_event_up_name
         and method_id = v_method_id
         and subscriber_id = v_subscriber_id
         and tag_name = v_tag_name;
      end if;
END; ';


ALTER FUNCTION public.deleteevent_subscriber(v_event_up_name character varying, v_method_id integer, v_subscriber_id uuid, v_tag_name character varying) OWNER TO postgres;

--
-- Name: deleteimage(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deleteimage(v_image_guid uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
   DECLARE
   v_val  UUID;
   v_disk_id UUID;
BEGIN
		-- Get (and keep) a shared lock with "right to upgrade to exclusive"
		-- in order to force locking parent before children 
      select   image_guid INTO v_val FROM images  WHERE image_guid = v_image_guid     FOR UPDATE;
      SELECT image_group_id INTO v_disk_id FROM images WHERE image_guid = v_image_guid;
      SELECT disk_id INTO v_disk_id FROM disks WHERE disk_id = v_disk_id FOR UPDATE;

      DELETE FROM images
      WHERE image_guid = v_image_guid;

      -- TODO: Delete this once the disks table is used directly from code.
      IF (SELECT COUNT(*) FROM images WHERE image_group_id = v_disk_id) = 0 THEN
          DELETE FROM disks
          WHERE disk_id = v_disk_id;
      END IF;
END; ';


ALTER FUNCTION public.deleteimage(v_image_guid uuid) OWNER TO postgres;

--
-- Name: deleteimage_group_storage_domain_map(uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deleteimage_group_storage_domain_map(v_image_group_id uuid, v_storage_domain_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
	
   DELETE FROM image_group_storage_domain_map
   WHERE image_group_id = v_image_group_id AND storage_domain_id = v_storage_domain_id;
    
END; ';


ALTER FUNCTION public.deleteimage_group_storage_domain_map(v_image_group_id uuid, v_storage_domain_id uuid) OWNER TO postgres;

--
-- Name: deleteimage_vm_map(uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deleteimage_vm_map(v_image_id uuid, v_vm_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      DELETE FROM image_vm_map
      WHERE image_id = v_image_id AND vm_id = v_vm_id;
END; ';


ALTER FUNCTION public.deleteimage_vm_map(v_image_id uuid, v_vm_id uuid) OWNER TO postgres;

--
-- Name: deleteimage_vm_pool_map(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deleteimage_vm_pool_map(v_image_guid uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      DELETE FROM image_vm_pool_map
      WHERE image_guid = v_image_guid;
END; ';


ALTER FUNCTION public.deleteimage_vm_pool_map(v_image_guid uuid) OWNER TO postgres;

--
-- Name: deletelun(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletelun(v_lun_id character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
   DECLARE
   v_val  VARCHAR(50);
BEGIN
	
	-- Get (and keep) a shared lock with "right to upgrade to exclusive"
	-- in order to force locking parent before children 
   select   LUN_id INTO v_val FROM LUNs  WHERE LUN_id = v_LUN_id     FOR UPDATE;

   DELETE FROM LUNs
   WHERE LUN_id = v_LUN_id;
    
END; ';


ALTER FUNCTION public.deletelun(v_lun_id character varying) OWNER TO postgres;

--
-- Name: deletelun_storage_server_connection_map(character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletelun_storage_server_connection_map(v_lun_id character varying, v_storage_server_connection character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
	
   DELETE FROM LUN_storage_server_connection_map
   WHERE LUN_id = v_LUN_id AND storage_server_connection = v_storage_server_connection;
    
END; ';


ALTER FUNCTION public.deletelun_storage_server_connection_map(v_lun_id character varying, v_storage_server_connection character varying) OWNER TO postgres;

--
-- Name: deletenetwork(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletenetwork(v_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
   DECLARE
   v_val  UUID;
BEGIN
	
	-- Get (and keep) a shared lock with "right to upgrade to exclusive"
	-- in order to force locking parent before children 
   select   id INTO v_val FROM network  WHERE id = v_id     FOR UPDATE;
	
   DELETE FROM network
   WHERE id = v_id;
    
END; ';


ALTER FUNCTION public.deletenetwork(v_id uuid) OWNER TO postgres;

--
-- Name: deletenetwork_cluster(uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletenetwork_cluster(v_cluster_id uuid, v_network_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
	
   DELETE FROM network_cluster
   WHERE cluster_id = v_cluster_id AND network_id = v_network_id;
    
END; ';


ALTER FUNCTION public.deletenetwork_cluster(v_cluster_id uuid, v_network_id uuid) OWNER TO postgres;

--
-- Name: deletepermission(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletepermission(v_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
   DECLARE
   v_val  UUID;
BEGIN
	
	-- Get (and keep) a shared lock with "right to upgrade to exclusive"
	-- in order to force locking parent before children
   select   id INTO v_val FROM permissions  WHERE id = v_id     FOR UPDATE;

   DELETE FROM permissions
   WHERE id = v_id;

END; ';


ALTER FUNCTION public.deletepermission(v_id uuid) OWNER TO postgres;

--
-- Name: deletepermissionsbyentityid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletepermissionsbyentityid(v_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
   DELETE FROM permissions
   WHERE object_id = v_id;
END; ';


ALTER FUNCTION public.deletepermissionsbyentityid(v_id uuid) OWNER TO postgres;

--
-- Name: deleterepo_domain_file_list(uuid, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deleterepo_domain_file_list(v_repo_domain_id uuid, v_file_type integer) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
    
   DELETE FROM repo_file_meta_data
   WHERE repo_domain_id = v_repo_domain_id
     AND file_type = v_file_type;
    
   RETURN;
END; ';


ALTER FUNCTION public.deleterepo_domain_file_list(v_repo_domain_id uuid, v_file_type integer) OWNER TO postgres;

--
-- Name: deleterole(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deleterole(v_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
   DECLARE
   v_val  UUID;
BEGIN
	
	-- Get (and keep) a shared lock with "right to upgrade to exclusive"
    -- in order to force locking parent before children
   select   id INTO v_val FROM roles  WHERE id = v_id     FOR UPDATE;

   DELETE FROM roles
   WHERE id = v_id;

END; ';


ALTER FUNCTION public.deleterole(v_id uuid) OWNER TO postgres;

--
-- Name: deleteroles_relations(uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deleteroles_relations(v_role_container_id uuid, v_role_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN

   DELETE FROM roles_relations
   WHERE role_container_id = v_role_container_id AND role_id = v_role_id;

END; ';


ALTER FUNCTION public.deleteroles_relations(v_role_container_id uuid, v_role_id uuid) OWNER TO postgres;

--
-- Name: deletestateless_vm_image_map(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletestateless_vm_image_map(v_image_guid uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
	
   DELETE FROM stateless_vm_image_map
   WHERE image_guid = v_image_guid;
    
END; ';


ALTER FUNCTION public.deletestateless_vm_image_map(v_image_guid uuid) OWNER TO postgres;

--
-- Name: deletestorage_domain_dynamic(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletestorage_domain_dynamic(v_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
	
   DELETE FROM storage_domain_dynamic
   WHERE id = v_id;
    
END; ';


ALTER FUNCTION public.deletestorage_domain_dynamic(v_id uuid) OWNER TO postgres;

--
-- Name: deletestorage_domain_static(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletestorage_domain_static(v_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
   DECLARE
   v_val  UUID;
BEGIN
	
	-- Get (and keep) a shared lock with "right to upgrade to exclusive"
	-- in order to force locking parent before children 
   select   id INTO v_val FROM storage_domain_static  WHERE id = v_id     FOR UPDATE;
	
   DELETE FROM storage_domain_static
   WHERE id = v_id;
    
	-- delete Storage permissions --
   DELETE FROM permissions where object_id = v_id; 	

END; ';


ALTER FUNCTION public.deletestorage_domain_static(v_id uuid) OWNER TO postgres;

--
-- Name: deletestorage_pool(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletestorage_pool(v_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
   DECLARE
   v_val  UUID;
BEGIN
	
         -- Get (and keep) a shared lock with "right to upgrade to exclusive"
    select vm_guid INTO v_val FROM vm_static where vm_guid in (select vm_guid from vms where storage_pool_id = v_id) FOR UPDATE;
    delete FROM vm_static where vm_guid in (select vm_guid from vms where storage_pool_id = v_id);

	-- Get (and keep) a shared lock with "right to upgrade to exclusive"
	-- in order to force locking parent before children 
   select   id INTO v_val FROM storage_pool  WHERE id = v_id     FOR UPDATE;
	
   DELETE FROM storage_pool
   WHERE id = v_id;

	-- delete StoragePool permissions --
   DELETE FROM permissions where object_id = v_id; 
    
END; ';


ALTER FUNCTION public.deletestorage_pool(v_id uuid) OWNER TO postgres;

--
-- Name: deletestorage_pool_iso_map(uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletestorage_pool_iso_map(v_storage_id uuid, v_storage_pool_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
	
   DELETE FROM storage_pool_iso_map
   WHERE storage_id = v_storage_id AND storage_pool_id = v_storage_pool_id;
    
END; ';


ALTER FUNCTION public.deletestorage_pool_iso_map(v_storage_id uuid, v_storage_pool_id uuid) OWNER TO postgres;

--
-- Name: deletestorage_server_connections(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletestorage_server_connections(v_id character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
   DECLARE
   v_val  VARCHAR(50);
BEGIN
	
	-- Get (and keep) a shared lock with "right to upgrade to exclusive"
	-- in order to force locking parent before children 
   select   id INTO v_val FROM storage_server_connections  WHERE id = v_id     FOR UPDATE;
	
   DELETE FROM storage_server_connections
   WHERE id = v_id;
    
END; ';


ALTER FUNCTION public.deletestorage_server_connections(v_id character varying) OWNER TO postgres;

--
-- Name: deletetags(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletetags(v_tag_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
   DECLARE
   v_val  UUID;
BEGIN
			-- Get (and keep) a shared lock with "right to upgrade to exclusive"
			-- in order to force locking parent before children 
      select   tag_id INTO v_val FROM tags  WHERE tag_id = v_tag_id     FOR UPDATE;
      DELETE FROM tags_user_group_map
      WHERE tag_id = v_tag_id;
      DELETE FROM tags_user_map
      WHERE tag_id = v_tag_id;
      DELETE FROM tags_vm_map
      WHERE tag_id = v_tag_id;
      DELETE FROM tags_vds_map
      WHERE tag_id = v_tag_id;
      DELETE FROM tags_vm_pool_map
      WHERE tag_id = v_tag_id;
      DELETE FROM tags
      WHERE tag_id = v_tag_id;
END; ';


ALTER FUNCTION public.deletetags(v_tag_id uuid) OWNER TO postgres;

--
-- Name: deletetags_user_group_map(uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletetags_user_group_map(v_group_id uuid, v_tag_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      DELETE FROM tags_user_group_map
      WHERE group_id = v_group_id AND tag_id = v_tag_id;
END; ';


ALTER FUNCTION public.deletetags_user_group_map(v_group_id uuid, v_tag_id uuid) OWNER TO postgres;

--
-- Name: deletetags_user_map(uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletetags_user_map(v_tag_id uuid, v_user_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      DELETE FROM tags_user_map
      WHERE tag_id = v_tag_id AND user_id = v_user_id;
END; ';


ALTER FUNCTION public.deletetags_user_map(v_tag_id uuid, v_user_id uuid) OWNER TO postgres;

--
-- Name: deletetags_vds_map(uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletetags_vds_map(v_tag_id uuid, v_vds_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      DELETE FROM tags_vds_map
      WHERE tag_id = v_tag_id AND vds_id = v_vds_id;
END; ';


ALTER FUNCTION public.deletetags_vds_map(v_tag_id uuid, v_vds_id uuid) OWNER TO postgres;

--
-- Name: deletetags_vm_map(uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletetags_vm_map(v_tag_id uuid, v_vm_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      DELETE FROM tags_vm_map
      WHERE tag_id = v_tag_id AND vm_id = v_vm_id;
END; ';


ALTER FUNCTION public.deletetags_vm_map(v_tag_id uuid, v_vm_id uuid) OWNER TO postgres;

--
-- Name: deletetags_vm_pool_map(uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletetags_vm_pool_map(v_tag_id uuid, v_vm_pool_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
	
   DELETE FROM tags_vm_pool_map
   WHERE tag_id = v_tag_id AND vm_pool_id = v_vm_pool_id;
    
END; ';


ALTER FUNCTION public.deletetags_vm_pool_map(v_tag_id uuid, v_vm_pool_id uuid) OWNER TO postgres;

--
-- Name: deletetime_lease_vm_pool_map(uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletetime_lease_vm_pool_map(v_id uuid, v_vm_pool_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      DELETE FROM time_lease_vm_pool_map
      WHERE id = v_id AND vm_pool_id = v_vm_pool_id;
END; ';


ALTER FUNCTION public.deletetime_lease_vm_pool_map(v_id uuid, v_vm_pool_id uuid) OWNER TO postgres;

--
-- Name: deleteuser(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deleteuser(v_user_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
   DECLARE
   v_val  UUID;
BEGIN
			-- Get (and keep) a shared lock with "right to upgrade to exclusive"
			-- in order to force locking parent before children 
      select   user_id INTO v_val FROM users  WHERE user_id = v_user_id     FOR UPDATE;
      DELETE FROM tags_user_map
      WHERE user_id = v_user_id;
      DELETE FROM users
      WHERE user_id = v_user_id;
END; ';


ALTER FUNCTION public.deleteuser(v_user_id uuid) OWNER TO postgres;

--
-- Name: deleteuser_sessions(character, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deleteuser_sessions(v_session_id character, v_user_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
   DECLARE
   v_counter  INTEGER;
   SWV_RowCount INTEGER;
BEGIN
      DELETE FROM user_sessions
      WHERE session_id = v_session_id AND user_id = v_user_id;
      GET DIAGNOSTICS SWV_RowCount = ROW_COUNT;
      if (SWV_RowCount > 0) then
         select   session_count INTO v_counter from users WHERE
         user_id = v_user_id;
         if (v_counter > 0) then
            UPDATE users
            SET session_count = session_count -1
            WHERE
            user_id = v_user_id;
         end if;
      end if;
END; ';


ALTER FUNCTION public.deleteuser_sessions(v_session_id character, v_user_id uuid) OWNER TO postgres;

--
-- Name: deleteuser_sessionsbyuser_id(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deleteuser_sessionsbyuser_id(v_user_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      DELETE FROM user_sessions
      WHERE user_id = v_user_id;
      UPDATE users
      SET session_count = 0
      WHERE
      user_id = v_user_id;
END; ';


ALTER FUNCTION public.deleteuser_sessionsbyuser_id(v_user_id uuid) OWNER TO postgres;

--
-- Name: deletevdcoption(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletevdcoption(v_option_id integer) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      DELETE FROM vdc_options
      WHERE option_id = v_option_id;
END; ';


ALTER FUNCTION public.deletevdcoption(v_option_id integer) OWNER TO postgres;

--
-- Name: deletevds(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletevds(v_vds_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN  
   BEGIN
      UPDATE vm_static
      SET dedicated_vm_for_vds = null
      WHERE dedicated_vm_for_vds = v_vds_id;
      DELETE FROM tags_vds_map
      WHERE vds_id = v_vds_id;  
   -- Delete all Vds Alerts from the database  
      PERFORM DeleteAuditLogAlertsByVdsID(v_vds_id);
      DELETE FROM vds_statistics WHERE vds_id = v_vds_id;
      DELETE FROM vds_dynamic WHERE vds_id = v_vds_id;
      DELETE FROM vds_static WHERE vds_id = v_vds_id;
      DELETE FROM permissions where object_id = v_vds_id;
   END;  
   RETURN;
END; ';


ALTER FUNCTION public.deletevds(v_vds_id uuid) OWNER TO postgres;

--
-- Name: deletevds_interface(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletevds_interface(v_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
	
   DELETE FROM vds_interface
   WHERE id = v_id;
    
END; ';


ALTER FUNCTION public.deletevds_interface(v_id uuid) OWNER TO postgres;

--
-- Name: deletevds_interface_statistics(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletevds_interface_statistics(v_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
   DECLARE
   v_val  UUID;
BEGIN
	
	-- Get (and keep) a shared lock with "right to upgrade to exclusive"
	-- in order to force locking parent before children 
   select   id INTO v_val FROM vds_interface_statistics  WHERE id = v_id     FOR UPDATE;

   DELETE FROM vds_interface_statistics
   WHERE id = v_id;
    
END; ';


ALTER FUNCTION public.deletevds_interface_statistics(v_id uuid) OWNER TO postgres;

--
-- Name: deletevds_spm_id_map(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletevds_spm_id_map(v_vds_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
	
   DELETE FROM vds_spm_id_map
   WHERE vds_id = v_vds_id;
    
END; ';


ALTER FUNCTION public.deletevds_spm_id_map(v_vds_id uuid) OWNER TO postgres;

--
-- Name: deletevdsdynamic(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletevdsdynamic(v_vds_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
   BEGIN
      DELETE FROM vds_dynamic
      WHERE vds_id = v_vds_id;
   END;
    
   RETURN;
END; ';


ALTER FUNCTION public.deletevdsdynamic(v_vds_id uuid) OWNER TO postgres;

--
-- Name: deletevdsgroup(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletevdsgroup(v_vds_group_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
   DECLARE
   v_val  UUID;
BEGIN
		-- Get (and keep) a shared lock with "right to upgrade to exclusive"
		-- in order to force locking parent before children 
      select   vds_group_id INTO v_val FROM vds_groups  WHERE vds_group_id = v_vds_group_id     FOR UPDATE;
      DELETE FROM vds_groups
      WHERE vds_group_id = v_vds_group_id;
		-- delete VDS group permissions --
      DELETE FROM permissions where object_id = v_vds_group_id;
END; ';


ALTER FUNCTION public.deletevdsgroup(v_vds_group_id uuid) OWNER TO postgres;

--
-- Name: deletevdsstatic(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletevdsstatic(v_vds_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN  
   BEGIN
      UPDATE vm_static
      SET dedicated_vm_for_vds = null,
          migration_support = 0
      WHERE dedicated_vm_for_vds = v_vds_id;
      DELETE FROM tags_vds_map
      WHERE vds_id = v_vds_id;  
   -- Delete all Vds Alerts from the database  
      PERFORM DeleteAuditLogAlertsByVdsID(v_vds_id);
      DELETE FROM vds_static
      WHERE vds_id = v_vds_id;
	-- delete VDS permissions --
      DELETE FROM permissions where object_id = v_vds_id;
   END;  
       
   RETURN;
END; ';


ALTER FUNCTION public.deletevdsstatic(v_vds_id uuid) OWNER TO postgres;

--
-- Name: deletevdsstatistics(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletevdsstatistics(v_vds_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
   BEGIN
      DELETE FROM vds_statistics
      WHERE vds_id = v_vds_id;
   END;
    
   RETURN;
END; ';


ALTER FUNCTION public.deletevdsstatistics(v_vds_id uuid) OWNER TO postgres;

--
-- Name: deletevm(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletevm(v_vm_guid uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
   DECLARE
   v_vmt_guid  UUID;
BEGIN
      select   vm_static.vmt_guid INTO v_vmt_guid FROM vm_static WHERE vm_guid = v_vm_guid;
      UPDATE vm_static
      SET child_count =(SELECT COUNT(*) FROM vm_static WHERE vmt_guid = v_vmt_guid) -1
      WHERE vm_guid = v_vmt_guid;
      DELETE FROM tags_vm_map
      WHERE vm_id = v_vm_guid;
      DELETE FROM vm_statistics WHERE vm_guid = v_vm_guid;
      DELETE FROM vm_dynamic WHERE vm_guid = v_vm_guid;
      DELETE FROM vm_static WHERE vm_guid = v_vm_guid;
      DELETE FROM permissions where object_id = v_vm_guid;
END; ';


ALTER FUNCTION public.deletevm(v_vm_guid uuid) OWNER TO postgres;

--
-- Name: deletevm_interface(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletevm_interface(v_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
   DECLARE
   v_val  UUID;
BEGIN
	
	-- Get (and keep) a shared lock with "right to upgrade to exclusive"
	-- in order to force locking parent before children 
   select   id INTO v_val FROM vm_interface  WHERE id = v_id     FOR UPDATE;
	
   DELETE FROM vm_interface
   WHERE id = v_id;
    
END; ';


ALTER FUNCTION public.deletevm_interface(v_id uuid) OWNER TO postgres;

--
-- Name: deletevm_interface_statistics(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletevm_interface_statistics(v_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
   DECLARE
   v_val  UUID;
BEGIN
	
	-- Get (and keep) a shared lock with "right to upgrade to exclusive"
	-- in order to force locking parent before children 
   select   id INTO v_val FROM vm_interface_statistics  WHERE id = v_id     FOR UPDATE;

   DELETE FROM vm_interface_statistics
   WHERE id = v_id;
    
END; ';


ALTER FUNCTION public.deletevm_interface_statistics(v_id uuid) OWNER TO postgres;

--
-- Name: deletevm_pool_map(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletevm_pool_map(v_vm_guid uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
   DECLARE
   v_val  VARCHAR(50);
BEGIN
		-- Get (and keep) a shared lock with "right to upgrade to exclusive"
		-- in order to force locking parent before children 
      select   vm_guid INTO v_val FROM vm_pool_map  WHERE vm_guid = v_vm_guid     FOR UPDATE;
      DELETE FROM vm_pool_map
      WHERE vm_guid = v_vm_guid;
END; ';


ALTER FUNCTION public.deletevm_pool_map(v_vm_guid uuid) OWNER TO postgres;

--
-- Name: deletevm_pools(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletevm_pools(v_vm_pool_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
   DECLARE
   v_val  UUID;
BEGIN
		-- Get (and keep) a shared lock with "right to upgrade to exclusive"
		-- in order to force locking parent before children 
      select   vm_pool_id INTO v_val FROM vm_pools  WHERE vm_pool_id = v_vm_pool_id     FOR UPDATE;
      DELETE FROM vm_pools
      WHERE vm_pool_id = v_vm_pool_id;

		-- delete VmPool permissions --
      DELETE FROM permissions where object_id = v_vm_pool_id;
END; ';


ALTER FUNCTION public.deletevm_pools(v_vm_pool_id uuid) OWNER TO postgres;

--
-- Name: deletevmdynamic(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletevmdynamic(v_vm_guid uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      DELETE FROM vm_dynamic
      WHERE vm_guid = v_vm_guid;
END; ';


ALTER FUNCTION public.deletevmdynamic(v_vm_guid uuid) OWNER TO postgres;

--
-- Name: deletevmstatic(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletevmstatic(v_vm_guid uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
   DECLARE
   v_val  UUID;
BEGIN
			-- Get (and keep) a shared lock with "right to upgrade to exclusive"
            -- in order to force locking parent before children 
      select   vm_guid INTO v_val FROM vm_static  WHERE vm_guid = v_vm_guid     FOR UPDATE;
      DELETE FROM vm_static
      WHERE vm_guid = v_vm_guid
      AND   entity_type = ''VM'';

			-- delete VM permissions --
      DELETE FROM permissions where object_id = v_vm_guid;
END; ';


ALTER FUNCTION public.deletevmstatic(v_vm_guid uuid) OWNER TO postgres;

--
-- Name: deletevmstatistics(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletevmstatistics(v_vm_guid uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      DELETE FROM vm_statistics
      WHERE vm_guid = v_vm_guid;
END; ';


ALTER FUNCTION public.deletevmstatistics(v_vm_guid uuid) OWNER TO postgres;

--
-- Name: deletevmtemplatedisk(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletevmtemplatedisk(v_it_guid uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      DELETE FROM image_vm_map
      WHERE image_id = v_it_guid;
      DELETE FROM image_templates
      WHERE it_guid = v_it_guid;
END; ';


ALTER FUNCTION public.deletevmtemplatedisk(v_it_guid uuid) OWNER TO postgres;

--
-- Name: deletevmtemplates(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION deletevmtemplates(v_vmt_guid uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
   DECLARE
   v_val  UUID;
BEGIN
        -- Get (and keep) a shared lock with "right to upgrade to exclusive"
		-- in order to force locking parent before children 
      select   vm_guid INTO v_val FROM vm_static  WHERE vm_guid = v_vmt_guid AND entity_type = ''TEMPLATE'' FOR UPDATE;
      DELETE FROM vm_static
      WHERE vm_guid = v_vmt_guid
      AND   entity_type = ''TEMPLATE'';
		-- delete Template permissions --
      DELETE FROM permissions where object_id = v_vmt_guid;
END; ';


ALTER FUNCTION public.deletevmtemplates(v_vmt_guid uuid) OWNER TO postgres;

--
-- Name: engine_record_license_usage(timestamp with time zone, integer, integer, integer, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION engine_record_license_usage(v_dt timestamp with time zone, v_lic_desktops integer, v_used_desktops integer, v_lic_sockets integer, v_used_sockets integer) RETURNS void
    LANGUAGE plpgsql
    AS '
   DECLARE
   v_current_lic_desktops  INTEGER;
   v_current_used_desktops  INTEGER; 
   v_current_lic_sockets  INTEGER;
   v_current_used_sockets  INTEGER; 
   v_month  INTEGER;
   v_year  CHAR(4);
   v_quarter  CHAR(7);
   v_now  TIMESTAMP WITH TIME ZONE;
   SWV_dt TIMESTAMP WITH TIME ZONE;
   SWV_used_desktops INTEGER;
   SWV_used_sockets INTEGER;
   v_update_info  BOOLEAN;
BEGIN
   SWV_dt := v_dt;
   SWV_used_desktops := v_used_desktops;
   SWV_used_sockets := v_used_sockets;
   if (SWV_dt is NULL) then
      SWV_dt := LOCALTIMESTAMP;
   end if;
   v_month := EXTRACT(MONTH FROM SWV_dt);
   v_year := cast(EXTRACT(YEAR FROM SWV_dt) as CHAR(30));
   if (v_month > 0 and v_month < 4) then
      v_quarter := ''Q1 '' || coalesce(v_year,'''');
   else 
      if (v_month > 3 and v_month < 7) then
         v_quarter := ''Q2 '' || coalesce(v_year,'''');
      else 
         if (v_month > 6 and v_month < 10) then
            v_quarter := ''Q3 '' || coalesce(v_year,'''');
         else
            v_quarter := ''Q4 '' || coalesce(v_year,'''');
         end if;
      end if;
   end if;
   if exists(select quarter from engine_license_usage where quarter = v_quarter) then
      select   lic_desktops, max_used_desktops, lic_sockets, max_used_sockets INTO v_current_lic_desktops,v_current_used_desktops,v_current_lic_sockets,v_current_used_sockets from engine_license_usage where quarter = v_quarter;
      v_update_info := 0;
      if (SWV_used_desktops > v_current_used_desktops or
      SWV_used_sockets > v_current_used_sockets or
      v_lic_desktops > v_current_lic_desktops or
      v_lic_sockets > v_current_lic_sockets) then
         v_update_info := 1;
      end if;
      if (SWV_used_desktops <= v_current_used_desktops) then
         SWV_used_desktops := v_current_used_desktops;
      end if;
      if (SWV_used_sockets <= v_current_used_sockets) then
         SWV_used_sockets := v_current_used_sockets;
      end if;
      if (v_update_info = true) then
         update engine_license_usage
         set date = SWV_dt,lic_desktops = v_lic_desktops,lic_sockets = v_lic_sockets,
         max_used_desktops = SWV_used_desktops,max_used_sockets = SWV_used_sockets
         where quarter = v_quarter;
      end if;
   else
insert INTO engine_license_usage  values(SWV_dt,v_quarter,v_lic_desktops,SWV_used_desktops,v_lic_sockets,SWV_used_sockets);
   end if;
	
END; ';


ALTER FUNCTION public.engine_record_license_usage(v_dt timestamp with time zone, v_lic_desktops integer, v_used_desktops integer, v_lic_sockets integer, v_used_sockets integer) OWNER TO postgres;

--
-- Name: fn_db_add_column(character varying, character varying, text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION fn_db_add_column(v_table character varying, v_column character varying, v_column_def text) RETURNS void
    LANGUAGE plpgsql
    AS '
declare
v_sql text;

begin
	if (not exists (select 1 from information_schema.columns where table_name ilike v_table and column_name ilike v_column)) then
	    begin
		v_sql := ''ALTER TABLE '' || v_table || '' ADD COLUMN '' || v_column || '' '' || v_column_def;
		EXECUTE v_sql;
            end;
	end if;
END; ';


ALTER FUNCTION public.fn_db_add_column(v_table character varying, v_column character varying, v_column_def text) OWNER TO postgres;

--
-- Name: fn_db_add_config_value(character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION fn_db_add_config_value(v_option_name character varying, v_option_value character varying, v_version character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
begin
    if (not exists (select 1 from vdc_options where option_name ilike v_option_name and version = v_version)) then
        begin
            insert into vdc_options (option_name, option_value, version) values (v_option_name, v_option_value, v_version);
        end;
    end if;
END; ';


ALTER FUNCTION public.fn_db_add_config_value(v_option_name character varying, v_option_value character varying, v_version character varying) OWNER TO postgres;

--
-- Name: fn_db_change_column_type(character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION fn_db_change_column_type(v_table character varying, v_column character varying, v_type character varying, v_new_type character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
declare
v_sql text;

begin
	if (exists (select 1 from information_schema.columns where table_name ilike v_table and column_name ilike v_column and (udt_name ilike v_type or data_type ilike v_type))) then
	    begin
		v_sql := ''ALTER TABLE '' || v_table || '' ALTER COLUMN '' || v_column || '' TYPE '' || v_new_type;
		EXECUTE v_sql;
            end;
	end if;
END; ';


ALTER FUNCTION public.fn_db_change_column_type(v_table character varying, v_column character varying, v_type character varying, v_new_type character varying) OWNER TO postgres;

--
-- Name: fn_db_delete_config_value(character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION fn_db_delete_config_value(v_option_name character varying, v_version character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
begin
    if (exists (select 1 from vdc_options where option_name ilike v_option_name and version = v_version)) then
        begin
            delete from vdc_options where option_name ilike v_option_name and version = v_version;
        end;
    end if;
END; ';


ALTER FUNCTION public.fn_db_delete_config_value(v_option_name character varying, v_version character varying) OWNER TO postgres;

--
-- Name: fn_db_drop_column(character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION fn_db_drop_column(v_table character varying, v_column character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
declare
v_sql text;
begin
        if (exists (select 1 from information_schema.columns where table_name ilike v_table and column_name ilike v_column)) then
            begin
                v_sql := ''ALTER TABLE '' || v_table || '' DROP COLUMN '' || v_column;
                EXECUTE v_sql;
            end;
        end if;
end;';


ALTER FUNCTION public.fn_db_drop_column(v_table character varying, v_column character varying) OWNER TO postgres;

--
-- Name: fn_db_update_config_value(character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION fn_db_update_config_value(v_option_name character varying, v_option_value character varying, v_version character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
begin
    if (exists (select 1 from vdc_options where option_name ilike v_option_name and version = v_version)) then
        begin
            update  vdc_options set option_value = v_option_value
            where option_name ilike v_option_name and version = v_version;
        end;
    end if;
END; ';


ALTER FUNCTION public.fn_db_update_config_value(v_option_name character varying, v_option_value character varying, v_version character varying) OWNER TO postgres;

--
-- Name: fn_db_update_default_config_value(character varying, character varying, character varying, character varying, boolean); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION fn_db_update_default_config_value(v_option_name character varying, v_default_option_value character varying, v_option_value character varying, v_version character varying, v_ignore_default_value_case boolean) RETURNS void
    LANGUAGE plpgsql
    AS '
begin
    if (exists (select 1 from vdc_options where option_name ilike v_option_name and version = v_version)) then
        begin
            if (v_ignore_default_value_case)
            then
               update  vdc_options set option_value = v_option_value
               where option_name ilike v_option_name and option_value ilike v_default_option_value and version = v_version;
            else
               update  vdc_options set option_value = v_option_value
               where option_name ilike v_option_name and option_value = v_default_option_value and version = v_version;
            end if;
        end;
    end if;
END; ';


ALTER FUNCTION public.fn_db_update_default_config_value(v_option_name character varying, v_default_option_value character varying, v_option_value character varying, v_version character varying, v_ignore_default_value_case boolean) OWNER TO postgres;

--
-- Name: fn_get_ad_element_name(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION fn_get_ad_element_name(v_ad_element_id uuid) RETURNS text
    LANGUAGE plpgsql
    AS '
DECLARE
    result text;

BEGIN
   if (v_ad_element_id = getGlobalIds(''everyone'')) then
      result := ''Everyone'';
   else
      select(COALESCE(name,'''') || '' '' || COALESCE(surname,'''') || '' ('' || COALESCE(username,'''') || '')'') INTO result from users where user_id = v_ad_element_id;
      if (result is null) then
         select   name INTO result from ad_groups where ID = v_ad_element_id;
      end if;
   end if;
   return result;
END; ';


ALTER FUNCTION public.fn_get_ad_element_name(v_ad_element_id uuid) OWNER TO postgres;

--
-- Name: fn_get_column_size(character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION fn_get_column_size(v_table character varying, v_column character varying) RETURNS integer
    LANGUAGE plpgsql
    AS '
   declare
   retvalue  integer;
BEGIN
   retvalue := character_maximum_length from information_schema.columns
    where
    table_name ilike v_table and column_name ilike v_column and
    table_schema = ''public'' and udt_name in (''char'',''varchar'');
   return retvalue;
END; ';


ALTER FUNCTION public.fn_get_column_size(v_table character varying, v_column character varying) OWNER TO postgres;

--
-- Name: fn_get_disk_commited_value_by_storage(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION fn_get_disk_commited_value_by_storage(v_storage_domain_id uuid) RETURNS integer
    LANGUAGE plpgsql
    AS '
DECLARE
    result integer;
    mult bigint;

BEGIN
	mult := ( SELECT
	    		COALESCE(SUM(images.size - disk_image_dynamic.actual_size),0)
				FROM images JOIN
	    			disk_image_dynamic ON ( images.image_guid = disk_image_dynamic.image_id )
				WHERE
   					images.storage_id = v_storage_domain_id );
        -- convert to GB from bytes
	mult := CAST((mult * 0.000000000931322574615478515625) AS bigint);
        result := CAST(mult as integer); 

	RETURN result;
END;';


ALTER FUNCTION public.fn_get_disk_commited_value_by_storage(v_storage_domain_id uuid) OWNER TO postgres;

--
-- Name: fn_get_entity_name(uuid, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION fn_get_entity_name(v_entity_id uuid, v_object_type integer) RETURNS text
    LANGUAGE plpgsql
    AS '
/*    Gets object name by its id and type

    Object Types (compatible with VdcObjectType, XXX entries are unused currently)
        Unknown XXX,
        System XXX,
        VM = 2,
        VDS = 3,
        VmTemplate = 4,
        VmPool = 5,
        AdElements XXX,
        Tags XXX,
        Bookmarks XXX,
        VdsGroups = 9,
        MultiLevelAdministration XXX,
        Storage = 11,
        EventNotification XXX,
        ImportExport XXX,
        StoragePool = 14,
        User = 15,
        Role = 16
*/
DECLARE
    v_entity_type int4 := v_object_type;
    result text;

BEGIN
  
    CASE
    WHEN v_entity_type = 1 THEN
        result := ''System'';
    WHEN v_entity_type = 2 OR v_entity_type = 4 THEN
        result := ( SELECT vm_name FROM vm_static WHERE vm_guid = v_entity_id );
    WHEN v_entity_type = 3 THEN
        result := ( SELECT vds_name FROM vds_static WHERE vds_id = v_entity_id );
    WHEN v_entity_type = 5 THEN
        result := ( SELECT vm_pool_name FROM vm_pools WHERE vm_pool_id = v_entity_id );
    WHEN v_entity_type = 9 THEN
        result := ( SELECT name FROM vds_groups WHERE vds_group_id = v_entity_id );
    WHEN v_entity_type = 11 THEN
	result := ( SELECT storage_name FROM storage_domain_static WHERE id = v_entity_id );
    WHEN v_entity_type = 14 THEN
        result := ( SELECT name FROM storage_pool WHERE id = v_entity_id );
    ELSE
        result := ''Unknown type '' ||  v_entity_type;
    END CASE;

--      -- This should be written to an error var or include object_id that is missing
--    IF result IS NULL THEN
--        result := v_entity_id || '''' NOT FOUND'''';
--    END IF;
    RETURN result;
END;';


ALTER FUNCTION public.fn_get_entity_name(v_entity_id uuid, v_object_type integer) OWNER TO postgres;

--
-- Name: fn_get_entity_parents(uuid, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION fn_get_entity_parents(v_entity_id uuid, v_object_type integer) RETURNS SETOF iduuidtype
    LANGUAGE plpgsql
    AS '
/*	Gets a list of all parent GUID to the system root (including)

	Object Types (compatible with VdcObjectType, XXX entries are unused currently)
		Unknown XXX,
		System XXX,
		VM = 2,
		VDS = 3,
		VmTemplate = 4,
		VmPool = 5,
		AdElements XXX,
		Tags XXX,
		Bookmarks XXX,
		VdsGroups = 9,
		MultiLevelAdministration XXX,
		Storage = 11,
		EventNotification XXX,
		ImportExport XXX,
		StoragePool = 14,
		User = 15,
		Role = 16
*/
DECLARE
	v_entity_type int4 := v_object_type;
	system_root_id uuid;
	cluster_id uuid;
	ds_id uuid;
	v_image_id uuid;
	v_storage_id uuid;

BEGIN

	system_root_id := ( SELECT getGlobalIds(''system'') ); -- hardcoded also in MLA Handler
	CASE
	WHEN v_entity_type = 2 THEN -- VM
        -- get cluster id
		cluster_id := ( SELECT vds_group_id FROM vm_static WHERE vm_guid = v_entity_id );
		-- get data center id
		ds_id := ( SELECT storage_pool_id FROM vds_groups WHERE vds_group_id = cluster_id );

		RETURN QUERY
			SELECT system_root_id AS id
			UNION
			SELECT ds_id AS id
			UNION
			SELECT cluster_id AS id
			UNION
			SELECT v_entity_id AS id;
	WHEN v_entity_type = 3 THEN -- VDS
        -- get cluster id
		cluster_id := ( SELECT vds_group_id FROM vds_static WHERE vds_id = v_entity_id );
		-- get data center id
		ds_id := ( SELECT storage_pool_id FROM vds_groups WHERE vds_group_id = cluster_id );

		RETURN QUERY
			SELECT system_root_id AS id
			UNION
			SELECT ds_id AS id
			UNION
			SELECT cluster_id AS id
			UNION
			SELECT v_entity_id AS id;
	WHEN v_entity_type = 4 THEN -- Template
		-- get image id first
		v_image_id := ( SELECT image_id FROM image_vm_map WHERE vm_id = v_entity_id limit 1);
		-- get the storage id from images
		v_storage_id := ( SELECT storage_id FROM images WHERE image_guid = v_image_id );
		-- finally get data center id
		ds_id := ( SELECT storage_pool_id FROM storage_pool_iso_map WHERE storage_id = v_storage_id );

		RETURN QUERY
			SELECT system_root_id AS id
			UNION
			SELECT ds_id AS id
			UNION
			SELECT v_entity_id AS id;
	WHEN v_entity_type = 5 THEN -- VM Pool
        -- get cluster id
		cluster_id := ( SELECT vds_group_id FROM vm_pools WHERE vm_pool_id = v_entity_id );
		-- get data center id
		ds_id := ( SELECT storage_pool_id FROM vds_groups WHERE vds_group_id = cluster_id );

		RETURN QUERY
			SELECT system_root_id AS id
			UNION
			SELECT ds_id AS id
			UNION
			SELECT cluster_id AS id
			UNION
			SELECT v_entity_id AS id;
	WHEN v_entity_type = 9 THEN -- Cluster
		-- get data center id
		ds_id := ( SELECT storage_pool_id FROM vds_groups WHERE vds_group_id = v_entity_id );

		RETURN QUERY
			SELECT system_root_id AS id
			UNION
			SELECT ds_id AS id
			UNION
			SELECT v_entity_id AS id;
	ELSE
		IF v_entity_type IN ( 1,14,11,15,16 ) THEN -- Data Center, storage, users and roles are under system
			RETURN QUERY
				SELECT system_root_id AS id
				UNION
				SELECT v_entity_id AS id;
		END IF;
	END CASE;
END;';


ALTER FUNCTION public.fn_get_entity_parents(v_entity_id uuid, v_object_type integer) OWNER TO postgres;

--
-- Name: fn_get_storage_domain_shared_status_by_domain_id(uuid, character varying, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION fn_get_storage_domain_shared_status_by_domain_id(v_storage_domain_id uuid, v_storage character varying, v_storage_type integer) RETURNS integer
    LANGUAGE plpgsql
    AS '
   DECLARE
   v_result  INTEGER;
   v_rowsCount  INTEGER;
   v_status  INTEGER;
BEGIN
   BEGIN
      CREATE GLOBAL TEMPORARY TABLE tt_TEMP22
      (
         status INTEGER, 
         count INTEGER
      ) WITH OIDS;
      exception when others then
         truncate table tt_TEMP22;
   END;
   delete from tt_TEMP22;
   Insert INTO tt_TEMP22
   select status, count(storage_id) from storage_pool_iso_map
   where storage_id = v_storage_domain_id
   group by status;

   select   count(*) INTO v_rowsCount from tt_TEMP22;

	-- if return 0 rows then the domain is unattached (0) or locked (4) if storage is null or empty for @storage_type iscsi (2) and fcp (3)
   if (v_rowsCount = 0) then
      if (v_storage_type in(2,3) and (v_storage is null or v_storage = '''')) then
         v_result := 4;
      else
         v_result := 0;
      end if;
   else 
      if (v_rowsCount = 1) then
         select   status INTO v_status from tt_TEMP22    LIMIT 1;
			-- if 1 row and status active (3) then domain is active (1)
         if v_status = 3 then
            v_result := 1;
			-- if 1 row and status not active then domain is inactive (2)
         else
            v_result := 2;
         end if;
	-- else (if return more then 1 row) 
      else
         select   count(*) INTO v_rowsCount from tt_TEMP22 where status = 3;
         if (v_rowsCount > 0) then
            v_result := 3;
			-- non of the statuses is active
         else
            v_result := 2;
         end if;
      end if;
   end if;
   return v_result;
END; ';


ALTER FUNCTION public.fn_get_storage_domain_shared_status_by_domain_id(v_storage_domain_id uuid, v_storage character varying, v_storage_type integer) OWNER TO postgres;

SET default_tablespace = '';

SET default_with_oids = true;

--
-- Name: storage_pool; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE storage_pool (
    id uuid NOT NULL,
    name character varying(40) NOT NULL,
    description character varying(4000) NOT NULL,
    storage_pool_type integer NOT NULL,
    storage_pool_format_type character varying(50),
    status integer NOT NULL,
    master_domain_version integer NOT NULL,
    spm_vds_id uuid,
    compatibility_version character varying(40) DEFAULT '2.2'::character varying NOT NULL,
    _create_date timestamp with time zone DEFAULT ('now'::text)::timestamp without time zone,
    _update_date timestamp with time zone
);


ALTER TABLE public.storage_pool OWNER TO postgres;

--
-- Name: fn_perms_get_storage_pools_with_permitted_action_on_vds_groups(uuid, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION fn_perms_get_storage_pools_with_permitted_action_on_vds_groups(v_user_id uuid, v_action_group_id integer) RETURNS SETOF storage_pool
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT * 
      FROM storage_pool
      WHERE storage_pool.id in 
	(SELECT storage_pool_id 
	 FROM vds_groups 
	 WHERE (SELECT get_entity_permissions(v_user_id, v_action_group_id, vds_groups.vds_group_id, 9)) IS NOT NULL);
END; ';


ALTER FUNCTION public.fn_perms_get_storage_pools_with_permitted_action_on_vds_groups(v_user_id uuid, v_action_group_id integer) OWNER TO postgres;

--
-- Name: vds_groups; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vds_groups (
    vds_group_id uuid NOT NULL,
    name character varying(40) NOT NULL,
    description character varying(4000),
    cpu_name character varying(255),
    _create_date timestamp with time zone DEFAULT ('now'::text)::timestamp without time zone,
    _update_date timestamp with time zone,
    selection_algorithm integer DEFAULT 0 NOT NULL,
    high_utilization integer DEFAULT 75 NOT NULL,
    low_utilization integer DEFAULT 0 NOT NULL,
    cpu_over_commit_duration_minutes integer DEFAULT 2 NOT NULL,
    hypervisor_type integer DEFAULT 0 NOT NULL,
    storage_pool_id uuid,
    max_vds_memory_over_commit integer DEFAULT 100 NOT NULL,
    compatibility_version character varying(40) DEFAULT '2.2'::character varying NOT NULL,
    transparent_hugepages boolean DEFAULT false NOT NULL,
    migrate_on_error integer DEFAULT 1 NOT NULL
);


ALTER TABLE public.vds_groups OWNER TO postgres;

--
-- Name: vm_static; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm_static (
    vm_guid uuid NOT NULL,
    vm_name character varying(255) NOT NULL,
    mem_size_mb integer NOT NULL,
    vmt_guid uuid NOT NULL,
    os integer DEFAULT 0 NOT NULL,
    description character varying(4000),
    vds_group_id uuid NOT NULL,
    domain character varying(40),
    creation_date timestamp with time zone,
    num_of_monitors integer NOT NULL,
    is_initialized boolean,
    is_auto_suspend boolean DEFAULT false,
    num_of_sockets integer DEFAULT 1 NOT NULL,
    cpu_per_socket integer DEFAULT 1 NOT NULL,
    usb_policy integer,
    time_zone character varying(40),
    is_stateless boolean,
    fail_back boolean DEFAULT false NOT NULL,
    _create_date timestamp with time zone DEFAULT ('now'::text)::timestamp without time zone,
    _update_date timestamp with time zone,
    dedicated_vm_for_vds uuid,
    auto_startup boolean,
    vm_type integer DEFAULT 0 NOT NULL,
    hypervisor_type integer DEFAULT 0 NOT NULL,
    operation_mode integer DEFAULT 0 NOT NULL,
    nice_level integer DEFAULT 0 NOT NULL,
    default_boot_sequence integer DEFAULT 0 NOT NULL,
    default_display_type integer DEFAULT 0 NOT NULL,
    priority integer DEFAULT 0 NOT NULL,
    iso_path character varying(4000) DEFAULT ''::character varying,
    origin integer DEFAULT 0,
    initrd_url character varying(4000),
    kernel_url character varying(4000),
    kernel_params character varying(4000),
    migration_support integer DEFAULT 0 NOT NULL,
    userdefined_properties character varying(4000),
    predefined_properties character varying(4000),
    min_allocated_mem integer DEFAULT 0 NOT NULL,
    entity_type character varying(32) NOT NULL,
    child_count integer DEFAULT 0,
    template_status integer
);


ALTER TABLE public.vm_static OWNER TO postgres;

--
-- Name: vm_templates_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW vm_templates_view AS
    SELECT vm_templates.vm_guid AS vmt_guid, vm_templates.vm_name AS name, vm_templates.mem_size_mb, vm_templates.os, vm_templates.creation_date, vm_templates.child_count, vm_templates.num_of_sockets, vm_templates.cpu_per_socket, (vm_templates.num_of_sockets * vm_templates.cpu_per_socket) AS num_of_cpus, vm_templates.description, vm_templates.vds_group_id, vm_templates.domain, vm_templates.num_of_monitors, vm_templates.template_status AS status, vm_templates.usb_policy, vm_templates.time_zone, vm_templates.is_auto_suspend, vm_templates.fail_back, vds_groups.name AS vds_group_name, vm_templates.vm_type, vm_templates.hypervisor_type, vm_templates.operation_mode, vm_templates.nice_level, storage_pool.id AS storage_pool_id, storage_pool.name AS storage_pool_name, vm_templates.default_boot_sequence, vm_templates.default_display_type, vm_templates.priority, vm_templates.auto_startup, vm_templates.is_stateless, vm_templates.iso_path, vm_templates.origin, vm_templates.initrd_url, vm_templates.kernel_url, vm_templates.kernel_params FROM ((vm_static vm_templates JOIN vds_groups ON ((vm_templates.vds_group_id = vds_groups.vds_group_id))) LEFT JOIN storage_pool ON ((storage_pool.id = vds_groups.storage_pool_id))) WHERE ((vm_templates.entity_type)::text = 'TEMPLATE'::text);


ALTER TABLE public.vm_templates_view OWNER TO postgres;

--
-- Name: fn_perms_get_templates_with_permitted_action(uuid, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION fn_perms_get_templates_with_permitted_action(v_user_id uuid, v_action_group_id integer) RETURNS SETOF vm_templates_view
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT * 
      FROM vm_templates_view 
      WHERE (SELECT get_entity_permissions(v_user_id, v_action_group_id, vm_templates_view.vmt_guid, 4)) IS NOT NULL;
END; ';


ALTER FUNCTION public.fn_perms_get_templates_with_permitted_action(v_user_id uuid, v_action_group_id integer) OWNER TO postgres;

--
-- Name: fn_perms_get_vds_groups_with_permitted_action(uuid, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION fn_perms_get_vds_groups_with_permitted_action(v_user_id uuid, v_action_group_id integer) RETURNS SETOF vds_groups
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT * 
      FROM vds_groups 
      WHERE (SELECT get_entity_permissions(v_user_id, v_action_group_id, vds_groups.vds_group_id, 9)) IS NOT NULL;
END; ';


ALTER FUNCTION public.fn_perms_get_vds_groups_with_permitted_action(v_user_id uuid, v_action_group_id integer) OWNER TO postgres;

--
-- Name: fn_user_permissions(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION fn_user_permissions(v_userid uuid) RETURNS SETOF user_permissions
    LANGUAGE plpgsql
    AS '
DECLARE

BEGIN
	RETURN QUERY
	    SELECT
		    permissions.id AS permission_id,
		    permissions.role_id,
		    permissions.ad_element_id AS user_id
	    FROM permissions
		INNER JOIN users ON permissions.ad_element_id = users.user_id
	    WHERE users.user_id = v_userId

	    UNION

	    SELECT
		    permissions.id AS permission_id,
		    permissions.role_id,
		    temp.user_id AS user_id
	    FROM permissions INNER JOIN
	    (
		    -- get all groups of admin users
		    SELECT ad_groups.id group_id, users.user_id
		    FROM ad_groups, users
		    WHERE ad_groups.id IN
		    (SELECT * FROM fnsplitteruuid(users.group_ids))
			AND users.user_id = v_userId ) temp
		ON permissions.ad_element_id = temp.group_id;

END; ';


ALTER FUNCTION public.fn_user_permissions(v_userid uuid) OWNER TO postgres;

--
-- Name: fnsplitter(text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION fnsplitter(ids text) RETURNS SETOF idtexttype
    LANGUAGE plpgsql
    AS '
BEGIN
	RETURN QUERY
		SELECT regexp_split_to_table(ids, '','') AS id;
END; ';


ALTER FUNCTION public.fnsplitter(ids text) OWNER TO postgres;

--
-- Name: fnsplitteruuid(text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION fnsplitteruuid(ids text) RETURNS SETOF iduuidtype
    LANGUAGE plpgsql
    AS '
DECLARE
    tempc REFCURSOR;
    currow TEXT;
    result idUuidType;
BEGIN
  IF ids != '''' THEN
    OPEN tempc FOR SELECT regexp_split_to_table(ids, '','');
    FETCH tempc INTO currow;
    WHILE FOUND LOOP
        result := CAST (ROW(currow) AS idUuidType);
        RETURN NEXT result;
        FETCH tempc INTO currow;
   END LOOP;
   CLOSE tempc;
  END IF;
END; ';


ALTER FUNCTION public.fnsplitteruuid(ids text) OWNER TO postgres;

--
-- Name: force_delete_storage_domain(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION force_delete_storage_domain(v_storage_domain_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
	
	-- delete the map between the domain to templates that was copied to it
   delete FROM image_group_storage_domain_map where storage_domain_id = v_storage_domain_id;

	-- update images that their first storage domain was this and are on other domains (set the storage_id field to any other domain)
   update images set storage_id =(select  storage_domain_id from image_group_storage_domain_map map where images.image_group_id = map.image_group_id LIMIT 1)
   where storage_id = v_storage_domain_id and image_group_id in(select image_group_id from image_group_storage_domain_map);

	-- delete relations that are now duplicate because of the previous update action
   delete FROM image_group_storage_domain_map where image_group_id in(select images.image_group_id from images, image_group_storage_domain_map imap
   where images.image_group_id = imap.image_group_id and images.storage_id = imap.storage_domain_id);
	
   BEGIN
      CREATE GLOBAL TEMPORARY TABLE tt_TEMPTEMPLATESTABLE AS select vmt_guid
	
         from vm_template_disk where vtim_it_guid in(select image_guid from images where storage_id = v_storage_domain_id);
      exception when others then
         truncate table tt_TEMPTEMPLATESTABLE;
         insert into tt_TEMPTEMPLATESTABLE select vmt_guid
	
         from vm_template_disk where vtim_it_guid in(select image_guid from images where storage_id = v_storage_domain_id);
   END;

   BEGIN
      CREATE GLOBAL TEMPORARY TABLE tt_TEMPTEMPLATEIMAGESTABLE AS select image_id
	
         from image_vm_map AS vm_template_image_map where vm_id in(select vmt_guid from tt_TEMPTEMPLATESTABLE);
      exception when others then
         truncate table tt_TEMPTEMPLATEIMAGESTABLE;
         insert into tt_TEMPTEMPLATEIMAGESTABLE select image_id
	
         from image_vm_map AS vm_template_image_map where vm_id in(select vmt_guid from tt_TEMPTEMPLATESTABLE);
   END;

   delete FROM permissions where object_id in (select vm_guid from vm_images_view where storage_id = v_storage_domain_id);
   delete FROM vm_static where vm_guid in(select vm_guid from vm_images_view where storage_id = v_storage_domain_id)
   or vmt_guid in(select vmt_guid from tt_TEMPTEMPLATESTABLE);

   delete FROM images where storage_id = v_storage_domain_id;

   delete FROM image_vm_map where vm_id in(select vmt_guid from tt_TEMPTEMPLATESTABLE);

   delete FROM image_templates where it_guid in(select it_guid from tt_TEMPTEMPLATEIMAGESTABLE);

   delete FROM vm_interface where vmt_guid in(select vmt_guid from tt_TEMPTEMPLATESTABLE);
   delete FROM permissions where object_id in (select vmt_guid from tt_TEMPTEMPLATESTABLE);
   delete FROM permissions where object_id = v_storage_domain_id;
   delete from vm_static where vm_guid in(select vmt_guid from tt_TEMPTEMPLATESTABLE);
   delete FROM storage_domain_dynamic where id  = v_storage_domain_id;
   delete FROM storage_domain_static where id  = v_storage_domain_id;
    
END; ';


ALTER FUNCTION public.force_delete_storage_domain(v_storage_domain_id uuid) OWNER TO postgres;

--
-- Name: generate_drop_all_functions_syntax(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION generate_drop_all_functions_syntax() RETURNS SETOF text
    LANGUAGE plpgsql
    AS '
BEGIN
RETURN QUERY select ''drop function if exists '' || ns.nspname || ''.'' || proname || ''('' || oidvectortypes(proargtypes) || '') cascade;'' from pg_proc inner join pg_namespace ns on (pg_proc.pronamespace=ns.oid) where ns.nspname = ''public'' and proname not ilike ''uuid%'' order by proname;
END; ';


ALTER FUNCTION public.generate_drop_all_functions_syntax() OWNER TO postgres;

--
-- Name: generate_drop_all_views_syntax(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION generate_drop_all_views_syntax() RETURNS SETOF text
    LANGUAGE plpgsql
    AS '
BEGIN
RETURN QUERY select ''DROP VIEW if exists '' || table_name || '' CASCADE;'' from information_schema.views where table_schema = ''public'' order by table_name;
END; ';


ALTER FUNCTION public.generate_drop_all_views_syntax() OWNER TO postgres;

--
-- Name: get_all_child_roles_of_role(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION get_all_child_roles_of_role(v_roleid uuid) RETURNS SETOF iduuidtype
    LANGUAGE plpgsql
    AS '
   DECLARE
   SWV_Rs idUuidType;
BEGIN
   BEGIN
      CREATE GLOBAL TEMPORARY TABLE tt_TEMP
      (
         id UUID
      ) WITH OIDS;
      exception when others then
         truncate table tt_TEMP;
   END;
   insert into tt_TEMP(id) values(v_roleId);

   insert into tt_TEMP   with recursive c(role_id,role_container_id)
   as(select role_id AS role_id, role_container_id AS role_container_id from roles_relations
   where role_container_id = v_roleId
   union all
   select t.role_id AS role_id, t.role_container_id AS role_container_id
   from c join roles_relations t on c.role_id = t.role_container_id) select distinct role_id from c;

   FOR SWV_Rs IN(SELECT * FROM  tt_TEMP) LOOP
      RETURN NEXT SWV_Rs;
   END LOOP;
   RETURN;
END; ';


ALTER FUNCTION public.get_all_child_roles_of_role(v_roleid uuid) OWNER TO postgres;

--
-- Name: get_all_commands(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION get_all_commands() RETURNS SETOF get_all_commands_rs
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT distinct business_entity_snapshot.command_id, business_entity_snapshot.command_type
      FROM business_entity_snapshot;

END; ';


ALTER FUNCTION public.get_all_commands() OWNER TO postgres;

--
-- Name: get_entity_permissions(uuid, integer, uuid, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION get_entity_permissions(v_user_id uuid, v_action_group_id integer, v_object_id uuid, v_object_type_id integer, OUT v_permission_id uuid) RETURNS uuid
    LANGUAGE plpgsql
    AS '
   DECLARE
   v_everyone_object_id  UUID;
BEGIN
   v_everyone_object_id := getGlobalIds(''everyone''); -- hardcoded also in MLA Handler
   select   id INTO v_permission_id from permissions where
		-- get all roles of action
   role_id in(select role_id from roles_groups where action_group_id = v_action_group_id)
		-- get allparents of object
   and (object_id in(select id from  fn_get_entity_parents(v_object_id,v_object_type_id)))
		-- get user and his groups
   and (ad_element_id = v_everyone_object_id or
   ad_element_id = v_user_id or ad_element_id in(select id from getUserAndGroupsById(v_user_id)))   LIMIT 1;
END; ';


ALTER FUNCTION public.get_entity_permissions(v_user_id uuid, v_action_group_id integer, v_object_id uuid, v_object_type_id integer, OUT v_permission_id uuid) OWNER TO postgres;

--
-- Name: business_entity_snapshot; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE business_entity_snapshot (
    id uuid NOT NULL,
    command_id uuid NOT NULL,
    command_type character varying(256) NOT NULL,
    entity_id character varying(128),
    entity_type character varying(128),
    entity_snapshot text,
    snapshot_class character varying(128),
    snapshot_type integer,
    insertion_order integer
);


ALTER TABLE public.business_entity_snapshot OWNER TO postgres;

--
-- Name: get_entity_snapshot_by_command_id(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION get_entity_snapshot_by_command_id(v_command_id uuid) RETURNS SETOF business_entity_snapshot
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT business_entity_snapshot.*
      FROM business_entity_snapshot
      WHERE command_id = v_command_id order by insertion_order desc;
END; ';


ALTER FUNCTION public.get_entity_snapshot_by_command_id(v_command_id uuid) OWNER TO postgres;

--
-- Name: get_entity_snapshot_by_id(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION get_entity_snapshot_by_id(v_id uuid) RETURNS SETOF business_entity_snapshot
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT business_entity_snapshot.*
      FROM business_entity_snapshot
      WHERE id = v_id;
END; ';


ALTER FUNCTION public.get_entity_snapshot_by_id(v_id uuid) OWNER TO postgres;

--
-- Name: roles_groups; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE roles_groups (
    role_id uuid NOT NULL,
    action_group_id integer NOT NULL
);


ALTER TABLE public.roles_groups OWNER TO postgres;

--
-- Name: get_role_groups_by_role_id(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION get_role_groups_by_role_id(v_role_id uuid) RETURNS SETOF roles_groups
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM roles_groups
   where
   role_id = v_role_id;

END; ';


ALTER FUNCTION public.get_role_groups_by_role_id(v_role_id uuid) OWNER TO postgres;

--
-- Name: get_roles_groups_by_action_group_id_and_by_role_id(integer, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION get_roles_groups_by_action_group_id_and_by_role_id(v_action_group_id integer, v_role_id uuid) RETURNS SETOF roles_groups
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM roles_groups
   where
   action_group_id = v_action_group_id AND
   role_id = v_role_id;

END; ';


ALTER FUNCTION public.get_roles_groups_by_action_group_id_and_by_role_id(v_action_group_id integer, v_role_id uuid) OWNER TO postgres;

--
-- Name: get_seconds_to_wait_before_pm_operation(character varying, character varying, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION get_seconds_to_wait_before_pm_operation(v_vds_name character varying, v_event character varying, v_wait_for_sec integer) RETURNS integer
    LANGUAGE plpgsql
    AS '
declare v_last_event_dt timestamp with time zone;
declare v_now_dt timestamp with time zone;
BEGIN
      if exists(select 1 from audit_log where vds_name = v_vds_name and log_type_name = v_event) then
       begin
          v_last_event_dt := log_time
          from audit_log
          where vds_name = v_vds_name and log_type_name = v_event
          order by audit_log_id desc limit 1;
          v_now_dt :=  CURRENT_TIMESTAMP;
          RETURN cast((extract(epoch from v_last_event_dt) + v_wait_for_sec) - extract(epoch from v_now_dt) as int);
       end;
     else
          RETURN 0;
     end if;
END; ';


ALTER FUNCTION public.get_seconds_to_wait_before_pm_operation(v_vds_name character varying, v_event character varying, v_wait_for_sec integer) OWNER TO postgres;

--
-- Name: action_version_map; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE action_version_map (
    action_type integer NOT NULL,
    cluster_minimal_version character varying(40) NOT NULL,
    storage_pool_minimal_version character varying(40) NOT NULL
);


ALTER TABLE public.action_version_map OWNER TO postgres;

--
-- Name: getaction_version_mapbyaction_type(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getaction_version_mapbyaction_type(v_action_type integer) RETURNS SETOF action_version_map
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM action_version_map
   WHERE action_type = v_action_type;

END; ';


ALTER FUNCTION public.getaction_version_mapbyaction_type(v_action_type integer) OWNER TO postgres;

--
-- Name: ad_groups; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE ad_groups (
    id uuid NOT NULL,
    name character varying(256) NOT NULL,
    status integer NOT NULL,
    domain character varying(100),
    distinguishedname character varying(4000) DEFAULT NULL::character varying
);


ALTER TABLE public.ad_groups OWNER TO postgres;

--
-- Name: getad_groupsbyid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getad_groupsbyid(v_id uuid) RETURNS SETOF ad_groups
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT *
      FROM ad_groups
      WHERE id = v_id;
END; ';


ALTER FUNCTION public.getad_groupsbyid(v_id uuid) OWNER TO postgres;

--
-- Name: getad_groupsbyname(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getad_groupsbyname(v_name character varying) RETURNS SETOF ad_groups
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT *
      FROM ad_groups
      WHERE name = v_name;
END; ';


ALTER FUNCTION public.getad_groupsbyname(v_name character varying) OWNER TO postgres;

--
-- Name: getallfromaction_version_map(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromaction_version_map() RETURNS SETOF action_version_map
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM action_version_map;

END; ';


ALTER FUNCTION public.getallfromaction_version_map() OWNER TO postgres;

--
-- Name: getallfromad_groups(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromad_groups() RETURNS SETOF ad_groups
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT *
      FROM ad_groups;
END; ';


ALTER FUNCTION public.getallfromad_groups() OWNER TO postgres;

--
-- Name: async_tasks; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE async_tasks (
    task_id uuid NOT NULL,
    action_type integer NOT NULL,
    status integer NOT NULL,
    result integer NOT NULL,
    action_parameters text,
    action_params_class character varying(256)
);


ALTER TABLE public.async_tasks OWNER TO postgres;

--
-- Name: getallfromasync_tasks(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromasync_tasks() RETURNS SETOF async_tasks
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM async_tasks;

END; ';


ALTER FUNCTION public.getallfromasync_tasks() OWNER TO postgres;

--
-- Name: audit_log_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE audit_log_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.audit_log_seq OWNER TO postgres;

--
-- Name: audit_log_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('audit_log_seq', 129, true);


--
-- Name: audit_log; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE audit_log (
    audit_log_id bigint DEFAULT nextval('audit_log_seq'::regclass) NOT NULL,
    user_id uuid,
    user_name character varying(255),
    vm_id uuid,
    vm_name character varying(255),
    vm_template_id uuid,
    vm_template_name character varying(40),
    vds_id uuid,
    vds_name character varying(255),
    log_time timestamp with time zone NOT NULL,
    log_type_name character varying(100) DEFAULT ''::character varying,
    log_type integer NOT NULL,
    severity integer NOT NULL,
    message text NOT NULL,
    processed boolean DEFAULT false NOT NULL,
    storage_pool_id uuid,
    storage_pool_name character varying(40),
    storage_domain_id uuid,
    storage_domain_name character varying(250),
    vds_group_id uuid,
    vds_group_name character varying(255)
);


ALTER TABLE public.audit_log OWNER TO postgres;

--
-- Name: getallfromauditlog(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromauditlog() RETURNS SETOF audit_log
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT *
      FROM audit_log;
END; ';


ALTER FUNCTION public.getallfromauditlog() OWNER TO postgres;

--
-- Name: bookmarks; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE bookmarks (
    bookmark_id uuid NOT NULL,
    bookmark_name character varying(40),
    bookmark_value character varying(300) NOT NULL
);


ALTER TABLE public.bookmarks OWNER TO postgres;

--
-- Name: getallfrombookmarks(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfrombookmarks() RETURNS SETOF bookmarks
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT *
      FROM bookmarks;
END; ';


ALTER FUNCTION public.getallfrombookmarks() OWNER TO postgres;

--
-- Name: custom_actions_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE custom_actions_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.custom_actions_seq OWNER TO postgres;

--
-- Name: custom_actions_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('custom_actions_seq', 1, false);


--
-- Name: custom_actions; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE custom_actions (
    action_id integer DEFAULT nextval('custom_actions_seq'::regclass) NOT NULL,
    action_name character varying(50) NOT NULL,
    path character varying(300) NOT NULL,
    tab integer NOT NULL,
    description character varying(4000)
);


ALTER TABLE public.custom_actions OWNER TO postgres;

--
-- Name: getallfromcustom_actions(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromcustom_actions() RETURNS SETOF custom_actions
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT *
      FROM custom_actions;
END; ';


ALTER FUNCTION public.getallfromcustom_actions() OWNER TO postgres;

--
-- Name: disk_image_dynamic; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE disk_image_dynamic (
    image_id uuid NOT NULL,
    read_rate integer,
    write_rate integer,
    actual_size bigint NOT NULL,
    read_latency_seconds numeric(18,9),
    write_latency_seconds numeric(18,9),
    flush_latency_seconds numeric(18,9)
);


ALTER TABLE public.disk_image_dynamic OWNER TO postgres;

--
-- Name: getallfromdisk_image_dynamic(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromdisk_image_dynamic() RETURNS SETOF disk_image_dynamic
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM disk_image_dynamic;

END; ';


ALTER FUNCTION public.getallfromdisk_image_dynamic() OWNER TO postgres;

--
-- Name: disks; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE disks (
    disk_id uuid NOT NULL,
    status character varying(32) NOT NULL,
    internal_drive_mapping integer NOT NULL,
    active_image_id uuid,
    disk_type character varying(32) NOT NULL,
    disk_interface character varying(32) NOT NULL,
    wipe_after_delete boolean DEFAULT false NOT NULL,
    propagate_errors character varying(32) DEFAULT 'Off'::character varying NOT NULL
);


ALTER TABLE public.disks OWNER TO postgres;

--
-- Name: getallfromdisks(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromdisks() RETURNS SETOF disks
    LANGUAGE plpgsql
    AS '
BEGIN
    RETURN QUERY
    SELECT *
    FROM   disks;
END; ';


ALTER FUNCTION public.getallfromdisks() OWNER TO postgres;

--
-- Name: event_map; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE event_map (
    event_up_name character varying(100) NOT NULL,
    event_down_name character varying(100) NOT NULL
);


ALTER TABLE public.event_map OWNER TO postgres;

--
-- Name: event_subscriber; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE event_subscriber (
    subscriber_id uuid NOT NULL,
    event_up_name character varying(100) NOT NULL,
    method_id integer NOT NULL,
    method_address character varying(255),
    tag_name character varying(50) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.event_subscriber OWNER TO postgres;

--
-- Name: event_audit_log_subscriber_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW event_audit_log_subscriber_view AS
    SELECT 1 AS event_type, event_subscriber_1.subscriber_id, event_subscriber_1.event_up_name, event_subscriber_1.method_id, event_subscriber_1.method_address, event_subscriber_1.tag_name, audit_log_1.audit_log_id, audit_log_1.user_id, audit_log_1.user_name, audit_log_1.vm_id, audit_log_1.vm_name, audit_log_1.vm_template_id, audit_log_1.vm_template_name, audit_log_1.vds_id, audit_log_1.vds_name, audit_log_1.storage_pool_id, audit_log_1.storage_pool_name, audit_log_1.storage_domain_id, audit_log_1.storage_domain_name, audit_log_1.log_time, audit_log_1.severity, audit_log_1.message FROM (audit_log audit_log_1 JOIN event_subscriber event_subscriber_1 ON (((audit_log_1.log_type_name)::text = (event_subscriber_1.event_up_name)::text))) WHERE (audit_log_1.processed = false) UNION SELECT DISTINCT 0 AS event_type, event_subscriber.subscriber_id, audit_log.log_type_name AS event_up_name, event_subscriber.method_id, event_subscriber.method_address, event_subscriber.tag_name, audit_log.audit_log_id, audit_log.user_id, audit_log.user_name, audit_log.vm_id, audit_log.vm_name, audit_log.vm_template_id, audit_log.vm_template_name, audit_log.vds_id, audit_log.vds_name, audit_log.storage_pool_id, audit_log.storage_pool_name, audit_log.storage_domain_id, audit_log.storage_domain_name, audit_log.log_time, audit_log.severity, audit_log.message FROM ((audit_log audit_log JOIN event_map ON (((audit_log.log_type_name)::text = (event_map.event_down_name)::text))) JOIN event_subscriber event_subscriber ON (((event_subscriber.event_up_name)::text = (event_map.event_up_name)::text))) WHERE (audit_log.processed = false);


ALTER TABLE public.event_audit_log_subscriber_view OWNER TO postgres;

--
-- Name: getallfromevent_audit_log_subscriber(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromevent_audit_log_subscriber() RETURNS SETOF event_audit_log_subscriber_view
    LANGUAGE plpgsql
    AS '
   DECLARE
   v_last  BIGINT;
BEGIN
      -- begin tran

			
			-- get last event
			select   audit_log_id INTO v_last from audit_log    order by audit_log_id desc LIMIT 1;
			-- mark processed events
      update audit_log set processed = TRUE where audit_log_id <= v_last;
			-- get from view all events with id <= @last
      RETURN QUERY SELECT *
      from event_audit_log_subscriber_view  event_audit_log_subscriber_view
      where audit_log_id <= v_last;
END; ';


ALTER FUNCTION public.getallfromevent_audit_log_subscriber() OWNER TO postgres;

--
-- Name: getallfromevent_audit_log_subscriber_only(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromevent_audit_log_subscriber_only() RETURNS SETOF event_audit_log_subscriber_view
    LANGUAGE plpgsql
    AS '
   DECLARE
   v_last  BIGINT;
BEGIN
        -- get last event
        select   audit_log_id INTO v_last from audit_log order by audit_log_id desc LIMIT 1;
        -- get from view all events with id <= @last
        RETURN QUERY select *
                   from event_audit_log_subscriber_view  where audit_log_id <= v_last;
END; ';


ALTER FUNCTION public.getallfromevent_audit_log_subscriber_only() OWNER TO postgres;

--
-- Name: getallfromevent_map(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromevent_map() RETURNS SETOF event_map
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM event_map;

END; ';


ALTER FUNCTION public.getallfromevent_map() OWNER TO postgres;

--
-- Name: event_notification_hist; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE event_notification_hist (
    subscriber_id uuid NOT NULL,
    event_name character varying(100) NOT NULL,
    audit_log_id bigint NOT NULL,
    method_type character(10) NOT NULL,
    sent_at timestamp with time zone NOT NULL,
    status boolean NOT NULL,
    reason character(255)
);


ALTER TABLE public.event_notification_hist OWNER TO postgres;

--
-- Name: getallfromevent_notification_hist(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromevent_notification_hist() RETURNS SETOF event_notification_hist
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM event_notification_hist;

END; ';


ALTER FUNCTION public.getallfromevent_notification_hist() OWNER TO postgres;

--
-- Name: event_notification_methods; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE event_notification_methods (
    method_id integer NOT NULL,
    method_type character(10) NOT NULL
);


ALTER TABLE public.event_notification_methods OWNER TO postgres;

--
-- Name: getallfromevent_notification_methods(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromevent_notification_methods() RETURNS SETOF event_notification_methods
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM event_notification_methods;

END; ';


ALTER FUNCTION public.getallfromevent_notification_methods() OWNER TO postgres;

--
-- Name: getallfromevent_subscriber(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromevent_subscriber() RETURNS SETOF event_subscriber
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM event_subscriber;

END; ';


ALTER FUNCTION public.getallfromevent_subscriber() OWNER TO postgres;

--
-- Name: event_subscriber_notification_methods_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW event_subscriber_notification_methods_view AS
    SELECT event_subscriber.subscriber_id, event_subscriber.event_up_name, event_notification_methods.method_type FROM (event_notification_methods JOIN event_subscriber ON ((event_notification_methods.method_id = event_subscriber.method_id)));


ALTER TABLE public.event_subscriber_notification_methods_view OWNER TO postgres;

--
-- Name: getallfromevent_subscriber_notification_methods(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromevent_subscriber_notification_methods() RETURNS SETOF event_subscriber_notification_methods_view
    LANGUAGE plpgsql
    AS '
BEGIN
RETURN QUERY SELECT *
from event_subscriber_notification_methods_view;
END; ';


ALTER FUNCTION public.getallfromevent_subscriber_notification_methods() OWNER TO postgres;

--
-- Name: image_group_storage_domain_map; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE image_group_storage_domain_map (
    image_group_id uuid NOT NULL,
    storage_domain_id uuid NOT NULL
);


ALTER TABLE public.image_group_storage_domain_map OWNER TO postgres;

--
-- Name: getallfromimage_group_storage_domain_map(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromimage_group_storage_domain_map() RETURNS SETOF image_group_storage_domain_map
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM image_group_storage_domain_map;

END; ';


ALTER FUNCTION public.getallfromimage_group_storage_domain_map() OWNER TO postgres;

--
-- Name: image_vm_map; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE image_vm_map (
    image_id uuid NOT NULL,
    vm_id uuid NOT NULL,
    active boolean
);


ALTER TABLE public.image_vm_map OWNER TO postgres;

--
-- Name: getallfromimage_vm_map(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromimage_vm_map() RETURNS SETOF image_vm_map
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT *
      FROM image_vm_map;
END; ';


ALTER FUNCTION public.getallfromimage_vm_map() OWNER TO postgres;

--
-- Name: image_vm_pool_map; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE image_vm_pool_map (
    vm_guid uuid NOT NULL,
    image_guid uuid NOT NULL,
    internal_drive_mapping character varying(50)
);


ALTER TABLE public.image_vm_pool_map OWNER TO postgres;

--
-- Name: getallfromimage_vm_pool_map(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromimage_vm_pool_map() RETURNS SETOF image_vm_pool_map
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT image_vm_pool_map.*
      FROM image_vm_pool_map;
END; ';


ALTER FUNCTION public.getallfromimage_vm_pool_map() OWNER TO postgres;

--
-- Name: images; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE images (
    image_guid uuid NOT NULL,
    creation_date timestamp with time zone NOT NULL,
    size bigint NOT NULL,
    it_guid uuid NOT NULL,
    internal_drive_mapping character varying(50),
    description character varying(4000),
    parentid uuid,
    imagestatus integer DEFAULT 0,
    lastmodified timestamp with time zone,
    app_list text,
    storage_id uuid,
    vm_snapshot_id uuid,
    volume_type integer DEFAULT 2 NOT NULL,
    volume_format integer DEFAULT 4 NOT NULL,
    disk_type integer DEFAULT 1 NOT NULL,
    image_group_id uuid,
    disk_interface integer DEFAULT 0 NOT NULL,
    boot boolean DEFAULT false NOT NULL,
    wipe_after_delete boolean DEFAULT false NOT NULL,
    propagate_errors integer DEFAULT 0 NOT NULL,
    _create_date timestamp with time zone DEFAULT ('now'::text)::timestamp without time zone,
    _update_date timestamp with time zone
);


ALTER TABLE public.images OWNER TO postgres;

--
-- Name: storage_domain_static; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE storage_domain_static (
    id uuid NOT NULL,
    storage character varying(250) NOT NULL,
    storage_name character varying(250) NOT NULL,
    storage_domain_type integer NOT NULL,
    storage_type integer NOT NULL,
    storage_domain_format_type character varying(50) DEFAULT 0 NOT NULL,
    _create_date timestamp with time zone DEFAULT ('now'::text)::timestamp without time zone,
    _update_date timestamp with time zone
);


ALTER TABLE public.storage_domain_static OWNER TO postgres;

--
-- Name: storage_pool_iso_map; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE storage_pool_iso_map (
    storage_id uuid NOT NULL,
    storage_pool_id uuid NOT NULL,
    status integer,
    owner integer
);


ALTER TABLE public.storage_pool_iso_map OWNER TO postgres;

--
-- Name: storage_domain_static_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW storage_domain_static_view AS
    SELECT storage_domain_static.id, storage_domain_static.storage, storage_domain_static.storage_name, storage_pool_iso_map.storage_pool_id, storage_pool_iso_map.status, storage_domain_static.storage_domain_type, storage_domain_static.storage_type, storage_domain_static.storage_domain_format_type, storage_pool.name AS storage_pool_name FROM ((storage_domain_static LEFT JOIN storage_pool_iso_map ON ((storage_pool_iso_map.storage_id = storage_domain_static.id))) LEFT JOIN storage_pool ON ((storage_pool.id = storage_pool_iso_map.storage_pool_id)));


ALTER TABLE public.storage_domain_static_view OWNER TO postgres;

--
-- Name: images_storage_domain_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW images_storage_domain_view AS
    SELECT storage_domain_static_view.storage AS storage_path, storage_domain_static_view.storage_pool_id, images.image_guid, images.creation_date, images.size, images.it_guid, images.description, images.parentid, images.lastmodified, images.app_list, images.storage_id, images.vm_snapshot_id, images.volume_type, images.volume_format, images.boot, disks.disk_id AS image_group_id, CASE WHEN ((disks.status)::text = 'OK'::text) THEN 1 WHEN ((disks.status)::text = 'LOCKED'::text) THEN 2 WHEN ((disks.status)::text = 'INVALID'::text) THEN 3 WHEN ((disks.status)::text = 'ILLEGAL'::text) THEN 4 ELSE 0 END AS imagestatus, (disks.internal_drive_mapping)::character varying(50) AS internal_drive_mapping, CASE WHEN ((disks.disk_type)::text = 'System'::text) THEN 1 WHEN ((disks.disk_type)::text = 'Data'::text) THEN 2 WHEN ((disks.disk_type)::text = 'Shared'::text) THEN 3 WHEN ((disks.disk_type)::text = 'Swap'::text) THEN 4 WHEN ((disks.disk_type)::text = 'Temp'::text) THEN 5 ELSE 0 END AS disk_type, CASE WHEN ((disks.disk_interface)::text = 'SCSI'::text) THEN 1 WHEN ((disks.disk_interface)::text = 'VirtIO'::text) THEN 2 ELSE 0 END AS disk_interface, disks.wipe_after_delete, CASE WHEN ((disks.propagate_errors)::text = 'On'::text) THEN 1 ELSE 0 END AS propagate_errors, disk_image_dynamic.actual_size, disk_image_dynamic.read_rate, disk_image_dynamic.write_rate FROM (((images LEFT JOIN storage_domain_static_view ON ((images.storage_id = storage_domain_static_view.id))) LEFT JOIN disk_image_dynamic ON ((images.image_guid = disk_image_dynamic.image_id))) JOIN disks ON ((images.image_group_id = disks.disk_id)));


ALTER TABLE public.images_storage_domain_view OWNER TO postgres;

--
-- Name: getallfromimages(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromimages() RETURNS SETOF images_storage_domain_view
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT *
      FROM images_storage_domain_view images_storage_domain_view;
END; ';


ALTER FUNCTION public.getallfromimages() OWNER TO postgres;

--
-- Name: lun_storage_server_connection_map; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE lun_storage_server_connection_map (
    lun_id character varying(50) NOT NULL,
    storage_server_connection character varying(50) NOT NULL
);


ALTER TABLE public.lun_storage_server_connection_map OWNER TO postgres;

--
-- Name: getallfromlun_storage_server_connection_map(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromlun_storage_server_connection_map() RETURNS SETOF lun_storage_server_connection_map
    LANGUAGE plpgsql
    AS '
BEGIN
	
   RETURN QUERY SELECT *
   FROM LUN_storage_server_connection_map lUN_storage_server_connection_map;

END; ';


ALTER FUNCTION public.getallfromlun_storage_server_connection_map() OWNER TO postgres;

--
-- Name: luns; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE luns (
    phisical_volume_id character varying(50),
    lun_id character varying(50) NOT NULL,
    volume_group_id character varying(50),
    serial character varying(4000),
    lun_mapping integer,
    vendor_id character varying(50),
    product_id character varying(50),
    device_size integer DEFAULT 0
);


ALTER TABLE public.luns OWNER TO postgres;

--
-- Name: getallfromluns(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromluns() RETURNS SETOF luns
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM LUNs LUNs;

END; ';


ALTER FUNCTION public.getallfromluns() OWNER TO postgres;

--
-- Name: network; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE network (
    id uuid NOT NULL,
    name character varying(50) NOT NULL,
    description character varying(4000),
    type integer,
    addr character varying(50),
    subnet character varying(20),
    gateway character varying(20),
    vlan_id integer,
    stp boolean DEFAULT false NOT NULL,
    storage_pool_id uuid
);


ALTER TABLE public.network OWNER TO postgres;

--
-- Name: network_cluster; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE network_cluster (
    network_id uuid NOT NULL,
    cluster_id uuid NOT NULL,
    status integer DEFAULT 0 NOT NULL,
    is_display boolean DEFAULT false NOT NULL
);


ALTER TABLE public.network_cluster OWNER TO postgres;

--
-- Name: network_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW network_view AS
    SELECT DISTINCT network.id, network.name, network.description, network.type, network.addr, network.subnet, network.gateway, network.vlan_id, network.stp, network.storage_pool_id, network_cluster.is_display, network_cluster.status FROM (network LEFT JOIN network_cluster ON ((network.id = network_cluster.network_id)));


ALTER TABLE public.network_view OWNER TO postgres;

--
-- Name: getallfromnetwork(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromnetwork() RETURNS SETOF network_view
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT
   distinct network_view.*  
   FROM network_view;

END; ';


ALTER FUNCTION public.getallfromnetwork() OWNER TO postgres;

--
-- Name: getallfromnetwork_cluster(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromnetwork_cluster() RETURNS SETOF network_cluster
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM network_cluster;

END; ';


ALTER FUNCTION public.getallfromnetwork_cluster() OWNER TO postgres;

--
-- Name: getallfromnetwork_clusterbyclusterid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromnetwork_clusterbyclusterid(v_cluster_id uuid) RETURNS SETOF network_cluster
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM network_cluster
   WHERE cluster_id = v_cluster_id;

END; ';


ALTER FUNCTION public.getallfromnetwork_clusterbyclusterid(v_cluster_id uuid) OWNER TO postgres;

--
-- Name: getallfromnetwork_clusterbynetworkid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromnetwork_clusterbynetworkid(v_network_id uuid) RETURNS SETOF network_cluster
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM network_cluster
   WHERE network_id = v_network_id;

END; ';


ALTER FUNCTION public.getallfromnetwork_clusterbynetworkid(v_network_id uuid) OWNER TO postgres;

--
-- Name: roles; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE roles (
    id uuid NOT NULL,
    name character varying(126) NOT NULL,
    description character varying(4000),
    is_readonly boolean NOT NULL,
    role_type integer NOT NULL
);


ALTER TABLE public.roles OWNER TO postgres;

--
-- Name: getallfromrole(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromrole() RETURNS SETOF roles
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM roles;

END; ';


ALTER FUNCTION public.getallfromrole() OWNER TO postgres;

--
-- Name: roles_relations; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE roles_relations (
    role_id uuid NOT NULL,
    role_container_id uuid NOT NULL
);


ALTER TABLE public.roles_relations OWNER TO postgres;

--
-- Name: getallfromroles_relations(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromroles_relations() RETURNS SETOF roles_relations
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM roles_relations;

END; ';


ALTER FUNCTION public.getallfromroles_relations() OWNER TO postgres;

--
-- Name: stateless_vm_image_map; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE stateless_vm_image_map (
    vm_guid uuid NOT NULL,
    image_guid uuid NOT NULL,
    internal_drive_mapping character varying(50)
);


ALTER TABLE public.stateless_vm_image_map OWNER TO postgres;

--
-- Name: getallfromstateless_vm_image_map(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromstateless_vm_image_map() RETURNS SETOF stateless_vm_image_map
    LANGUAGE plpgsql
    AS '
BEGIN
RETURN QUERY SELECT stateless_vm_image_map.*
   FROM stateless_vm_image_map;

END; ';


ALTER FUNCTION public.getallfromstateless_vm_image_map() OWNER TO postgres;

--
-- Name: storage_domain_dynamic; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE storage_domain_dynamic (
    id uuid NOT NULL,
    available_disk_size integer,
    used_disk_size integer
);


ALTER TABLE public.storage_domain_dynamic OWNER TO postgres;

--
-- Name: getallfromstorage_domain_dynamic(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromstorage_domain_dynamic() RETURNS SETOF storage_domain_dynamic
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM storage_domain_dynamic;

END; ';


ALTER FUNCTION public.getallfromstorage_domain_dynamic() OWNER TO postgres;

--
-- Name: getallfromstorage_domain_static(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromstorage_domain_static() RETURNS SETOF storage_domain_static
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM storage_domain_static;
END; ';


ALTER FUNCTION public.getallfromstorage_domain_static() OWNER TO postgres;

--
-- Name: storage_domains; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW storage_domains AS
    SELECT storage_domain_static.id, storage_domain_static.storage, storage_domain_static.storage_name, storage_pool_iso_map.storage_pool_id, storage_domain_dynamic.available_disk_size, storage_domain_dynamic.used_disk_size, fn_get_disk_commited_value_by_storage(storage_domain_static.id) AS commited_disk_size, storage_pool_iso_map.status, storage_pool.name AS storage_pool_name, storage_domain_static.storage_type, storage_domain_static.storage_domain_type, storage_domain_static.storage_domain_format_type, storage_pool_iso_map.owner, fn_get_storage_domain_shared_status_by_domain_id(storage_domain_static.id, storage_domain_static.storage, storage_domain_static.storage_type) AS storage_domain_shared_status FROM (((storage_domain_static JOIN storage_domain_dynamic ON ((storage_domain_static.id = storage_domain_dynamic.id))) LEFT JOIN storage_pool_iso_map ON ((storage_domain_static.id = storage_pool_iso_map.storage_id))) LEFT JOIN storage_pool ON ((storage_pool_iso_map.storage_pool_id = storage_pool.id)));


ALTER TABLE public.storage_domains OWNER TO postgres;

--
-- Name: getallfromstorage_domains(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromstorage_domains() RETURNS SETOF storage_domains
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM storage_domains;
END; ';


ALTER FUNCTION public.getallfromstorage_domains() OWNER TO postgres;

--
-- Name: getallfromstorage_pool(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromstorage_pool() RETURNS SETOF storage_pool
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM storage_pool;
END; ';


ALTER FUNCTION public.getallfromstorage_pool() OWNER TO postgres;

--
-- Name: getallfromstorage_pool_iso_map(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromstorage_pool_iso_map() RETURNS SETOF storage_pool_iso_map
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM storage_pool_iso_map;

END; ';


ALTER FUNCTION public.getallfromstorage_pool_iso_map() OWNER TO postgres;

--
-- Name: storage_server_connections; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE storage_server_connections (
    id character varying(50) NOT NULL,
    connection character varying(250) NOT NULL,
    user_name character varying(50),
    password character varying(50),
    iqn character varying(128),
    port character varying(50),
    portal character varying(50),
    storage_type integer NOT NULL
);


ALTER TABLE public.storage_server_connections OWNER TO postgres;

--
-- Name: getallfromstorage_server_connections(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromstorage_server_connections() RETURNS SETOF storage_server_connections
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM storage_server_connections;

END; ';


ALTER FUNCTION public.getallfromstorage_server_connections() OWNER TO postgres;

--
-- Name: tags; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tags (
    tag_id uuid NOT NULL,
    tag_name character varying(50) DEFAULT ''::character varying NOT NULL,
    description character varying(4000),
    parent_id uuid,
    readonly boolean,
    type integer DEFAULT 0 NOT NULL,
    _create_date timestamp with time zone DEFAULT ('now'::text)::timestamp without time zone,
    _update_date timestamp with time zone
);


ALTER TABLE public.tags OWNER TO postgres;

--
-- Name: getallfromtags(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromtags() RETURNS SETOF tags
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT tags.*
      FROM tags;
END; ';


ALTER FUNCTION public.getallfromtags() OWNER TO postgres;

--
-- Name: tags_user_group_map; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tags_user_group_map (
    tag_id uuid NOT NULL,
    group_id uuid NOT NULL,
    _create_date timestamp with time zone DEFAULT ('now'::text)::timestamp without time zone
);


ALTER TABLE public.tags_user_group_map OWNER TO postgres;

--
-- Name: getallfromtags_user_group_map(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromtags_user_group_map() RETURNS SETOF tags_user_group_map
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT tags_user_group_map.*
      FROM tags_user_group_map;
END; ';


ALTER FUNCTION public.getallfromtags_user_group_map() OWNER TO postgres;

--
-- Name: tags_user_map; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tags_user_map (
    tag_id uuid NOT NULL,
    user_id uuid NOT NULL,
    _create_date timestamp with time zone DEFAULT ('now'::text)::timestamp without time zone
);


ALTER TABLE public.tags_user_map OWNER TO postgres;

--
-- Name: getallfromtags_user_map(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromtags_user_map() RETURNS SETOF tags_user_map
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT tags_user_map.*
      FROM tags_user_map;
END; ';


ALTER FUNCTION public.getallfromtags_user_map() OWNER TO postgres;

--
-- Name: tags_vds_map; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tags_vds_map (
    tag_id uuid NOT NULL,
    vds_id uuid NOT NULL,
    _create_date timestamp with time zone DEFAULT ('now'::text)::timestamp without time zone
);


ALTER TABLE public.tags_vds_map OWNER TO postgres;

--
-- Name: getallfromtags_vds_map(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromtags_vds_map() RETURNS SETOF tags_vds_map
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT tags_vds_map.*
      FROM tags_vds_map;
END; ';


ALTER FUNCTION public.getallfromtags_vds_map() OWNER TO postgres;

--
-- Name: tags_vm_map; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tags_vm_map (
    tag_id uuid NOT NULL,
    vm_id uuid NOT NULL,
    _create_date timestamp with time zone DEFAULT ('now'::text)::timestamp without time zone,
    defaultdisplaytype integer DEFAULT 0
);


ALTER TABLE public.tags_vm_map OWNER TO postgres;

--
-- Name: getallfromtags_vm_map(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromtags_vm_map() RETURNS SETOF tags_vm_map
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT tags_vm_map.*
      FROM tags_vm_map;
END; ';


ALTER FUNCTION public.getallfromtags_vm_map() OWNER TO postgres;

--
-- Name: tags_vm_pool_map; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tags_vm_pool_map (
    tag_id uuid NOT NULL,
    vm_pool_id uuid NOT NULL,
    _create_date timestamp with time zone DEFAULT ('now'::text)::timestamp without time zone
);


ALTER TABLE public.tags_vm_pool_map OWNER TO postgres;

--
-- Name: getallfromtags_vm_pool_map(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromtags_vm_pool_map() RETURNS SETOF tags_vm_pool_map
    LANGUAGE plpgsql
    AS '
BEGIN
	
   RETURN QUERY SELECT tags_vm_pool_map.*
   FROM tags_vm_pool_map;

END; ';


ALTER FUNCTION public.getallfromtags_vm_pool_map() OWNER TO postgres;

--
-- Name: time_lease_vm_pool_map; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE time_lease_vm_pool_map (
    vm_pool_id uuid NOT NULL,
    id uuid NOT NULL,
    start_time timestamp with time zone NOT NULL,
    end_time timestamp with time zone NOT NULL,
    type integer NOT NULL
);


ALTER TABLE public.time_lease_vm_pool_map OWNER TO postgres;

--
-- Name: getallfromtime_lease_vm_pool_map(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromtime_lease_vm_pool_map() RETURNS SETOF time_lease_vm_pool_map
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT time_lease_vm_pool_map.*
      FROM time_lease_vm_pool_map;
END; ';


ALTER FUNCTION public.getallfromtime_lease_vm_pool_map() OWNER TO postgres;

--
-- Name: user_sessions; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE user_sessions (
    session_id character(32) NOT NULL,
    user_id uuid NOT NULL,
    os character(10),
    browser character(10),
    client_type character(10),
    login_time timestamp with time zone DEFAULT ('now'::text)::timestamp without time zone
);


ALTER TABLE public.user_sessions OWNER TO postgres;

--
-- Name: getallfromuser_sessions(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromuser_sessions() RETURNS SETOF user_sessions
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT user_sessions.*
      FROM user_sessions;
END; ';


ALTER FUNCTION public.getallfromuser_sessions() OWNER TO postgres;

--
-- Name: users; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE users (
    user_id uuid NOT NULL,
    name character varying(255),
    surname character varying(255),
    domain character varying(255) NOT NULL,
    username character varying(255) NOT NULL,
    groups character varying NOT NULL,
    department character varying(255),
    role character varying(255),
    user_icon_path character varying(255),
    desktop_device character varying(255),
    email character varying(255),
    note character varying(255),
    status integer NOT NULL,
    session_count integer DEFAULT 0 NOT NULL,
    last_admin_check_status boolean DEFAULT false NOT NULL,
    group_ids text
);


ALTER TABLE public.users OWNER TO postgres;

--
-- Name: getallfromusers(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromusers() RETURNS SETOF users
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT users.*
      FROM users;
END; ';


ALTER FUNCTION public.getallfromusers() OWNER TO postgres;

--
-- Name: vdc_options_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vdc_options_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.vdc_options_seq OWNER TO postgres;

--
-- Name: vdc_options_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('vdc_options_seq', 282, true);


--
-- Name: vdc_options; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vdc_options (
    option_id integer DEFAULT nextval('vdc_options_seq'::regclass) NOT NULL,
    option_name character varying(100) NOT NULL,
    option_value character varying(4000) NOT NULL,
    version character varying(40) DEFAULT 'general'::character varying NOT NULL
);


ALTER TABLE public.vdc_options OWNER TO postgres;

--
-- Name: getallfromvdcoption(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromvdcoption() RETURNS SETOF vdc_options
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT vdc_options.*
      FROM vdc_options;
END; ';


ALTER FUNCTION public.getallfromvdcoption() OWNER TO postgres;

--
-- Name: vds_dynamic; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vds_dynamic (
    vds_id uuid NOT NULL,
    status integer NOT NULL,
    cpu_cores integer,
    cpu_model character varying(255),
    cpu_speed_mh numeric(18,0),
    if_total_speed character varying(40),
    kvm_enabled boolean,
    physical_mem_mb integer,
    mem_commited integer DEFAULT 0,
    vm_active integer DEFAULT 0,
    vm_count integer DEFAULT 0 NOT NULL,
    vm_migrating integer DEFAULT 0,
    reserved_mem integer,
    guest_overhead integer,
    software_version character varying(40),
    version_name character varying(40),
    build_name character varying(40),
    previous_status integer,
    cpu_flags character varying(4000),
    cpu_over_commit_time_stamp timestamp with time zone,
    hypervisor_type integer,
    vms_cores_count integer,
    pending_vcpus_count integer,
    cpu_sockets integer,
    net_config_dirty boolean,
    supported_cluster_levels character varying(40),
    supported_engines character varying(40),
    host_os character varying(4000),
    kvm_version character varying(4000),
    spice_version character varying(4000),
    kernel_version character varying(4000),
    iscsi_initiator_name character varying(4000),
    transparent_hugepages_state integer DEFAULT 0 NOT NULL,
    anonymous_hugepages integer DEFAULT 0 NOT NULL,
    hooks character varying(4000) DEFAULT ''::character varying,
    _update_date timestamp with time zone,
    non_operational_reason integer DEFAULT 0 NOT NULL,
    pending_vmem_size integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.vds_dynamic OWNER TO postgres;

--
-- Name: vds_spm_id_map; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vds_spm_id_map (
    storage_pool_id uuid NOT NULL,
    vds_spm_id integer NOT NULL,
    vds_id uuid NOT NULL
);


ALTER TABLE public.vds_spm_id_map OWNER TO postgres;

--
-- Name: vds_static; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vds_static (
    vds_id uuid NOT NULL,
    vds_name character varying(255) NOT NULL,
    ip character varying(255),
    vds_unique_id character varying(128),
    host_name character varying(255) NOT NULL,
    port integer NOT NULL,
    vds_group_id uuid NOT NULL,
    server_ssl_enabled boolean,
    vds_type integer DEFAULT 0 NOT NULL,
    vds_strength integer DEFAULT 100 NOT NULL,
    pm_type character varying(20),
    pm_user character varying(50),
    pm_password text,
    pm_port integer,
    pm_options character varying(4000) DEFAULT ''::character varying NOT NULL,
    pm_enabled boolean DEFAULT false NOT NULL,
    _create_date timestamp with time zone DEFAULT ('now'::text)::timestamp without time zone,
    _update_date timestamp with time zone,
    otp_validity bigint,
    vds_spm_priority smallint DEFAULT 5,
    CONSTRAINT vds_static_vds_spm_priority_check CHECK (((vds_spm_priority >= (-1)) AND (vds_spm_priority <= 10)))
);


ALTER TABLE public.vds_static OWNER TO postgres;

--
-- Name: vds_statistics; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vds_statistics (
    vds_id uuid NOT NULL,
    cpu_idle numeric(18,0) DEFAULT 0,
    cpu_load numeric(18,0) DEFAULT 0,
    cpu_sys numeric(18,0) DEFAULT 0,
    cpu_user numeric(18,0) DEFAULT 0,
    usage_mem_percent integer DEFAULT 0,
    usage_cpu_percent integer DEFAULT 0,
    usage_network_percent integer,
    mem_available bigint,
    mem_shared bigint,
    swap_free bigint,
    swap_total bigint,
    ksm_cpu_percent integer DEFAULT 0,
    ksm_pages bigint,
    ksm_state boolean
);


ALTER TABLE public.vds_statistics OWNER TO postgres;

--
-- Name: vds; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW vds AS
    SELECT vds_groups.vds_group_id, vds_groups.name AS vds_group_name, vds_groups.description AS vds_group_description, vds_groups.selection_algorithm, vds_static.vds_id, vds_static.vds_name, vds_static.ip, vds_static.vds_unique_id, vds_static.host_name, vds_static.port, vds_static.vds_strength, vds_static.server_ssl_enabled, vds_static.vds_type, vds_static.pm_type, vds_static.pm_user, vds_static.pm_password, vds_static.pm_port, vds_static.pm_options, vds_static.pm_enabled, vds_static.vds_spm_priority, vds_dynamic.hooks, vds_dynamic.status, vds_dynamic.cpu_cores, vds_dynamic.cpu_model, vds_dynamic.cpu_speed_mh, vds_dynamic.if_total_speed, vds_dynamic.kvm_enabled, vds_dynamic.physical_mem_mb, vds_dynamic.pending_vcpus_count, vds_dynamic.pending_vmem_size, vds_dynamic.mem_commited, vds_dynamic.vm_active, vds_dynamic.vm_count, vds_dynamic.vm_migrating, vds_dynamic.vms_cores_count, vds_dynamic.cpu_over_commit_time_stamp, vds_dynamic.hypervisor_type, vds_dynamic.net_config_dirty, vds_groups.high_utilization, vds_groups.low_utilization, vds_groups.max_vds_memory_over_commit, vds_groups.cpu_over_commit_duration_minutes, storage_pool.id AS storage_pool_id, storage_pool.name AS storage_pool_name, vds_dynamic.reserved_mem, vds_dynamic.guest_overhead, vds_dynamic.software_version, vds_dynamic.version_name, vds_dynamic.build_name, vds_dynamic.previous_status, vds_statistics.cpu_idle, vds_statistics.cpu_load, vds_statistics.cpu_sys, vds_statistics.cpu_user, vds_statistics.usage_mem_percent, vds_statistics.usage_cpu_percent, vds_statistics.usage_network_percent, vds_statistics.mem_available, vds_statistics.mem_shared, vds_statistics.swap_free, vds_statistics.swap_total, vds_statistics.ksm_cpu_percent, vds_statistics.ksm_pages, vds_statistics.ksm_state, vds_dynamic.cpu_flags, vds_groups.cpu_name AS vds_group_cpu_name, vds_dynamic.cpu_sockets, vds_spm_id_map.vds_spm_id, vds_static.otp_validity, CASE WHEN (storage_pool.spm_vds_id = vds_static.vds_id) THEN CASE WHEN (storage_pool.status = 5) THEN 1 ELSE 2 END ELSE 0 END AS spm_status, vds_dynamic.supported_cluster_levels, vds_dynamic.supported_engines, vds_groups.compatibility_version AS vds_group_compatibility_version, vds_dynamic.host_os, vds_dynamic.kvm_version, vds_dynamic.spice_version, vds_dynamic.kernel_version, vds_dynamic.iscsi_initiator_name, vds_dynamic.transparent_hugepages_state, vds_dynamic.anonymous_hugepages, vds_dynamic.non_operational_reason FROM (((((vds_groups JOIN vds_static ON ((vds_groups.vds_group_id = vds_static.vds_group_id))) JOIN vds_dynamic ON ((vds_static.vds_id = vds_dynamic.vds_id))) JOIN vds_statistics ON ((vds_static.vds_id = vds_statistics.vds_id))) LEFT JOIN storage_pool ON ((vds_groups.storage_pool_id = storage_pool.id))) LEFT JOIN vds_spm_id_map ON ((vds_static.vds_id = vds_spm_id_map.vds_id)));


ALTER TABLE public.vds OWNER TO postgres;

--
-- Name: getallfromvds(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromvds() RETURNS SETOF vds
    LANGUAGE plpgsql
    AS '
BEGIN
BEGIN
      RETURN QUERY SELECT DISTINCT vds.*
      FROM vds;
   END;
	

   RETURN;
END; ';


ALTER FUNCTION public.getallfromvds() OWNER TO postgres;

--
-- Name: getallfromvds_spm_id_map(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromvds_spm_id_map() RETURNS SETOF vds_spm_id_map
    LANGUAGE plpgsql
    AS '
BEGIN
RETURN QUERY SELECT vds_spm_id_map.*
   FROM vds_spm_id_map;

END; ';


ALTER FUNCTION public.getallfromvds_spm_id_map() OWNER TO postgres;

--
-- Name: getallfromvdsdynamic(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromvdsdynamic() RETURNS SETOF vds_dynamic
    LANGUAGE plpgsql
    AS '
BEGIN
BEGIN
      RETURN QUERY SELECT vds_dynamic.*
      FROM vds_dynamic;
   END;
	
   RETURN;
END; ';


ALTER FUNCTION public.getallfromvdsdynamic() OWNER TO postgres;

--
-- Name: getallfromvdsgroups(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromvdsgroups() RETURNS SETOF vds_groups
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT vds_groups.*
      FROM vds_groups;
END; ';


ALTER FUNCTION public.getallfromvdsgroups() OWNER TO postgres;

--
-- Name: getallfromvdsstatic(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromvdsstatic() RETURNS SETOF vds_static
    LANGUAGE plpgsql
    AS '
BEGIN
RETURN QUERY SELECT vds_static.*
   FROM vds_static;

   RETURN;
END; ';


ALTER FUNCTION public.getallfromvdsstatic() OWNER TO postgres;

--
-- Name: getallfromvdsstatistics(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromvdsstatistics() RETURNS SETOF vds_statistics
    LANGUAGE plpgsql
    AS '
BEGIN
BEGIN
      RETURN QUERY SELECT vds_statistics.*
      FROM vds_statistics;
   END;
	

   RETURN;
END; ';


ALTER FUNCTION public.getallfromvdsstatistics() OWNER TO postgres;

--
-- Name: vm_interface; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm_interface (
    id uuid NOT NULL,
    network_name character varying(50),
    vm_guid uuid,
    vmt_guid uuid,
    mac_addr character varying(20),
    name character varying(50) NOT NULL,
    speed integer,
    type integer DEFAULT 0,
    _create_date timestamp with time zone DEFAULT ('now'::text)::timestamp without time zone,
    _update_date timestamp with time zone
);


ALTER TABLE public.vm_interface OWNER TO postgres;

--
-- Name: getallfromvm_interface(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromvm_interface() RETURNS SETOF vm_interface
    LANGUAGE plpgsql
    AS '
BEGIN
RETURN QUERY SELECT *
   FROM vm_interface;

END; ';


ALTER FUNCTION public.getallfromvm_interface() OWNER TO postgres;

--
-- Name: vm_pool_map; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm_pool_map (
    vm_pool_id uuid,
    vm_guid uuid NOT NULL
);


ALTER TABLE public.vm_pool_map OWNER TO postgres;

--
-- Name: getallfromvm_pool_map(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromvm_pool_map() RETURNS SETOF vm_pool_map
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT vm_pool_map.*
      FROM vm_pool_map;
END; ';


ALTER FUNCTION public.getallfromvm_pool_map() OWNER TO postgres;

--
-- Name: getallfromvm_pools(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromvm_pools() RETURNS SETOF getallfromvm_pools_rs
    LANGUAGE plpgsql
    AS '
BEGIN
      -- BEGIN TRAN
BEGIN
         CREATE GLOBAL TEMPORARY TABLE tt_VM_POOL_GROUP
         (
            vm_pool_id UUID,
            assigned_vm_count INTEGER
         ) WITH OIDS;
         exception when others then
            truncate table tt_VM_POOL_GROUP;
      END;
      insert INTO tt_VM_POOL_GROUP(vm_pool_id,
					assigned_vm_count)
      select
      vm_pools_view.vm_pool_id,
			  count(vm_pool_map.vm_pool_id)
      from vm_pools_view
      left join vm_pool_map on vm_pools_view.vm_pool_id = vm_pool_map.vm_pool_id
      group by vm_pools_view.vm_pool_id,vm_pool_map.vm_pool_id;
      BEGIN
         CREATE GLOBAL TEMPORARY TABLE tt_VM_POOL_RUNNING
         (
            vm_pool_id UUID,
            vm_running_count INTEGER
         ) WITH OIDS;
         exception when others then
            truncate table tt_VM_POOL_RUNNING;
      END;
      insert INTO tt_VM_POOL_RUNNING(vm_pool_id,
					vm_running_count)
      select vm_pools_view.vm_pool_id, count(vm_pools_view.vm_pool_id)
      from vm_pools_view
      left join vm_pool_map on vm_pools_view.vm_pool_id = vm_pool_map.vm_pool_id
      left join vm_dynamic on vm_pool_map.vm_guid = vm_dynamic.vm_guid
      where vm_dynamic.status > 0
      group by vm_pools_view.vm_pool_id;
      BEGIN
         CREATE GLOBAL TEMPORARY TABLE tt_VM_POOL_PRERESULT
         (
            vm_pool_id UUID,
            assigned_vm_count INTEGER,
            vm_running_count INTEGER
         ) WITH OIDS;
         exception when others then
            truncate table tt_VM_POOL_PRERESULT;
      END;
      insert INTO tt_VM_POOL_PRERESULT(vm_pool_id,
					assigned_vm_count,
					vm_running_count)
      select pg.vm_pool_id, pg.assigned_vm_count, pr.vm_running_count
      from tt_VM_POOL_GROUP pg
      left join tt_VM_POOL_RUNNING pr on pg.vm_pool_id = pr.vm_pool_id;
      update tt_VM_POOL_PRERESULT
      set vm_running_count = 0
      where vm_running_count is NULL;
      BEGIN
         CREATE GLOBAL TEMPORARY TABLE tt_VM_POOL_RESULT
         (
            vm_pool_id UUID,
            assigned_vm_count INTEGER,
            vm_running_count INTEGER,
            vm_pool_description VARCHAR(4000),
            vm_pool_name VARCHAR(255),
            vm_pool_type INTEGER,
            parameters VARCHAR(200),
            vds_group_id UUID,
            vds_group_name VARCHAR(40)
         ) WITH OIDS;
         exception when others then
            truncate table tt_VM_POOL_RESULT;
      END;
      insert INTO tt_VM_POOL_RESULT(vm_pool_id,
					assigned_vm_count,
					vm_running_count,
					vm_pool_description,
					vm_pool_name,
				vm_pool_type,
				parameters,
				vds_group_id,
				vds_group_name)
      select ppr.vm_pool_id, ppr.assigned_vm_count, ppr.vm_running_count,
  				 p.vm_pool_description, p.vm_pool_name, p.vm_pool_type, p.parameters,
					 p.vds_group_id, p.vds_group_name
      from tt_VM_POOL_PRERESULT ppr
      inner join vm_pools_view p on ppr.vm_pool_id = p.vm_pool_id;
      RETURN QUERY select *
      from tt_VM_POOL_RESULT;
END; ';


ALTER FUNCTION public.getallfromvm_pools() OWNER TO postgres;

--
-- Name: vm_dynamic; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm_dynamic (
    vm_guid uuid NOT NULL,
    status integer NOT NULL,
    vm_ip text,
    vm_host character varying(255),
    vm_pid integer,
    vm_last_up_time timestamp with time zone,
    vm_last_boot_time timestamp with time zone,
    guest_cur_user_name character varying(255),
    guest_cur_user_id uuid,
    guest_last_login_time timestamp with time zone,
    guest_last_logout_time timestamp with time zone,
    guest_os character varying(255),
    run_on_vds uuid,
    migrating_to_vds uuid,
    app_list text,
    display integer,
    acpi_enable boolean,
    session integer,
    display_ip character varying(255),
    display_type integer,
    kvm_enable boolean,
    display_secure_port integer,
    utc_diff integer,
    last_vds_run_on uuid,
    client_ip character varying(255),
    guest_requested_memory integer,
    hibernation_vol_handle character varying(255),
    boot_sequence integer,
    exit_status integer DEFAULT 0 NOT NULL,
    pause_status integer DEFAULT 0 NOT NULL,
    exit_message character varying(4000)
);


ALTER TABLE public.vm_dynamic OWNER TO postgres;

--
-- Name: getallfromvmdynamic(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromvmdynamic() RETURNS SETOF vm_dynamic
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT vm_dynamic.*
      FROM vm_dynamic;
END; ';


ALTER FUNCTION public.getallfromvmdynamic() OWNER TO postgres;

--
-- Name: vm_pools; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm_pools (
    vm_pool_id uuid NOT NULL,
    vm_pool_name character varying(255) NOT NULL,
    vm_pool_description character varying(4000) NOT NULL,
    vm_pool_type integer,
    parameters character varying(200),
    vds_group_id uuid
);


ALTER TABLE public.vm_pools OWNER TO postgres;

--
-- Name: vm_pool_map_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW vm_pool_map_view AS
    SELECT vm_pool_map.vm_guid, vm_pool_map.vm_pool_id, vm_pools.vm_pool_name FROM (vm_pool_map JOIN vm_pools ON ((vm_pool_map.vm_pool_id = vm_pools.vm_pool_id)));


ALTER TABLE public.vm_pool_map_view OWNER TO postgres;

--
-- Name: vm_statistics; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm_statistics (
    vm_guid uuid NOT NULL,
    cpu_user numeric(18,0) DEFAULT 0,
    cpu_sys numeric(18,0) DEFAULT 0,
    elapsed_time numeric(18,0) DEFAULT 0,
    usage_network_percent integer DEFAULT 0,
    usage_mem_percent integer DEFAULT 0,
    usage_cpu_percent integer DEFAULT 0,
    disks_usage text
);


ALTER TABLE public.vm_statistics OWNER TO postgres;

--
-- Name: vms; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW vms AS
    SELECT vm_static.vm_name, vm_static.mem_size_mb AS vm_mem_size_mb, vm_static.nice_level, vm_static.vmt_guid, vm_static.os AS vm_os, vm_static.description AS vm_description, vm_static.vds_group_id, vm_static.domain AS vm_domain, vm_static.creation_date AS vm_creation_date, vm_static.auto_startup, vm_static.is_stateless, vm_static.dedicated_vm_for_vds, vm_static.fail_back, vm_static.default_boot_sequence, vm_static.vm_type, vm_static.hypervisor_type, vm_static.operation_mode, vds_groups.name AS vds_group_name, vds_groups.selection_algorithm, vds_groups.transparent_hugepages, storage_pool.id AS storage_pool_id, storage_pool.name AS storage_pool_name, vds_groups.description AS vds_group_description, vm_templates.vm_name AS vmt_name, vm_templates.mem_size_mb AS vmt_mem_size_mb, vm_templates.os AS vmt_os, vm_templates.creation_date AS vmt_creation_date, vm_templates.child_count AS vmt_child_count, vm_templates.num_of_sockets AS vmt_num_of_sockets, vm_templates.cpu_per_socket AS vmt_cpu_per_socket, (vm_templates.num_of_sockets * vm_templates.cpu_per_socket) AS vmt_num_of_cpus, vm_templates.description AS vmt_description, vm_dynamic.status, vm_dynamic.vm_ip, vm_dynamic.vm_host, vm_dynamic.vm_pid, vm_dynamic.vm_last_up_time, vm_dynamic.vm_last_boot_time, vm_dynamic.guest_cur_user_name, vm_dynamic.guest_last_login_time, vm_dynamic.guest_cur_user_id, vm_dynamic.guest_last_logout_time, vm_dynamic.guest_os, vm_dynamic.run_on_vds, vm_dynamic.migrating_to_vds, vm_dynamic.app_list, vm_dynamic.display, vm_dynamic.hibernation_vol_handle, vm_pool_map_view.vm_pool_name, vm_pool_map_view.vm_pool_id, vm_static.vm_guid, vm_static.num_of_monitors, vm_static.is_initialized, vm_static.is_auto_suspend, vm_static.num_of_sockets, vm_static.cpu_per_socket, vm_static.usb_policy, vm_dynamic.acpi_enable, vm_dynamic.session, (vm_static.num_of_sockets * vm_static.cpu_per_socket) AS num_of_cpus, vm_dynamic.display_ip, vm_dynamic.display_type, vm_dynamic.kvm_enable, vm_dynamic.boot_sequence, vm_dynamic.display_secure_port, vm_dynamic.utc_diff, vm_dynamic.last_vds_run_on, vm_dynamic.client_ip, vm_dynamic.guest_requested_memory, vm_static.time_zone, vm_statistics.cpu_user, vm_statistics.cpu_sys, vm_statistics.elapsed_time, vm_statistics.usage_network_percent, vm_statistics.usage_mem_percent, vm_statistics.usage_cpu_percent, vds_static.vds_name AS run_on_vds_name, vds_groups.cpu_name AS vds_group_cpu_name, vm_static.default_display_type, vm_static.priority, vm_static.iso_path, vm_static.origin, vds_groups.compatibility_version AS vds_group_compatibility_version, vm_static.initrd_url, vm_static.kernel_url, vm_static.kernel_params, vm_dynamic.pause_status, vm_dynamic.exit_message, vm_dynamic.exit_status, vm_static.migration_support, vm_static.predefined_properties, vm_static.userdefined_properties, vm_static.min_allocated_mem FROM (((((((vm_static JOIN vm_dynamic ON ((vm_static.vm_guid = vm_dynamic.vm_guid))) JOIN vm_static vm_templates ON ((vm_static.vmt_guid = vm_templates.vm_guid))) JOIN vm_statistics ON ((vm_static.vm_guid = vm_statistics.vm_guid))) JOIN vds_groups ON ((vm_static.vds_group_id = vds_groups.vds_group_id))) LEFT JOIN storage_pool ON (((vm_static.vds_group_id = vds_groups.vds_group_id) AND (vds_groups.storage_pool_id = storage_pool.id)))) LEFT JOIN vds_static ON ((vm_dynamic.run_on_vds = vds_static.vds_id))) LEFT JOIN vm_pool_map_view ON ((vm_static.vm_guid = vm_pool_map_view.vm_guid))) WHERE ((vm_static.entity_type)::text = 'VM'::text);


ALTER TABLE public.vms OWNER TO postgres;

--
-- Name: getallfromvms(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromvms() RETURNS SETOF vms
    LANGUAGE plpgsql
    AS '
BEGIN
RETURN QUERY SELECT DISTINCT vms.*
   FROM vms;

END; ';


ALTER FUNCTION public.getallfromvms() OWNER TO postgres;

--
-- Name: getallfromvmstatic(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromvmstatic() RETURNS SETOF vm_static
    LANGUAGE plpgsql
    AS '
BEGIN
RETURN QUERY SELECT vm_static.*
   FROM vm_static
   WHERE entity_type = ''VM'';

END; ';


ALTER FUNCTION public.getallfromvmstatic() OWNER TO postgres;

--
-- Name: getallfromvmstaticbystoragepoolid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromvmstaticbystoragepoolid(v_sp_id uuid) RETURNS SETOF vm_static
    LANGUAGE plpgsql
    AS '
BEGIN
RETURN QUERY SELECT vm_static.*
   FROM vm_static INNER JOIN
        vm_dynamic ON vm_static.vm_guid = vm_dynamic.vm_guid INNER JOIN
        vds_groups ON vm_static.vds_group_id = vds_groups.vds_group_id LEFT OUTER JOIN
        storage_pool ON vm_static.vds_group_id = vds_groups.vds_group_id
        and vds_groups.storage_pool_id = storage_pool.id
   WHERE v_sp_id = storage_pool.id
   AND   entity_type = ''VM'';

END; ';


ALTER FUNCTION public.getallfromvmstaticbystoragepoolid(v_sp_id uuid) OWNER TO postgres;

--
-- Name: getallfromvmstatistics(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromvmstatistics() RETURNS SETOF vm_statistics
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT vm_statistics.*
      FROM vm_statistics;
END; ';


ALTER FUNCTION public.getallfromvmstatistics() OWNER TO postgres;

--
-- Name: getallfromvmtemplates(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallfromvmtemplates() RETURNS SETOF vm_templates_view
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT vm_templates.*
      FROM vm_templates_view vm_templates
      ORDER BY name;
END; ';


ALTER FUNCTION public.getallfromvmtemplates() OWNER TO postgres;

--
-- Name: getallgroupsfromtime_lease_vm_pool_map(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallgroupsfromtime_lease_vm_pool_map() RETURNS SETOF time_lease_vm_pool_map
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT time_lease_vm_pool_map.*
      FROM time_lease_vm_pool_map
      WHERE time_lease_vm_pool_map.type = 0;
END; ';


ALTER FUNCTION public.getallgroupsfromtime_lease_vm_pool_map() OWNER TO postgres;

--
-- Name: getallnetworkbyclusterid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallnetworkbyclusterid(v_id uuid) RETURNS SETOF networkviewclustertype
    LANGUAGE plpgsql
    AS '
BEGIN
RETURN QUERY SELECT 
    DISTINCT
    network_view.id,
    network_view.name,
    network_view.description,
    network_view.type,
    network_view.addr,
    network_view.subnet,
    network_view.gateway,
    network_view.vlan_id,
    network_view.stp,
    network_view.storage_pool_id,
    network_cluster.* FROM network_view
   INNER JOIN network_cluster
   ON network_view.id = network_cluster.network_id
   where network_cluster.cluster_id = v_id;

END; ';


ALTER FUNCTION public.getallnetworkbyclusterid(v_id uuid) OWNER TO postgres;

--
-- Name: getallnetworkbystoragepoolid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallnetworkbystoragepoolid(v_id uuid) RETURNS SETOF network_view
    LANGUAGE plpgsql
    AS '
BEGIN
RETURN QUERY SELECT 
distinct   network.id, network.name, network.description, network.type, network.addr, network.subnet, network.gateway,
                      network.vlan_id, network.stp, network.storage_pool_id, CAST(0 AS BOOLEAN) as is_display, 0 as status
   FROM network_view network
   where storage_pool_id = v_id;

END; ';


ALTER FUNCTION public.getallnetworkbystoragepoolid(v_id uuid) OWNER TO postgres;

--
-- Name: getallrolesbyadelementid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallrolesbyadelementid(v_ad_element_id uuid) RETURNS SETOF roles
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT roles.*
   FROM roles INNER JOIN
   permissions ON permissions.role_id = roles.id
   WHERE permissions.ad_element_id = v_ad_element_id
   or permissions.ad_element_id in(select id from getUserAndGroupsById(v_ad_element_id));

END; ';


ALTER FUNCTION public.getallrolesbyadelementid(v_ad_element_id uuid) OWNER TO postgres;

--
-- Name: getallusersfromtime_lease_vm_pool_map(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallusersfromtime_lease_vm_pool_map() RETURNS SETOF time_lease_vm_pool_map
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT time_lease_vm_pool_map.*
      FROM time_lease_vm_pool_map
      WHERE time_lease_vm_pool_map.type = 0;
END; ';


ALTER FUNCTION public.getallusersfromtime_lease_vm_pool_map() OWNER TO postgres;

--
-- Name: vm_pools_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW vm_pools_view AS
    SELECT vm_pools.vm_pool_id, vm_pools.vm_pool_name, vm_pools.vm_pool_description, vm_pools.vm_pool_type, vm_pools.parameters, vm_pools.vds_group_id, vds_groups.name AS vds_group_name FROM (vm_pools JOIN vds_groups ON ((vm_pools.vds_group_id = vds_groups.vds_group_id)));


ALTER TABLE public.vm_pools_view OWNER TO postgres;

--
-- Name: getallvm_poolsbyuser_id(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallvm_poolsbyuser_id(v_user_id uuid) RETURNS SETOF vm_pools_view
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT  DISTINCT vm_pools_view.*
      FROM         users_and_groups_to_vm_pool_map_view INNER JOIN
      vm_pools_view ON
      users_and_groups_to_vm_pool_map_view.vm_pool_id = vm_pools_view.vm_pool_id
      WHERE     (users_and_groups_to_vm_pool_map_view.user_id = v_user_id);
END; ';


ALTER FUNCTION public.getallvm_poolsbyuser_id(v_user_id uuid) OWNER TO postgres;

--
-- Name: getallvm_poolsbyuser_id_with_groups_and_userroles(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallvm_poolsbyuser_id_with_groups_and_userroles(v_user_id uuid) RETURNS SETOF vm_pools_view
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT DISTINCT pools.*
	FROM vm_pools_view pools
	WHERE exists (
		SELECT *
		from permissions_view perms 
		WHERE perms.object_id in (
			SELECT * from
			fn_get_entity_parents(pools.vm_pool_id,5))
		and perms.ad_element_id in (
				SELECT id from getUserAndGroupsById(v_user_id))
		and perms.role_type = 2);
END; ';


ALTER FUNCTION public.getallvm_poolsbyuser_id_with_groups_and_userroles(v_user_id uuid) OWNER TO postgres;

--
-- Name: image_templates; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE image_templates (
    it_guid uuid NOT NULL,
    creation_date timestamp with time zone NOT NULL,
    size bigint NOT NULL,
    os character varying(40),
    os_version character varying(40),
    bootable boolean DEFAULT false,
    description character varying(4000),
    internal_drive_mapping character varying(50)
);


ALTER TABLE public.image_templates OWNER TO postgres;

--
-- Name: vm_template_disk; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW vm_template_disk AS
    SELECT vm_template_image_map.image_id AS vtim_it_guid, vm_template_image_map.vm_id AS vmt_guid, image_templates.internal_drive_mapping, image_templates.it_guid, image_templates.os, image_templates.os_version, image_templates.creation_date, image_templates.size, image_templates.description, image_templates.bootable FROM (image_vm_map vm_template_image_map JOIN image_templates ON ((vm_template_image_map.image_id = image_templates.it_guid)));


ALTER TABLE public.vm_template_disk OWNER TO postgres;

--
-- Name: getallvmtemplatedisks(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getallvmtemplatedisks() RETURNS SETOF vm_template_disk
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT vm_template_disk.*
      FROM vm_template_disk;
END; ';


ALTER FUNCTION public.getallvmtemplatedisks() OWNER TO postgres;

--
-- Name: getancestralimagebyimageguid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getancestralimagebyimageguid(v_image_guid uuid) RETURNS SETOF images
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY WITH RECURSIVE ancestor_image(image_guid, parentid) AS (
         SELECT image_guid, parentid 
         FROM images
         WHERE image_guid = v_image_guid
         UNION ALL
         SELECT i.image_guid, i.parentid
         FROM images i, ancestor_image ai
         WHERE i.image_guid = ai.parentid
      )
      SELECT i.*
      FROM ancestor_image ai, images i
      WHERE ai.parentid = ''00000000-0000-0000-0000-000000000000''
      AND ai.image_guid = i.image_guid;
END; ';


ALTER FUNCTION public.getancestralimagebyimageguid(v_image_guid uuid) OWNER TO postgres;

--
-- Name: getasync_tasksbytask_id(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getasync_tasksbytask_id(v_task_id uuid) RETURNS SETOF async_tasks
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM async_tasks
   WHERE task_id = v_task_id;

END; ';


ALTER FUNCTION public.getasync_tasksbytask_id(v_task_id uuid) OWNER TO postgres;

--
-- Name: getauditlogbyauditlogid(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getauditlogbyauditlogid(v_audit_log_id integer) RETURNS SETOF audit_log
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT *
      FROM audit_log
      WHERE audit_log_id = v_audit_log_id;
END; ';


ALTER FUNCTION public.getauditlogbyauditlogid(v_audit_log_id integer) OWNER TO postgres;

--
-- Name: getauditloglaterthendate(timestamp with time zone); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getauditloglaterthendate(v_date timestamp with time zone) RETURNS SETOF audit_log
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT *
      FROM audit_log
      WHERE LOG_TIME >= v_date;
END; ';


ALTER FUNCTION public.getauditloglaterthendate(v_date timestamp with time zone) OWNER TO postgres;

--
-- Name: getbookmarkbybookmark_id(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getbookmarkbybookmark_id(v_bookmark_id uuid) RETURNS SETOF bookmarks
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT *
      FROM bookmarks
      WHERE bookmark_Id = v_bookmark_id;
END; ';


ALTER FUNCTION public.getbookmarkbybookmark_id(v_bookmark_id uuid) OWNER TO postgres;

--
-- Name: getbookmarkbybookmark_name(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getbookmarkbybookmark_name(v_bookmark_name character varying) RETURNS SETOF bookmarks
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT *
      FROM bookmarks
      WHERE bookmark_name = v_bookmark_name;
END; ';


ALTER FUNCTION public.getbookmarkbybookmark_name(v_bookmark_name character varying) OWNER TO postgres;

--
-- Name: getcustom_actionsbyaction_id(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getcustom_actionsbyaction_id(v_action_id integer) RETURNS SETOF custom_actions
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT *
      FROM custom_actions
      WHERE action_id = v_action_id;
END; ';


ALTER FUNCTION public.getcustom_actionsbyaction_id(v_action_id integer) OWNER TO postgres;

--
-- Name: getcustom_actionsbynameandtab(character varying, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getcustom_actionsbynameandtab(v_action_name character varying, v_tab integer) RETURNS SETOF custom_actions
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT *
      FROM custom_actions
      WHERE tab = v_tab and action_name = v_action_name;
END; ';


ALTER FUNCTION public.getcustom_actionsbynameandtab(v_action_name character varying, v_tab integer) OWNER TO postgres;

--
-- Name: getcustom_actionsbytab_id(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getcustom_actionsbytab_id(v_tab integer) RETURNS SETOF custom_actions
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT *
      FROM custom_actions
      WHERE tab = v_tab;
END; ';


ALTER FUNCTION public.getcustom_actionsbytab_id(v_tab integer) OWNER TO postgres;

--
-- Name: permissions; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE permissions (
    id uuid NOT NULL,
    role_id uuid NOT NULL,
    ad_element_id uuid NOT NULL,
    object_id uuid NOT NULL,
    object_type_id integer NOT NULL
);


ALTER TABLE public.permissions OWNER TO postgres;

--
-- Name: permissions_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW permissions_view AS
    SELECT permissions.id, permissions.role_id, permissions.ad_element_id, permissions.object_id, permissions.object_type_id, roles.name AS role_name, roles.role_type, fn_get_entity_name(permissions.object_id, permissions.object_type_id) AS object_name, fn_get_ad_element_name(permissions.ad_element_id) AS owner_name FROM (permissions JOIN roles ON ((permissions.role_id = roles.id)));


ALTER TABLE public.permissions_view OWNER TO postgres;

--
-- Name: getdirectpermissionsbyadelementid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getdirectpermissionsbyadelementid(v_ad_element_id uuid) RETURNS SETOF permissions_view
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM permissions_view
   WHERE permissions_view.ad_element_id = v_ad_element_id;

END; ';


ALTER FUNCTION public.getdirectpermissionsbyadelementid(v_ad_element_id uuid) OWNER TO postgres;

--
-- Name: getdisk_image_dynamicbyimage_id(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getdisk_image_dynamicbyimage_id(v_image_id uuid) RETURNS SETOF disk_image_dynamic
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM disk_image_dynamic
   WHERE image_id = v_image_id;

END; ';


ALTER FUNCTION public.getdisk_image_dynamicbyimage_id(v_image_id uuid) OWNER TO postgres;

--
-- Name: getdiskbydiskid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getdiskbydiskid(v_disk_id uuid) RETURNS SETOF disks
    LANGUAGE plpgsql
    AS '
BEGIN
    RETURN QUERY
    SELECT *
    FROM   disks
    WHERE  disk_id = v_disk_id;
END; ';


ALTER FUNCTION public.getdiskbydiskid(v_disk_id uuid) OWNER TO postgres;

--
-- Name: getevent_subscriberbysubscriber_id(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getevent_subscriberbysubscriber_id(v_subscriber_id uuid) RETURNS SETOF event_subscriber
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM event_subscriber
   WHERE subscriber_id = v_subscriber_id;

END; ';


ALTER FUNCTION public.getevent_subscriberbysubscriber_id(v_subscriber_id uuid) OWNER TO postgres;

--
-- Name: geteventmapbyname(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION geteventmapbyname(v_event_name character varying) RETURNS SETOF event_map
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT *
      from event_map
      where event_up_name = v_event_name;
END; ';


ALTER FUNCTION public.geteventmapbyname(v_event_name character varying) OWNER TO postgres;

--
-- Name: geteventnotificationmethodbyid(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION geteventnotificationmethodbyid(v_method_id integer) RETURNS SETOF event_notification_methods
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT *
      from event_notification_methods
      where method_id = v_method_id;
END; ';


ALTER FUNCTION public.geteventnotificationmethodbyid(v_method_id integer) OWNER TO postgres;

--
-- Name: geteventnotificationmethodbytype(character); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION geteventnotificationmethodbytype(v_method_type character) RETURNS SETOF event_notification_methods
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT *
      from event_notification_methods
      where method_type = v_method_type;
END; ';


ALTER FUNCTION public.geteventnotificationmethodbytype(v_method_type character) OWNER TO postgres;

--
-- Name: getforroleandadelementandobject_wgroupcheck(uuid, uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getforroleandadelementandobject_wgroupcheck(v_role_id uuid, v_ad_element_id uuid, v_object_id uuid) RETURNS SETOF permissions_view
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM permissions_view
   WHERE role_id = v_role_id and object_id = v_object_id and ad_element_id in (
         select id from getUserAndGroupsById(v_ad_element_id));
END; ';


ALTER FUNCTION public.getforroleandadelementandobject_wgroupcheck(v_role_id uuid, v_ad_element_id uuid, v_object_id uuid) OWNER TO postgres;

--
-- Name: getglobalids(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getglobalids(v_name character varying) RETURNS uuid
    LANGUAGE plpgsql
    AS '
   DECLARE
   v_id  UUID;
BEGIN
   if (v_name = ''system'') then
      v_id := ''AAA00000-0000-0000-0000-123456789AAA'';
   else 
      if (v_name = ''everyone'') then
         v_id := ''EEE00000-0000-0000-0000-123456789EEE'';
      end if;
   end if;
   return  v_id;
END; ';


ALTER FUNCTION public.getglobalids(v_name character varying) OWNER TO postgres;

--
-- Name: getimage_group_storage_domain_mapbyimage_group_id(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getimage_group_storage_domain_mapbyimage_group_id(v_image_group_id uuid) RETURNS SETOF image_group_storage_domain_map
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM image_group_storage_domain_map
   WHERE image_group_id = v_image_group_id;

END; ';


ALTER FUNCTION public.getimage_group_storage_domain_mapbyimage_group_id(v_image_group_id uuid) OWNER TO postgres;

--
-- Name: getimage_group_storage_domain_mapbystorage_domain_id(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getimage_group_storage_domain_mapbystorage_domain_id(v_storage_domain_id uuid) RETURNS SETOF image_group_storage_domain_map
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM image_group_storage_domain_map
   WHERE storage_domain_id = v_storage_domain_id;

END; ';


ALTER FUNCTION public.getimage_group_storage_domain_mapbystorage_domain_id(v_storage_domain_id uuid) OWNER TO postgres;

--
-- Name: getimage_grp_storage_domain_mapbyimg_grp_idandstorage_domain(uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getimage_grp_storage_domain_mapbyimg_grp_idandstorage_domain(v_image_group_id uuid, v_storage_domain_id uuid) RETURNS SETOF image_group_storage_domain_map
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM image_group_storage_domain_map
   WHERE image_group_id = v_image_group_id AND storage_domain_id = v_storage_domain_id;

END; ';


ALTER FUNCTION public.getimage_grp_storage_domain_mapbyimg_grp_idandstorage_domain(v_image_group_id uuid, v_storage_domain_id uuid) OWNER TO postgres;

--
-- Name: getimage_vm_mapbyimage_id(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getimage_vm_mapbyimage_id(v_image_id uuid) RETURNS SETOF image_vm_map
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT *
      FROM image_vm_map
      WHERE image_id = v_image_id;
END; ';


ALTER FUNCTION public.getimage_vm_mapbyimage_id(v_image_id uuid) OWNER TO postgres;

--
-- Name: getimage_vm_mapbyimage_idandbyvm_id(uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getimage_vm_mapbyimage_idandbyvm_id(v_image_id uuid, v_vm_id uuid) RETURNS SETOF image_vm_map
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT *
      FROM image_vm_map
      WHERE image_id = v_image_id AND vm_id = v_vm_id;
END; ';


ALTER FUNCTION public.getimage_vm_mapbyimage_idandbyvm_id(v_image_id uuid, v_vm_id uuid) OWNER TO postgres;

--
-- Name: getimage_vm_mapbyvm_id(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getimage_vm_mapbyvm_id(v_vm_id uuid) RETURNS SETOF image_vm_map
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT *
      FROM image_vm_map
      WHERE vm_id = v_vm_id;
END; ';


ALTER FUNCTION public.getimage_vm_mapbyvm_id(v_vm_id uuid) OWNER TO postgres;

--
-- Name: getimage_vm_pool_mapbyimage_guid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getimage_vm_pool_mapbyimage_guid(v_image_guid uuid) RETURNS SETOF image_vm_pool_map
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT image_vm_pool_map.*
      FROM image_vm_pool_map
      WHERE image_guid = v_image_guid;
END; ';


ALTER FUNCTION public.getimage_vm_pool_mapbyimage_guid(v_image_guid uuid) OWNER TO postgres;

--
-- Name: getimage_vm_pool_mapbyvm_guid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getimage_vm_pool_mapbyvm_guid(v_vm_guid uuid) RETURNS SETOF image_vm_pool_map
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT image_vm_pool_map.*
      FROM image_vm_pool_map
      WHERE vm_guid = v_vm_guid;
END; ';


ALTER FUNCTION public.getimage_vm_pool_mapbyvm_guid(v_vm_guid uuid) OWNER TO postgres;

--
-- Name: vm_images_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW vm_images_view AS
    SELECT images_storage_domain_view.storage_path, images_storage_domain_view.storage_pool_id, images_storage_domain_view.image_guid, images_storage_domain_view.creation_date, disk_image_dynamic.actual_size, disk_image_dynamic.read_rate, disk_image_dynamic.write_rate, images_storage_domain_view.size, images_storage_domain_view.it_guid, images_storage_domain_view.internal_drive_mapping, images_storage_domain_view.description, images_storage_domain_view.parentid, images_storage_domain_view.imagestatus, images_storage_domain_view.lastmodified, images_storage_domain_view.app_list, images_storage_domain_view.storage_id, images_storage_domain_view.vm_snapshot_id, images_storage_domain_view.volume_type, images_storage_domain_view.image_group_id, image_vm_map.vm_id AS vm_guid, image_vm_map.active, images_storage_domain_view.volume_format, images_storage_domain_view.disk_type, images_storage_domain_view.disk_interface, images_storage_domain_view.boot, images_storage_domain_view.wipe_after_delete, images_storage_domain_view.propagate_errors FROM ((image_vm_map JOIN images_storage_domain_view ON ((image_vm_map.image_id = images_storage_domain_view.image_guid))) JOIN disk_image_dynamic ON ((images_storage_domain_view.image_guid = disk_image_dynamic.image_id)));


ALTER TABLE public.vm_images_view OWNER TO postgres;

--
-- Name: getimagebyimageguid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getimagebyimageguid(v_image_guid uuid) RETURNS SETOF vm_images_view
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT *
      FROM vm_images_view
      WHERE image_guid = v_image_guid;
END; ';


ALTER FUNCTION public.getimagebyimageguid(v_image_guid uuid) OWNER TO postgres;

--
-- Name: getimagesbyvmguid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getimagesbyvmguid(v_vm_guid uuid) RETURNS SETOF vm_images_view
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT *
      FROM vm_images_view
      WHERE
      vm_guid = v_vm_guid;
END; ';


ALTER FUNCTION public.getimagesbyvmguid(v_vm_guid uuid) OWNER TO postgres;

--
-- Name: vds_interface; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vds_interface (
    id uuid NOT NULL,
    name character varying(50) NOT NULL,
    network_name character varying(50),
    vds_id uuid,
    mac_addr character varying(20),
    is_bond boolean DEFAULT false,
    bond_name character varying(50),
    bond_type integer,
    bond_opts character varying(4000),
    vlan_id integer,
    speed integer,
    addr character varying(20),
    subnet character varying(20),
    gateway character varying(20),
    boot_protocol integer,
    type integer DEFAULT 0,
    _create_date timestamp with time zone DEFAULT ('now'::text)::timestamp without time zone,
    _update_date timestamp with time zone
);


ALTER TABLE public.vds_interface OWNER TO postgres;

--
-- Name: vds_interface_statistics; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vds_interface_statistics (
    id uuid NOT NULL,
    vds_id uuid,
    rx_rate numeric(18,0),
    tx_rate numeric(18,0),
    rx_drop numeric(18,0),
    tx_drop numeric(18,0),
    iface_status integer
);


ALTER TABLE public.vds_interface_statistics OWNER TO postgres;

--
-- Name: vds_interface_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW vds_interface_view AS
    SELECT vds_interface_statistics.rx_rate, vds_interface_statistics.tx_rate, vds_interface_statistics.rx_drop, vds_interface_statistics.tx_drop, vds_interface_statistics.iface_status, vds_interface.type, vds_interface.gateway, vds_interface.subnet, vds_interface.addr, vds_interface.speed, vds_interface.vlan_id, vds_interface.bond_type, vds_interface.bond_name, vds_interface.is_bond, vds_interface.bond_opts, vds_interface.mac_addr, vds_interface.network_name, vds_interface.name, vds_static.vds_id, vds_static.vds_name, vds_interface.id, vds_interface.boot_protocol, 1 AS is_vds FROM ((vds_interface_statistics JOIN vds_interface ON ((vds_interface_statistics.id = vds_interface.id))) JOIN vds_static ON ((vds_interface.vds_id = vds_static.vds_id)));


ALTER TABLE public.vds_interface_view OWNER TO postgres;

--
-- Name: getinterface_viewbyvds_id(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getinterface_viewbyvds_id(v_vds_id uuid) RETURNS SETOF vds_interface_view
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM vds_interface_view
   WHERE vds_id = v_vds_id;

END; ';


ALTER FUNCTION public.getinterface_viewbyvds_id(v_vds_id uuid) OWNER TO postgres;

--
-- Name: getlun_storage_server_connection_mapbylunbystorage_server_conn(character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getlun_storage_server_connection_mapbylunbystorage_server_conn(v_lun_id character varying, v_storage_server_connection character varying) RETURNS SETOF lun_storage_server_connection_map
    LANGUAGE plpgsql
    AS '
BEGIN
	
   RETURN QUERY SELECT *
   FROM LUN_storage_server_connection_map lUN_storage_server_connection_map
   WHERE LUN_id = v_LUN_id AND storage_server_connection = v_storage_server_connection;

END; ';


ALTER FUNCTION public.getlun_storage_server_connection_mapbylunbystorage_server_conn(v_lun_id character varying, v_storage_server_connection character varying) OWNER TO postgres;

--
-- Name: getlunbylunid(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getlunbylunid(v_lun_id character varying) RETURNS SETOF luns
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM LUNs LUNs
   WHERE LUN_id = v_LUN_id; 

END; ';


ALTER FUNCTION public.getlunbylunid(v_lun_id character varying) OWNER TO postgres;

--
-- Name: getlunsbystorage_server_connection(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getlunsbystorage_server_connection(v_storage_server_connection character varying) RETURNS SETOF luns
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT  LUNs.*
   FROM LUNs LUNs INNER JOIN
   LUN_storage_server_connection_map
   ON LUN_storage_server_connection_map.LUN_id = LUNs.LUN_id
   WHERE LUN_storage_server_connection_map.storage_server_connection = v_storage_server_connection;

END; ';


ALTER FUNCTION public.getlunsbystorage_server_connection(v_storage_server_connection character varying) OWNER TO postgres;

--
-- Name: getlunsbyvolumegroupid(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getlunsbyvolumegroupid(v_volume_group_id character varying) RETURNS SETOF luns
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM LUNs LUNs
   WHERE volume_group_id = v_volume_group_id; 

END; ';


ALTER FUNCTION public.getlunsbyvolumegroupid(v_volume_group_id character varying) OWNER TO postgres;

--
-- Name: getnamesofvmstaticdedicatedtovds(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getnamesofvmstaticdedicatedtovds(v_vds_id uuid) RETURNS SETOF getnamesofvmstaticdedicatedtovds_rs
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY
      SELECT vm_name
      FROM vm_static
      WHERE dedicated_vm_for_vds = v_vds_id
      AND   migration_support = 2
      AND   entity_type = ''VM'';

END; ';


ALTER FUNCTION public.getnamesofvmstaticdedicatedtovds(v_vds_id uuid) OWNER TO postgres;

--
-- Name: getnetwork_clusterbycluster_idandbynetwork_id(uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getnetwork_clusterbycluster_idandbynetwork_id(v_cluster_id uuid, v_network_id uuid) RETURNS SETOF network_cluster
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM network_cluster
   WHERE cluster_id = v_cluster_id AND network_id = v_network_id;

END; ';


ALTER FUNCTION public.getnetwork_clusterbycluster_idandbynetwork_id(v_cluster_id uuid, v_network_id uuid) OWNER TO postgres;

--
-- Name: getnetworkbyid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getnetworkbyid(v_id uuid) RETURNS SETOF network_view
    LANGUAGE plpgsql
    AS '
BEGIN
RETURN QUERY SELECT *
   FROM network_view
   WHERE id = v_id;

END; ';


ALTER FUNCTION public.getnetworkbyid(v_id uuid) OWNER TO postgres;

--
-- Name: getnetworkbyname(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getnetworkbyname(v_networkname character varying) RETURNS SETOF network_view
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM network_view
   WHERE name = v_networkName;

END; ';


ALTER FUNCTION public.getnetworkbyname(v_networkname character varying) OWNER TO postgres;

--
-- Name: getnfsstorage_server_connectionsbystoragepoolid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getnfsstorage_server_connectionsbystoragepoolid(v_storage_pool_id uuid) RETURNS SETOF storage_server_connections
    LANGUAGE plpgsql
    AS '
BEGIN
RETURN QUERY SELECT distinct storage_server_connections.*
   FROM    storage_server_connections storage_server_connections
   INNER JOIN
   storage_domain_static_view ON
   storage_server_connections.id = storage_domain_static_view.storage
   WHERE     (storage_domain_static_view.storage_pool_id = v_storage_pool_id);
END; ';


ALTER FUNCTION public.getnfsstorage_server_connectionsbystoragepoolid(v_storage_pool_id uuid) OWNER TO postgres;

--
-- Name: getnvmtagsbyvmid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getnvmtagsbyvmid(v_vm_id uuid) RETURNS SETOF tags_vm_map
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY select * from tags_vm_map
      where tags_vm_map.vm_id = v_vm_id;
END; ';


ALTER FUNCTION public.getnvmtagsbyvmid(v_vm_id uuid) OWNER TO postgres;

--
-- Name: getnvmtagsbyvmidanddefaulttag(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getnvmtagsbyvmidanddefaulttag(v_vm_id uuid) RETURNS SETOF tags_vm_map
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY select tags_vm_map.* from tags_vm_map
      inner join tags on tags.tag_id = tags_vm_map.tag_id
      where tags_vm_map.vm_id = v_vm_id
      and tags.type = 1;
END; ';


ALTER FUNCTION public.getnvmtagsbyvmidanddefaulttag(v_vm_id uuid) OWNER TO postgres;

--
-- Name: getorderedvmguidsforrunmultipleactions(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getorderedvmguidsforrunmultipleactions(v_vm_guids character varying) RETURNS SETOF getorderedvmguidsforrunmultipleactions_rs
    LANGUAGE plpgsql
    AS '
   DECLARE
   v_ordered_guids GetOrderedVmGuidsForRunMultipleActions_rs;
BEGIN
   FOR v_ordered_guids IN EXECUTE ''SELECT vm_guid from vm_static where vm_guid in( '' || v_vm_guids || '' ) AND entity_type = ''''VM''''  order by auto_startup desc,priority desc, migration_support desc'' LOOP
      RETURN NEXT v_ordered_guids;
   END LOOP;
	
END; ';


ALTER FUNCTION public.getorderedvmguidsforrunmultipleactions(v_vm_guids character varying) OWNER TO postgres;

--
-- Name: getpermissionbyroleid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getpermissionbyroleid(v_role_id uuid) RETURNS SETOF permissions
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   from permissions
   where role_id = v_role_id;
END; ';


ALTER FUNCTION public.getpermissionbyroleid(v_role_id uuid) OWNER TO postgres;

--
-- Name: getpermissionsbyadelementid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getpermissionsbyadelementid(v_ad_element_id uuid) RETURNS SETOF permissions_view
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM permissions_view
   WHERE permissions_view.ad_element_id = v_ad_element_id
   or ad_element_id in(select id from getUserAndGroupsById(v_ad_element_id));

END; ';


ALTER FUNCTION public.getpermissionsbyadelementid(v_ad_element_id uuid) OWNER TO postgres;

--
-- Name: getpermissionsbyentityid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getpermissionsbyentityid(v_id uuid) RETURNS SETOF permissions_view
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM permissions_view
   WHERE object_id = v_id;
END; ';


ALTER FUNCTION public.getpermissionsbyentityid(v_id uuid) OWNER TO postgres;

--
-- Name: getpermissionsbyid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getpermissionsbyid(v_id uuid) RETURNS SETOF permissions_view
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM permissions_view
   WHERE id = v_id;

END; ';


ALTER FUNCTION public.getpermissionsbyid(v_id uuid) OWNER TO postgres;

--
-- Name: getpermissionsbyroleid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getpermissionsbyroleid(v_role_id uuid) RETURNS SETOF permissions_view
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM permissions_view
   WHERE role_id = v_role_id;

END; ';


ALTER FUNCTION public.getpermissionsbyroleid(v_role_id uuid) OWNER TO postgres;

--
-- Name: getpermissionsbyroleidandadelementid(uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getpermissionsbyroleidandadelementid(v_role_id uuid, v_ad_element_id uuid) RETURNS SETOF permissions_view
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM permissions_view
   WHERE role_id = v_role_id and ad_element_id = v_ad_element_id;

END; ';


ALTER FUNCTION public.getpermissionsbyroleidandadelementid(v_role_id uuid, v_ad_element_id uuid) OWNER TO postgres;

--
-- Name: getpermissionsbyroleidandadelementidandobjectid(uuid, uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getpermissionsbyroleidandadelementidandobjectid(v_role_id uuid, v_ad_element_id uuid, v_object_id uuid) RETURNS SETOF permissions_view
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM permissions_view
   WHERE role_id = v_role_id and ad_element_id = v_ad_element_id and object_id = v_object_id;

END; ';


ALTER FUNCTION public.getpermissionsbyroleidandadelementidandobjectid(v_role_id uuid, v_ad_element_id uuid, v_object_id uuid) OWNER TO postgres;

--
-- Name: getpermissionsbyroleidandobjectid(uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getpermissionsbyroleidandobjectid(v_role_id uuid, v_object_id uuid) RETURNS SETOF permissions_view
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM permissions_view
   WHERE role_id = v_role_id and object_id = v_object_id;

END; ';


ALTER FUNCTION public.getpermissionsbyroleidandobjectid(v_role_id uuid, v_object_id uuid) OWNER TO postgres;

--
-- Name: getpermissionstreebyentityid(uuid, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getpermissionstreebyentityid(v_id uuid, v_object_type_id integer) RETURNS SETOF permissions_view
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM permissions_view
   WHERE object_id in(select id from  fn_get_entity_parents(v_id,v_object_type_id));
END; ';


ALTER FUNCTION public.getpermissionstreebyentityid(v_id uuid, v_object_type_id integer) OWNER TO postgres;

--
-- Name: repo_file_meta_data; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE repo_file_meta_data (
    repo_domain_id uuid NOT NULL,
    repo_file_name character varying(256) NOT NULL,
    size bigint DEFAULT 0,
    date_created timestamp with time zone DEFAULT ('now'::text)::timestamp without time zone,
    last_refreshed bigint DEFAULT 0,
    file_type integer DEFAULT 0
);


ALTER TABLE public.repo_file_meta_data OWNER TO postgres;

--
-- Name: getrepo_files_by_storage_domain(uuid, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getrepo_files_by_storage_domain(v_storage_domain_id uuid, v_file_type integer) RETURNS SETOF repo_file_meta_data
    LANGUAGE plpgsql
    AS '
BEGIN
-- SET TRANSACTION ISOLATION LEVEL READ COMMITTED
   RETURN QUERY SELECT repo_file_meta_data.*
   FROM repo_file_meta_data
   WHERE repo_domain_id = v_storage_domain_id
   AND repo_file_meta_data.file_type = v_file_type
   ORDER BY repo_file_meta_data.last_refreshed;
END; ';


ALTER FUNCTION public.getrepo_files_by_storage_domain(v_storage_domain_id uuid, v_file_type integer) OWNER TO postgres;

--
-- Name: storage_domain_file_repos; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW storage_domain_file_repos AS
    SELECT storage_domain_static.id AS storage_domain_id, storage_domain_static.storage_domain_type, storage_pool_iso_map.storage_pool_id, storage_pool_iso_map.status AS storage_domain_status, repo_file_meta_data.repo_file_name, repo_file_meta_data.size, repo_file_meta_data.date_created, repo_file_meta_data.last_refreshed, repo_file_meta_data.file_type, vds_dynamic.status AS vds_status, storage_pool.status AS storage_pool_status FROM ((((storage_domain_static JOIN storage_pool_iso_map ON ((storage_domain_static.id = storage_pool_iso_map.storage_id))) JOIN storage_pool ON ((storage_pool.id = storage_pool_iso_map.storage_pool_id))) JOIN vds_dynamic ON ((vds_dynamic.vds_id = storage_pool.spm_vds_id))) LEFT JOIN repo_file_meta_data ON ((storage_pool_iso_map.storage_id = repo_file_meta_data.repo_domain_id)));


ALTER TABLE public.storage_domain_file_repos OWNER TO postgres;

--
-- Name: getrepo_files_by_storage_domain_and_storage_pool(uuid, uuid, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getrepo_files_by_storage_domain_and_storage_pool(v_storage_pool_id uuid, v_storage_domain_id uuid, v_file_type integer) RETURNS SETOF storage_domain_file_repos
    LANGUAGE plpgsql
    AS '
BEGIN
-- SET TRANSACTION ISOLATION LEVEL READ COMMITTED
   RETURN QUERY SELECT storage_domain_file_repos.*
   FROM storage_domain_file_repos
   WHERE storage_domain_id = v_storage_domain_id
   AND storage_pool_id = v_storage_pool_id
   AND storage_domain_file_repos.file_type = v_file_type
   ORDER BY storage_domain_file_repos.last_refreshed;
END; ';


ALTER FUNCTION public.getrepo_files_by_storage_domain_and_storage_pool(v_storage_pool_id uuid, v_storage_domain_id uuid, v_file_type integer) OWNER TO postgres;

--
-- Name: getrepo_files_in_all_storage_pools(integer, integer, integer, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getrepo_files_in_all_storage_pools(v_storage_domain_type integer, v_storage_pool_status integer, v_vds_status integer, v_storage_domain_status integer) RETURNS SETOF getrepo_files_in_all_storage_pools_rs
    LANGUAGE plpgsql
    AS '
BEGIN
-- SET TRANSACTION ISOLATION LEVEL READ COMMITTED
 RETURN QUERY SELECT distinct b.storage_domain_id,c.last_refreshed,b.file_type
   FROM storage_domain_file_repos b  
   LEFT OUTER JOIN 
   (SELECT storage_domain_id,file_type,min(last_refreshed) as last_refreshed
      FROM storage_domain_file_repos a
   	  Group by storage_domain_id,file_type) as c ON b.storage_domain_id = c.storage_domain_id
                                                 AND b.file_type = c.file_type
   WHERE b.storage_domain_type = v_storage_domain_type
     and b.storage_pool_status = v_storage_pool_status
     and b.storage_domain_status = v_storage_domain_status
	 and b.vds_status = v_vds_status;
END; ';


ALTER FUNCTION public.getrepo_files_in_all_storage_pools(v_storage_domain_type integer, v_storage_pool_status integer, v_vds_status integer, v_storage_domain_status integer) OWNER TO postgres;

--
-- Name: getrole_children(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getrole_children(v_role_id uuid) RETURNS SETOF roles_relations
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM roles_relations
   WHERE role_container_id = v_role_id;

END; ';


ALTER FUNCTION public.getrole_children(v_role_id uuid) OWNER TO postgres;

--
-- Name: getroleactiongroupsbyroleid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getroleactiongroupsbyroleid(v_id uuid) RETURNS SETOF roles_groups
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM roles_groups
   WHERE role_id = v_id;
END; ';


ALTER FUNCTION public.getroleactiongroupsbyroleid(v_id uuid) OWNER TO postgres;

--
-- Name: getrolebyname(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getrolebyname(v_name character varying) RETURNS SETOF roles
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM roles
   WHERE name = v_name;

END; ';


ALTER FUNCTION public.getrolebyname(v_name character varying) OWNER TO postgres;

--
-- Name: getroles_relationsbyrole_container_idandbyrole_id(uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getroles_relationsbyrole_container_idandbyrole_id(v_role_container_id uuid, v_role_id uuid) RETURNS SETOF roles_relations
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM roles_relations
   WHERE role_container_id = v_role_container_id AND role_id = v_role_id;

END; ';


ALTER FUNCTION public.getroles_relationsbyrole_container_idandbyrole_id(v_role_container_id uuid, v_role_id uuid) OWNER TO postgres;

--
-- Name: getrolesbyadelementid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getrolesbyadelementid(v_ad_element_id uuid) RETURNS SETOF roles
    LANGUAGE plpgsql
    AS '
BEGIN
    RETURN QUERY SELECT roles.*
   FROM roles
   inner join permissions permissions on roles.id = permissions.role_id
   WHERE ad_element_id = v_ad_element_id;
END; ';


ALTER FUNCTION public.getrolesbyadelementid(v_ad_element_id uuid) OWNER TO postgres;

--
-- Name: getrolsbyid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getrolsbyid(v_id uuid) RETURNS SETOF roles
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM roles
   WHERE id = v_id;

END; ';


ALTER FUNCTION public.getrolsbyid(v_id uuid) OWNER TO postgres;

--
-- Name: getrunningvmsbystoragedomainid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getrunningvmsbystoragedomainid(v_storage_domain_id uuid) RETURNS SETOF vms
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT DISTINCT vms.*
      FROM vms
      inner join image_vm_map on vms.vm_guid = image_vm_map.vm_id
      inner join images on image_vm_map.image_id = images.image_guid
      and images.image_guid in(select image_guid
         from images where storage_id = v_storage_domain_id)
      WHERE status <> 0;
END; ';


ALTER FUNCTION public.getrunningvmsbystoragedomainid(v_storage_domain_id uuid) OWNER TO postgres;

--
-- Name: getsnapshotbyguid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getsnapshotbyguid(v_image_guid uuid) RETURNS SETOF images_storage_domain_view
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT *
      FROM images_storage_domain_view images_storage_domain_view
      WHERE image_guid = v_image_guid;
END; ';


ALTER FUNCTION public.getsnapshotbyguid(v_image_guid uuid) OWNER TO postgres;

--
-- Name: getsnapshotbyparentguid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getsnapshotbyparentguid(v_parent_guid uuid) RETURNS SETOF images_storage_domain_view
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT *
      FROM images_storage_domain_view images_storage_domain_view
      WHERE ParentId = v_parent_guid;
END; ';


ALTER FUNCTION public.getsnapshotbyparentguid(v_parent_guid uuid) OWNER TO postgres;

--
-- Name: getsnapshotsbyimagegroupid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getsnapshotsbyimagegroupid(v_image_group_id uuid) RETURNS SETOF images_storage_domain_view
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT *
      FROM images_storage_domain_view images_storage_domain_view
      WHERE image_group_id = v_image_group_id;
END; ';


ALTER FUNCTION public.getsnapshotsbyimagegroupid(v_image_group_id uuid) OWNER TO postgres;

--
-- Name: getsnapshotsbystoragedomainid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getsnapshotsbystoragedomainid(v_storage_domain_id uuid) RETURNS SETOF images_storage_domain_view
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT *
      FROM images_storage_domain_view images_storage_domain_view
      WHERE storage_id = v_storage_domain_id;
END; ';


ALTER FUNCTION public.getsnapshotsbystoragedomainid(v_storage_domain_id uuid) OWNER TO postgres;

--
-- Name: getsnapshotsbyvmsnapshotid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getsnapshotsbyvmsnapshotid(v_vm_snapshot_id uuid) RETURNS SETOF images_storage_domain_view
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT *
      FROM images_storage_domain_view images_storage_domain_view
      WHERE vm_snapshot_id = v_vm_snapshot_id;
END; ';


ALTER FUNCTION public.getsnapshotsbyvmsnapshotid(v_vm_snapshot_id uuid) OWNER TO postgres;

--
-- Name: getstateless_vm_image_mapbyimage_guid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getstateless_vm_image_mapbyimage_guid(v_image_guid uuid) RETURNS SETOF stateless_vm_image_map
    LANGUAGE plpgsql
    AS '
BEGIN
RETURN QUERY SELECT stateless_vm_image_map.*
   FROM stateless_vm_image_map
   WHERE image_guid = v_image_guid;

END; ';


ALTER FUNCTION public.getstateless_vm_image_mapbyimage_guid(v_image_guid uuid) OWNER TO postgres;

--
-- Name: getstateless_vm_image_mapbyvm_guid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getstateless_vm_image_mapbyvm_guid(v_vm_guid uuid) RETURNS SETOF stateless_vm_image_map
    LANGUAGE plpgsql
    AS '
BEGIN
RETURN QUERY SELECT stateless_vm_image_map.*
   FROM stateless_vm_image_map
   WHERE vm_guid = v_vm_guid;

END; ';


ALTER FUNCTION public.getstateless_vm_image_mapbyvm_guid(v_vm_guid uuid) OWNER TO postgres;

--
-- Name: getstorage_domain_dynamicbyid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getstorage_domain_dynamicbyid(v_id uuid) RETURNS SETOF storage_domain_dynamic
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM storage_domain_dynamic
   WHERE id = v_id;

END; ';


ALTER FUNCTION public.getstorage_domain_dynamicbyid(v_id uuid) OWNER TO postgres;

--
-- Name: getstorage_domain_staticbyid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getstorage_domain_staticbyid(v_id uuid) RETURNS SETOF storage_domain_static
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM storage_domain_static
   WHERE id = v_id;

END; ';


ALTER FUNCTION public.getstorage_domain_staticbyid(v_id uuid) OWNER TO postgres;

--
-- Name: getstorage_domain_staticbyname(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getstorage_domain_staticbyname(v_name character varying) RETURNS SETOF storage_domain_static
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM storage_domain_static
   WHERE storage_name = v_name;

END; ';


ALTER FUNCTION public.getstorage_domain_staticbyname(v_name character varying) OWNER TO postgres;

--
-- Name: getstorage_domain_staticbystorage_pool_id(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getstorage_domain_staticbystorage_pool_id(v_storage_pool_id uuid) RETURNS SETOF storage_domain_static_view
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM storage_domain_static_view
   WHERE storage_pool_id = v_storage_pool_id;

END; ';


ALTER FUNCTION public.getstorage_domain_staticbystorage_pool_id(v_storage_pool_id uuid) OWNER TO postgres;

--
-- Name: getstorage_domain_staticbystorage_pool_type(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getstorage_domain_staticbystorage_pool_type(v_storage_pool_type integer) RETURNS SETOF storage_domain_static
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM storage_domain_static
   WHERE storage_type = v_storage_pool_type;

END; ';


ALTER FUNCTION public.getstorage_domain_staticbystorage_pool_type(v_storage_pool_type integer) OWNER TO postgres;

--
-- Name: getstorage_domain_staticbystorage_type_and_storage_pool_id(integer, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getstorage_domain_staticbystorage_type_and_storage_pool_id(v_storage_type integer, v_storage_pool_id uuid) RETURNS SETOF storage_domains
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM storage_domains
   WHERE storage_pool_id = v_storage_pool_id and storage_type = v_storage_type;

END; ';


ALTER FUNCTION public.getstorage_domain_staticbystorage_type_and_storage_pool_id(v_storage_type integer, v_storage_pool_id uuid) OWNER TO postgres;

--
-- Name: getstorage_domains_by_connection(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getstorage_domains_by_connection(v_connection character varying) RETURNS SETOF storage_domains
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM storage_domains
   WHERE storage IN (
      SELECT id
      FROM storage_server_connections
      WHERE connection = v_connection);

END; ';


ALTER FUNCTION public.getstorage_domains_by_connection(v_connection character varying) OWNER TO postgres;

--
-- Name: storage_domains_without_storage_pools; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW storage_domains_without_storage_pools AS
    SELECT storage_domain_static.id, storage_domain_static.storage, storage_domain_static.storage_name, storage_domain_static.storage_type, storage_domain_static.storage_domain_type, storage_domain_static.storage_domain_format_type, NULL::unknown AS status, NULL::unknown AS owner, NULL::unknown AS storage_pool_id, NULL::unknown AS storage_pool_name, storage_domain_dynamic.available_disk_size, storage_domain_dynamic.used_disk_size, fn_get_disk_commited_value_by_storage(storage_domain_static.id) AS commited_disk_size, fn_get_storage_domain_shared_status_by_domain_id(storage_domain_static.id, storage_domain_static.storage, storage_domain_static.storage_type) AS storage_domain_shared_status FROM (storage_domain_static JOIN storage_domain_dynamic ON ((storage_domain_static.id = storage_domain_dynamic.id)));


ALTER TABLE public.storage_domains_without_storage_pools OWNER TO postgres;

--
-- Name: getstorage_domains_by_id(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getstorage_domains_by_id(v_id uuid) RETURNS SETOF storage_domains_without_storage_pools
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM storage_domains_without_storage_pools
   WHERE id = v_id;

END; ';


ALTER FUNCTION public.getstorage_domains_by_id(v_id uuid) OWNER TO postgres;

--
-- Name: getstorage_domains_by_id_and_by_storage_pool_id(uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getstorage_domains_by_id_and_by_storage_pool_id(v_id uuid, v_storage_pool_id uuid) RETURNS SETOF storage_domains
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM storage_domains
   WHERE id = v_id and storage_pool_id = v_storage_pool_id;

END; ';


ALTER FUNCTION public.getstorage_domains_by_id_and_by_storage_pool_id(v_id uuid, v_storage_pool_id uuid) OWNER TO postgres;

--
-- Name: getstorage_domains_by_imagegroupid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getstorage_domains_by_imagegroupid(v_image_group_id uuid) RETURNS SETOF storage_domains
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT storage_domains.*
   FROM storage_domains
   INNER JOIN image_group_storage_domain_map as map on storage_domains.id = map.storage_domain_id
   WHERE map.image_group_id = v_image_group_id;

END; ';


ALTER FUNCTION public.getstorage_domains_by_imagegroupid(v_image_group_id uuid) OWNER TO postgres;

--
-- Name: getstorage_domains_by_storage_pool_id_and_connection(uuid, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getstorage_domains_by_storage_pool_id_and_connection(v_storage_pool_id uuid, v_connection character varying) RETURNS SETOF storage_domains
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM storage_domains
   WHERE storage_pool_id = v_storage_pool_id
   AND storage IN (
      SELECT id
      FROM storage_server_connections
      WHERE connection = v_connection);
END; ';


ALTER FUNCTION public.getstorage_domains_by_storage_pool_id_and_connection(v_storage_pool_id uuid, v_connection character varying) OWNER TO postgres;

--
-- Name: getstorage_domains_by_storagepoolid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getstorage_domains_by_storagepoolid(v_storage_pool_id uuid) RETURNS SETOF storage_domains
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM storage_domains
   WHERE storage_pool_id = v_storage_pool_id;

END; ';


ALTER FUNCTION public.getstorage_domains_by_storagepoolid(v_storage_pool_id uuid) OWNER TO postgres;

--
-- Name: getstorage_domains_list_by_storagedomainid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getstorage_domains_list_by_storagedomainid(v_storage_domain_id uuid) RETURNS SETOF storage_domains
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM storage_domains
   WHERE storage_domains.id = v_storage_domain_id;

END; ';


ALTER FUNCTION public.getstorage_domains_list_by_storagedomainid(v_storage_domain_id uuid) OWNER TO postgres;

--
-- Name: getstorage_domainsid_by_imagegroupid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getstorage_domainsid_by_imagegroupid(v_image_group_id uuid) RETURNS SETOF getstorage_domainsid_by_imagegroupid_rs
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT 
   images.storage_id AS storage_id FROM images
   WHERE  images.image_group_id = v_image_group_id
   UNION
   SELECT image_group_storage_domain_map.storage_domain_id AS storage_id FROM image_group_storage_domain_map
   WHERE image_group_storage_domain_map.image_group_id = v_image_group_id;


END; ';


ALTER FUNCTION public.getstorage_domainsid_by_imagegroupid(v_image_group_id uuid) OWNER TO postgres;

--
-- Name: getstorage_pool_iso_mapbystorage_idandbystorage_pool_id(uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getstorage_pool_iso_mapbystorage_idandbystorage_pool_id(v_storage_id uuid, v_storage_pool_id uuid) RETURNS SETOF storage_pool_iso_map
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM storage_pool_iso_map
   WHERE storage_id = v_storage_id AND storage_pool_id = v_storage_pool_id;

END; ';


ALTER FUNCTION public.getstorage_pool_iso_mapbystorage_idandbystorage_pool_id(v_storage_id uuid, v_storage_pool_id uuid) OWNER TO postgres;

--
-- Name: getstorage_pool_iso_mapsbybystorage_pool_id(uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getstorage_pool_iso_mapsbybystorage_pool_id(v_storage_id uuid, v_storage_pool_id uuid) RETURNS SETOF storage_pool_iso_map
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM storage_pool_iso_map
   WHERE storage_pool_id = v_storage_pool_id;

END; ';


ALTER FUNCTION public.getstorage_pool_iso_mapsbybystorage_pool_id(v_storage_id uuid, v_storage_pool_id uuid) OWNER TO postgres;

--
-- Name: getstorage_pool_iso_mapsbystorage_id(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getstorage_pool_iso_mapsbystorage_id(v_storage_id uuid) RETURNS SETOF storage_pool_iso_map
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM storage_pool_iso_map
   WHERE storage_id = v_storage_id;

END; ';


ALTER FUNCTION public.getstorage_pool_iso_mapsbystorage_id(v_storage_id uuid) OWNER TO postgres;

--
-- Name: getstorage_poolbyid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getstorage_poolbyid(v_id uuid) RETURNS SETOF storage_pool
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM storage_pool
   WHERE id = v_id;

END; ';


ALTER FUNCTION public.getstorage_poolbyid(v_id uuid) OWNER TO postgres;

--
-- Name: getstorage_poolbyname(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getstorage_poolbyname(v_name character varying) RETURNS SETOF storage_pool
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM storage_pool
   WHERE name = v_name;
END; ';


ALTER FUNCTION public.getstorage_poolbyname(v_name character varying) OWNER TO postgres;

--
-- Name: getstorage_poolsbystoragedomainid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getstorage_poolsbystoragedomainid(v_storage_domain_id uuid) RETURNS SETOF storage_pool
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT storage_pool.*
   FROM storage_pool
   inner join storage_pool_iso_map on storage_pool.id = storage_pool_iso_map.storage_pool_id
   WHERE storage_pool_iso_map.storage_id = v_storage_domain_id;

END; ';


ALTER FUNCTION public.getstorage_poolsbystoragedomainid(v_storage_domain_id uuid) OWNER TO postgres;

--
-- Name: getstorage_poolsbytype(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getstorage_poolsbytype(v_storage_pool_type integer) RETURNS SETOF storage_pool
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM storage_pool
   WHERE storage_pool_type = v_storage_pool_type;
END; ';


ALTER FUNCTION public.getstorage_poolsbytype(v_storage_pool_type integer) OWNER TO postgres;

--
-- Name: getstorage_poolsbyvdsgroupid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getstorage_poolsbyvdsgroupid(v_clusterid uuid) RETURNS SETOF storage_pool
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM storage_pool
   WHERE storage_pool.id in(select storage_pool_id
      FROM vds_groups
      WHERE vds_group_id = v_clusterId);

END; ';


ALTER FUNCTION public.getstorage_poolsbyvdsgroupid(v_clusterid uuid) OWNER TO postgres;

--
-- Name: getstorage_poolsbyvdsid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getstorage_poolsbyvdsid(v_vdsid uuid) RETURNS SETOF storage_pool
    LANGUAGE plpgsql
    AS '
   DECLARE
   v_clusterId  UUID;
BEGIN
select   vds_group_id INTO v_clusterId FROM Vds_static WHERE vds_id = v_vdsId; 
   RETURN QUERY SELECT *
   FROM storage_pool
   WHERE storage_pool.id in(select storage_pool_id
      FROM vds_groups
      WHERE vds_group_id = v_clusterId);

END; ';


ALTER FUNCTION public.getstorage_poolsbyvdsid(v_vdsid uuid) OWNER TO postgres;

--
-- Name: getstorage_server_connectionsbyconnection(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getstorage_server_connectionsbyconnection(v_connection character varying) RETURNS SETOF storage_server_connections
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM storage_server_connections
   WHERE connection = v_connection;

END; ';


ALTER FUNCTION public.getstorage_server_connectionsbyconnection(v_connection character varying) OWNER TO postgres;

--
-- Name: getstorage_server_connectionsbyid(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getstorage_server_connectionsbyid(v_id character varying) RETURNS SETOF storage_server_connections
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM storage_server_connections
   WHERE id = v_id;

END; ';


ALTER FUNCTION public.getstorage_server_connectionsbyid(v_id character varying) OWNER TO postgres;

--
-- Name: getstorage_server_connectionsbyiqn(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getstorage_server_connectionsbyiqn(v_iqn character varying) RETURNS SETOF storage_server_connections
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM storage_server_connections
   WHERE iqn = v_iqn;

END; ';


ALTER FUNCTION public.getstorage_server_connectionsbyiqn(v_iqn character varying) OWNER TO postgres;

--
-- Name: getstorage_server_connectionsbyiqnandconnection(character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getstorage_server_connectionsbyiqnandconnection(v_iqn character varying, v_connection character varying) RETURNS SETOF storage_server_connections
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM storage_server_connections
   WHERE iqn = v_iqn and (connection = v_connection or connection is NULL);

END; ';


ALTER FUNCTION public.getstorage_server_connectionsbyiqnandconnection(v_iqn character varying, v_connection character varying) OWNER TO postgres;

--
-- Name: getstorage_server_connectionsbykey(character varying, character varying, character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getstorage_server_connectionsbykey(v_iqn character varying, v_connection character varying, v_port character varying, v_portal character varying, v_username character varying, v_password character varying) RETURNS SETOF storage_server_connections
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM storage_server_connections
   WHERE (iqn = v_iqn or iqn is NULL) and
			(connection = v_connection) and
			(port = v_port or port is NULL) and
			(portal = v_portal or portal is NULL) and
			(user_name = v_username or user_name is NULL) and
			(password = v_password or password is NULL);

END; ';


ALTER FUNCTION public.getstorage_server_connectionsbykey(v_iqn character varying, v_connection character varying, v_port character varying, v_portal character varying, v_username character varying, v_password character varying) OWNER TO postgres;

--
-- Name: getstorage_server_connectionsbystoragepoolid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getstorage_server_connectionsbystoragepoolid(v_storage_pool_id uuid) RETURNS SETOF storage_server_connections
    LANGUAGE plpgsql
    AS '
BEGIN
RETURN QUERY SELECT distinct storage_server_connections.*
   FROM
   LUN_storage_server_connection_map LUN_storage_server_connection_map
   INNER JOIN  LUNs ON LUN_storage_server_connection_map.LUN_id = LUNs.LUN_id
   INNER JOIN  storage_domains ON LUNs.volume_group_id = storage_domains.storage
   INNER JOIN  storage_server_connections ON LUN_storage_server_connection_map.storage_server_connection = storage_server_connections.id
   WHERE     (storage_domains.storage_pool_id = v_storage_pool_id  and storage_domains.status in(0,3))
   UNION
   SELECT distinct storage_server_connections.*
   FROM         storage_server_connections
   INNER JOIN  storage_domains ON storage_server_connections.id = storage_domains.storage
   WHERE     (storage_domains.storage_pool_id = v_storage_pool_id and storage_domains.status in(0,3));
END; ';


ALTER FUNCTION public.getstorage_server_connectionsbystoragepoolid(v_storage_pool_id uuid) OWNER TO postgres;

--
-- Name: getstorage_server_connectionsbystoragetype(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getstorage_server_connectionsbystoragetype(v_storage_type integer) RETURNS SETOF storage_server_connections
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM storage_server_connections
   WHERE storage_type = v_storage_type;

END; ';


ALTER FUNCTION public.getstorage_server_connectionsbystoragetype(v_storage_type integer) OWNER TO postgres;

--
-- Name: getstorage_server_connectionsbyvolumegroupid(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getstorage_server_connectionsbyvolumegroupid(v_volume_group_id character varying) RETURNS SETOF storage_server_connections
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT storage_server_connections.*
   FROM
   LUN_storage_server_connection_map  LUN_storage_server_connection_map 
   INNER JOIN
   LUNs ON LUN_storage_server_connection_map.LUN_id = LUNs.LUN_id INNER JOIN
   storage_domain_static ON LUNs.volume_group_id = storage_domain_static.storage INNER JOIN
   storage_server_connections ON
   LUN_storage_server_connection_map.storage_server_connection = storage_server_connections.id
   WHERE     (storage_domain_static.storage = v_volume_group_id);
END; ';


ALTER FUNCTION public.getstorage_server_connectionsbyvolumegroupid(v_volume_group_id character varying) OWNER TO postgres;

--
-- Name: getstoragedomainidsbystoragepoolidandstatus(uuid, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getstoragedomainidsbystoragepoolidandstatus(v_storage_pool_id uuid, v_status integer) RETURNS SETOF getstoragedomainidsbystoragepoolidandstatus_rs
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY
   SELECT storage_id
   FROM   storage_pool_iso_map
   WHERE  storage_pool_id = v_storage_pool_id
   AND    status = v_status;

END; ';


ALTER FUNCTION public.getstoragedomainidsbystoragepoolidandstatus(v_storage_pool_id uuid, v_status integer) OWNER TO postgres;

--
-- Name: getsystem_statistics(character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getsystem_statistics(v_entity character varying, v_status character varying) RETURNS getsystem_statistics_rs
    LANGUAGE plpgsql
    AS '
   DECLARE
   v_i Getsystem_statistics_rs;
   v_sql  VARCHAR(4000);
   v_sys_entity VARCHAR(10);
BEGIN
   v_sys_entity := v_entity;
   v_sql := NULL;

   v_sys_entity := upper(v_sys_entity);
   if (v_sys_entity = ''VM'') then
      v_sql := ''select count(vm_guid) from vm_dynamic'';
   else 
      if (v_sys_entity = ''HOST'') then
         v_sql := ''select count(vds_id)  from vds_dynamic'';
      else 
         if (v_sys_entity = ''USER'') then
            v_sql := ''select count(user_id) from users'';
         else 
            if (v_sys_entity = ''TSD'') then
               v_sql := ''select count(id) from storage_domain_static'';
            else 
               if (v_sys_entity = ''ASD'') then
                  v_sql := ''select count(storage_id) from storage_pool_iso_map'';
               end if;
            end if;
         end if;
      end if;
   end if;

   if (v_status != '''' and v_sys_entity != ''TSD'') then
      v_sql := coalesce(v_sql,'''') || '' where status in ('' || coalesce(v_status,'''') || '')'';
   end if;
   EXECUTE v_sql INTO v_i;
   RETURN v_i;
END; ';


ALTER FUNCTION public.getsystem_statistics(v_entity character varying, v_status character varying) OWNER TO postgres;

--
-- Name: tags_user_group_map_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW tags_user_group_map_view AS
    SELECT tags.tag_id, tags.tag_name, tags.parent_id, tags.readonly, tags.type, tags_user_group_map.group_id FROM (tags_user_group_map JOIN tags ON ((tags_user_group_map.tag_id = tags.tag_id)));


ALTER TABLE public.tags_user_group_map_view OWNER TO postgres;

--
-- Name: gettags_user_group_mapbytagname(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION gettags_user_group_mapbytagname(v_tag_name character varying) RETURNS SETOF tags_user_group_map_view
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT tags_user_group_map_view.*
      FROM tags_user_group_map_view
      WHERE tag_name = v_tag_name;
END; ';


ALTER FUNCTION public.gettags_user_group_mapbytagname(v_tag_name character varying) OWNER TO postgres;

--
-- Name: tags_user_map_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW tags_user_map_view AS
    SELECT tags.tag_id, tags.tag_name, tags.parent_id, tags.readonly, tags.type, tags_user_map.user_id FROM (tags JOIN tags_user_map ON ((tags.tag_id = tags_user_map.tag_id)));


ALTER TABLE public.tags_user_map_view OWNER TO postgres;

--
-- Name: gettags_user_mapbytagname(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION gettags_user_mapbytagname(v_tag_name character varying) RETURNS SETOF tags_user_map_view
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT tags_user_map_view.*
      FROM tags_user_map_view
      WHERE tag_name = v_tag_name;
END; ';


ALTER FUNCTION public.gettags_user_mapbytagname(v_tag_name character varying) OWNER TO postgres;

--
-- Name: tags_vds_map_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW tags_vds_map_view AS
    SELECT tags.tag_id, tags.tag_name, tags.parent_id, tags.readonly, tags.type, tags_vds_map.vds_id FROM (tags JOIN tags_vds_map ON ((tags.tag_id = tags_vds_map.tag_id)));


ALTER TABLE public.tags_vds_map_view OWNER TO postgres;

--
-- Name: gettags_vds_mapbytagname(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION gettags_vds_mapbytagname(v_tag_name character varying) RETURNS SETOF tags_vds_map_view
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT tags_vds_map_view.*
      FROM tags_vds_map_view
      WHERE tag_name = v_tag_name;
END; ';


ALTER FUNCTION public.gettags_vds_mapbytagname(v_tag_name character varying) OWNER TO postgres;

--
-- Name: tags_vm_map_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW tags_vm_map_view AS
    SELECT tags.tag_id, tags.tag_name, tags.parent_id, tags.readonly, tags.type, tags_vm_map.vm_id FROM (tags JOIN tags_vm_map ON ((tags.tag_id = tags_vm_map.tag_id)));


ALTER TABLE public.tags_vm_map_view OWNER TO postgres;

--
-- Name: gettags_vm_mapbytagname(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION gettags_vm_mapbytagname(v_tag_name character varying) RETURNS SETOF tags_vm_map_view
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT tags_vm_map_view.*
      FROM tags_vm_map_view
      WHERE tag_name = v_tag_name;
END; ';


ALTER FUNCTION public.gettags_vm_mapbytagname(v_tag_name character varying) OWNER TO postgres;

--
-- Name: gettags_vm_pool_mapbytag_idandbyvm_pool_id(uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION gettags_vm_pool_mapbytag_idandbyvm_pool_id(v_tag_id uuid, v_vm_pool_id uuid) RETURNS SETOF tags_vm_pool_map
    LANGUAGE plpgsql
    AS '
BEGIN
	
   RETURN QUERY SELECT tags_vm_pool_map.*
   FROM tags_vm_pool_map
   WHERE tag_id = v_tag_id AND vm_pool_id = v_vm_pool_id;

END; ';


ALTER FUNCTION public.gettags_vm_pool_mapbytag_idandbyvm_pool_id(v_tag_id uuid, v_vm_pool_id uuid) OWNER TO postgres;

--
-- Name: gettagsbyparent_id(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION gettagsbyparent_id(v_parent_id uuid) RETURNS SETOF tags
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT tags.*
      FROM tags
      WHERE parent_id = v_parent_id;
END; ';


ALTER FUNCTION public.gettagsbyparent_id(v_parent_id uuid) OWNER TO postgres;

--
-- Name: gettagsbytag_id(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION gettagsbytag_id(v_tag_id uuid) RETURNS SETOF tags
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT tags.*
      FROM tags
      WHERE tag_id = v_tag_id;
END; ';


ALTER FUNCTION public.gettagsbytag_id(v_tag_id uuid) OWNER TO postgres;

--
-- Name: gettagsbytag_name(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION gettagsbytag_name(v_tag_name character varying) RETURNS SETOF tags
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT tags.*
      FROM tags
      WHERE tag_name = v_tag_name;
END; ';


ALTER FUNCTION public.gettagsbytag_name(v_tag_name character varying) OWNER TO postgres;

--
-- Name: gettagsbyusergroupid(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION gettagsbyusergroupid(v_group_ids character varying) RETURNS SETOF tags_user_group_map_view
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT DISTINCT tags_user_group_map_view.*
      FROM tags_user_group_map_view
      WHERE group_id in(select id from fnSplitterUuid(v_group_ids));
END; ';


ALTER FUNCTION public.gettagsbyusergroupid(v_group_ids character varying) OWNER TO postgres;

--
-- Name: gettagsbyuserid(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION gettagsbyuserid(v_user_ids character varying) RETURNS SETOF tags_user_map_view
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT DISTINCT tags_user_map_view.*
      FROM tags_user_map_view
      WHERE user_id in(select id from fnSplitterUuid(v_user_ids));
END; ';


ALTER FUNCTION public.gettagsbyuserid(v_user_ids character varying) OWNER TO postgres;

--
-- Name: gettagsbyvdsid(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION gettagsbyvdsid(v_vds_ids character varying) RETURNS SETOF tags_vds_map_view
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT DISTINCT tags_vds_map_view.*
      FROM tags_vds_map_view
      WHERE vds_id in(select id from fnSplitterUuid(v_vds_ids));
END; ';


ALTER FUNCTION public.gettagsbyvdsid(v_vds_ids character varying) OWNER TO postgres;

--
-- Name: gettagsbyvmid(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION gettagsbyvmid(v_vm_ids character varying) RETURNS SETOF tags_vm_map_view
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT DISTINCT tags_vm_map_view.*
      FROM tags_vm_map_view
      WHERE vm_id in(select id from fnSplitterUuid(v_vm_ids));
END; ';


ALTER FUNCTION public.gettagsbyvmid(v_vm_ids character varying) OWNER TO postgres;

--
-- Name: tags_vm_pool_map_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW tags_vm_pool_map_view AS
    SELECT tags.tag_id, tags.tag_name, tags.parent_id, tags.readonly, tags.type, tags_vm_pool_map.vm_pool_id FROM (tags JOIN tags_vm_pool_map ON ((tags.tag_id = tags_vm_pool_map.tag_id)));


ALTER TABLE public.tags_vm_pool_map_view OWNER TO postgres;

--
-- Name: gettagsbyvmpoolid(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION gettagsbyvmpoolid(v_vm_pool_ids character varying) RETURNS SETOF tags_vm_pool_map_view
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT DISTINCT tags_vm_pool_map_view.*
      FROM tags_vm_pool_map_view
      WHERE vm_pool_id in(select id from fnSplitterUuid(v_vm_pool_ids));
END; ';


ALTER FUNCTION public.gettagsbyvmpoolid(v_vm_pool_ids character varying) OWNER TO postgres;

--
-- Name: gettaguserbytagidandbyuserid(uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION gettaguserbytagidandbyuserid(v_tag_id uuid, v_user_id uuid) RETURNS SETOF tags_user_map
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT tags_user_map.*
      FROM tags_user_map
      WHERE tag_id = v_tag_id AND user_id = v_user_id;
END; ';


ALTER FUNCTION public.gettaguserbytagidandbyuserid(v_tag_id uuid, v_user_id uuid) OWNER TO postgres;

--
-- Name: gettagusergroupbygroupidandbytagid(uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION gettagusergroupbygroupidandbytagid(v_group_id uuid, v_tag_id uuid) RETURNS SETOF tags_user_group_map
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT tags_user_group_map.*
      FROM tags_user_group_map
      WHERE group_id = v_group_id AND tag_id = v_tag_id;
END; ';


ALTER FUNCTION public.gettagusergroupbygroupidandbytagid(v_group_id uuid, v_tag_id uuid) OWNER TO postgres;

--
-- Name: gettagvdsbytagidandbyvdsid(uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION gettagvdsbytagidandbyvdsid(v_tag_id uuid, v_vds_id uuid) RETURNS SETOF tags_vds_map
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT tags_vds_map.*
      FROM tags_vds_map
      WHERE tag_id = v_tag_id AND vds_id = v_vds_id;
END; ';


ALTER FUNCTION public.gettagvdsbytagidandbyvdsid(v_tag_id uuid, v_vds_id uuid) OWNER TO postgres;

--
-- Name: gettagvmbytagidandbyvmid(uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION gettagvmbytagidandbyvmid(v_tag_id uuid, v_vm_id uuid) RETURNS SETOF tags_vm_map
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT tags_vm_map.*
      FROM tags_vm_map
      WHERE tag_id = v_tag_id AND vm_id = v_vm_id;
END; ';


ALTER FUNCTION public.gettagvmbytagidandbyvmid(v_tag_id uuid, v_vm_id uuid) OWNER TO postgres;

--
-- Name: gettime_lease_vm_pool_mapbyid(uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION gettime_lease_vm_pool_mapbyid(v_id uuid, v_vm_pool_id uuid) RETURNS SETOF time_lease_vm_pool_map
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT time_lease_vm_pool_map.*
      FROM time_lease_vm_pool_map
      WHERE id = v_id;
END; ';


ALTER FUNCTION public.gettime_lease_vm_pool_mapbyid(v_id uuid, v_vm_pool_id uuid) OWNER TO postgres;

--
-- Name: gettime_lease_vm_pool_mapbyidandbyvm_pool_id(uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION gettime_lease_vm_pool_mapbyidandbyvm_pool_id(v_id uuid, v_vm_pool_id uuid) RETURNS SETOF time_lease_vm_pool_map
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT time_lease_vm_pool_map.*
      FROM time_lease_vm_pool_map
      WHERE id = v_id AND vm_pool_id = v_vm_pool_id;
END; ';


ALTER FUNCTION public.gettime_lease_vm_pool_mapbyidandbyvm_pool_id(v_id uuid, v_vm_pool_id uuid) OWNER TO postgres;

--
-- Name: gettime_lease_vm_pool_mapbyvm_pool_id(uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION gettime_lease_vm_pool_mapbyvm_pool_id(v_id uuid, v_vm_pool_id uuid) RETURNS SETOF time_lease_vm_pool_map
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT time_lease_vm_pool_map.*
      FROM time_lease_vm_pool_map
      WHERE vm_pool_id = v_vm_pool_id;
END; ';


ALTER FUNCTION public.gettime_lease_vm_pool_mapbyvm_pool_id(v_id uuid, v_vm_pool_id uuid) OWNER TO postgres;

--
-- Name: gettime_leasedad_groups_by_vm_pool_id(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION gettime_leasedad_groups_by_vm_pool_id(v_vmpoolid uuid) RETURNS SETOF ad_groups
    LANGUAGE plpgsql
    AS '
DECLARE
   v_row RECORD;
   v_ad_groups ad_groups%ROWTYPE;
BEGIN
      FOR v_row IN SELECT DISTINCT ad_groups.*,
						time_lease_vm_pool_map.start_time AS "from",
						time_lease_vm_pool_map.end_time AS "to"
      FROM         ad_groups INNER JOIN
      time_lease_vm_pool_map
      ON ad_groups.id = time_lease_vm_pool_map.id
      WHERE     (time_lease_vm_pool_map.vm_pool_id = v_vmPoolId) LOOP
         SELECT INTO v_ad_groups * FROM ad_groups WHERE ad_groups.id = v_row.id;
         RETURN NEXT v_ad_groups;
      END LOOP;
END; ';


ALTER FUNCTION public.gettime_leasedad_groups_by_vm_pool_id(v_vmpoolid uuid) OWNER TO postgres;

--
-- Name: gettime_leasedusers_by_vm_pool_id(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION gettime_leasedusers_by_vm_pool_id(v_vm_pool_id uuid) RETURNS SETOF users
    LANGUAGE plpgsql
    AS '
DECLARE
   v_row RECORD;
   v_users users%ROWTYPE;
BEGIN
      FOR v_row IN SELECT users.*,
			time_lease_vm_pool_map.start_time AS "from",
			time_lease_vm_pool_map.end_time AS "to"
      FROM         users INNER JOIN
      time_lease_vm_pool_map ON users.user_id = time_lease_vm_pool_map.id
      WHERE     (time_lease_vm_pool_map.vm_pool_id = v_vm_pool_id) LOOP
         SELECT INTO v_users * FROM users WHERE users.user_id = v_row.user_id;
         RETURN NEXT v_users;
      END LOOP;
END; ';


ALTER FUNCTION public.gettime_leasedusers_by_vm_pool_id(v_vm_pool_id uuid) OWNER TO postgres;

--
-- Name: gettimeleasedusersvmsbygroupidandpoolid(uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION gettimeleasedusersvmsbygroupidandpoolid(v_groupid uuid, v_vm_pool_id uuid) RETURNS SETOF tags_vm_map
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY select tags_vm_map.* from tags_vm_map
      inner join vm_pool_map on vm_pool_map.vm_guid = tags_vm_map.vm_id
      inner join tags_permissions_map on tags_permissions_map.tag_id = tags_vm_map.tag_id
      inner join permissions on permissions.id = tags_permissions_map.permission_id
      where permissions.ad_element_id
      in(select users.user_id from users
         where (users.groups LIKE ''%'' ||(select ad_groups.name from ad_groups where ad_groups.id = v_groupId)
         || ''%''))
      and
      vm_pool_map.vm_pool_id = v_vm_pool_id;
END; ';


ALTER FUNCTION public.gettimeleasedusersvmsbygroupidandpoolid(v_groupid uuid, v_vm_pool_id uuid) OWNER TO postgres;

--
-- Name: getupandprioritizedvds(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getupandprioritizedvds(v_storage_pool_id uuid) RETURNS SETOF vds
    LANGUAGE plpgsql
    AS '

BEGIN
BEGIN
      RETURN QUERY SELECT vds.*
      FROM vds
      WHERE (status = 3) AND (storage_pool_id = v_storage_pool_id) AND (vds_spm_priority IS NULL OR vds_spm_priority > (-1))
      ORDER BY vds_spm_priority DESC, RANDOM();
   END;
   RETURN;
END; ';


ALTER FUNCTION public.getupandprioritizedvds(v_storage_pool_id uuid) OWNER TO postgres;

--
-- Name: getuser_sessionsbysession_idandbyuser_id(character, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getuser_sessionsbysession_idandbyuser_id(v_session_id character, v_user_id uuid) RETURNS SETOF user_sessions
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT user_sessions.*
      FROM user_sessions
      WHERE session_id = v_session_id AND user_id = v_user_id;
END; ';


ALTER FUNCTION public.getuser_sessionsbysession_idandbyuser_id(v_session_id character, v_user_id uuid) OWNER TO postgres;

--
-- Name: getuserandgroupsbyid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getuserandgroupsbyid(v_id uuid) RETURNS SETOF iduuidtype
    LANGUAGE plpgsql
    AS '
   DECLARE
   SWV_Rs idUuidType;
BEGIN
   BEGIN
      CREATE GLOBAL TEMPORARY TABLE tt_TEMP3
      (
         id UUID
      ) WITH OIDS;
      exception when others then
         truncate table tt_TEMP3;
   END;
   insert INTO tt_TEMP3
   select ID from ad_groups,users where users.user_id = v_id
   and ad_groups.id in(select ID from fnsplitteruuid(users.group_ids))
   UNION
   select v_id
   UNION
   -- user is also member of ''Everyone''
   select ''EEE00000-0000-0000-0000-123456789EEE'';
   FOR SWV_Rs IN(SELECT * FROM  tt_TEMP3) LOOP
      RETURN NEXT SWV_Rs;
   END LOOP;
   RETURN;
END; ';


ALTER FUNCTION public.getuserandgroupsbyid(v_id uuid) OWNER TO postgres;

--
-- Name: getuserbyuserid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getuserbyuserid(v_user_id uuid) RETURNS SETOF users
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT users.*
      FROM users
      WHERE user_id = v_user_id;
END; ';


ALTER FUNCTION public.getuserbyuserid(v_user_id uuid) OWNER TO postgres;

--
-- Name: getuserbyusername(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getuserbyusername(v_username character varying) RETURNS SETOF users
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT users.*
      FROM users
      WHERE username = v_username;
END; ';


ALTER FUNCTION public.getuserbyusername(v_username character varying) OWNER TO postgres;

--
-- Name: getusergrouptagsbytagids(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getusergrouptagsbytagids(v_tag_ids character varying) RETURNS SETOF tags_user_group_map_view
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT DISTINCT tags_user_group_map_view.*
      FROM tags_user_group_map_view
      WHERE tag_id in(select id from fnSplitterUuid(v_tag_ids));
END; ';


ALTER FUNCTION public.getusergrouptagsbytagids(v_tag_ids character varying) OWNER TO postgres;

--
-- Name: getusersbyvmguid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getusersbyvmguid(v_vm_guid uuid) RETURNS SETOF users
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT users.*
      FROM users
      inner join permissions
      on users.user_id = permissions.ad_element_id
      WHERE permissions.object_type_id = 2
      and	permissions.object_id = v_vm_guid;
END; ';


ALTER FUNCTION public.getusersbyvmguid(v_vm_guid uuid) OWNER TO postgres;

--
-- Name: getusertagsbytagids(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getusertagsbytagids(v_tag_ids character varying) RETURNS SETOF tags_user_map_view
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT DISTINCT tags_user_map_view.*
      FROM tags_user_map_view
      WHERE tag_id in(select id from fnSplitterUuid(v_tag_ids));
END; ';


ALTER FUNCTION public.getusertagsbytagids(v_tag_ids character varying) OWNER TO postgres;

--
-- Name: getvdcoptionbyid(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvdcoptionbyid(v_option_id integer) RETURNS SETOF vdc_options
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT vdc_options.*
      FROM vdc_options
      WHERE option_id = v_option_id;
END; ';


ALTER FUNCTION public.getvdcoptionbyid(v_option_id integer) OWNER TO postgres;

--
-- Name: getvdcoptionbyname(character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvdcoptionbyname(v_option_name character varying, v_version character varying) RETURNS SETOF vdc_options
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT vdc_options.*
      FROM vdc_options
      WHERE OPTION_NAME = v_option_name and version = v_version;
END; ';


ALTER FUNCTION public.getvdcoptionbyname(v_option_name character varying, v_version character varying) OWNER TO postgres;

--
-- Name: getvds_spm_id_mapbystorage_pool_id(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvds_spm_id_mapbystorage_pool_id(v_storage_pool_id uuid) RETURNS SETOF vds_spm_id_map
    LANGUAGE plpgsql
    AS '
BEGIN
RETURN QUERY SELECT vds_spm_id_map.*
   FROM vds_spm_id_map
   WHERE storage_pool_id = v_storage_pool_id;

END; ';


ALTER FUNCTION public.getvds_spm_id_mapbystorage_pool_id(v_storage_pool_id uuid) OWNER TO postgres;

--
-- Name: getvds_spm_id_mapbystorage_pool_idandbyvds_spm_id(uuid, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvds_spm_id_mapbystorage_pool_idandbyvds_spm_id(v_storage_pool_id uuid, v_vds_spm_id integer) RETURNS SETOF vds_spm_id_map
    LANGUAGE plpgsql
    AS '
BEGIN
RETURN QUERY SELECT vds_spm_id_map.*
   FROM vds_spm_id_map
   WHERE storage_pool_id = v_storage_pool_id AND vds_spm_id = v_vds_spm_id;

END; ';


ALTER FUNCTION public.getvds_spm_id_mapbystorage_pool_idandbyvds_spm_id(v_storage_pool_id uuid, v_vds_spm_id integer) OWNER TO postgres;

--
-- Name: getvds_spm_id_mapbyvds_id(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvds_spm_id_mapbyvds_id(v_vds_id uuid) RETURNS SETOF vds_spm_id_map
    LANGUAGE plpgsql
    AS '
BEGIN
RETURN QUERY SELECT vds_spm_id_map.*
   FROM vds_spm_id_map
   WHERE vds_id = v_vds_id;

END; ';


ALTER FUNCTION public.getvds_spm_id_mapbyvds_id(v_vds_id uuid) OWNER TO postgres;

--
-- Name: getvdsbyhostname(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvdsbyhostname(v_host_name character varying) RETURNS SETOF vds
    LANGUAGE plpgsql
    AS '
BEGIN
BEGIN
      RETURN QUERY SELECT DISTINCT vds.*
      FROM vds
      WHERE host_name = v_host_name;
   END;

   RETURN;
END; ';


ALTER FUNCTION public.getvdsbyhostname(v_host_name character varying) OWNER TO postgres;

--
-- Name: getvdsbyip(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvdsbyip(v_ip character varying) RETURNS SETOF vds
    LANGUAGE plpgsql
    AS '
BEGIN
BEGIN
      RETURN QUERY SELECT DISTINCT vds.*
      FROM vds
      WHERE ip = v_ip;
   END;

   RETURN;
END; ';


ALTER FUNCTION public.getvdsbyip(v_ip character varying) OWNER TO postgres;

--
-- Name: getvdsbyname(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvdsbyname(v_vds_name character varying) RETURNS SETOF vds
    LANGUAGE plpgsql
    AS '
BEGIN
BEGIN
      RETURN QUERY SELECT DISTINCT vds.*
      FROM vds
      WHERE vds_name = v_vds_name;
   END;

   RETURN;
END; ';


ALTER FUNCTION public.getvdsbyname(v_vds_name character varying) OWNER TO postgres;

--
-- Name: getvdsbytype(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvdsbytype(v_vds_type integer) RETURNS SETOF vds
    LANGUAGE plpgsql
    AS '
BEGIN
BEGIN
      RETURN QUERY SELECT DISTINCT vds.*
      FROM vds
      WHERE vds_type = v_vds_type;
   END;

   RETURN;
END; ';


ALTER FUNCTION public.getvdsbytype(v_vds_type integer) OWNER TO postgres;

--
-- Name: getvdsbyuniqueid(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvdsbyuniqueid(v_vds_unique_id character varying) RETURNS SETOF vds
    LANGUAGE plpgsql
    AS '
BEGIN
BEGIN
      RETURN QUERY SELECT DISTINCT vds.*
      FROM vds
      WHERE vds_unique_id = v_vds_unique_id;
   END;

   RETURN;
END; ';


ALTER FUNCTION public.getvdsbyuniqueid(v_vds_unique_id character varying) OWNER TO postgres;

--
-- Name: getvdsbyvdsgroupid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvdsbyvdsgroupid(v_vds_group_id uuid) RETURNS SETOF vds
    LANGUAGE plpgsql
    AS '
BEGIN

	
	-- this sp returns all vds for a given cluster
	BEGIN
      RETURN QUERY SELECT DISTINCT vds.*

      FROM vds
      WHERE vds_group_id = v_vds_group_id;
   END;

   RETURN;
END; ';


ALTER FUNCTION public.getvdsbyvdsgroupid(v_vds_group_id uuid) OWNER TO postgres;

--
-- Name: getvdsbyvdsid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvdsbyvdsid(v_vds_id uuid) RETURNS SETOF vds
    LANGUAGE plpgsql
    AS '
BEGIN
BEGIN
      RETURN QUERY SELECT DISTINCT vds.*
      FROM vds
      WHERE vds_id = v_vds_id;
   END;

   RETURN;
END; ';


ALTER FUNCTION public.getvdsbyvdsid(v_vds_id uuid) OWNER TO postgres;

--
-- Name: getvdsdynamicbyvdsid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvdsdynamicbyvdsid(v_vds_id uuid) RETURNS SETOF vds_dynamic
    LANGUAGE plpgsql
    AS '
BEGIN
BEGIN
      RETURN QUERY SELECT vds_dynamic.*
      FROM vds_dynamic
      WHERE vds_id = v_vds_id;
   END;

   RETURN;
END; ';


ALTER FUNCTION public.getvdsdynamicbyvdsid(v_vds_id uuid) OWNER TO postgres;

--
-- Name: getvdsgroupbyvdsgroupid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvdsgroupbyvdsgroupid(v_vds_group_id uuid) RETURNS SETOF vds_groups
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT vds_groups.*
      FROM vds_groups
      WHERE vds_group_id = v_vds_group_id;
END; ';


ALTER FUNCTION public.getvdsgroupbyvdsgroupid(v_vds_group_id uuid) OWNER TO postgres;

--
-- Name: getvdsgroupbyvdsgroupname(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvdsgroupbyvdsgroupname(v_vds_group_name character varying) RETURNS SETOF vds_groups
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT vds_groups.*
      FROM vds_groups
      WHERE name = v_vds_group_name;
END; ';


ALTER FUNCTION public.getvdsgroupbyvdsgroupname(v_vds_group_name character varying) OWNER TO postgres;

--
-- Name: getvdsgroupsbystoragepoolid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvdsgroupsbystoragepoolid(v_storage_pool_id uuid) RETURNS SETOF vds_groups
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT vds_groups.*
      FROM vds_groups
      WHERE storage_pool_id = v_storage_pool_id;
END; ';


ALTER FUNCTION public.getvdsgroupsbystoragepoolid(v_storage_pool_id uuid) OWNER TO postgres;

--
-- Name: getvdsgroupwithrunningvms(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvdsgroupwithrunningvms(v_vds_group_id uuid) RETURNS SETOF vds_groups
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT vds_groups.*
      FROM vds_groups
      WHERE vds_group_id = v_vds_group_id and vds_group_id in(select vds_group_id from vms where vms.status NOT IN(0,13,14));
END; ';


ALTER FUNCTION public.getvdsgroupwithrunningvms(v_vds_group_id uuid) OWNER TO postgres;

--
-- Name: getvdsstaticbyhostname(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvdsstaticbyhostname(v_host_name character varying) RETURNS SETOF vds_static
    LANGUAGE plpgsql
    AS '
BEGIN
RETURN QUERY SELECT vds_static.*
   FROM vds_static
   WHERE host_name = v_host_name;

   RETURN;
END; ';


ALTER FUNCTION public.getvdsstaticbyhostname(v_host_name character varying) OWNER TO postgres;

--
-- Name: getvdsstaticbyip(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvdsstaticbyip(v_ip character varying) RETURNS SETOF vds_static
    LANGUAGE plpgsql
    AS '
BEGIN
BEGIN
      RETURN QUERY SELECT vds_static.*
      FROM vds_static
      WHERE ip = v_ip;
   END;

   RETURN;
END; ';


ALTER FUNCTION public.getvdsstaticbyip(v_ip character varying) OWNER TO postgres;

--
-- Name: getvdsstaticbyvdsgroupid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvdsstaticbyvdsgroupid(v_vds_group_id uuid) RETURNS SETOF vds_static
    LANGUAGE plpgsql
    AS '
BEGIN
BEGIN
      RETURN QUERY SELECT vds_static.*
      FROM vds_static vds_static
      WHERE vds_group_id = v_vds_group_id;
   END;

   RETURN;
END; ';


ALTER FUNCTION public.getvdsstaticbyvdsgroupid(v_vds_group_id uuid) OWNER TO postgres;

--
-- Name: getvdsstaticbyvdsid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvdsstaticbyvdsid(v_vds_id uuid) RETURNS SETOF vds_static
    LANGUAGE plpgsql
    AS '
BEGIN
BEGIN
      RETURN QUERY SELECT vds_static.*
      FROM vds_static
      WHERE vds_id = v_vds_id;
   END;

   RETURN;
END; ';


ALTER FUNCTION public.getvdsstaticbyvdsid(v_vds_id uuid) OWNER TO postgres;

--
-- Name: getvdsstaticbyvdsname(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvdsstaticbyvdsname(v_vds_name character varying) RETURNS SETOF vds_static
    LANGUAGE plpgsql
    AS '
BEGIN
BEGIN
      RETURN QUERY SELECT vds_static.*
      FROM vds_static
      WHERE vds_name = v_vds_name;
   END;

   RETURN;
END; ';


ALTER FUNCTION public.getvdsstaticbyvdsname(v_vds_name character varying) OWNER TO postgres;

--
-- Name: getvdsstatisticsbyvdsid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvdsstatisticsbyvdsid(v_vds_id uuid) RETURNS SETOF vds_statistics
    LANGUAGE plpgsql
    AS '
BEGIN
BEGIN
      RETURN QUERY SELECT vds_statistics.*
      FROM vds_statistics
      WHERE vds_id = v_vds_id;
   END;

   RETURN;
END; ';


ALTER FUNCTION public.getvdsstatisticsbyvdsid(v_vds_id uuid) OWNER TO postgres;

--
-- Name: getvdstagsbytagids(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvdstagsbytagids(v_tag_ids character varying) RETURNS SETOF tags_vds_map_view
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT DISTINCT tags_vds_map_view.*
      FROM tags_vds_map_view
      WHERE tag_id in(select id from fnSplitterUuid(v_tag_ids));
END; ';


ALTER FUNCTION public.getvdstagsbytagids(v_tag_ids character varying) OWNER TO postgres;

--
-- Name: getvdswithoutmigratingvmsbyvdsgroupid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvdswithoutmigratingvmsbyvdsgroupid(v_vds_group_id uuid) RETURNS SETOF vds
    LANGUAGE plpgsql
    AS '
BEGIN

	
	-- this sp returns all vds in given cluster that have no pending vms and no vms in migration states
	BEGIN
      RETURN QUERY SELECT DISTINCT vds.*
      FROM vds
      WHERE vds_group_id = v_vds_group_id and
      pending_vcpus_count = 0
      and	vds.status = 3
      and	vds_id not in(select distinct RUN_ON_VDS from vm_dynamic
         where status in(5,6,11,12));
   END;

   RETURN;
END; ';


ALTER FUNCTION public.getvdswithoutmigratingvmsbyvdsgroupid(v_vds_group_id uuid) OWNER TO postgres;

--
-- Name: vm_interface_statistics; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm_interface_statistics (
    id uuid NOT NULL,
    vm_id uuid,
    rx_rate numeric(18,0),
    tx_rate numeric(18,0),
    rx_drop numeric(18,0),
    tx_drop numeric(18,0),
    iface_status integer
);


ALTER TABLE public.vm_interface_statistics OWNER TO postgres;

--
-- Name: getvm_interface_statisticsbyid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvm_interface_statisticsbyid(v_id uuid) RETURNS SETOF vm_interface_statistics
    LANGUAGE plpgsql
    AS '
BEGIN
RETURN QUERY SELECT *
   FROM vm_interface_statistics
   WHERE id = v_id;

END; ';


ALTER FUNCTION public.getvm_interface_statisticsbyid(v_id uuid) OWNER TO postgres;

--
-- Name: getvm_interfacebyid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvm_interfacebyid(v_id uuid) RETURNS SETOF vm_interface
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM vm_interface
   WHERE id = v_id;

END; ';


ALTER FUNCTION public.getvm_interfacebyid(v_id uuid) OWNER TO postgres;

--
-- Name: vm_interface_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW vm_interface_view AS
    SELECT vm_interface_statistics.rx_rate, vm_interface_statistics.tx_rate, vm_interface_statistics.rx_drop, vm_interface_statistics.tx_drop, vm_interface_statistics.iface_status, vm_interface.type, vm_interface.speed, vm_interface.mac_addr, vm_interface.network_name, vm_interface.name, vm_static.vm_guid, vm_interface.vmt_guid, vm_static.vm_name, vm_interface.id, 0 AS boot_protocol, 0 AS is_vds FROM ((vm_interface_statistics JOIN vm_interface ON ((vm_interface_statistics.id = vm_interface.id))) JOIN vm_static ON ((vm_interface.vm_guid = vm_static.vm_guid))) UNION SELECT vm_interface_statistics.rx_rate, vm_interface_statistics.tx_rate, vm_interface_statistics.rx_drop, vm_interface_statistics.tx_drop, vm_interface_statistics.iface_status, vm_interface.type, vm_interface.speed, vm_interface.mac_addr, vm_interface.network_name, vm_interface.name, NULL::uuid AS vm_guid, vm_interface.vmt_guid, vm_templates.vm_name, vm_interface.id, 0 AS boot_protocol, 0 AS is_vds FROM ((vm_interface_statistics RIGHT JOIN vm_interface ON ((vm_interface_statistics.id = vm_interface.id))) JOIN vm_static vm_templates ON ((vm_interface.vmt_guid = vm_templates.vm_guid)));


ALTER TABLE public.vm_interface_view OWNER TO postgres;

--
-- Name: getvm_interfacebytemplate_id(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvm_interfacebytemplate_id(v_template_id uuid) RETURNS SETOF vm_interface_view
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM vm_interface_view
   WHERE vmt_guid = v_template_id;

END; ';


ALTER FUNCTION public.getvm_interfacebytemplate_id(v_template_id uuid) OWNER TO postgres;

--
-- Name: getvm_interfacebyvm_guidandbyvmt_guid(uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvm_interfacebyvm_guidandbyvmt_guid(v_vm_guid uuid, v_vmt_guid uuid) RETURNS SETOF vm_interface
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT *
   FROM vm_interface
   WHERE VM_GUID = v_vm_guid AND VMT_GUID = v_vmt_guid;

END; ';


ALTER FUNCTION public.getvm_interfacebyvm_guidandbyvmt_guid(v_vm_guid uuid, v_vmt_guid uuid) OWNER TO postgres;

--
-- Name: getvm_interfacebyvm_id(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvm_interfacebyvm_id(v_vm_id uuid) RETURNS SETOF vm_interface_view
    LANGUAGE plpgsql
    AS '
BEGIN
RETURN QUERY SELECT *
   FROM vm_interface_view
   WHERE vm_guid = v_vm_id;

END; ';


ALTER FUNCTION public.getvm_interfacebyvm_id(v_vm_id uuid) OWNER TO postgres;

--
-- Name: getvm_pool_mapbyvm_guid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvm_pool_mapbyvm_guid(v_vm_guid uuid) RETURNS SETOF vm_pool_map
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT vm_pool_map.*
      FROM vm_pool_map
      WHERE vm_guid = v_vm_guid;
END; ';


ALTER FUNCTION public.getvm_pool_mapbyvm_guid(v_vm_guid uuid) OWNER TO postgres;

--
-- Name: getvm_pool_mapbyvm_pool_id(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvm_pool_mapbyvm_pool_id(v_vm_pool_id uuid) RETURNS SETOF vm_pool_map
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT vm_pool_map.*
      FROM vm_pool_map INNER JOIN vm_static
      ON vm_pool_map.vm_guid = vm_static.vm_guid
      WHERE vm_pool_id = v_vm_pool_id
      ORDER BY vm_static.VM_NAME;
END; ';


ALTER FUNCTION public.getvm_pool_mapbyvm_pool_id(v_vm_pool_id uuid) OWNER TO postgres;

--
-- Name: getvm_pools_by_time_leased_id(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvm_pools_by_time_leased_id(v_id uuid) RETURNS SETOF vm_pools_view
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT vm_pools_view.*
      FROM         time_lease_vm_pool_map INNER JOIN
      vm_pools_view ON
      time_lease_vm_pool_map.vm_pool_id = vm_pools_view.vm_pool_id
      WHERE     (time_lease_vm_pool_map.id = v_id);
END; ';


ALTER FUNCTION public.getvm_pools_by_time_leased_id(v_id uuid) OWNER TO postgres;

--
-- Name: getvm_poolsbyadgroup_id(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvm_poolsbyadgroup_id(v_ad_group_id uuid) RETURNS SETOF vm_pools_view
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT DISTINCT vm_pools_view.*
      FROM  ad_vm_pool_group_map INNER JOIN
      vm_pools_view ON ad_vm_pool_group_map.vm_pool_id = vm_pools_view.vm_pool_id
      WHERE(ad_vm_pool_group_map.group_id = v_ad_group_id);
END; ';


ALTER FUNCTION public.getvm_poolsbyadgroup_id(v_ad_group_id uuid) OWNER TO postgres;

--
-- Name: getvm_poolsbyadgroup_names(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvm_poolsbyadgroup_names(v_ad_group_names character varying) RETURNS SETOF vm_pools_view
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT DISTINCT vm_pools_view.*
      FROM         ad_groups INNER JOIN
      users_and_groups_to_vm_pool_map_view ON
      ad_groups.id = users_and_groups_to_vm_pool_map_view.user_id INNER JOIN
      vm_pools_view ON users_and_groups_to_vm_pool_map_view.vm_pool_id = vm_pools_view.vm_pool_id
      WHERE     (ad_groups.name in(select Id from fnSplitter(v_ad_group_names)));
END; ';


ALTER FUNCTION public.getvm_poolsbyadgroup_names(v_ad_group_names character varying) OWNER TO postgres;

--
-- Name: vm_pools_full_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW vm_pools_full_view AS
    SELECT vmp.vm_pool_id, vmp.vm_pool_name, vmp.vm_pool_description, vmp.vm_pool_type, vmp.parameters, vmp.vds_group_id, vmp.vds_group_name, (SELECT count(vm_pool_map.vm_pool_id) AS expr1 FROM (vm_pools_view v1 LEFT JOIN vm_pool_map ON (((v1.vm_pool_id = vm_pool_map.vm_pool_id) AND (v1.vm_pool_id = vmp.vm_pool_id))))) AS assigned_vm_count, (SELECT count(v2.vm_pool_id) AS expr1 FROM ((vm_pools v2 LEFT JOIN vm_pool_map vm_pool_map_1 ON (((v2.vm_pool_id = vm_pool_map_1.vm_pool_id) AND (v2.vm_pool_id = vmp.vm_pool_id)))) LEFT JOIN vm_dynamic ON ((vm_pool_map_1.vm_guid = vm_dynamic.vm_guid))) WHERE (vm_dynamic.status <> ALL (ARRAY[0, 15])) GROUP BY v2.vm_pool_id) AS vm_running_count FROM vm_pools_view vmp;


ALTER TABLE public.vm_pools_full_view OWNER TO postgres;

--
-- Name: getvm_poolsbyvm_pool_id(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvm_poolsbyvm_pool_id(v_vm_pool_id uuid) RETURNS SETOF vm_pools_full_view
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT vm_pools_full_view.*
      FROM vm_pools_full_view
      WHERE vm_pool_id = v_vm_pool_id;
END; ';


ALTER FUNCTION public.getvm_poolsbyvm_pool_id(v_vm_pool_id uuid) OWNER TO postgres;

--
-- Name: getvm_poolsbyvm_pool_name(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvm_poolsbyvm_pool_name(v_vm_pool_name character varying) RETURNS SETOF vm_pools_view
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT vm_pools_view.*
      FROM vm_pools_view
      WHERE vm_pool_name = v_vm_pool_name;
END; ';


ALTER FUNCTION public.getvm_poolsbyvm_pool_name(v_vm_pool_name character varying) OWNER TO postgres;

--
-- Name: getvmbyhibernationimageid(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvmbyhibernationimageid(v_image_id character varying) RETURNS SETOF vms
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT DISTINCT vms.*
      FROM vms
      WHERE hibernation_vol_handle like ''%'' || coalesce(v_image_id,'''') || ''%'';
END; ';


ALTER FUNCTION public.getvmbyhibernationimageid(v_image_id character varying) OWNER TO postgres;

--
-- Name: getvmbyimagegroupid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvmbyimagegroupid(v_image_group_id uuid) RETURNS SETOF vms
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT DISTINCT vms.*
      FROM vms
      inner join image_vm_map on vms.vm_guid = image_vm_map.vm_id
      inner join images on image_vm_map.image_id = images.image_guid
      and images.image_guid in(select image_guid
         from images where image_group_id = v_image_group_id);
END; ';


ALTER FUNCTION public.getvmbyimagegroupid(v_image_group_id uuid) OWNER TO postgres;

--
-- Name: getvmbyimageid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvmbyimageid(v_image_guid uuid) RETURNS SETOF vms
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT DISTINCT vms.*
      FROM vms
      inner join image_vm_map on vms.vm_guid = image_vm_map.vm_id
      WHERE image_vm_map.image_id = v_image_guid;
END; ';


ALTER FUNCTION public.getvmbyimageid(v_image_guid uuid) OWNER TO postgres;

--
-- Name: getvmbyvmguid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvmbyvmguid(v_vm_guid uuid) RETURNS SETOF vms
    LANGUAGE plpgsql
    AS '
BEGIN
RETURN QUERY SELECT DISTINCT vms.*
   FROM vms
   WHERE vm_guid = v_vm_guid;
END; ';


ALTER FUNCTION public.getvmbyvmguid(v_vm_guid uuid) OWNER TO postgres;

--
-- Name: getvmdynamicbyvmguid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvmdynamicbyvmguid(v_vm_guid uuid) RETURNS SETOF vm_dynamic
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT vm_dynamic.*
      FROM vm_dynamic
      WHERE vm_guid = v_vm_guid;
END; ';


ALTER FUNCTION public.getvmdynamicbyvmguid(v_vm_guid uuid) OWNER TO postgres;

--
-- Name: getvmimagebyimageguid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvmimagebyimageguid(v_image_guid uuid) RETURNS SETOF vm_images_view
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT *
      FROM vm_images_view
      WHERE image_guid = v_image_guid;
END; ';


ALTER FUNCTION public.getvmimagebyimageguid(v_image_guid uuid) OWNER TO postgres;

--
-- Name: getvmsbyadgroupnames(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvmsbyadgroupnames(v_ad_group_names character varying) RETURNS SETOF vms
    LANGUAGE plpgsql
    AS '
BEGIN
RETURN QUERY select distinct vms.* from vms
   inner join permissions on vms.vm_guid = permissions.object_id
   inner join ad_groups on ad_groups.id = permissions.ad_element_id
   WHERE     (ad_groups.name in(select Id from fnSplitter(v_ad_group_names))); 
END; ';


ALTER FUNCTION public.getvmsbyadgroupnames(v_ad_group_names character varying) OWNER TO postgres;

--
-- Name: getvmsbystoragedomainid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvmsbystoragedomainid(v_storage_domain_id uuid) RETURNS SETOF vms
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT DISTINCT vms.*
      FROM vms
      inner join image_vm_map on vms.vm_guid = image_vm_map.vm_id
      inner join images on image_vm_map.image_id = images.image_guid
      and images.image_guid in(select image_guid
         from images where storage_id = v_storage_domain_id);
END; ';


ALTER FUNCTION public.getvmsbystoragedomainid(v_storage_domain_id uuid) OWNER TO postgres;

--
-- Name: getvmsbyuserid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvmsbyuserid(v_user_id uuid) RETURNS SETOF vms
    LANGUAGE plpgsql
    AS '
BEGIN
RETURN QUERY select vms.* from vms
   inner join permissions on vms.vm_guid = permissions.object_id
   WHERE permissions.ad_element_id = v_user_id;
END; ';


ALTER FUNCTION public.getvmsbyuserid(v_user_id uuid) OWNER TO postgres;

--
-- Name: getvmsbyuseridwithgroupsanduserroles(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvmsbyuseridwithgroupsanduserroles(v_user_id uuid) RETURNS SETOF vms
    LANGUAGE plpgsql
    AS '
BEGIN
RETURN QUERY SELECT DISTINCT vms.*
   from vms
   inner join permissions_view as perms on vms.vm_guid = perms.object_id
   WHERE (perms.ad_element_id = v_user_id
   or perms.ad_element_id in(select id from getUserAndGroupsById(v_user_id)))
   and perms.role_type = 2;

END; ';


ALTER FUNCTION public.getvmsbyuseridwithgroupsanduserroles(v_user_id uuid) OWNER TO postgres;

--
-- Name: getvmsbyvmtguid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvmsbyvmtguid(v_vmt_guid uuid) RETURNS SETOF vms
    LANGUAGE plpgsql
    AS '
BEGIN
RETURN QUERY SELECT DISTINCT vms.*
   FROM vms
   WHERE vmt_guid = v_vmt_guid;
END; ';


ALTER FUNCTION public.getvmsbyvmtguid(v_vmt_guid uuid) OWNER TO postgres;

--
-- Name: getvmsdedicatedtopowerclientbyvdsid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvmsdedicatedtopowerclientbyvdsid(v_dedicated_vm_for_vds uuid) RETURNS SETOF vms
    LANGUAGE plpgsql
    AS '
BEGIN
RETURN QUERY SELECT DISTINCT vms.*
   FROM vms inner join
   vds_static on vms.dedicated_vm_for_vds = vds_static.vds_id
   WHERE vms.dedicated_vm_for_vds = v_dedicated_vm_for_vds
   and vds_static.vds_type = 1;
END; ';


ALTER FUNCTION public.getvmsdedicatedtopowerclientbyvdsid(v_dedicated_vm_for_vds uuid) OWNER TO postgres;

--
-- Name: getvmsdynamicrunningonvds(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvmsdynamicrunningonvds(v_vds_id uuid) RETURNS SETOF vm_dynamic
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT vm_dynamic.*
      FROM vm_dynamic
      WHERE RUN_ON_VDS = v_vds_id;
END; ';


ALTER FUNCTION public.getvmsdynamicrunningonvds(v_vds_id uuid) OWNER TO postgres;

--
-- Name: getvmsrunningonvds(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvmsrunningonvds(v_vds_id uuid) RETURNS SETOF vms
    LANGUAGE plpgsql
    AS '
BEGIN
RETURN QUERY SELECT DISTINCT vms.*
   FROM vms
   WHERE run_on_vds = v_vds_id;

END; ';


ALTER FUNCTION public.getvmsrunningonvds(v_vds_id uuid) OWNER TO postgres;

--
-- Name: getvmstaticbygroupidandnetwork(uuid, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvmstaticbygroupidandnetwork(v_groupid uuid, v_networkname character varying) RETURNS SETOF vm_static
    LANGUAGE plpgsql
    AS '
BEGIN
   RETURN QUERY SELECT
   vm_static.* from vm_static
   inner join vm_interface_view
   on vm_static.vm_guid = vm_interface_view.vm_guid
   and network_name = v_networkName
   and vm_static.vds_group_id = v_groupId;

    
END; ';


ALTER FUNCTION public.getvmstaticbygroupidandnetwork(v_groupid uuid, v_networkname character varying) OWNER TO postgres;

--
-- Name: getvmstaticbyname(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvmstaticbyname(v_vm_name character varying) RETURNS SETOF vm_static
    LANGUAGE plpgsql
    AS '
BEGIN
RETURN QUERY SELECT vm_static.*
   FROM vm_static
   WHERE VM_NAME = v_vm_name
   AND   entity_type = ''VM'';

END; ';


ALTER FUNCTION public.getvmstaticbyname(v_vm_name character varying) OWNER TO postgres;

--
-- Name: getvmstaticbyvdsgroup(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvmstaticbyvdsgroup(v_vds_group_id uuid) RETURNS SETOF vm_static
    LANGUAGE plpgsql
    AS '
BEGIN
RETURN QUERY SELECT vm_static.*
   FROM vm_static
   WHERE vds_group_id = v_vds_group_id
   AND   entity_type = ''VM'';

END; ';


ALTER FUNCTION public.getvmstaticbyvdsgroup(v_vds_group_id uuid) OWNER TO postgres;

--
-- Name: getvmstaticbyvmguid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvmstaticbyvmguid(v_vm_guid uuid) RETURNS SETOF vm_static
    LANGUAGE plpgsql
    AS '
BEGIN
RETURN QUERY SELECT vm_static.*
   FROM vm_static
   WHERE vm_guid = v_vm_guid
   AND   entity_type = ''VM'';

END; ';


ALTER FUNCTION public.getvmstaticbyvmguid(v_vm_guid uuid) OWNER TO postgres;

--
-- Name: getvmstaticwithfailbackbyvdsid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvmstaticwithfailbackbyvdsid(v_vds_id uuid) RETURNS SETOF vm_static
    LANGUAGE plpgsql
    AS '
BEGIN
RETURN QUERY SELECT vm_static.*
   FROM vm_static
   WHERE dedicated_vm_for_vds = v_vds_id and fail_back = TRUE
   AND   entity_type = ''VM'';

END; ';


ALTER FUNCTION public.getvmstaticwithfailbackbyvdsid(v_vds_id uuid) OWNER TO postgres;

--
-- Name: getvmstatisticsbyvmguid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvmstatisticsbyvmguid(v_vm_guid uuid) RETURNS SETOF vm_statistics
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT vm_statistics.*
      FROM vm_statistics
      WHERE vm_guid = v_vm_guid;
END; ';


ALTER FUNCTION public.getvmstatisticsbyvmguid(v_vm_guid uuid) OWNER TO postgres;

--
-- Name: getvmtagsbytagid(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvmtagsbytagid(v_tag_ids character varying) RETURNS SETOF tags_vm_map_view
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT DISTINCT tags_vm_map_view.*
      FROM tags_vm_map_view
      WHERE tag_id in(select id from fnSplitterUuid(v_tag_ids));
END; ';


ALTER FUNCTION public.getvmtagsbytagid(v_tag_ids character varying) OWNER TO postgres;

--
-- Name: getvmtemplatebyimageid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvmtemplatebyimageid(v_image_guid uuid) RETURNS SETOF vm_templates_view
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT vm_templates.*
      FROM vm_templates_view vm_templates
      inner join image_vm_map AS vm_template_image_map on vm_templates.vmt_guid = vm_template_image_map.vm_id
      WHERE vm_template_image_map.image_id = v_image_guid;
END; ';


ALTER FUNCTION public.getvmtemplatebyimageid(v_image_guid uuid) OWNER TO postgres;

--
-- Name: getvmtemplatebyvdsgroupid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvmtemplatebyvdsgroupid(v_vds_group_id uuid) RETURNS SETOF vm_templates_view
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT vm_templates.*
      FROM vm_templates_view vm_templates
      WHERE vds_group_id = v_vds_group_id;
END; ';


ALTER FUNCTION public.getvmtemplatebyvdsgroupid(v_vds_group_id uuid) OWNER TO postgres;

--
-- Name: getvmtemplatebyvmtguid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvmtemplatebyvmtguid(v_vmt_guid uuid) RETURNS SETOF vm_templates_view
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT vm_templates.*
      FROM vm_templates_view vm_templates
      WHERE vmt_guid = v_vmt_guid;
END; ';


ALTER FUNCTION public.getvmtemplatebyvmtguid(v_vmt_guid uuid) OWNER TO postgres;

--
-- Name: getvmtemplatediskbyvmtguidanditguid(uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvmtemplatediskbyvmtguidanditguid(v_vmt_guid uuid, v_it_guid uuid) RETURNS SETOF vm_template_disk
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT vm_template_disk.*
      FROM vm_template_disk
      WHERE vmt_guid = v_vmt_guid AND it_guid = v_it_guid;
END; ';


ALTER FUNCTION public.getvmtemplatediskbyvmtguidanditguid(v_vmt_guid uuid, v_it_guid uuid) OWNER TO postgres;

--
-- Name: getvmtemplatedisksbyimagetemplateguid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvmtemplatedisksbyimagetemplateguid(v_it_guid uuid) RETURNS SETOF vm_template_disk
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT vm_template_disk.*
      FROM vm_template_disk
      WHERE it_guid = v_it_guid;
END; ';


ALTER FUNCTION public.getvmtemplatedisksbyimagetemplateguid(v_it_guid uuid) OWNER TO postgres;

--
-- Name: getvmtemplatedisksbyvmtguid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvmtemplatedisksbyvmtguid(v_vmt_guid uuid) RETURNS SETOF vm_template_disk
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT vm_template_disk.*
      FROM vm_template_disk
      WHERE vmt_guid = v_vmt_guid;
END; ';


ALTER FUNCTION public.getvmtemplatedisksbyvmtguid(v_vmt_guid uuid) OWNER TO postgres;

--
-- Name: getvmtemplatesbystoragedomainid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION getvmtemplatesbystoragedomainid(v_storage_domain_id uuid) RETURNS SETOF vm_templates_view
    LANGUAGE plpgsql
    AS '
BEGIN
      RETURN QUERY SELECT DISTINCT vm_templates.*
      FROM vm_templates_view vm_templates
      inner join image_vm_map AS vm_template_image_map on vm_templates.vmt_guid = vm_template_image_map.vm_id
      where vm_template_image_map.image_id in(select image_guid from images where storage_id = v_storage_domain_id or image_group_id in(select image_group_id from image_group_storage_domain_map
            where image_group_storage_domain_map.storage_domain_id = v_storage_domain_id));
END; ';


ALTER FUNCTION public.getvmtemplatesbystoragedomainid(v_storage_domain_id uuid) OWNER TO postgres;

--
-- Name: insert_entity_snapshot(uuid, character varying, character varying, character varying, text, character varying, integer, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insert_entity_snapshot(v_command_id uuid, v_command_type character varying, v_entity_id character varying, v_entity_type character varying, v_entity_snapshot text, v_snapshot_class character varying, v_snapshot_type integer, v_insertion_order integer) RETURNS void
    LANGUAGE plpgsql
    AS '
declare v_id uuid;
BEGIN
	BEGIN 	 
		INSERT INTO business_entity_snapshot(id, command_id, command_type, entity_id,entity_type,entity_snapshot, snapshot_class, snapshot_type,insertion_order)
				VALUES(uuid_generate_v1(), v_command_id, v_command_type, v_entity_id,v_entity_type,v_entity_snapshot, v_snapshot_class, v_snapshot_type,v_insertion_order);
	END;
    
   RETURN;
END; ';


ALTER FUNCTION public.insert_entity_snapshot(v_command_id uuid, v_command_type character varying, v_entity_id character varying, v_entity_type character varying, v_entity_snapshot text, v_snapshot_class character varying, v_snapshot_type integer, v_insertion_order integer) OWNER TO postgres;

--
-- Name: insert_roles_groups(integer, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insert_roles_groups(v_action_group_id integer, v_role_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO roles_groups(action_group_id, role_id)
	VALUES(v_action_group_id, v_role_id);
END; ';


ALTER FUNCTION public.insert_roles_groups(v_action_group_id integer, v_role_id uuid) OWNER TO postgres;

--
-- Name: insertaction_version_map(integer, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertaction_version_map(v_action_type integer, v_cluster_minimal_version character varying, v_storage_pool_minimal_version character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO action_version_map(action_type, cluster_minimal_version, storage_pool_minimal_version)
	VALUES(v_action_type, v_cluster_minimal_version, v_storage_pool_minimal_version);
END; ';


ALTER FUNCTION public.insertaction_version_map(v_action_type integer, v_cluster_minimal_version character varying, v_storage_pool_minimal_version character varying) OWNER TO postgres;

--
-- Name: insertad_groups(uuid, character varying, integer, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertad_groups(v_id uuid, v_name character varying, v_status integer, v_domain character varying, v_distinguishedname character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO ad_groups(id, name,status,domain,distinguishedname)
	VALUES(v_id, v_name,v_status,v_domain,v_distinguishedname);
END; ';


ALTER FUNCTION public.insertad_groups(v_id uuid, v_name character varying, v_status integer, v_domain character varying, v_distinguishedname character varying) OWNER TO postgres;

--
-- Name: insertasync_tasks(integer, integer, integer, uuid, text, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertasync_tasks(v_action_type integer, v_result integer, v_status integer, v_task_id uuid, v_action_parameters text, v_action_params_class character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO async_tasks(action_type, result, status, task_id, action_parameters,action_params_class)
	VALUES(v_action_type, v_result, v_status, v_task_id, v_action_parameters,v_action_params_class);
END; ';


ALTER FUNCTION public.insertasync_tasks(v_action_type integer, v_result integer, v_status integer, v_task_id uuid, v_action_parameters text, v_action_params_class character varying) OWNER TO postgres;

--
-- Name: insertauditlog(integer, timestamp with time zone, integer, character varying, integer, character varying, uuid, character varying, uuid, character varying, uuid, character varying, uuid, character varying, uuid, character varying, uuid, character varying, uuid, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertauditlog(INOUT v_audit_log_id integer, v_log_time timestamp with time zone, v_log_type integer, v_log_type_name character varying, v_severity integer, v_message character varying, v_user_id uuid, v_user_name character varying, v_vds_id uuid, v_vds_name character varying, v_vm_id uuid, v_vm_name character varying, v_vm_template_id uuid, v_vm_template_name character varying, v_storage_pool_id uuid, v_storage_pool_name character varying, v_storage_domain_id uuid, v_storage_domain_name character varying, v_vds_group_id uuid, v_vds_group_name character varying) RETURNS integer
    LANGUAGE plpgsql
    AS '
   DECLARE
   v_min_alret_severity  INTEGER;
BEGIN
      v_min_alret_severity := 10;
	-- insert regular log messages (non alerts)
      if (v_severity < v_min_alret_severity) then
	 
INSERT INTO audit_log(LOG_TIME, log_type, log_type_name, severity,message, user_id, USER_NAME, vds_id, VDS_NAME, vm_id, VM_NAME,vm_template_id,VM_TEMPLATE_NAME,storage_pool_id,STORAGE_POOL_NAME,storage_domain_id,STORAGE_DOMAIN_NAME,vds_group_id,vds_group_name)
		VALUES(v_log_time, v_log_type, v_log_type_name, v_severity, v_message, v_user_id, v_user_name, v_vds_id, v_vds_name, v_vm_id, v_vm_name,v_vm_template_id,v_vm_template_name,v_storage_pool_id,v_storage_pool_name,v_storage_domain_id,v_storage_domain_name,v_vds_group_id,v_vds_group_name);
		
         v_audit_log_id := CURRVAL(''audit_log_seq'');
      else
         if (not exists(select audit_log_id from audit_log where vds_name = v_vds_name and log_type = v_log_type)) then
		 
INSERT INTO audit_log(LOG_TIME, log_type, log_type_name, severity,message, user_id, USER_NAME, vds_id, VDS_NAME, vm_id, VM_NAME,vm_template_id,VM_TEMPLATE_NAME,storage_pool_id,STORAGE_POOL_NAME,storage_domain_id,STORAGE_DOMAIN_NAME,vds_group_id,vds_group_name)
			VALUES(v_log_time, v_log_type, v_log_type_name, v_severity, v_message, v_user_id, v_user_name, v_vds_id, v_vds_name, v_vm_id, v_vm_name,v_vm_template_id,v_vm_template_name,v_storage_pool_id,v_storage_pool_name,v_storage_domain_id,v_storage_domain_name,v_vds_group_id,v_vds_group_name);
			
            v_audit_log_id := CURRVAL(''audit_log_seq'');
         else
            select   audit_log_id INTO v_audit_log_id from audit_log where vds_name = v_vds_name and log_type = v_log_type;
         end if;
      end if;
END; ';


ALTER FUNCTION public.insertauditlog(INOUT v_audit_log_id integer, v_log_time timestamp with time zone, v_log_type integer, v_log_type_name character varying, v_severity integer, v_message character varying, v_user_id uuid, v_user_name character varying, v_vds_id uuid, v_vds_name character varying, v_vm_id uuid, v_vm_name character varying, v_vm_template_id uuid, v_vm_template_name character varying, v_storage_pool_id uuid, v_storage_pool_name character varying, v_storage_domain_id uuid, v_storage_domain_name character varying, v_vds_group_id uuid, v_vds_group_name character varying) OWNER TO postgres;

--
-- Name: insertbookmark(character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertbookmark(v_bookmark_name character varying, v_bookmark_value character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO bookmarks(bookmark_Id,bookmark_name, bookmark_value)
	VALUES(uuid_generate_v1(),v_bookmark_name, v_bookmark_value);
END; ';


ALTER FUNCTION public.insertbookmark(v_bookmark_name character varying, v_bookmark_value character varying) OWNER TO postgres;

--
-- Name: insertcustom_actions(integer, character varying, character varying, integer, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertcustom_actions(INOUT v_action_id integer, v_action_name character varying, v_path character varying, v_tab integer, v_description character varying) RETURNS integer
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO custom_actions(action_name, path, tab, description)
	VALUES(v_action_name, v_path, v_tab, v_description);
    
      v_action_id := CURRVAL(''custom_actions_seq'');
END; ';


ALTER FUNCTION public.insertcustom_actions(INOUT v_action_id integer, v_action_name character varying, v_path character varying, v_tab integer, v_description character varying) OWNER TO postgres;

--
-- Name: insertdisk(uuid, character varying, integer, uuid, character varying, character varying, boolean, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertdisk(v_disk_id uuid, v_status character varying, v_internal_drive_mapping integer, v_active_image_id uuid, v_disk_type character varying, v_disk_interface character varying, v_wipe_after_delete boolean, v_propagate_errors character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
    INSERT INTO disks(
        disk_id,
        status,
        internal_drive_mapping,
        active_image_id,
        disk_type,
        disk_interface,
        wipe_after_delete,
        propagate_errors)
    VALUES(
        v_disk_id,
        v_status,
        v_internal_drive_mapping,
        v_active_image_id,
        v_disk_type,
        v_disk_interface,
        v_wipe_after_delete,
        v_propagate_errors);
END; ';


ALTER FUNCTION public.insertdisk(v_disk_id uuid, v_status character varying, v_internal_drive_mapping integer, v_active_image_id uuid, v_disk_type character varying, v_disk_interface character varying, v_wipe_after_delete boolean, v_propagate_errors character varying) OWNER TO postgres;

--
-- Name: insertdisk_image_dynamic(uuid, integer, integer, bigint, numeric, numeric, numeric); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertdisk_image_dynamic(v_image_id uuid, v_read_rate integer, v_write_rate integer, v_actual_size bigint, v_read_latency_seconds numeric, v_write_latency_seconds numeric, v_flush_latency_seconds numeric) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO disk_image_dynamic(image_id, read_rate, write_rate, actual_size, read_latency_seconds, write_latency_seconds, flush_latency_seconds)
	VALUES(v_image_id, v_read_rate, v_write_rate, v_actual_size, v_read_latency_seconds, v_write_latency_seconds, v_flush_latency_seconds);
END; ';


ALTER FUNCTION public.insertdisk_image_dynamic(v_image_id uuid, v_read_rate integer, v_write_rate integer, v_actual_size bigint, v_read_latency_seconds numeric, v_write_latency_seconds numeric, v_flush_latency_seconds numeric) OWNER TO postgres;

--
-- Name: insertevent_notification_hist(bigint, character varying, character, character, timestamp with time zone, boolean, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertevent_notification_hist(v_audit_log_id bigint, v_event_name character varying, v_method_type character, v_reason character, v_sent_at timestamp with time zone, v_status boolean, v_subscriber_id character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO event_notification_hist(audit_log_id, event_name, method_type, reason, sent_at, status, subscriber_id)
	VALUES(v_audit_log_id, v_event_name, v_method_type, v_reason, v_sent_at, v_status, v_subscriber_id::uuid);
END; ';


ALTER FUNCTION public.insertevent_notification_hist(v_audit_log_id bigint, v_event_name character varying, v_method_type character, v_reason character, v_sent_at timestamp with time zone, v_status boolean, v_subscriber_id character varying) OWNER TO postgres;

--
-- Name: insertevent_subscriber(character varying, integer, character varying, uuid, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertevent_subscriber(v_event_up_name character varying, v_method_id integer, v_method_address character varying, v_subscriber_id uuid, v_tag_name character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      if not exists(select * from  event_subscriber where
      subscriber_id = v_subscriber_id and
      event_up_name = v_event_up_name and
      method_id = v_method_id and
      tag_name = v_tag_name) then
		 
INSERT INTO event_subscriber(event_up_name, method_id, method_address, subscriber_id, tag_name)
			VALUES(v_event_up_name, v_method_id, v_method_address, v_subscriber_id,v_tag_name);
      end if;
END; ';


ALTER FUNCTION public.insertevent_subscriber(v_event_up_name character varying, v_method_id integer, v_method_address character varying, v_subscriber_id uuid, v_tag_name character varying) OWNER TO postgres;

--
-- Name: insertimage(timestamp with time zone, character varying, uuid, character varying, uuid, bigint, uuid, integer, timestamp with time zone, character varying, uuid, uuid, integer, integer, integer, uuid, integer, boolean, boolean, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertimage(v_creation_date timestamp with time zone, v_description character varying, v_image_guid uuid, v_internal_drive_mapping character varying, v_it_guid uuid, v_size bigint, v_parentid uuid, v_imagestatus integer, v_lastmodified timestamp with time zone, v_app_list character varying, v_storage_id uuid, v_vm_snapshot_id uuid, v_volume_type integer, v_volume_format integer, v_disk_type integer, v_image_group_id uuid, v_disk_interface integer, v_boot boolean, v_wipe_after_delete boolean, v_propagate_errors integer) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO images(creation_date, description, image_guid, internal_drive_mapping, it_guid, size, ParentId,imageStatus,lastModified, app_list,
    storage_id, vm_snapshot_id, volume_type, image_group_id, volume_format, disk_type, disk_interface, boot, wipe_after_delete, propagate_errors)
	VALUES(v_creation_date, v_description, v_image_guid, v_internal_drive_mapping, v_it_guid, v_size, v_ParentId, v_imageStatus, v_lastModified,v_app_list,
	v_storage_id, v_vm_snapshot_id, v_volume_type, v_image_group_id, v_volume_format, v_disk_type, v_disk_interface, v_boot, v_wipe_after_delete, v_propagate_errors);

-- TODO: Delete this once the disks table is updated directly from code.
IF NOT EXISTS (SELECT * FROM disks WHERE disk_id = v_image_group_id) THEN
    EXECUTE InsertDisk(
        v_image_group_id,
        CASE WHEN v_imageStatus = 1 THEN ''OK''
             WHEN v_imageStatus = 2 THEN ''LOCKED''
             WHEN v_imageStatus = 3 THEN ''INVALID''
             WHEN v_imageStatus = 4 THEN ''ILLEGAL''
             ELSE ''Unassigned''
        END,
        CAST (v_internal_drive_mapping AS INTEGER),
                       v_image_guid,
        CASE WHEN v_disk_type = 1 THEN ''System''
             WHEN v_disk_type = 2 THEN ''Data''
             WHEN v_disk_type = 3 THEN ''Shared''
             WHEN v_disk_type = 4 THEN ''Swap''
             WHEN v_disk_type = 5 THEN ''Temp''
             ELSE ''Unassigned''
        END,
        CASE WHEN v_disk_interface = 1 THEN ''SCSI''
             WHEN v_disk_interface = 2 THEN ''VirtIO''
             ELSE ''IDE''
        END,
        v_wipe_after_delete,
        CASE WHEN v_propagate_errors = 1 THEN ''On''
             ELSE ''Off''
        END);
END IF;

END; ';


ALTER FUNCTION public.insertimage(v_creation_date timestamp with time zone, v_description character varying, v_image_guid uuid, v_internal_drive_mapping character varying, v_it_guid uuid, v_size bigint, v_parentid uuid, v_imagestatus integer, v_lastmodified timestamp with time zone, v_app_list character varying, v_storage_id uuid, v_vm_snapshot_id uuid, v_volume_type integer, v_volume_format integer, v_disk_type integer, v_image_group_id uuid, v_disk_interface integer, v_boot boolean, v_wipe_after_delete boolean, v_propagate_errors integer) OWNER TO postgres;

--
-- Name: insertimage_group_storage_domain_map(uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertimage_group_storage_domain_map(v_image_group_id uuid, v_storage_domain_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO image_group_storage_domain_map(image_group_id, storage_domain_id)
	VALUES(v_image_group_id, v_storage_domain_id);
END; ';


ALTER FUNCTION public.insertimage_group_storage_domain_map(v_image_group_id uuid, v_storage_domain_id uuid) OWNER TO postgres;

--
-- Name: insertimage_vm_map(boolean, uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertimage_vm_map(v_active boolean, v_image_id uuid, v_vm_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO image_vm_map(active, image_id, vm_id)
	VALUES(v_active, v_image_id, v_vm_id);
-- TODO: Delete this once the disks table is updated directly from code.
IF (v_active) THEN
   PERFORM UpdateActiveImageIdInDisk(v_image_id);
END IF;
END; ';


ALTER FUNCTION public.insertimage_vm_map(v_active boolean, v_image_id uuid, v_vm_id uuid) OWNER TO postgres;

--
-- Name: insertimage_vm_pool_map(uuid, character varying, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertimage_vm_pool_map(v_image_guid uuid, v_internal_drive_mapping character varying, v_vm_guid uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO image_vm_pool_map(image_guid, internal_drive_mapping, vm_guid)
	VALUES(v_image_guid, v_internal_drive_mapping, v_vm_guid);
END; ';


ALTER FUNCTION public.insertimage_vm_pool_map(v_image_guid uuid, v_internal_drive_mapping character varying, v_vm_guid uuid) OWNER TO postgres;

--
-- Name: insertlun_storage_server_connection_map(character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertlun_storage_server_connection_map(v_lun_id character varying, v_storage_server_connection character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO LUN_storage_server_connection_map(LUN_id, storage_server_connection)
	VALUES(v_LUN_id, v_storage_server_connection);
END; ';


ALTER FUNCTION public.insertlun_storage_server_connection_map(v_lun_id character varying, v_storage_server_connection character varying) OWNER TO postgres;

--
-- Name: insertluns(character varying, character varying, character varying, character varying, integer, character varying, character varying, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertluns(v_lun_id character varying, v_phisical_volume_id character varying, v_volume_group_id character varying, v_serial character varying, v_lun_mapping integer, v_vendor_id character varying, v_product_id character varying, v_device_size integer) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO LUNs(LUN_id, phisical_volume_id, volume_group_id, serial, lun_mapping, vendor_id, product_id, device_size)
	VALUES(v_LUN_id, v_phisical_volume_id, v_volume_group_id, v_serial, v_lun_mapping, v_vendor_id, v_product_id, v_device_size);
END; ';


ALTER FUNCTION public.insertluns(v_lun_id character varying, v_phisical_volume_id character varying, v_volume_group_id character varying, v_serial character varying, v_lun_mapping integer, v_vendor_id character varying, v_product_id character varying, v_device_size integer) OWNER TO postgres;

--
-- Name: insertnetwork(character varying, character varying, uuid, character varying, character varying, character varying, integer, integer, boolean, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertnetwork(v_addr character varying, v_description character varying, v_id uuid, v_name character varying, v_subnet character varying, v_gateway character varying, v_type integer, v_vlan_id integer, v_stp boolean, v_storage_pool_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO network(addr, description, id, name, subnet, gateway, type, vlan_id, stp, storage_pool_id)
	VALUES(v_addr, v_description, v_id, v_name, v_subnet, v_gateway, v_type, v_vlan_id, v_stp, v_storage_pool_id);
END; ';


ALTER FUNCTION public.insertnetwork(v_addr character varying, v_description character varying, v_id uuid, v_name character varying, v_subnet character varying, v_gateway character varying, v_type integer, v_vlan_id integer, v_stp boolean, v_storage_pool_id uuid) OWNER TO postgres;

--
-- Name: insertnetwork_cluster(uuid, uuid, integer, boolean); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertnetwork_cluster(v_cluster_id uuid, v_network_id uuid, v_status integer, v_is_display boolean) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO network_cluster(cluster_id, network_id, status, is_display)
	VALUES(v_cluster_id, v_network_id, v_status, v_is_display);
END; ';


ALTER FUNCTION public.insertnetwork_cluster(v_cluster_id uuid, v_network_id uuid, v_status integer, v_is_display boolean) OWNER TO postgres;

--
-- Name: insertpermission(uuid, uuid, uuid, uuid, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertpermission(v_ad_element_id uuid, v_id uuid, v_role_id uuid, v_object_id uuid, v_object_type_id integer) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO permissions(ad_element_id, id, role_id, object_id, object_type_id)
	VALUES(v_ad_element_id, v_id, v_role_id, v_object_id, v_object_type_id);
END; ';


ALTER FUNCTION public.insertpermission(v_ad_element_id uuid, v_id uuid, v_role_id uuid, v_object_id uuid, v_object_type_id integer) OWNER TO postgres;

--
-- Name: insertrepo_domain_file_meta_data(uuid, character varying, bigint, timestamp with time zone, bigint, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertrepo_domain_file_meta_data(v_repo_domain_id uuid, v_repo_file_name character varying, v_size bigint, v_date_created timestamp with time zone, v_last_refreshed bigint, v_file_type integer) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN

INSERT INTO repo_file_meta_data(repo_domain_id, repo_file_name, size, date_created, last_refreshed, file_type)
    VALUES(v_repo_domain_id, v_repo_file_name, v_size, v_date_created, v_last_refreshed, v_file_type);

END; ';


ALTER FUNCTION public.insertrepo_domain_file_meta_data(v_repo_domain_id uuid, v_repo_file_name character varying, v_size bigint, v_date_created timestamp with time zone, v_last_refreshed bigint, v_file_type integer) OWNER TO postgres;

--
-- Name: insertrole(character varying, uuid, character varying, boolean, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertrole(v_description character varying, v_id uuid, v_name character varying, v_is_readonly boolean, v_role_type integer) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO roles(description, id, name, is_readonly, role_type)
	VALUES(v_description, v_id, v_name, v_is_readonly, v_role_type);
END; ';


ALTER FUNCTION public.insertrole(v_description character varying, v_id uuid, v_name character varying, v_is_readonly boolean, v_role_type integer) OWNER TO postgres;

--
-- Name: insertroles_relations(uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertroles_relations(v_role_container_id uuid, v_role_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO roles_relations(role_container_id, role_id)
	VALUES(v_role_container_id, v_role_id);
END; ';


ALTER FUNCTION public.insertroles_relations(v_role_container_id uuid, v_role_id uuid) OWNER TO postgres;

--
-- Name: insertstateless_vm_image_map(uuid, character varying, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertstateless_vm_image_map(v_image_guid uuid, v_internal_drive_mapping character varying, v_vm_guid uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO stateless_vm_image_map(image_guid, internal_drive_mapping, vm_guid)
	VALUES(v_image_guid, v_internal_drive_mapping, v_vm_guid);
END; ';


ALTER FUNCTION public.insertstateless_vm_image_map(v_image_guid uuid, v_internal_drive_mapping character varying, v_vm_guid uuid) OWNER TO postgres;

--
-- Name: insertstorage_domain_dynamic(integer, uuid, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertstorage_domain_dynamic(v_available_disk_size integer, v_id uuid, v_used_disk_size integer) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO storage_domain_dynamic(available_disk_size, id, used_disk_size)
	VALUES(v_available_disk_size, v_id, v_used_disk_size);
END; ';


ALTER FUNCTION public.insertstorage_domain_dynamic(v_available_disk_size integer, v_id uuid, v_used_disk_size integer) OWNER TO postgres;

--
-- Name: insertstorage_domain_static(uuid, character varying, character varying, integer, integer, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertstorage_domain_static(v_id uuid, v_storage character varying, v_storage_name character varying, v_storage_type integer, v_storage_domain_type integer, v_storage_domain_format_type character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
   BEGIN
INSERT INTO storage_domain_static(id, storage,storage_name, storage_type, storage_domain_type, storage_domain_format_type)
	VALUES(v_id, v_storage, v_storage_name, v_storage_type, v_storage_domain_type, v_storage_domain_format_type);
END; ';


ALTER FUNCTION public.insertstorage_domain_static(v_id uuid, v_storage character varying, v_storage_name character varying, v_storage_type integer, v_storage_domain_type integer, v_storage_domain_format_type character varying) OWNER TO postgres;

--
-- Name: insertstorage_pool(character varying, uuid, character varying, integer, integer, integer, uuid, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertstorage_pool(v_description character varying, v_id uuid, v_name character varying, v_storage_pool_type integer, v_status integer, v_master_domain_version integer, v_spm_vds_id uuid, v_compatibility_version character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO storage_pool(description, id, name, storage_pool_type,status,master_domain_version,spm_vds_id,compatibility_version)
	VALUES(v_description, v_id, v_name, v_storage_pool_type,v_status,v_master_domain_version,v_spm_vds_id,v_compatibility_version);
END; ';


ALTER FUNCTION public.insertstorage_pool(v_description character varying, v_id uuid, v_name character varying, v_storage_pool_type integer, v_status integer, v_master_domain_version integer, v_spm_vds_id uuid, v_compatibility_version character varying) OWNER TO postgres;

--
-- Name: insertstorage_pool_iso_map(uuid, uuid, integer, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertstorage_pool_iso_map(v_storage_id uuid, v_storage_pool_id uuid, v_status integer, v_owner integer) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO storage_pool_iso_map(storage_id, storage_pool_id, status, owner)
	VALUES(v_storage_id, v_storage_pool_id, v_status, v_owner);
END; ';


ALTER FUNCTION public.insertstorage_pool_iso_map(v_storage_id uuid, v_storage_pool_id uuid, v_status integer, v_owner integer) OWNER TO postgres;

--
-- Name: insertstorage_server_connections(character varying, character varying, character varying, character varying, character varying, character varying, integer, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertstorage_server_connections(v_connection character varying, v_id character varying, v_iqn character varying, v_port character varying, v_portal character varying, v_password character varying, v_storage_type integer, v_user_name character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO storage_server_connections(connection, id, iqn, port,portal,
	password, storage_type, user_name)
	VALUES(v_connection, v_id, v_iqn,v_port,v_portal, v_password, v_storage_type, v_user_name);
END; ';


ALTER FUNCTION public.insertstorage_server_connections(v_connection character varying, v_id character varying, v_iqn character varying, v_port character varying, v_portal character varying, v_password character varying, v_storage_type integer, v_user_name character varying) OWNER TO postgres;

--
-- Name: inserttags(character varying, uuid, character varying, uuid, boolean, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION inserttags(v_description character varying, INOUT v_tag_id uuid, v_tag_name character varying, v_parent_id uuid, v_readonly boolean, v_type integer) RETURNS uuid
    LANGUAGE plpgsql
    AS '
BEGIN
      v_tag_id := uuid_generate_v1();
      INSERT INTO tags(tag_id,description, tag_name,parent_id,readonly,type)
	VALUES(v_tag_id,v_description, v_tag_name,v_parent_id,v_readonly,v_type);
END; ';


ALTER FUNCTION public.inserttags(v_description character varying, INOUT v_tag_id uuid, v_tag_name character varying, v_parent_id uuid, v_readonly boolean, v_type integer) OWNER TO postgres;

--
-- Name: inserttags_user_group_map(uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION inserttags_user_group_map(v_group_id uuid, v_tag_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO tags_user_group_map(group_id, tag_id)
	VALUES(v_group_id, v_tag_id);
END; ';


ALTER FUNCTION public.inserttags_user_group_map(v_group_id uuid, v_tag_id uuid) OWNER TO postgres;

--
-- Name: inserttags_user_map(uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION inserttags_user_map(v_tag_id uuid, v_user_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO tags_user_map(tag_id, user_id)
	VALUES(v_tag_id, v_user_id);
END; ';


ALTER FUNCTION public.inserttags_user_map(v_tag_id uuid, v_user_id uuid) OWNER TO postgres;

--
-- Name: inserttags_vds_map(uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION inserttags_vds_map(v_tag_id uuid, v_vds_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO tags_vds_map(tag_id, vds_id)
	VALUES(v_tag_id, v_vds_id);
END; ';


ALTER FUNCTION public.inserttags_vds_map(v_tag_id uuid, v_vds_id uuid) OWNER TO postgres;

--
-- Name: inserttags_vm_map(uuid, uuid, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION inserttags_vm_map(v_tag_id uuid, v_vm_id uuid, v_defaultdisplaytype integer) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO tags_vm_map(tag_id, vm_id, DefaultDisplayType)
	VALUES(v_tag_id, v_vm_id, v_DefaultDisplayType);
END; ';


ALTER FUNCTION public.inserttags_vm_map(v_tag_id uuid, v_vm_id uuid, v_defaultdisplaytype integer) OWNER TO postgres;

--
-- Name: inserttags_vm_pool_map(uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION inserttags_vm_pool_map(v_tag_id uuid, v_vm_pool_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO tags_vm_pool_map(tag_id, vm_pool_id)
	VALUES(v_tag_id, v_vm_pool_id);
END; ';


ALTER FUNCTION public.inserttags_vm_pool_map(v_tag_id uuid, v_vm_pool_id uuid) OWNER TO postgres;

--
-- Name: inserttime_lease_vm_pool_map(timestamp with time zone, uuid, timestamp with time zone, integer, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION inserttime_lease_vm_pool_map(v_end_time timestamp with time zone, v_id uuid, v_start_time timestamp with time zone, v_type integer, v_vm_pool_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO time_lease_vm_pool_map(end_time, id, start_time, type, vm_pool_id)
	VALUES(v_end_time, v_id, v_start_time, v_type, v_vm_pool_id);
END; ';


ALTER FUNCTION public.inserttime_lease_vm_pool_map(v_end_time timestamp with time zone, v_id uuid, v_start_time timestamp with time zone, v_type integer, v_vm_pool_id uuid) OWNER TO postgres;

--
-- Name: insertuser(character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, integer, character varying, character varying, uuid, integer, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertuser(v_department character varying, v_desktop_device character varying, v_domain character varying, v_email character varying, v_groups character varying, v_name character varying, v_note character varying, v_role character varying, v_status integer, v_surname character varying, v_user_icon_path character varying, v_user_id uuid, v_session_count integer, v_username character varying, v_group_ids character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO users(department, desktop_device, domain, email, groups, name, note, role, status, surname, user_icon_path, user_id, session_count, username, group_ids)
	VALUES(v_department, v_desktop_device, v_domain, v_email, v_groups, v_name, v_note, v_role, v_status, v_surname, v_user_icon_path, v_user_id, v_session_count, v_username, v_group_ids);
END; ';


ALTER FUNCTION public.insertuser(v_department character varying, v_desktop_device character varying, v_domain character varying, v_email character varying, v_groups character varying, v_name character varying, v_note character varying, v_role character varying, v_status integer, v_surname character varying, v_user_icon_path character varying, v_user_id uuid, v_session_count integer, v_username character varying, v_group_ids character varying) OWNER TO postgres;

--
-- Name: insertuser_sessions(character, character, timestamp with time zone, character, character, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertuser_sessions(v_browser character, v_client_type character, v_login_time timestamp with time zone, v_os character, v_session_id character, v_user_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      if (not exists(select session_id from user_sessions
      where session_id = v_session_id and user_id = v_user_id)) then
		 
INSERT INTO user_sessions(browser, client_type, login_time, os, session_id, user_id)
				VALUES(v_browser, v_client_type, v_login_time, v_os, v_session_id, v_user_id);
				
         UPDATE users
         SET session_count = session_count+1
         WHERE
         user_id = v_user_id;
      end if;
END; ';


ALTER FUNCTION public.insertuser_sessions(v_browser character, v_client_type character, v_login_time timestamp with time zone, v_os character, v_session_id character, v_user_id uuid) OWNER TO postgres;

--
-- Name: insertvdcoption(character varying, character varying, character varying, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertvdcoption(v_option_name character varying, v_option_value character varying, v_version character varying, INOUT v_option_id integer) RETURNS integer
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO vdc_options(OPTION_NAME, option_value, version)
	VALUES(v_option_name, v_option_value, v_version);
    
      v_option_id := CURRVAL(''vdc_options_seq'');
END; ';


ALTER FUNCTION public.insertvdcoption(v_option_name character varying, v_option_value character varying, v_version character varying, INOUT v_option_id integer) OWNER TO postgres;

--
-- Name: insertvds(character varying, character varying, character varying, integer, uuid, uuid, character varying, boolean, integer, integer, character varying, character varying, character varying, integer, character varying, boolean, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertvds(v_host_name character varying, v_ip character varying, v_vds_unique_id character varying, v_port integer, v_vds_group_id uuid, INOUT v_vds_id uuid, v_vds_name character varying, v_server_ssl_enabled boolean, v_vds_type integer, v_vds_strength integer, v_pm_type character varying, v_pm_user character varying, v_pm_password character varying, v_pm_port integer, v_pm_options character varying, v_pm_enabled boolean, v_vds_spm_priority integer) RETURNS uuid
    LANGUAGE plpgsql
    AS '
BEGIN
	
   BEGIN
      v_vds_id := uuid_generate_v1();
      INSERT INTO vds_static(vds_id,host_name, ip, vds_unique_id, port, vds_group_id, vds_name, server_SSL_enabled,vds_type,vds_strength,pm_type,pm_user,pm_password, pm_port, pm_options, pm_enabled, vds_spm_priority)
	VALUES(v_vds_id,v_host_name, v_ip, v_vds_unique_id, v_port, v_vds_group_id, v_vds_name, v_server_SSL_enabled,v_vds_type, v_vds_strength,v_pm_type,v_pm_user,v_pm_password,v_pm_port, v_pm_options, v_pm_enabled, v_vds_spm_priority);
    
      INSERT INTO vds_dynamic(vds_id, status) VALUES(v_vds_id, 0);
    
      INSERT INTO vds_statistics(vds_id) VALUES(v_vds_id);
   END;
    
   RETURN;
END; ';


ALTER FUNCTION public.insertvds(v_host_name character varying, v_ip character varying, v_vds_unique_id character varying, v_port integer, v_vds_group_id uuid, INOUT v_vds_id uuid, v_vds_name character varying, v_server_ssl_enabled boolean, v_vds_type integer, v_vds_strength integer, v_pm_type character varying, v_pm_user character varying, v_pm_password character varying, v_pm_port integer, v_pm_options character varying, v_pm_enabled boolean, v_vds_spm_priority integer) OWNER TO postgres;

--
-- Name: insertvds_interface(character varying, character varying, integer, character varying, uuid, boolean, character varying, character varying, character varying, character varying, integer, character varying, integer, integer, uuid, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertvds_interface(v_addr character varying, v_bond_name character varying, v_bond_type integer, v_gateway character varying, v_id uuid, v_is_bond boolean, v_bond_opts character varying, v_mac_addr character varying, v_name character varying, v_network_name character varying, v_speed integer, v_subnet character varying, v_boot_protocol integer, v_type integer, v_vds_id uuid, v_vlan_id integer) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO vds_interface(addr, bond_name, bond_type, gateway, id, is_bond, bond_opts, mac_addr, name, network_name, speed, subnet, boot_protocol, type, VDS_ID, vlan_id)
	VALUES(v_addr, v_bond_name, v_bond_type, v_gateway, v_id, v_is_bond, v_bond_opts, v_mac_addr, v_name, v_network_name, v_speed, v_subnet, v_boot_protocol, v_type, v_vds_id, v_vlan_id);
END; ';


ALTER FUNCTION public.insertvds_interface(v_addr character varying, v_bond_name character varying, v_bond_type integer, v_gateway character varying, v_id uuid, v_is_bond boolean, v_bond_opts character varying, v_mac_addr character varying, v_name character varying, v_network_name character varying, v_speed integer, v_subnet character varying, v_boot_protocol integer, v_type integer, v_vds_id uuid, v_vlan_id integer) OWNER TO postgres;

--
-- Name: insertvds_interface_statistics(uuid, numeric, numeric, numeric, numeric, integer, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertvds_interface_statistics(v_id uuid, v_rx_drop numeric, v_rx_rate numeric, v_tx_drop numeric, v_tx_rate numeric, v_iface_status integer, v_vds_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO vds_interface_statistics(id, rx_drop, rx_rate, tx_drop, tx_rate, vds_id, iface_status)
	VALUES(v_id, v_rx_drop, v_rx_rate, v_tx_drop, v_tx_rate, v_vds_id,v_iface_status);
END; ';


ALTER FUNCTION public.insertvds_interface_statistics(v_id uuid, v_rx_drop numeric, v_rx_rate numeric, v_tx_drop numeric, v_tx_rate numeric, v_iface_status integer, v_vds_id uuid) OWNER TO postgres;

--
-- Name: insertvds_spm_id_map(uuid, uuid, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertvds_spm_id_map(v_storage_pool_id uuid, v_vds_id uuid, v_vds_spm_id integer) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO vds_spm_id_map(storage_pool_id, vds_id, vds_spm_id)
	VALUES(v_storage_pool_id, v_vds_id, v_vds_spm_id);
END; ';


ALTER FUNCTION public.insertvds_spm_id_map(v_storage_pool_id uuid, v_vds_id uuid, v_vds_spm_id integer) OWNER TO postgres;

--
-- Name: insertvdsdynamic(integer, character varying, numeric, character varying, boolean, integer, integer, integer, uuid, integer, integer, integer, integer, integer, integer, character varying, character varying, character varying, integer, character varying, timestamp with time zone, integer, integer, integer, integer, boolean, character varying, character varying, character varying, character varying, character varying, character varying, character varying, integer, integer, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertvdsdynamic(v_cpu_cores integer, v_cpu_model character varying, v_cpu_speed_mh numeric, v_if_total_speed character varying, v_kvm_enabled boolean, v_mem_commited integer, v_physical_mem_mb integer, v_status integer, v_vds_id uuid, v_vm_active integer, v_vm_count integer, v_vms_cores_count integer, v_vm_migrating integer, v_reserved_mem integer, v_guest_overhead integer, v_software_version character varying, v_version_name character varying, v_build_name character varying, v_previous_status integer, v_cpu_flags character varying, v_cpu_over_commit_time_stamp timestamp with time zone, v_hypervisor_type integer, v_pending_vcpus_count integer, v_pending_vmem_size integer, v_cpu_sockets integer, v_net_config_dirty boolean, v_supported_cluster_levels character varying, v_supported_engines character varying, v_host_os character varying, v_kvm_version character varying, v_spice_version character varying, v_kernel_version character varying, v_iscsi_initiator_name character varying, v_transparent_hugepages_state integer, v_anonymous_hugepages integer, v_hooks character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
	
   BEGIN
INSERT INTO vds_dynamic(cpu_cores, cpu_model, cpu_speed_mh, if_total_speed, kvm_enabled, mem_commited, physical_mem_mb,	status, vds_id, vm_active, vm_count, vm_migrating, reserved_mem, guest_overhead, software_version, version_name, build_name, previous_status, cpu_flags, cpu_over_commit_time_stamp, hypervisor_type, vms_cores_count, pending_vcpus_count, pending_vmem_size, cpu_sockets,net_config_dirty, supported_cluster_levels, supported_engines, host_os, kvm_version, spice_version, kernel_version, iscsi_initiator_name, transparent_hugepages_state, anonymous_hugepages,hooks)
	VALUES(v_cpu_cores,	v_cpu_model,	v_cpu_speed_mh,	v_if_total_speed, v_kvm_enabled, v_mem_commited, v_physical_mem_mb,	v_status, v_vds_id, v_vm_active, v_vm_count, v_vm_migrating,	v_reserved_mem, v_guest_overhead, v_software_version, v_version_name, v_build_name, v_previous_status, v_cpu_flags, v_cpu_over_commit_time_stamp, v_hypervisor_type, v_vms_cores_count,v_pending_vcpus_count, v_pending_vmem_size, v_cpu_sockets, v_net_config_dirty, v_supported_cluster_levels, v_supported_engines, v_host_os, v_kvm_version, v_spice_version, v_kernel_version, v_iscsi_initiator_name, v_transparent_hugepages_state, v_anonymous_hugepages,v_hooks);
   END;
    
   RETURN;
END; ';


ALTER FUNCTION public.insertvdsdynamic(v_cpu_cores integer, v_cpu_model character varying, v_cpu_speed_mh numeric, v_if_total_speed character varying, v_kvm_enabled boolean, v_mem_commited integer, v_physical_mem_mb integer, v_status integer, v_vds_id uuid, v_vm_active integer, v_vm_count integer, v_vms_cores_count integer, v_vm_migrating integer, v_reserved_mem integer, v_guest_overhead integer, v_software_version character varying, v_version_name character varying, v_build_name character varying, v_previous_status integer, v_cpu_flags character varying, v_cpu_over_commit_time_stamp timestamp with time zone, v_hypervisor_type integer, v_pending_vcpus_count integer, v_pending_vmem_size integer, v_cpu_sockets integer, v_net_config_dirty boolean, v_supported_cluster_levels character varying, v_supported_engines character varying, v_host_os character varying, v_kvm_version character varying, v_spice_version character varying, v_kernel_version character varying, v_iscsi_initiator_name character varying, v_transparent_hugepages_state integer, v_anonymous_hugepages integer, v_hooks character varying) OWNER TO postgres;

--
-- Name: insertvdsgroups(character varying, character varying, character varying, integer, integer, integer, integer, integer, uuid, integer, character varying, boolean, integer, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertvdsgroups(v_description character varying, v_name character varying, v_cpu_name character varying, v_selection_algorithm integer, v_high_utilization integer, v_low_utilization integer, v_cpu_over_commit_duration_minutes integer, v_hypervisor_type integer, v_storage_pool_id uuid, v_max_vds_memory_over_commit integer, v_compatibility_version character varying, v_transparent_hugepages boolean, v_migrate_on_error integer, INOUT v_vds_group_id uuid) RETURNS uuid
    LANGUAGE plpgsql
    AS '
BEGIN
      v_vds_group_id := uuid_generate_v1();
      INSERT INTO vds_groups(vds_group_id,description, name, cpu_name, selection_algorithm, high_utilization, low_utilization,
	cpu_over_commit_duration_minutes, hypervisor_type, storage_pool_id,  max_vds_memory_over_commit, compatibility_version, transparent_hugepages, migrate_on_error)
	VALUES(v_vds_group_id,v_description, v_name, v_cpu_name, v_selection_algorithm, v_high_utilization, v_low_utilization,
	v_cpu_over_commit_duration_minutes, v_hypervisor_type, v_storage_pool_id,  v_max_vds_memory_over_commit, v_compatibility_version, v_transparent_hugepages, v_migrate_on_error);
END; ';


ALTER FUNCTION public.insertvdsgroups(v_description character varying, v_name character varying, v_cpu_name character varying, v_selection_algorithm integer, v_high_utilization integer, v_low_utilization integer, v_cpu_over_commit_duration_minutes integer, v_hypervisor_type integer, v_storage_pool_id uuid, v_max_vds_memory_over_commit integer, v_compatibility_version character varying, v_transparent_hugepages boolean, v_migrate_on_error integer, INOUT v_vds_group_id uuid) OWNER TO postgres;

--
-- Name: insertvdsstatic(character varying, character varying, character varying, integer, uuid, uuid, character varying, boolean, integer, integer, character varying, character varying, character varying, integer, character varying, boolean, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertvdsstatic(v_host_name character varying, v_ip character varying, v_vds_unique_id character varying, v_port integer, v_vds_group_id uuid, INOUT v_vds_id uuid, v_vds_name character varying, v_server_ssl_enabled boolean, v_vds_type integer, v_vds_strength integer, v_pm_type character varying, v_pm_user character varying, v_pm_password character varying, v_pm_port integer, v_pm_options character varying, v_pm_enabled boolean, v_vds_spm_priority integer) RETURNS uuid
    LANGUAGE plpgsql
    AS '
BEGIN
   IF v_vds_unique_id IS NULL OR NOT EXISTS(SELECT vds_name FROM vds_static WHERE vds_unique_id = v_vds_unique_id) then
      BEGIN
         v_vds_id := uuid_generate_v1();
         INSERT INTO vds_static(vds_id,host_name, ip, vds_unique_id, port, vds_group_id, vds_name, server_SSL_enabled,vds_type,vds_strength,pm_type,pm_user,pm_password,pm_port,pm_options,pm_enabled, vds_spm_priority)
			VALUES(v_vds_id,v_host_name, v_ip, v_vds_unique_id, v_port, v_vds_group_id, v_vds_name, v_server_SSL_enabled,v_vds_type,v_vds_strength,v_pm_type,v_pm_user,v_pm_password,v_pm_port,v_pm_options,v_pm_enabled, v_vds_spm_priority);
      END;
   end if;
   RETURN;
END; ';


ALTER FUNCTION public.insertvdsstatic(v_host_name character varying, v_ip character varying, v_vds_unique_id character varying, v_port integer, v_vds_group_id uuid, INOUT v_vds_id uuid, v_vds_name character varying, v_server_ssl_enabled boolean, v_vds_type integer, v_vds_strength integer, v_pm_type character varying, v_pm_user character varying, v_pm_password character varying, v_pm_port integer, v_pm_options character varying, v_pm_enabled boolean, v_vds_spm_priority integer) OWNER TO postgres;

--
-- Name: insertvdsstatistics(numeric, numeric, numeric, numeric, integer, integer, integer, uuid, bigint, bigint, bigint, bigint, integer, bigint, boolean); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertvdsstatistics(v_cpu_idle numeric, v_cpu_load numeric, v_cpu_sys numeric, v_cpu_user numeric, v_usage_cpu_percent integer, v_usage_mem_percent integer, v_usage_network_percent integer, v_vds_id uuid, v_mem_available bigint, v_mem_shared bigint, v_swap_free bigint, v_swap_total bigint, v_ksm_cpu_percent integer, v_ksm_pages bigint, v_ksm_state boolean) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
	
   BEGIN
INSERT INTO vds_statistics(cpu_idle, cpu_load, cpu_sys, cpu_user, usage_cpu_percent, usage_mem_percent, usage_network_percent, vds_id, mem_available, mem_shared,swap_free,swap_total,ksm_cpu_percent,ksm_pages,ksm_state)
	VALUES(v_cpu_idle, v_cpu_load, v_cpu_sys, v_cpu_user, v_usage_cpu_percent, v_usage_mem_percent, v_usage_network_percent, v_vds_id, v_mem_available, v_mem_shared,v_swap_free,v_swap_total,v_ksm_cpu_percent,v_ksm_pages,v_ksm_state);
   END;
    
   RETURN;
END; ';


ALTER FUNCTION public.insertvdsstatistics(v_cpu_idle numeric, v_cpu_load numeric, v_cpu_sys numeric, v_cpu_user numeric, v_usage_cpu_percent integer, v_usage_mem_percent integer, v_usage_network_percent integer, v_vds_id uuid, v_mem_available bigint, v_mem_shared bigint, v_swap_free bigint, v_swap_total bigint, v_ksm_cpu_percent integer, v_ksm_pages bigint, v_ksm_state boolean) OWNER TO postgres;

--
-- Name: insertvm(character varying, integer, integer, uuid, uuid, character varying, uuid, integer, boolean, boolean, integer, integer, integer, character varying, boolean, boolean, uuid, boolean, integer, integer, integer, integer, integer, integer, integer, character varying, integer, character varying, character varying, character varying, integer, character varying, character varying, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertvm(v_description character varying, v_mem_size_mb integer, v_os integer, v_vds_group_id uuid, v_vm_guid uuid, v_vm_name character varying, v_vmt_guid uuid, v_num_of_monitors integer, v_is_initialized boolean, v_is_auto_suspend boolean, v_num_of_sockets integer, v_cpu_per_socket integer, v_usb_policy integer, v_time_zone character varying, v_auto_startup boolean, v_is_stateless boolean, v_dedicated_vm_for_vds uuid, v_fail_back boolean, v_vm_type integer, v_hypervisor_type integer, v_operation_mode integer, v_nice_level integer, v_default_boot_sequence integer, v_default_display_type integer, v_priority integer, v_iso_path character varying, v_origin integer, v_initrd_url character varying, v_kernel_url character varying, v_kernel_params character varying, v_migration_support integer, v_predefined_properties character varying, v_userdefined_properties character varying, v_min_allocated_mem integer) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO vm_static(description, mem_size_mb, os, vds_group_id, vm_guid, VM_NAME, vmt_guid, num_of_monitors, is_initialized, is_auto_suspend, num_of_sockets, cpu_per_socket, usb_policy, time_zone,auto_startup,is_stateless,dedicated_vm_for_vds,fail_back,vm_type,hypervisor_type,operation_mode,nice_level,default_boot_sequence,default_display_type,priority,iso_path,origin,initrd_url,kernel_url,kernel_params,migration_support,predefined_properties,userdefined_properties,min_allocated_mem)
	VALUES(v_description, v_mem_size_mb, v_os, v_vds_group_id, v_vm_guid, v_vm_name, v_vmt_guid, v_num_of_monitors, v_is_initialized, v_is_auto_suspend, v_num_of_sockets, v_cpu_per_socket, v_usb_policy, v_time_zone,v_auto_startup,v_is_stateless,v_dedicated_vm_for_vds,v_fail_back,v_vm_type,v_hypervisor_type,v_operation_mode,v_nice_level,v_default_boot_sequence,v_default_display_type,v_priority,v_iso_path,v_origin,v_initrd_url,v_kernel_url,v_kernel_params,v_migration_support,v_predefined_properties,v_userdefined_properties,v_min_allocated_mem);
	
      INSERT INTO vm_dynamic(vm_guid, status) VALUES(v_vm_guid, 0);
	
      INSERT INTO vm_statistics(vm_guid) VALUES(v_vm_guid);
	
      UPDATE vm_static
      SET child_count =(SELECT COUNT(*) FROM vm_static WHERE vmt_guid = v_vmt_guid)
      WHERE vm_guid = v_vmt_guid;
END; ';


ALTER FUNCTION public.insertvm(v_description character varying, v_mem_size_mb integer, v_os integer, v_vds_group_id uuid, v_vm_guid uuid, v_vm_name character varying, v_vmt_guid uuid, v_num_of_monitors integer, v_is_initialized boolean, v_is_auto_suspend boolean, v_num_of_sockets integer, v_cpu_per_socket integer, v_usb_policy integer, v_time_zone character varying, v_auto_startup boolean, v_is_stateless boolean, v_dedicated_vm_for_vds uuid, v_fail_back boolean, v_vm_type integer, v_hypervisor_type integer, v_operation_mode integer, v_nice_level integer, v_default_boot_sequence integer, v_default_display_type integer, v_priority integer, v_iso_path character varying, v_origin integer, v_initrd_url character varying, v_kernel_url character varying, v_kernel_params character varying, v_migration_support integer, v_predefined_properties character varying, v_userdefined_properties character varying, v_min_allocated_mem integer) OWNER TO postgres;

--
-- Name: insertvm_interface(uuid, character varying, character varying, character varying, integer, uuid, uuid, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertvm_interface(v_id uuid, v_mac_addr character varying, v_name character varying, v_network_name character varying, v_speed integer, v_vm_guid uuid, v_vmt_guid uuid, v_type integer) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO vm_interface(id, mac_addr, name, network_name, speed, VM_GUID, VMT_GUID, type)
	VALUES(v_id, v_mac_addr, v_name, v_network_name, v_speed, v_vm_guid, v_vmt_guid, v_type);
END; ';


ALTER FUNCTION public.insertvm_interface(v_id uuid, v_mac_addr character varying, v_name character varying, v_network_name character varying, v_speed integer, v_vm_guid uuid, v_vmt_guid uuid, v_type integer) OWNER TO postgres;

--
-- Name: insertvm_interface_statistics(uuid, numeric, numeric, numeric, numeric, integer, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertvm_interface_statistics(v_id uuid, v_rx_drop numeric, v_rx_rate numeric, v_tx_drop numeric, v_tx_rate numeric, v_iface_status integer, v_vm_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO vm_interface_statistics(id, rx_drop, rx_rate, tx_drop, tx_rate, vm_id, iface_status)
	VALUES(v_id, v_rx_drop, v_rx_rate, v_tx_drop, v_tx_rate, v_vm_id,v_iface_status);
END; ';


ALTER FUNCTION public.insertvm_interface_statistics(v_id uuid, v_rx_drop numeric, v_rx_rate numeric, v_tx_drop numeric, v_tx_rate numeric, v_iface_status integer, v_vm_id uuid) OWNER TO postgres;

--
-- Name: insertvm_pool_map(uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertvm_pool_map(v_vm_guid uuid, v_vm_pool_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO vm_pool_map(vm_guid, vm_pool_id)
	VALUES(v_vm_guid, v_vm_pool_id);
END; ';


ALTER FUNCTION public.insertvm_pool_map(v_vm_guid uuid, v_vm_pool_id uuid) OWNER TO postgres;

--
-- Name: insertvm_pools(character varying, uuid, character varying, integer, character varying, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertvm_pools(v_vm_pool_description character varying, INOUT v_vm_pool_id uuid, v_vm_pool_name character varying, v_vm_pool_type integer, v_parameters character varying, v_vds_group_id uuid) RETURNS uuid
    LANGUAGE plpgsql
    AS '
BEGIN
      v_vm_pool_id := uuid_generate_v1();
      INSERT INTO vm_pools(vm_pool_id,vm_pool_description, vm_pool_name,
								  vm_pool_type,parameters,vds_group_id)
	VALUES(v_vm_pool_id,v_vm_pool_description, v_vm_pool_name,v_vm_pool_type,v_parameters,v_vds_group_id);
END; ';


ALTER FUNCTION public.insertvm_pools(v_vm_pool_description character varying, INOUT v_vm_pool_id uuid, v_vm_pool_name character varying, v_vm_pool_type integer, v_parameters character varying, v_vds_group_id uuid) OWNER TO postgres;

--
-- Name: insertvmdynamic(character varying, uuid, character varying, timestamp with time zone, timestamp with time zone, character varying, uuid, uuid, integer, uuid, character varying, character varying, timestamp with time zone, timestamp with time zone, integer, integer, boolean, integer, character varying, integer, boolean, integer, integer, integer, uuid, character varying, integer, character varying, integer, integer, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertvmdynamic(v_app_list character varying, v_guest_cur_user_id uuid, v_guest_cur_user_name character varying, v_guest_last_login_time timestamp with time zone, v_guest_last_logout_time timestamp with time zone, v_guest_os character varying, v_migrating_to_vds uuid, v_run_on_vds uuid, v_status integer, v_vm_guid uuid, v_vm_host character varying, v_vm_ip character varying, v_vm_last_boot_time timestamp with time zone, v_vm_last_up_time timestamp with time zone, v_vm_pid integer, v_display integer, v_acpi_enable boolean, v_session integer, v_display_ip character varying, v_display_type integer, v_kvm_enable boolean, v_boot_sequence integer, v_display_secure_port integer, v_utc_diff integer, v_last_vds_run_on uuid, v_client_ip character varying, v_guest_requested_memory integer, v_hibernation_vol_handle character varying, v_exit_status integer, v_pause_status integer, v_exit_message character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO vm_dynamic(app_list,	guest_cur_user_id, guest_cur_user_name, guest_last_login_time, guest_last_logout_time, guest_os, migrating_to_vds, RUN_ON_VDS, status, vm_guid, vm_host, vm_ip, vm_last_boot_time, vm_last_up_time, vm_pid, display, acpi_enable, session, display_ip, display_type, kvm_enable, boot_sequence, display_secure_port, utc_diff, last_vds_run_on, client_ip, guest_requested_memory, hibernation_vol_handle,exit_status,pause_status,exit_message)
	VALUES(v_app_list, v_guest_cur_user_id, v_guest_cur_user_name, v_guest_last_login_time, v_guest_last_logout_time, v_guest_os, v_migrating_to_vds, v_run_on_vds, v_status, v_vm_guid, v_vm_host, v_vm_ip, v_vm_last_boot_time, v_vm_last_up_time, v_vm_pid, v_display, v_acpi_enable, v_session, v_display_ip, v_display_type, v_kvm_enable, v_boot_sequence, v_display_secure_port, v_utc_diff, v_last_vds_run_on, v_client_ip, v_guest_requested_memory, v_hibernation_vol_handle, v_exit_status, v_pause_status, v_exit_message);
END; ';


ALTER FUNCTION public.insertvmdynamic(v_app_list character varying, v_guest_cur_user_id uuid, v_guest_cur_user_name character varying, v_guest_last_login_time timestamp with time zone, v_guest_last_logout_time timestamp with time zone, v_guest_os character varying, v_migrating_to_vds uuid, v_run_on_vds uuid, v_status integer, v_vm_guid uuid, v_vm_host character varying, v_vm_ip character varying, v_vm_last_boot_time timestamp with time zone, v_vm_last_up_time timestamp with time zone, v_vm_pid integer, v_display integer, v_acpi_enable boolean, v_session integer, v_display_ip character varying, v_display_type integer, v_kvm_enable boolean, v_boot_sequence integer, v_display_secure_port integer, v_utc_diff integer, v_last_vds_run_on uuid, v_client_ip character varying, v_guest_requested_memory integer, v_hibernation_vol_handle character varying, v_exit_status integer, v_pause_status integer, v_exit_message character varying) OWNER TO postgres;

--
-- Name: insertvmstatic(character varying, integer, integer, uuid, uuid, character varying, uuid, character varying, timestamp with time zone, integer, boolean, boolean, integer, integer, integer, character varying, boolean, boolean, uuid, boolean, integer, integer, integer, integer, integer, integer, integer, character varying, integer, character varying, character varying, character varying, integer, character varying, character varying, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertvmstatic(v_description character varying, v_mem_size_mb integer, v_os integer, v_vds_group_id uuid, v_vm_guid uuid, v_vm_name character varying, v_vmt_guid uuid, v_domain character varying, v_creation_date timestamp with time zone, v_num_of_monitors integer, v_is_initialized boolean, v_is_auto_suspend boolean, v_num_of_sockets integer, v_cpu_per_socket integer, v_usb_policy integer, v_time_zone character varying, v_auto_startup boolean, v_is_stateless boolean, v_dedicated_vm_for_vds uuid, v_fail_back boolean, v_vm_type integer, v_hypervisor_type integer, v_operation_mode integer, v_nice_level integer, v_default_boot_sequence integer, v_default_display_type integer, v_priority integer, v_iso_path character varying, v_origin integer, v_initrd_url character varying, v_kernel_url character varying, v_kernel_params character varying, v_migration_support integer, v_predefined_properties character varying, v_userdefined_properties character varying, v_min_allocated_mem integer) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO vm_static(description, mem_size_mb, os, vds_group_id, vm_guid, VM_NAME, vmt_guid,domain,creation_date,num_of_monitors,is_initialized,is_auto_suspend,num_of_sockets,cpu_per_socket,usb_policy, time_zone,auto_startup,is_stateless,dedicated_vm_for_vds, fail_back, default_boot_sequence, vm_type, hypervisor_type, operation_mode, nice_level, default_display_type, priority,iso_path,origin,initrd_url,kernel_url,kernel_params,migration_support,predefined_properties,userdefined_properties,min_allocated_mem, entity_type)
	VALUES(v_description,  v_mem_size_mb, v_os, v_vds_group_id, v_vm_guid, v_vm_name, v_vmt_guid, v_domain, v_creation_date, v_num_of_monitors, v_is_initialized, v_is_auto_suspend, v_num_of_sockets, v_cpu_per_socket, v_usb_policy, v_time_zone, v_auto_startup,v_is_stateless,v_dedicated_vm_for_vds,v_fail_back, v_default_boot_sequence, v_vm_type, v_hypervisor_type, v_operation_mode, v_nice_level, v_default_display_type, v_priority,v_iso_path,v_origin,v_initrd_url,v_kernel_url,v_kernel_params,v_migration_support,v_predefined_properties,v_userdefined_properties,v_min_allocated_mem, ''VM'');
END; ';


ALTER FUNCTION public.insertvmstatic(v_description character varying, v_mem_size_mb integer, v_os integer, v_vds_group_id uuid, v_vm_guid uuid, v_vm_name character varying, v_vmt_guid uuid, v_domain character varying, v_creation_date timestamp with time zone, v_num_of_monitors integer, v_is_initialized boolean, v_is_auto_suspend boolean, v_num_of_sockets integer, v_cpu_per_socket integer, v_usb_policy integer, v_time_zone character varying, v_auto_startup boolean, v_is_stateless boolean, v_dedicated_vm_for_vds uuid, v_fail_back boolean, v_vm_type integer, v_hypervisor_type integer, v_operation_mode integer, v_nice_level integer, v_default_boot_sequence integer, v_default_display_type integer, v_priority integer, v_iso_path character varying, v_origin integer, v_initrd_url character varying, v_kernel_url character varying, v_kernel_params character varying, v_migration_support integer, v_predefined_properties character varying, v_userdefined_properties character varying, v_min_allocated_mem integer) OWNER TO postgres;

--
-- Name: insertvmstatistics(numeric, numeric, numeric, integer, integer, integer, text, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertvmstatistics(v_cpu_sys numeric, v_cpu_user numeric, v_elapsed_time numeric, v_usage_cpu_percent integer, v_usage_mem_percent integer, v_usage_network_percent integer, v_disks_usage text, v_vm_guid uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO vm_statistics(cpu_sys, cpu_user, elapsed_time, usage_cpu_percent, usage_mem_percent, usage_network_percent, disks_usage, vm_guid)
	VALUES(v_cpu_sys, v_cpu_user, v_elapsed_time, v_usage_cpu_percent, v_usage_mem_percent, v_usage_network_percent, v_disks_usage, v_vm_guid);
END; ';


ALTER FUNCTION public.insertvmstatistics(v_cpu_sys numeric, v_cpu_user numeric, v_elapsed_time numeric, v_usage_cpu_percent integer, v_usage_mem_percent integer, v_usage_network_percent integer, v_disks_usage text, v_vm_guid uuid) OWNER TO postgres;

--
-- Name: insertvmtemplate(integer, timestamp with time zone, character varying, integer, character varying, integer, integer, integer, uuid, uuid, character varying, integer, integer, integer, character varying, boolean, boolean, integer, integer, integer, integer, integer, integer, integer, boolean, boolean, character varying, integer, character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertvmtemplate(v_child_count integer, v_creation_date timestamp with time zone, v_description character varying, v_mem_size_mb integer, v_name character varying, v_num_of_sockets integer, v_cpu_per_socket integer, v_os integer, v_vmt_guid uuid, v_vds_group_id uuid, v_domain character varying, v_num_of_monitors integer, v_status integer, v_usb_policy integer, v_time_zone character varying, v_fail_back boolean, v_is_auto_suspend boolean, v_vm_type integer, v_hypervisor_type integer, v_operation_mode integer, v_nice_level integer, v_default_boot_sequence integer, v_default_display_type integer, v_priority integer, v_auto_startup boolean, v_is_stateless boolean, v_iso_path character varying, v_origin integer, v_initrd_url character varying, v_kernel_url character varying, v_kernel_params character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT
INTO vm_static(
    vmt_guid,
    child_count,
    creation_date,
    description,
    mem_size_mb,
    vm_name,
    num_of_sockets,
    cpu_per_socket,
    os,
    vm_guid,
    vds_group_id,
    domain,
    num_of_monitors,
    template_status,
    usb_policy,
    time_zone,
    fail_back,
    is_auto_suspend,
    vm_type,
    hypervisor_type,
    operation_mode,
    nice_level,
    default_boot_sequence,
    default_display_type,
    priority,
    auto_startup,
    is_stateless,
    iso_path,
    origin,
    initrd_url,
    kernel_url,
    kernel_params,
    entity_type)
VALUES(
    -- This field is meaningless for templates for the time being, however we want to keep it not null for VMs.
    -- Thus, since templates are top level elements they "point" to the ''Blank'' template.
    ''00000000-0000-0000-0000-000000000000'',
    v_child_count,
    v_creation_date,
    v_description,
    v_mem_size_mb,
    v_name,
    v_num_of_sockets,
    v_cpu_per_socket,
    v_os,
    v_vmt_guid,
    v_vds_group_id,
    v_domain,
    v_num_of_monitors,
    v_status,
    v_usb_policy,
    v_time_zone,
    v_fail_back,
    v_is_auto_suspend,
    v_vm_type,
    v_hypervisor_type,
    v_operation_mode,
    v_nice_level,
    v_default_boot_sequence,
    v_default_display_type,
    v_priority,
    v_auto_startup,
    v_is_stateless,
    v_iso_path,
    v_origin,
    v_initrd_url,
    v_kernel_url,
    v_kernel_params,
    ''TEMPLATE'');
END; ';


ALTER FUNCTION public.insertvmtemplate(v_child_count integer, v_creation_date timestamp with time zone, v_description character varying, v_mem_size_mb integer, v_name character varying, v_num_of_sockets integer, v_cpu_per_socket integer, v_os integer, v_vmt_guid uuid, v_vds_group_id uuid, v_domain character varying, v_num_of_monitors integer, v_status integer, v_usb_policy integer, v_time_zone character varying, v_fail_back boolean, v_is_auto_suspend boolean, v_vm_type integer, v_hypervisor_type integer, v_operation_mode integer, v_nice_level integer, v_default_boot_sequence integer, v_default_display_type integer, v_priority integer, v_auto_startup boolean, v_is_stateless boolean, v_iso_path character varying, v_origin integer, v_initrd_url character varying, v_kernel_url character varying, v_kernel_params character varying) OWNER TO postgres;

--
-- Name: insertvmtemplatedisk(timestamp with time zone, character varying, uuid, uuid, bigint, character varying, character varying, boolean, uuid, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION insertvmtemplatedisk(v_creation_date timestamp with time zone, v_description character varying, v_it_guid uuid, v_vtim_it_guid uuid, v_size bigint, v_os character varying, v_os_version character varying, v_bootable boolean, v_vmt_guid uuid, v_internal_drive_mapping character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
INSERT INTO image_templates(creation_date, description, it_guid, size, os, os_version, bootable, internal_drive_mapping)
	VALUES(v_creation_date, v_description, v_it_guid, v_size, v_os, v_os_version, v_bootable, v_internal_drive_mapping);
    
      INSERT INTO image_vm_map(image_id, vm_id, active)
	VALUES(v_vtim_it_guid, v_vmt_guid, TRUE);
END; ';


ALTER FUNCTION public.insertvmtemplatedisk(v_creation_date timestamp with time zone, v_description character varying, v_it_guid uuid, v_vtim_it_guid uuid, v_size bigint, v_os character varying, v_os_version character varying, v_bootable boolean, v_vmt_guid uuid, v_internal_drive_mapping character varying) OWNER TO postgres;

--
-- Name: inst_add_iso_storage_domain(uuid, character varying, character varying, integer, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION inst_add_iso_storage_domain(v_storage_domain_id uuid, v_name character varying, v_connection character varying, v_available integer, v_used integer) RETURNS void
    LANGUAGE plpgsql
    AS '
   DECLARE
   v_connection_id UUID;
BEGIN        
    v_connection_id := uuid_generate_v1();
    if not exists (select 1 from storage_server_connections where connection = v_connection) then
        -- Insert storage server connection info
        perform Insertstorage_server_connections(v_connection,cast(v_connection_id as varchar(250)),NULL,NULL,NULL,NULL,1,NULL);
        -- Insert storage domain static info
        perform Insertstorage_domain_static(v_storage_domain_id,cast(v_connection_id as varchar(250)),v_name,1,2,''0'');
        -- Insert storage domain dynamic  info
        perform Insertstorage_domain_dynamic(v_available,v_storage_domain_id,v_used);
    end if;
    exception 
        when others then
	    RAISE EXCEPTION ''NUM:%, DETAILS:%'', SQLSTATE, SQLERRM;        
END; ';


ALTER FUNCTION public.inst_add_iso_storage_domain(v_storage_domain_id uuid, v_name character varying, v_connection character varying, v_available integer, v_used integer) OWNER TO postgres;

--
-- Name: inst_update_default_storage_pool_type(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION inst_update_default_storage_pool_type(v_storage_pool_type integer) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      if (v_storage_pool_type > 0 and v_storage_pool_type < 5) then
         UPDATE storage_pool
         SET storage_pool_type = v_storage_pool_type, _update_date = LOCALTIMESTAMP
         WHERE storage_pool.name = ''Default'' and not exists
         (select 1 from storage_domains where storage_domains.storage_pool_name = ''Default'');
      end if;
END; ';


ALTER FUNCTION public.inst_update_default_storage_pool_type(v_storage_pool_type integer) OWNER TO postgres;

--
-- Name: isloggingenabled(text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION isloggingenabled(errorcode text) RETURNS boolean
    LANGUAGE plpgsql
    AS '
-- determine if logging errors is enabled.
-- define in your postgresql.conf:
-- custom_variable_classes = ''engine''
-- set engine.logging = ''true'';
-- or this could be in a config table

-- NOTE: We should look at checking error codes as not all are suitable for exceptions some are just notice or info
declare 
    result boolean := false;
    prop text;
begin
    -- check for log setting in postgresql.conf
    select current_setting(''engine.logging'') into prop;
    if prop = ''true'' then
result = true;
    end if;
    return result;
exception
    when others then
result = true;  -- default to log if not specified 
return result;
end;
';


ALTER FUNCTION public.isloggingenabled(errorcode text) OWNER TO postgres;

--
-- Name: removeallvmtagsbyvmid(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION removeallvmtagsbyvmid(v_vm_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      delete FROM tags_vm_map
      where vm_id = v_vm_id;
END; ';


ALTER FUNCTION public.removeallvmtagsbyvmid(v_vm_id uuid) OWNER TO postgres;

--
-- Name: updateactiveimageidindisk(uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updateactiveimageidindisk(v_image_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
    UPDATE disks
    SET    active_image_id = v_image_id
    WHERE  disk_id IN (SELECT image_group_id
                       FROM   images
                       WHERE  image_guid = v_image_id);
END; ';


ALTER FUNCTION public.updateactiveimageidindisk(v_image_id uuid) OWNER TO postgres;

--
-- Name: updatead_groups(uuid, character varying, integer, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updatead_groups(v_id uuid, v_name character varying, v_status integer, v_domain character varying, v_distinguishedname character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      UPDATE ad_groups
      SET name = v_name,status = v_status,domain = v_domain,distinguishedname =v_distinguishedname
      WHERE id = v_id;
END; ';


ALTER FUNCTION public.updatead_groups(v_id uuid, v_name character varying, v_status integer, v_domain character varying, v_distinguishedname character varying) OWNER TO postgres;

--
-- Name: updateasync_tasks(integer, integer, integer, uuid, text, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updateasync_tasks(v_action_type integer, v_result integer, v_status integer, v_task_id uuid, v_action_parameters text, v_action_params_class character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      UPDATE async_tasks
      SET action_type = v_action_type,result = v_result,status = v_status,action_parameters = v_action_parameters,action_params_class = v_action_params_class
      WHERE task_id = v_task_id;
END; ';


ALTER FUNCTION public.updateasync_tasks(v_action_type integer, v_result integer, v_status integer, v_task_id uuid, v_action_parameters text, v_action_params_class character varying) OWNER TO postgres;

--
-- Name: updateauditlog(integer, timestamp with time zone, integer, integer, character varying, uuid, character varying, uuid, character varying, uuid, character varying, uuid, character varying, uuid, character varying, uuid, character varying, uuid, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updateauditlog(v_audit_log_id integer, v_log_time timestamp with time zone, v_log_type integer, v_severity integer, v_message character varying, v_user_id uuid, v_user_name character varying, v_vds_id uuid, v_vds_name character varying, v_vm_id uuid, v_vm_name character varying, v_vm_template_id uuid, v_vm_template_name character varying, v_storage_pool_id uuid, v_storage_pool_name character varying, v_storage_domain_id uuid, v_storage_domain_name character varying, v_vds_group_id uuid, v_vds_group_name character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      UPDATE audit_log
      SET LOG_TIME = v_log_time,log_type = v_log_type,severity = v_severity,message = v_message, 
      user_id = v_user_id,USER_NAME = v_user_name,vds_id = v_vds_id, 
      VDS_NAME = v_vds_name,vm_id = v_vm_id,VM_NAME = v_vm_name,
      vm_template_id = v_vm_template_id,VM_TEMPLATE_NAME = v_vm_template_name,
      storage_pool_id = v_storage_pool_id,STORAGE_POOL_NAME = v_storage_pool_name, 
      storage_domain_id = v_storage_domain_id,STORAGE_DOMAIN_NAME = v_storage_domain_name,
      vds_group_id = v_vds_group_id,vds_group_name = v_vds_group_name
      WHERE audit_log_id = v_audit_log_id;
END; ';


ALTER FUNCTION public.updateauditlog(v_audit_log_id integer, v_log_time timestamp with time zone, v_log_type integer, v_severity integer, v_message character varying, v_user_id uuid, v_user_name character varying, v_vds_id uuid, v_vds_name character varying, v_vm_id uuid, v_vm_name character varying, v_vm_template_id uuid, v_vm_template_name character varying, v_storage_pool_id uuid, v_storage_pool_name character varying, v_storage_domain_id uuid, v_storage_domain_name character varying, v_vds_group_id uuid, v_vds_group_name character varying) OWNER TO postgres;

--
-- Name: updatebookmark(uuid, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updatebookmark(v_bookmark_id uuid, v_bookmark_name character varying, v_bookmark_value character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      UPDATE bookmarks
      SET bookmark_name = v_bookmark_name,bookmark_value = v_bookmark_value
      WHERE bookmark_Id = v_bookmark_id;
END; ';


ALTER FUNCTION public.updatebookmark(v_bookmark_id uuid, v_bookmark_name character varying, v_bookmark_value character varying) OWNER TO postgres;

--
-- Name: updatecustom_actions(integer, character varying, character varying, integer, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updatecustom_actions(v_action_id integer, v_action_name character varying, v_path character varying, v_tab integer, v_description character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      UPDATE custom_actions
      SET action_name = v_action_name,path = v_path,tab = v_tab,description = v_description
      WHERE action_id = v_action_id;
END; ';


ALTER FUNCTION public.updatecustom_actions(v_action_id integer, v_action_name character varying, v_path character varying, v_tab integer, v_description character varying) OWNER TO postgres;

--
-- Name: updatedisk(uuid, character varying, integer, uuid, character varying, character varying, boolean, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updatedisk(v_disk_id uuid, v_status character varying, v_internal_drive_mapping integer, v_active_image_id uuid, v_disk_type character varying, v_disk_interface character varying, v_wipe_after_delete boolean, v_propagate_errors character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
    UPDATE disks
    SET    status = v_status,
           internal_drive_mapping = v_internal_drive_mapping,
           active_image_id = v_active_image_id,
           disk_type = v_disk_type,
           disk_interface = v_disk_interface,
           wipe_after_delete = v_wipe_after_delete,
           propagate_errors = v_propagate_errors
    WHERE  disk_id = v_disk_id;
END; ';


ALTER FUNCTION public.updatedisk(v_disk_id uuid, v_status character varying, v_internal_drive_mapping integer, v_active_image_id uuid, v_disk_type character varying, v_disk_interface character varying, v_wipe_after_delete boolean, v_propagate_errors character varying) OWNER TO postgres;

--
-- Name: updatedisk_image_dynamic(uuid, integer, integer, bigint, numeric, numeric, numeric); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updatedisk_image_dynamic(v_image_id uuid, v_read_rate integer, v_write_rate integer, v_actual_size bigint, v_read_latency_seconds numeric, v_write_latency_seconds numeric, v_flush_latency_seconds numeric) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      UPDATE disk_image_dynamic
      SET read_rate = v_read_rate,write_rate = v_write_rate,actual_size = v_actual_size,read_latency_seconds = v_read_latency_seconds,write_latency_seconds = v_write_latency_seconds,flush_latency_seconds = v_flush_latency_seconds
      WHERE image_id = v_image_id;
END; ';


ALTER FUNCTION public.updatedisk_image_dynamic(v_image_id uuid, v_read_rate integer, v_write_rate integer, v_actual_size bigint, v_read_latency_seconds numeric, v_write_latency_seconds numeric, v_flush_latency_seconds numeric) OWNER TO postgres;

--
-- Name: updateevent_subscriber(character varying, integer, integer, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updateevent_subscriber(v_event_up_name character varying, v_old_method_id integer, v_new_method_id integer, v_subscriber_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      update event_subscriber set method_id = v_new_method_id
      where event_up_name = v_event_up_name
      and method_id = v_old_method_id
      and subscriber_id = v_subscriber_id;
END; ';


ALTER FUNCTION public.updateevent_subscriber(v_event_up_name character varying, v_old_method_id integer, v_new_method_id integer, v_subscriber_id uuid) OWNER TO postgres;

--
-- Name: updateimage(timestamp with time zone, character varying, uuid, character varying, uuid, bigint, uuid, integer, timestamp with time zone, character varying, uuid, uuid, integer, integer, integer, uuid, integer, boolean, boolean, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updateimage(v_creation_date timestamp with time zone, v_description character varying, v_image_guid uuid, v_internal_drive_mapping character varying, v_it_guid uuid, v_size bigint, v_parentid uuid, v_imagestatus integer, v_lastmodified timestamp with time zone, v_app_list character varying, v_storage_id uuid, v_vm_snapshot_id uuid, v_volume_type integer, v_volume_format integer, v_disk_type integer, v_image_group_id uuid, v_disk_interface integer, v_boot boolean, v_wipe_after_delete boolean, v_propagate_errors integer) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      UPDATE images
      SET creation_date = v_creation_date,description = v_description,internal_drive_mapping = v_internal_drive_mapping, 
      it_guid = v_it_guid,size = v_size, 
      ParentId = v_ParentId,imageStatus = v_imageStatus,lastModified = v_lastModified, 
      app_list = v_app_list,storage_id = v_storage_id, 
      vm_snapshot_id = v_vm_snapshot_id,volume_type = v_volume_type,image_group_id = v_image_group_id, 
      volume_format = v_volume_format,disk_type = v_disk_type, 
      disk_interface = v_disk_interface,boot = v_boot,wipe_after_delete = v_wipe_after_delete, 
      propagate_errors = v_propagate_errors, 
      _update_date = LOCALTIMESTAMP
      WHERE image_guid = v_image_guid;

      -- TODO: Delete this once the disks table is updated directly from code.
      UPDATE disks
      SET    status = CASE WHEN v_imageStatus = 1 THEN ''OK''
                           WHEN v_imageStatus = 2 THEN ''LOCKED''
                           WHEN v_imageStatus = 3 THEN ''INVALID''
                           WHEN v_imageStatus = 4 THEN ''ILLEGAL''
                           ELSE ''Unassigned''
                      END,
             internal_drive_mapping = CAST (v_internal_drive_mapping AS INTEGER),
             disk_type = CASE WHEN v_disk_type = 1 THEN ''System''
                              WHEN v_disk_type = 2 THEN ''Data''
                              WHEN v_disk_type = 3 THEN ''Shared''
                              WHEN v_disk_type = 4 THEN ''Swap''
                              WHEN v_disk_type = 5 THEN ''Temp''
                              ELSE ''Unassigned''
                         END,
             disk_interface = CASE WHEN v_disk_interface = 1 THEN ''SCSI''
                                   WHEN v_disk_interface = 2 THEN ''VirtIO''
                                   ELSE ''IDE''
                              END,
             wipe_after_delete = v_wipe_after_delete,
             propagate_errors = CASE WHEN v_propagate_errors = 1 THEN ''On''
                                     ELSE ''Off''
                                END
      WHERE  disk_id = v_image_group_id;
END; ';


ALTER FUNCTION public.updateimage(v_creation_date timestamp with time zone, v_description character varying, v_image_guid uuid, v_internal_drive_mapping character varying, v_it_guid uuid, v_size bigint, v_parentid uuid, v_imagestatus integer, v_lastmodified timestamp with time zone, v_app_list character varying, v_storage_id uuid, v_vm_snapshot_id uuid, v_volume_type integer, v_volume_format integer, v_disk_type integer, v_image_group_id uuid, v_disk_interface integer, v_boot boolean, v_wipe_after_delete boolean, v_propagate_errors integer) OWNER TO postgres;

--
-- Name: updateimage_vm_map(boolean, uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updateimage_vm_map(v_active boolean, v_image_id uuid, v_vm_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      UPDATE image_vm_map
      SET active = v_active
      WHERE image_id = v_image_id AND vm_id = v_vm_id;

      -- TODO: Delete this once the disks table is updated directly from code.
      IF (v_active) THEN
         PERFORM UpdateActiveImageIdInDisk(v_image_id);
      END IF;

END; ';


ALTER FUNCTION public.updateimage_vm_map(v_active boolean, v_image_id uuid, v_vm_id uuid) OWNER TO postgres;

--
-- Name: updateimage_vm_pool_map(uuid, character varying, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updateimage_vm_pool_map(v_image_guid uuid, v_internal_drive_mapping character varying, v_vm_guid uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      UPDATE image_vm_pool_map
      SET internal_drive_mapping = v_internal_drive_mapping,vm_guid = v_vm_guid
      WHERE image_guid = v_image_guid;
END; ';


ALTER FUNCTION public.updateimage_vm_pool_map(v_image_guid uuid, v_internal_drive_mapping character varying, v_vm_guid uuid) OWNER TO postgres;

--
-- Name: updateisinitialized(uuid, boolean); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updateisinitialized(v_vm_guid uuid, v_is_initialized boolean) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      UPDATE vm_static
      SET is_initialized = v_is_initialized
      WHERE vm_guid = v_vm_guid
      AND   entity_type = ''VM'';
END; ';


ALTER FUNCTION public.updateisinitialized(v_vm_guid uuid, v_is_initialized boolean) OWNER TO postgres;

--
-- Name: updatelastadmincheckstatus(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updatelastadmincheckstatus(v_userids character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
   DECLARE
   v_id  UUID;
   v_tempId  VARCHAR(4000);
   myCursor cursor for select id from fnSplitter(v_userIds);
   v_result  INTEGER;
BEGIN	
	-- get users and its groups
	-- get their permission based on ad_element_id.
	-- if one permissions role''s type is ADMIN(1) then set the user last_admin_check_status to 1
   OPEN myCursor;
   FETCH myCursor into v_tempId;
   WHILE FOUND LOOP
      v_id := CAST(v_tempId AS UUID);
      select   count(*) INTO v_result from users where user_id in(select ad_element_id as user_id from permissions,roles
         where permissions.role_id = roles.id
         and ad_element_id in((select id from ad_groups,users where users.user_id = v_id
               and ad_groups.id in(select id from fnsplitteruuid(users.group_ids))
               union
               select v_id))
         and (roles.role_type = 1 or permissions.role_id = ''00000000-0000-0000-0000-000000000001''));
      update users set last_admin_check_status =
      case
      when v_result = 0 then FALSE
      else TRUE
      end
      where user_id = v_id;
      FETCH myCursor into v_tempId;
   END LOOP;
   CLOSE myCursor;  
END; ';


ALTER FUNCTION public.updatelastadmincheckstatus(v_userids character varying) OWNER TO postgres;

--
-- Name: updatelun_storage_server_connection_map(character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updatelun_storage_server_connection_map(v_lun_id character varying, v_storage_server_connection character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
END; ';


ALTER FUNCTION public.updatelun_storage_server_connection_map(v_lun_id character varying, v_storage_server_connection character varying) OWNER TO postgres;

--
-- Name: updatenetwork(character varying, character varying, uuid, character varying, character varying, character varying, integer, integer, boolean, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updatenetwork(v_addr character varying, v_description character varying, v_id uuid, v_name character varying, v_subnet character varying, v_gateway character varying, v_type integer, v_vlan_id integer, v_stp boolean, v_storage_pool_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      UPDATE network
      SET addr = v_addr,description = v_description,name = v_name,subnet = v_subnet, 
      gateway = v_gateway,type = v_type,vlan_id = v_vlan_id, 
      stp = v_stp,storage_pool_id = v_storage_pool_id
      WHERE id = v_id;
END; ';


ALTER FUNCTION public.updatenetwork(v_addr character varying, v_description character varying, v_id uuid, v_name character varying, v_subnet character varying, v_gateway character varying, v_type integer, v_vlan_id integer, v_stp boolean, v_storage_pool_id uuid) OWNER TO postgres;

--
-- Name: updatenetwork_cluster(uuid, uuid, integer, boolean); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updatenetwork_cluster(v_cluster_id uuid, v_network_id uuid, v_status integer, v_is_display boolean) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
   UPDATE network_cluster
   SET status = v_status,is_display = v_is_display
   WHERE cluster_id = v_cluster_id AND network_id = v_network_id;
END; ';


ALTER FUNCTION public.updatenetwork_cluster(v_cluster_id uuid, v_network_id uuid, v_status integer, v_is_display boolean) OWNER TO postgres;

--
-- Name: updatenetwork_cluster_status(uuid, uuid, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updatenetwork_cluster_status(v_cluster_id uuid, v_network_id uuid, v_status integer) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
   UPDATE network_cluster
   SET status = v_status
   WHERE cluster_id = v_cluster_id AND network_id = v_network_id;
END; ';


ALTER FUNCTION public.updatenetwork_cluster_status(v_cluster_id uuid, v_network_id uuid, v_status integer) OWNER TO postgres;

--
-- Name: updaterole(character varying, uuid, character varying, boolean, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updaterole(v_description character varying, v_id uuid, v_name character varying, v_is_readonly boolean, v_role_type integer) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      UPDATE roles
      SET description = v_description,name = v_name,is_readonly = v_is_readonly, 
      role_type = v_role_type
      WHERE id = v_id;
END; ';


ALTER FUNCTION public.updaterole(v_description character varying, v_id uuid, v_name character varying, v_is_readonly boolean, v_role_type integer) OWNER TO postgres;

--
-- Name: updateroles_relations(uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updateroles_relations(v_role_container_id uuid, v_role_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
END; ';


ALTER FUNCTION public.updateroles_relations(v_role_container_id uuid, v_role_id uuid) OWNER TO postgres;

--
-- Name: updatestateless_vm_image_map(uuid, character varying, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updatestateless_vm_image_map(v_image_guid uuid, v_internal_drive_mapping character varying, v_vm_guid uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      UPDATE stateless_vm_image_map
      SET internal_drive_mapping = v_internal_drive_mapping,vm_guid = v_vm_guid
      WHERE image_guid = v_image_guid;
END; ';


ALTER FUNCTION public.updatestateless_vm_image_map(v_image_guid uuid, v_internal_drive_mapping character varying, v_vm_guid uuid) OWNER TO postgres;

--
-- Name: updatestorage_domain_dynamic(integer, uuid, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updatestorage_domain_dynamic(v_available_disk_size integer, v_id uuid, v_used_disk_size integer) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      UPDATE storage_domain_dynamic
      SET available_disk_size = v_available_disk_size,used_disk_size = v_used_disk_size
      WHERE id = v_id;
END; ';


ALTER FUNCTION public.updatestorage_domain_dynamic(v_available_disk_size integer, v_id uuid, v_used_disk_size integer) OWNER TO postgres;

--
-- Name: updatestorage_domain_static(uuid, character varying, character varying, integer, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updatestorage_domain_static(v_id uuid, v_storage character varying, v_storage_name character varying, v_storage_type integer, v_storage_domain_type integer) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      UPDATE storage_domain_static
      SET storage = v_storage,storage_name = v_storage_name,storage_type = v_storage_type, 
      storage_domain_type = v_storage_domain_type,_update_date = LOCALTIMESTAMP
      WHERE id = v_id;
END; ';


ALTER FUNCTION public.updatestorage_domain_static(v_id uuid, v_storage character varying, v_storage_name character varying, v_storage_type integer, v_storage_domain_type integer) OWNER TO postgres;

--
-- Name: updatestorage_pool(character varying, uuid, character varying, integer, integer, character varying, integer, uuid, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updatestorage_pool(v_description character varying, v_id uuid, v_name character varying, v_storage_pool_type integer, v_status integer, v_storage_pool_format_type character varying, v_master_domain_version integer, v_spm_vds_id uuid, v_compatibility_version character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      UPDATE storage_pool
      SET description = v_description,name = v_name,storage_pool_type = v_storage_pool_type, 
      status = v_status,storage_pool_format_type = v_storage_pool_format_type,master_domain_version = v_master_domain_version, 
      spm_vds_id = v_spm_vds_id,compatibility_version = v_compatibility_version, 
      _update_date = LOCALTIMESTAMP
      WHERE id = v_id;
END; ';


ALTER FUNCTION public.updatestorage_pool(v_description character varying, v_id uuid, v_name character varying, v_storage_pool_type integer, v_status integer, v_storage_pool_format_type character varying, v_master_domain_version integer, v_spm_vds_id uuid, v_compatibility_version character varying) OWNER TO postgres;

--
-- Name: updatestorage_pool_iso_map(uuid, uuid, integer, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updatestorage_pool_iso_map(v_storage_id uuid, v_storage_pool_id uuid, v_status integer, v_owner integer) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      UPDATE storage_pool_iso_map
      SET status = v_status,owner = v_owner
      WHERE storage_id = v_storage_id and storage_pool_id = v_storage_pool_id;
END; ';


ALTER FUNCTION public.updatestorage_pool_iso_map(v_storage_id uuid, v_storage_pool_id uuid, v_status integer, v_owner integer) OWNER TO postgres;

--
-- Name: updatestorage_pool_iso_map_status(uuid, uuid, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updatestorage_pool_iso_map_status(v_storage_id uuid, v_storage_pool_id uuid, v_status integer) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
   UPDATE storage_pool_iso_map
   SET status = v_status
   WHERE storage_pool_id = v_storage_pool_id AND storage_id = v_storage_id;
END; ';


ALTER FUNCTION public.updatestorage_pool_iso_map_status(v_storage_id uuid, v_storage_pool_id uuid, v_status integer) OWNER TO postgres;

--
-- Name: updatestorage_pool_partial(character varying, uuid, character varying, integer, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updatestorage_pool_partial(v_description character varying, v_id uuid, v_name character varying, v_storage_pool_type integer, v_compatibility_version character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      UPDATE storage_pool
      SET description = v_description,name = v_name,storage_pool_type = v_storage_pool_type,compatibility_version = v_compatibility_version, 
      _update_date = LOCALTIMESTAMP
      WHERE id = v_id;
END; ';


ALTER FUNCTION public.updatestorage_pool_partial(v_description character varying, v_id uuid, v_name character varying, v_storage_pool_type integer, v_compatibility_version character varying) OWNER TO postgres;

--
-- Name: updatestorage_pool_status(uuid, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updatestorage_pool_status(v_id uuid, v_status integer) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      UPDATE storage_pool
      SET 
      status = v_status,
      _update_date = LOCALTIMESTAMP
      WHERE id = v_id;
END; ';


ALTER FUNCTION public.updatestorage_pool_status(v_id uuid, v_status integer) OWNER TO postgres;

--
-- Name: updatestorage_server_connections(character varying, character varying, character varying, character varying, integer, character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updatestorage_server_connections(v_connection character varying, v_id character varying, v_iqn character varying, v_password character varying, v_storage_type integer, v_port character varying, v_portal character varying, v_user_name character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      UPDATE storage_server_connections
      SET connection = v_connection,iqn = v_iqn,password = v_password,port = v_port, 
      portal = v_portal,storage_type = v_storage_type,user_name = v_user_name
      WHERE id = v_id;
END; ';


ALTER FUNCTION public.updatestorage_server_connections(v_connection character varying, v_id character varying, v_iqn character varying, v_password character varying, v_storage_type integer, v_port character varying, v_portal character varying, v_user_name character varying) OWNER TO postgres;

--
-- Name: updatetags(character varying, uuid, character varying, uuid, boolean, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updatetags(v_description character varying, v_tag_id uuid, v_tag_name character varying, v_parent_id uuid, v_readonly boolean, v_type integer) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      UPDATE tags
      SET description = v_description,tag_name = v_tag_name,parent_id = v_parent_id,
      readonly	= v_readonly,type = v_type,_update_date = LOCALTIMESTAMP
      WHERE tag_id = v_tag_id;
END; ';


ALTER FUNCTION public.updatetags(v_description character varying, v_tag_id uuid, v_tag_name character varying, v_parent_id uuid, v_readonly boolean, v_type integer) OWNER TO postgres;

--
-- Name: updatetags_vm_pool_map(integer, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updatetags_vm_pool_map(v_tag_id integer, v_vm_pool_id integer) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
END; ';


ALTER FUNCTION public.updatetags_vm_pool_map(v_tag_id integer, v_vm_pool_id integer) OWNER TO postgres;

--
-- Name: updatetime_lease_vm_pool_map(timestamp with time zone, uuid, timestamp with time zone, integer, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updatetime_lease_vm_pool_map(v_end_time timestamp with time zone, v_id uuid, v_start_time timestamp with time zone, v_type integer, v_vm_pool_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      UPDATE time_lease_vm_pool_map
      SET end_time = v_end_time,start_time = v_start_time,type = v_type
      WHERE id = v_id AND vm_pool_id = v_vm_pool_id;
END; ';


ALTER FUNCTION public.updatetime_lease_vm_pool_map(v_end_time timestamp with time zone, v_id uuid, v_start_time timestamp with time zone, v_type integer, v_vm_pool_id uuid) OWNER TO postgres;

--
-- Name: updateuser(character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, integer, character varying, character varying, uuid, integer, character varying, boolean, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updateuser(v_department character varying, v_desktop_device character varying, v_domain character varying, v_email character varying, v_groups character varying, v_name character varying, v_note character varying, v_role character varying, v_status integer, v_surname character varying, v_user_icon_path character varying, v_user_id uuid, v_session_count integer, v_username character varying, v_last_admin_check_status boolean, v_group_ids character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      UPDATE users
      SET department = v_department,desktop_device = v_desktop_device,domain = v_domain, 
      email = v_email,groups = v_groups,name = v_name,note = v_note, 
      role = v_role,status = v_status,surname = v_surname,user_icon_path = v_user_icon_path, 
      username = v_username,session_count = v_session_count, 
      last_admin_check_status = v_last_admin_check_status,
      group_ids = v_group_ids
      WHERE user_id = v_user_id;
END; ';


ALTER FUNCTION public.updateuser(v_department character varying, v_desktop_device character varying, v_domain character varying, v_email character varying, v_groups character varying, v_name character varying, v_note character varying, v_role character varying, v_status integer, v_surname character varying, v_user_icon_path character varying, v_user_id uuid, v_session_count integer, v_username character varying, v_last_admin_check_status boolean, v_group_ids character varying) OWNER TO postgres;

--
-- Name: updatevdcoption(character varying, character varying, integer, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updatevdcoption(v_option_name character varying, v_option_value character varying, v_option_id integer, v_version character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      UPDATE vdc_options
      SET OPTION_NAME = v_option_name,option_value = v_option_value,version = v_version
      WHERE option_id = v_option_id;
END; ';


ALTER FUNCTION public.updatevdcoption(v_option_name character varying, v_option_value character varying, v_option_id integer, v_version character varying) OWNER TO postgres;

--
-- Name: updatevds_interface(character varying, character varying, integer, character varying, uuid, boolean, character varying, character varying, character varying, character varying, integer, character varying, integer, integer, uuid, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updatevds_interface(v_addr character varying, v_bond_name character varying, v_bond_type integer, v_gateway character varying, v_id uuid, v_is_bond boolean, v_bond_opts character varying, v_mac_addr character varying, v_name character varying, v_network_name character varying, v_speed integer, v_subnet character varying, v_boot_protocol integer, v_type integer, v_vds_id uuid, v_vlan_id integer) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      UPDATE vds_interface
      SET addr = v_addr,bond_name = v_bond_name,bond_type = v_bond_type,gateway = v_gateway, 
      is_bond = v_is_bond,bond_opts = v_bond_opts,mac_addr = v_mac_addr, 
      name = v_name,network_name = v_network_name,speed = v_speed, 
      subnet = v_subnet,boot_protocol = v_boot_protocol, 
      type = v_type,VDS_ID = v_vds_id,vlan_id = v_vlan_id,_update_date = LOCALTIMESTAMP
      WHERE id = v_id;
END; ';


ALTER FUNCTION public.updatevds_interface(v_addr character varying, v_bond_name character varying, v_bond_type integer, v_gateway character varying, v_id uuid, v_is_bond boolean, v_bond_opts character varying, v_mac_addr character varying, v_name character varying, v_network_name character varying, v_speed integer, v_subnet character varying, v_boot_protocol integer, v_type integer, v_vds_id uuid, v_vlan_id integer) OWNER TO postgres;

--
-- Name: updatevds_interface_statistics(uuid, numeric, numeric, numeric, numeric, integer, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updatevds_interface_statistics(v_id uuid, v_rx_drop numeric, v_rx_rate numeric, v_tx_drop numeric, v_tx_rate numeric, v_iface_status integer, v_vds_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      UPDATE vds_interface_statistics
      SET rx_drop = v_rx_drop,rx_rate = v_rx_rate,tx_drop = v_tx_drop,tx_rate = v_tx_rate, 
      vds_id = v_vds_id,iface_status = v_iface_status
      WHERE id = v_id;
END; ';


ALTER FUNCTION public.updatevds_interface_statistics(v_id uuid, v_rx_drop numeric, v_rx_rate numeric, v_tx_drop numeric, v_tx_rate numeric, v_iface_status integer, v_vds_id uuid) OWNER TO postgres;

--
-- Name: updatevdsdynamic(integer, character varying, numeric, character varying, boolean, integer, integer, integer, uuid, integer, integer, integer, integer, integer, integer, character varying, character varying, character varying, integer, character varying, timestamp with time zone, integer, integer, integer, integer, boolean, character varying, character varying, character varying, character varying, character varying, character varying, character varying, integer, integer, character varying, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updatevdsdynamic(v_cpu_cores integer, v_cpu_model character varying, v_cpu_speed_mh numeric, v_if_total_speed character varying, v_kvm_enabled boolean, v_mem_commited integer, v_physical_mem_mb integer, v_status integer, v_vds_id uuid, v_vm_active integer, v_vm_count integer, v_vms_cores_count integer, v_vm_migrating integer, v_reserved_mem integer, v_guest_overhead integer, v_software_version character varying, v_version_name character varying, v_build_name character varying, v_previous_status integer, v_cpu_flags character varying, v_cpu_over_commit_time_stamp timestamp with time zone, v_hypervisor_type integer, v_pending_vcpus_count integer, v_pending_vmem_size integer, v_cpu_sockets integer, v_net_config_dirty boolean, v_supported_cluster_levels character varying, v_supported_engines character varying, v_host_os character varying, v_kvm_version character varying, v_spice_version character varying, v_kernel_version character varying, v_iscsi_initiator_name character varying, v_transparent_hugepages_state integer, v_anonymous_hugepages integer, v_hooks character varying, v_non_operational_reason integer) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN

   BEGIN
      UPDATE vds_dynamic
      SET cpu_cores = v_cpu_cores,cpu_model = v_cpu_model,cpu_speed_mh = v_cpu_speed_mh, 
      if_total_speed = v_if_total_speed,kvm_enabled = v_kvm_enabled, 
      mem_commited = v_mem_commited,physical_mem_mb = v_physical_mem_mb, 
      status = v_status,vm_active = v_vm_active,vm_count = v_vm_count, 
      vm_migrating = v_vm_migrating,reserved_mem = v_reserved_mem, 
      guest_overhead = v_guest_overhead,software_version = v_software_version, 
      version_name = v_version_name,build_name = v_build_name,previous_status = v_previous_status, 
      cpu_flags = v_cpu_flags,cpu_over_commit_time_stamp = v_cpu_over_commit_time_stamp, 
      hypervisor_type = v_hypervisor_type, 
      vms_cores_count = v_vms_cores_count,pending_vcpus_count = v_pending_vcpus_count, 
      pending_vmem_size = v_pending_vmem_size, 
      cpu_sockets = v_cpu_sockets,net_config_dirty = v_net_config_dirty, 
      supported_cluster_levels = v_supported_cluster_levels, 
      supported_engines = v_supported_engines,host_os = v_host_os, 
      kvm_version = v_kvm_version,spice_version = v_spice_version, 
      kernel_version = v_kernel_version,iscsi_initiator_name = v_iscsi_initiator_name, 
      transparent_hugepages_state = v_transparent_hugepages_state, 
      anonymous_hugepages = v_anonymous_hugepages,hooks = v_hooks,
      _update_date = LOCALTIMESTAMP,non_operational_reason = v_non_operational_reason
      WHERE vds_id = v_vds_id;
   END;	

   RETURN;
END; ';


ALTER FUNCTION public.updatevdsdynamic(v_cpu_cores integer, v_cpu_model character varying, v_cpu_speed_mh numeric, v_if_total_speed character varying, v_kvm_enabled boolean, v_mem_commited integer, v_physical_mem_mb integer, v_status integer, v_vds_id uuid, v_vm_active integer, v_vm_count integer, v_vms_cores_count integer, v_vm_migrating integer, v_reserved_mem integer, v_guest_overhead integer, v_software_version character varying, v_version_name character varying, v_build_name character varying, v_previous_status integer, v_cpu_flags character varying, v_cpu_over_commit_time_stamp timestamp with time zone, v_hypervisor_type integer, v_pending_vcpus_count integer, v_pending_vmem_size integer, v_cpu_sockets integer, v_net_config_dirty boolean, v_supported_cluster_levels character varying, v_supported_engines character varying, v_host_os character varying, v_kvm_version character varying, v_spice_version character varying, v_kernel_version character varying, v_iscsi_initiator_name character varying, v_transparent_hugepages_state integer, v_anonymous_hugepages integer, v_hooks character varying, v_non_operational_reason integer) OWNER TO postgres;

--
-- Name: updatevdsdynamicstatus(uuid, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updatevdsdynamicstatus(v_vds_guid uuid, v_status integer) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      UPDATE vds_dynamic
      SET
      status = v_status
      WHERE vds_id = v_vds_guid;
END; ';


ALTER FUNCTION public.updatevdsdynamicstatus(v_vds_guid uuid, v_status integer) OWNER TO postgres;

--
-- Name: updatevdsgroup(character varying, character varying, uuid, character varying, integer, integer, integer, integer, integer, uuid, integer, character varying, boolean, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updatevdsgroup(v_description character varying, v_name character varying, v_vds_group_id uuid, v_cpu_name character varying, v_selection_algorithm integer, v_high_utilization integer, v_low_utilization integer, v_cpu_over_commit_duration_minutes integer, v_hypervisor_type integer, v_storage_pool_id uuid, v_max_vds_memory_over_commit integer, v_compatibility_version character varying, v_transparent_hugepages boolean, v_migrate_on_error integer) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      UPDATE vds_groups
      SET description = v_description,name = v_name,cpu_name = v_cpu_name,selection_algorithm = v_selection_algorithm, 
      high_utilization = v_high_utilization, 
      low_utilization = v_low_utilization,cpu_over_commit_duration_minutes = v_cpu_over_commit_duration_minutes, 
      hypervisor_type = v_hypervisor_type, 
      storage_pool_id = v_storage_pool_id,_update_date = LOCALTIMESTAMP,
      max_vds_memory_over_commit = v_max_vds_memory_over_commit, 
      compatibility_version = v_compatibility_version,transparent_hugepages = v_transparent_hugepages, 
      migrate_on_error = v_migrate_on_error
      WHERE vds_group_id = v_vds_group_id;
END; ';


ALTER FUNCTION public.updatevdsgroup(v_description character varying, v_name character varying, v_vds_group_id uuid, v_cpu_name character varying, v_selection_algorithm integer, v_high_utilization integer, v_low_utilization integer, v_cpu_over_commit_duration_minutes integer, v_hypervisor_type integer, v_storage_pool_id uuid, v_max_vds_memory_over_commit integer, v_compatibility_version character varying, v_transparent_hugepages boolean, v_migrate_on_error integer) OWNER TO postgres;

--
-- Name: updatevdsstatic(character varying, character varying, character varying, integer, uuid, uuid, character varying, boolean, integer, integer, character varying, character varying, character varying, integer, character varying, boolean, bigint, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updatevdsstatic(v_host_name character varying, v_ip character varying, v_vds_unique_id character varying, v_port integer, v_vds_group_id uuid, v_vds_id uuid, v_vds_name character varying, v_server_ssl_enabled boolean, v_vds_type integer, v_vds_strength integer, v_pm_type character varying, v_pm_user character varying, v_pm_password character varying, v_pm_port integer, v_pm_options character varying, v_pm_enabled boolean, v_otp_validity bigint, v_vds_spm_priority integer) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN

   BEGIN
      UPDATE vds_static
      SET host_name = v_host_name,ip = v_ip,vds_unique_id = v_vds_unique_id, 
      port = v_port,vds_group_id = v_vds_group_id,vds_name = v_vds_name,server_SSL_enabled = v_server_SSL_enabled, 
      vds_type = v_vds_type, 
      _update_date = LOCALTIMESTAMP,vds_strength = v_vds_strength, 
      pm_type = v_pm_type,pm_user = v_pm_user,pm_password = v_pm_password, 
      pm_port = v_pm_port,pm_options = v_pm_options,pm_enabled = v_pm_enabled, otp_validity = v_otp_validity, vds_spm_priority = v_vds_spm_priority
      WHERE vds_id = v_vds_id;
   END;	

   RETURN;
END; ';


ALTER FUNCTION public.updatevdsstatic(v_host_name character varying, v_ip character varying, v_vds_unique_id character varying, v_port integer, v_vds_group_id uuid, v_vds_id uuid, v_vds_name character varying, v_server_ssl_enabled boolean, v_vds_type integer, v_vds_strength integer, v_pm_type character varying, v_pm_user character varying, v_pm_password character varying, v_pm_port integer, v_pm_options character varying, v_pm_enabled boolean, v_otp_validity bigint, v_vds_spm_priority integer) OWNER TO postgres;

--
-- Name: updatevdsstatistics(numeric, numeric, numeric, numeric, integer, integer, integer, uuid, bigint, bigint, bigint, bigint, integer, bigint, boolean); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updatevdsstatistics(v_cpu_idle numeric, v_cpu_load numeric, v_cpu_sys numeric, v_cpu_user numeric, v_usage_cpu_percent integer, v_usage_mem_percent integer, v_usage_network_percent integer, v_vds_id uuid, v_mem_available bigint, v_mem_shared bigint, v_swap_free bigint, v_swap_total bigint, v_ksm_cpu_percent integer, v_ksm_pages bigint, v_ksm_state boolean) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN

   BEGIN
      UPDATE vds_statistics
      SET cpu_idle = v_cpu_idle,cpu_load = v_cpu_load,cpu_sys = v_cpu_sys, 
      cpu_user = v_cpu_user,usage_cpu_percent = v_usage_cpu_percent,usage_mem_percent = v_usage_mem_percent, 
      usage_network_percent = v_usage_network_percent, 
      mem_available = v_mem_available,mem_shared = v_mem_shared,
      swap_free = v_swap_free,swap_total = v_swap_total,ksm_cpu_percent = v_ksm_cpu_percent, 
      ksm_pages = v_ksm_pages,ksm_state = v_ksm_state
      WHERE vds_id = v_vds_id;
   END;	

   RETURN;
END; ';


ALTER FUNCTION public.updatevdsstatistics(v_cpu_idle numeric, v_cpu_load numeric, v_cpu_sys numeric, v_cpu_user numeric, v_usage_cpu_percent integer, v_usage_mem_percent integer, v_usage_network_percent integer, v_vds_id uuid, v_mem_available bigint, v_mem_shared bigint, v_swap_free bigint, v_swap_total bigint, v_ksm_cpu_percent integer, v_ksm_pages bigint, v_ksm_state boolean) OWNER TO postgres;

--
-- Name: updatevm_interface(uuid, character varying, character varying, character varying, integer, uuid, uuid, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updatevm_interface(v_id uuid, v_mac_addr character varying, v_name character varying, v_network_name character varying, v_speed integer, v_vm_guid uuid, v_vmt_guid uuid, v_type integer) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      UPDATE vm_interface
      SET mac_addr = v_mac_addr,name = v_name,network_name = v_network_name, 
      speed = v_speed,VM_GUID = v_vm_guid,VMT_GUID = v_vmt_guid,type = v_type, 
      _update_date = LOCALTIMESTAMP
      WHERE id = v_id;
END; ';


ALTER FUNCTION public.updatevm_interface(v_id uuid, v_mac_addr character varying, v_name character varying, v_network_name character varying, v_speed integer, v_vm_guid uuid, v_vmt_guid uuid, v_type integer) OWNER TO postgres;

--
-- Name: updatevm_interface_statistics(uuid, numeric, numeric, numeric, numeric, integer, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updatevm_interface_statistics(v_id uuid, v_rx_drop numeric, v_rx_rate numeric, v_tx_drop numeric, v_tx_rate numeric, v_iface_status integer, v_vm_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      UPDATE vm_interface_statistics
      SET rx_drop = v_rx_drop,rx_rate = v_rx_rate,tx_drop = v_tx_drop,tx_rate = v_tx_rate, 
      vm_id = v_vm_id,iface_status = v_iface_status
      WHERE id = v_id;
END; ';


ALTER FUNCTION public.updatevm_interface_statistics(v_id uuid, v_rx_drop numeric, v_rx_rate numeric, v_tx_drop numeric, v_tx_rate numeric, v_iface_status integer, v_vm_id uuid) OWNER TO postgres;

--
-- Name: updatevm_pool_map(uuid, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updatevm_pool_map(v_vm_guid uuid, v_vm_pool_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      UPDATE vm_pool_map
      SET vm_pool_id = v_vm_pool_id
      WHERE vm_guid = v_vm_guid;
END; ';


ALTER FUNCTION public.updatevm_pool_map(v_vm_guid uuid, v_vm_pool_id uuid) OWNER TO postgres;

--
-- Name: updatevm_pools(character varying, uuid, character varying, integer, character varying, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updatevm_pools(v_vm_pool_description character varying, v_vm_pool_id uuid, v_vm_pool_name character varying, v_vm_pool_type integer, v_parameters character varying, v_vds_group_id uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      UPDATE vm_pools
      SET vm_pool_description = v_vm_pool_description,vm_pool_name = v_vm_pool_name,
      vm_pool_type = v_vm_pool_type,parameters = v_parameters,vds_group_id = v_vds_group_id
      WHERE vm_pool_id = v_vm_pool_id;
END; ';


ALTER FUNCTION public.updatevm_pools(v_vm_pool_description character varying, v_vm_pool_id uuid, v_vm_pool_name character varying, v_vm_pool_type integer, v_parameters character varying, v_vds_group_id uuid) OWNER TO postgres;

--
-- Name: updatevmdynamic(character varying, uuid, character varying, timestamp with time zone, timestamp with time zone, character varying, uuid, uuid, integer, uuid, character varying, character varying, timestamp with time zone, timestamp with time zone, integer, integer, boolean, integer, character varying, integer, boolean, integer, integer, integer, uuid, character varying, integer, character varying, integer, integer, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updatevmdynamic(v_app_list character varying, v_guest_cur_user_id uuid, v_guest_cur_user_name character varying, v_guest_last_login_time timestamp with time zone, v_guest_last_logout_time timestamp with time zone, v_guest_os character varying, v_migrating_to_vds uuid, v_run_on_vds uuid, v_status integer, v_vm_guid uuid, v_vm_host character varying, v_vm_ip character varying, v_vm_last_boot_time timestamp with time zone, v_vm_last_up_time timestamp with time zone, v_vm_pid integer, v_display integer, v_acpi_enable boolean, v_session integer, v_display_ip character varying, v_display_type integer, v_kvm_enable boolean, v_boot_sequence integer, v_display_secure_port integer, v_utc_diff integer, v_last_vds_run_on uuid, v_client_ip character varying, v_guest_requested_memory integer, v_hibernation_vol_handle character varying, v_exit_status integer, v_pause_status integer, v_exit_message character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      UPDATE vm_dynamic
      SET app_list = v_app_list,guest_cur_user_id = v_guest_cur_user_id,guest_cur_user_name = v_guest_cur_user_name, 
      guest_last_login_time = v_guest_last_login_time, 
      guest_last_logout_time = v_guest_last_logout_time, 
      guest_os = v_guest_os,migrating_to_vds = v_migrating_to_vds,RUN_ON_VDS = v_run_on_vds, 
      status = v_status,vm_host = v_vm_host,vm_ip = v_vm_ip, 
      vm_last_boot_time = v_vm_last_boot_time,vm_last_up_time = v_vm_last_up_time, 
      vm_pid = v_vm_pid,display = v_display,acpi_enable = v_acpi_enable, 
      session = v_session,display_ip = v_display_ip, 
      display_type = v_display_type,kvm_enable = v_kvm_enable,boot_sequence = v_boot_sequence, 
      display_secure_port = v_display_secure_port, 
      utc_diff = v_utc_diff,last_vds_run_on = v_last_vds_run_on,client_ip = v_client_ip, 
      guest_requested_memory = v_guest_requested_memory, 
      hibernation_vol_handle = v_hibernation_vol_handle,exit_status = v_exit_status, 
      pause_status = v_pause_status,exit_message = v_exit_message
      WHERE vm_guid = v_vm_guid;
END; ';


ALTER FUNCTION public.updatevmdynamic(v_app_list character varying, v_guest_cur_user_id uuid, v_guest_cur_user_name character varying, v_guest_last_login_time timestamp with time zone, v_guest_last_logout_time timestamp with time zone, v_guest_os character varying, v_migrating_to_vds uuid, v_run_on_vds uuid, v_status integer, v_vm_guid uuid, v_vm_host character varying, v_vm_ip character varying, v_vm_last_boot_time timestamp with time zone, v_vm_last_up_time timestamp with time zone, v_vm_pid integer, v_display integer, v_acpi_enable boolean, v_session integer, v_display_ip character varying, v_display_type integer, v_kvm_enable boolean, v_boot_sequence integer, v_display_secure_port integer, v_utc_diff integer, v_last_vds_run_on uuid, v_client_ip character varying, v_guest_requested_memory integer, v_hibernation_vol_handle character varying, v_exit_status integer, v_pause_status integer, v_exit_message character varying) OWNER TO postgres;

--
-- Name: updatevmdynamicstatus(uuid, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updatevmdynamicstatus(v_vm_guid uuid, v_status integer) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      UPDATE vm_dynamic
      SET  
      status = v_status 
      WHERE vm_guid = v_vm_guid;
END; ';


ALTER FUNCTION public.updatevmdynamicstatus(v_vm_guid uuid, v_status integer) OWNER TO postgres;

--
-- Name: updatevmstatic(character varying, integer, integer, uuid, uuid, character varying, uuid, character varying, timestamp with time zone, integer, boolean, boolean, integer, integer, integer, character varying, boolean, boolean, uuid, boolean, integer, integer, integer, integer, integer, integer, integer, character varying, integer, character varying, character varying, character varying, integer, character varying, character varying, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updatevmstatic(v_description character varying, v_mem_size_mb integer, v_os integer, v_vds_group_id uuid, v_vm_guid uuid, v_vm_name character varying, v_vmt_guid uuid, v_domain character varying, v_creation_date timestamp with time zone, v_num_of_monitors integer, v_is_initialized boolean, v_is_auto_suspend boolean, v_num_of_sockets integer, v_cpu_per_socket integer, v_usb_policy integer, v_time_zone character varying, v_auto_startup boolean, v_is_stateless boolean, v_dedicated_vm_for_vds uuid, v_fail_back boolean, v_vm_type integer, v_hypervisor_type integer, v_operation_mode integer, v_nice_level integer, v_default_boot_sequence integer, v_default_display_type integer, v_priority integer, v_iso_path character varying, v_origin integer, v_initrd_url character varying, v_kernel_url character varying, v_kernel_params character varying, v_migration_support integer, v_predefined_properties character varying, v_userdefined_properties character varying, v_min_allocated_mem integer) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      UPDATE vm_static
      SET description = v_description,mem_size_mb = v_mem_size_mb,os = v_os,vds_group_id = v_vds_group_id, 
      VM_NAME = v_vm_name,vmt_guid = v_vmt_guid, 
      domain = v_domain,creation_date = v_creation_date,num_of_monitors = v_num_of_monitors, 
      is_initialized = v_is_initialized,is_auto_suspend = v_is_auto_suspend, 
      num_of_sockets = v_num_of_sockets,cpu_per_socket = v_cpu_per_socket, 
      usb_policy = v_usb_policy,time_zone = v_time_zone,auto_startup = v_auto_startup, 
      is_stateless = v_is_stateless,dedicated_vm_for_vds = v_dedicated_vm_for_vds, 
      fail_back = v_fail_back,vm_type = v_vm_type, 
      hypervisor_type = v_hypervisor_type,nice_level = v_nice_level,operation_mode = v_operation_mode, 
      _update_date = LOCALTIMESTAMP,default_boot_sequence = v_default_boot_sequence, 
      default_display_type = v_default_display_type, 
      priority = v_priority,iso_path = v_iso_path,origin = v_origin, 
      initrd_url = v_initrd_url,kernel_url = v_kernel_url, 
      kernel_params = v_kernel_params,migration_support = v_migration_support,
      predefined_properties = v_predefined_properties,userdefined_properties = v_userdefined_properties,
      min_allocated_mem = v_min_allocated_mem
      WHERE vm_guid = v_vm_guid
      AND   entity_type = ''VM'';
END; ';


ALTER FUNCTION public.updatevmstatic(v_description character varying, v_mem_size_mb integer, v_os integer, v_vds_group_id uuid, v_vm_guid uuid, v_vm_name character varying, v_vmt_guid uuid, v_domain character varying, v_creation_date timestamp with time zone, v_num_of_monitors integer, v_is_initialized boolean, v_is_auto_suspend boolean, v_num_of_sockets integer, v_cpu_per_socket integer, v_usb_policy integer, v_time_zone character varying, v_auto_startup boolean, v_is_stateless boolean, v_dedicated_vm_for_vds uuid, v_fail_back boolean, v_vm_type integer, v_hypervisor_type integer, v_operation_mode integer, v_nice_level integer, v_default_boot_sequence integer, v_default_display_type integer, v_priority integer, v_iso_path character varying, v_origin integer, v_initrd_url character varying, v_kernel_url character varying, v_kernel_params character varying, v_migration_support integer, v_predefined_properties character varying, v_userdefined_properties character varying, v_min_allocated_mem integer) OWNER TO postgres;

--
-- Name: updatevmstatistics(numeric, numeric, numeric, integer, integer, integer, text, uuid); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updatevmstatistics(v_cpu_sys numeric, v_cpu_user numeric, v_elapsed_time numeric, v_usage_cpu_percent integer, v_usage_mem_percent integer, v_usage_network_percent integer, v_disks_usage text, v_vm_guid uuid) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      UPDATE vm_statistics
      SET cpu_sys = v_cpu_sys,cpu_user = v_cpu_user,elapsed_time = v_elapsed_time, 
      usage_cpu_percent = v_usage_cpu_percent,usage_mem_percent = v_usage_mem_percent, 
      usage_network_percent = v_usage_network_percent,disks_usage = v_disks_usage
      WHERE vm_guid = v_vm_guid;
END; ';


ALTER FUNCTION public.updatevmstatistics(v_cpu_sys numeric, v_cpu_user numeric, v_elapsed_time numeric, v_usage_cpu_percent integer, v_usage_mem_percent integer, v_usage_network_percent integer, v_disks_usage text, v_vm_guid uuid) OWNER TO postgres;

--
-- Name: updatevmtagsdefaultdisplaytype(uuid, uuid, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updatevmtagsdefaultdisplaytype(v_tag_id uuid, v_vm_id uuid, v_defaultdisplaytype integer) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      update tags_vm_map
      set DefaultDisplayType = v_DefaultDisplayType
      where tags_vm_map.tag_id = v_tag_id
      and tags_vm_map.vm_id = v_vm_id;
END; ';


ALTER FUNCTION public.updatevmtagsdefaultdisplaytype(v_tag_id uuid, v_vm_id uuid, v_defaultdisplaytype integer) OWNER TO postgres;

--
-- Name: updatevmtemplate(integer, timestamp with time zone, character varying, integer, character varying, integer, integer, integer, uuid, uuid, character varying, integer, integer, integer, character varying, boolean, boolean, integer, integer, integer, integer, integer, integer, integer, boolean, boolean, character varying, integer, character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updatevmtemplate(v_child_count integer, v_creation_date timestamp with time zone, v_description character varying, v_mem_size_mb integer, v_name character varying, v_num_of_sockets integer, v_cpu_per_socket integer, v_os integer, v_vmt_guid uuid, v_vds_group_id uuid, v_domain character varying, v_num_of_monitors integer, v_status integer, v_usb_policy integer, v_time_zone character varying, v_fail_back boolean, v_is_auto_suspend boolean, v_vm_type integer, v_hypervisor_type integer, v_operation_mode integer, v_nice_level integer, v_default_boot_sequence integer, v_default_display_type integer, v_priority integer, v_auto_startup boolean, v_is_stateless boolean, v_iso_path character varying, v_origin integer, v_initrd_url character varying, v_kernel_url character varying, v_kernel_params character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      UPDATE vm_static
      SET child_count = v_child_count,creation_date = v_creation_date,description = v_description, 
      mem_size_mb = v_mem_size_mb,vm_name = v_name,num_of_sockets = v_num_of_sockets,
      cpu_per_socket = v_cpu_per_socket,os = v_os, 
      vds_group_id = v_vds_group_id,domain = v_domain,num_of_monitors = v_num_of_monitors,
      template_status = v_status,usb_policy = v_usb_policy,time_zone = v_time_zone,
      fail_back = v_fail_back,is_auto_suspend = v_is_auto_suspend,
      vm_type = v_vm_type,hypervisor_type = v_hypervisor_type,operation_mode = v_operation_mode, 
      nice_level = v_nice_level,default_boot_sequence = v_default_boot_sequence, 
      default_display_type = v_default_display_type, 
      priority = v_priority,auto_startup = v_auto_startup,is_stateless = v_is_stateless, 
      iso_path = v_iso_path,origin = v_origin,initrd_url = v_initrd_url, 
      kernel_url = v_kernel_url,kernel_params = v_kernel_params, _update_date = CURRENT_TIMESTAMP
      WHERE vm_guid = v_vmt_guid
      AND   entity_type = ''TEMPLATE'';
END; ';


ALTER FUNCTION public.updatevmtemplate(v_child_count integer, v_creation_date timestamp with time zone, v_description character varying, v_mem_size_mb integer, v_name character varying, v_num_of_sockets integer, v_cpu_per_socket integer, v_os integer, v_vmt_guid uuid, v_vds_group_id uuid, v_domain character varying, v_num_of_monitors integer, v_status integer, v_usb_policy integer, v_time_zone character varying, v_fail_back boolean, v_is_auto_suspend boolean, v_vm_type integer, v_hypervisor_type integer, v_operation_mode integer, v_nice_level integer, v_default_boot_sequence integer, v_default_display_type integer, v_priority integer, v_auto_startup boolean, v_is_stateless boolean, v_iso_path character varying, v_origin integer, v_initrd_url character varying, v_kernel_url character varying, v_kernel_params character varying) OWNER TO postgres;

--
-- Name: updatevmtemplatedisk(timestamp with time zone, character varying, uuid, uuid, bigint, character varying, character varying, boolean, uuid, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updatevmtemplatedisk(v_creation_date timestamp with time zone, v_description character varying, v_it_guid uuid, v_vtim_it_guid uuid, v_size bigint, v_os character varying, v_os_version character varying, v_bootable boolean, v_vmt_guid uuid, v_internal_drive_mapping character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      UPDATE image_templates
      SET creation_date = v_creation_date,description = v_description,size = v_size, 
      os = v_os,os_version = v_os_version,bootable = v_bootable,
      internal_drive_mapping = v_internal_drive_mapping
      WHERE it_guid = v_it_guid;
END; ';


ALTER FUNCTION public.updatevmtemplatedisk(v_creation_date timestamp with time zone, v_description character varying, v_it_guid uuid, v_vtim_it_guid uuid, v_size bigint, v_os character varying, v_os_version character varying, v_bootable boolean, v_vmt_guid uuid, v_internal_drive_mapping character varying) OWNER TO postgres;

--
-- Name: updatevmtemplatestatus(uuid, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION updatevmtemplatestatus(v_vmt_guid uuid, v_status integer) RETURNS void
    LANGUAGE plpgsql
    AS '
BEGIN
      UPDATE vm_static
      SET    template_status = v_status
      WHERE  vm_guid = v_vmt_guid
      AND    entity_type = ''TEMPLATE'';
END; ';


ALTER FUNCTION public.updatevmtemplatestatus(v_vmt_guid uuid, v_status integer) OWNER TO postgres;

--
-- Name: desktop_vms; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW desktop_vms AS
    SELECT vms.vm_name, vms.vm_mem_size_mb, vms.nice_level, vms.vmt_guid, vms.vm_os, vms.vm_description, vms.vds_group_id, vms.vm_domain, vms.vm_creation_date, vms.auto_startup, vms.is_stateless, vms.dedicated_vm_for_vds, vms.fail_back, vms.default_boot_sequence, vms.vm_type, vms.hypervisor_type, vms.operation_mode, vms.vds_group_name, vms.selection_algorithm, vms.transparent_hugepages, vms.storage_pool_id, vms.storage_pool_name, vms.vds_group_description, vms.vmt_name, vms.vmt_mem_size_mb, vms.vmt_os, vms.vmt_creation_date, vms.vmt_child_count, vms.vmt_num_of_sockets, vms.vmt_cpu_per_socket, vms.vmt_num_of_cpus, vms.vmt_description, vms.status, vms.vm_ip, vms.vm_host, vms.vm_pid, vms.vm_last_up_time, vms.vm_last_boot_time, vms.guest_cur_user_name, vms.guest_last_login_time, vms.guest_cur_user_id, vms.guest_last_logout_time, vms.guest_os, vms.run_on_vds, vms.migrating_to_vds, vms.app_list, vms.display, vms.hibernation_vol_handle, vms.vm_pool_name, vms.vm_pool_id, vms.vm_guid, vms.num_of_monitors, vms.is_initialized, vms.is_auto_suspend, vms.num_of_sockets, vms.cpu_per_socket, vms.usb_policy, vms.acpi_enable, vms.session, vms.num_of_cpus, vms.display_ip, vms.display_type, vms.kvm_enable, vms.boot_sequence, vms.display_secure_port, vms.utc_diff, vms.last_vds_run_on, vms.client_ip, vms.guest_requested_memory, vms.time_zone, vms.cpu_user, vms.cpu_sys, vms.elapsed_time, vms.usage_network_percent, vms.usage_mem_percent, vms.usage_cpu_percent, vms.run_on_vds_name, vms.vds_group_cpu_name, vms.default_display_type, vms.priority, vms.iso_path, vms.origin, vms.vds_group_compatibility_version, vms.initrd_url, vms.kernel_url, vms.kernel_params, vms.pause_status, vms.exit_message, vms.exit_status, vms.migration_support, vms.predefined_properties, vms.userdefined_properties, vms.min_allocated_mem FROM vms WHERE (vms.vm_type = 0);


ALTER TABLE public.desktop_vms OWNER TO postgres;

--
-- Name: dwh_history_timekeeping; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE dwh_history_timekeeping (
    var_name character varying(50) NOT NULL,
    var_value character varying(255),
    var_datetime timestamp with time zone
);


ALTER TABLE public.dwh_history_timekeeping OWNER TO postgres;

--
-- Name: dwh_add_tags_relations_history_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW dwh_add_tags_relations_history_view AS
    ((((SELECT tags.tag_id AS entity_id, tags.parent_id, (18)::smallint AS entity_type, tags._create_date AS attach_date, tags._update_date AS move_date FROM tags WHERE ((tags._create_date > (SELECT dwh_history_timekeeping.var_datetime FROM dwh_history_timekeeping WHERE ((dwh_history_timekeeping.var_name)::text = 'lastSync'::text))) OR (tags._update_date > (SELECT history_timekeeping_1.var_datetime FROM dwh_history_timekeeping history_timekeeping_1 WHERE ((history_timekeeping_1.var_name)::text = 'lastSync'::text)))) UNION ALL SELECT tags_vds_map.vds_id AS entity_id, tags_vds_map.tag_id AS parent_id, (3)::smallint AS entity_type, tags_vds_map._create_date AS attach_date, NULL::timestamp with time zone AS move_date FROM tags_vds_map WHERE (tags_vds_map._create_date > (SELECT dwh_history_timekeeping.var_datetime FROM dwh_history_timekeeping WHERE ((dwh_history_timekeeping.var_name)::text = 'lastSync'::text)))) UNION ALL SELECT tags_vm_pool_map.vm_pool_id AS entity_id, tags_vm_pool_map.tag_id AS parent_id, (5)::smallint AS entity_type, tags_vm_pool_map._create_date AS attach_date, NULL::timestamp with time zone AS move_date FROM tags_vm_pool_map WHERE (tags_vm_pool_map._create_date > (SELECT dwh_history_timekeeping.var_datetime FROM dwh_history_timekeeping WHERE ((dwh_history_timekeeping.var_name)::text = 'lastSync'::text)))) UNION ALL SELECT tags_vm_map.vm_id AS entity_id, tags_vm_map.tag_id AS parent_id, (2)::smallint AS entity_type, tags_vm_map._create_date AS attach_date, NULL::timestamp with time zone AS move_date FROM tags_vm_map WHERE (tags_vm_map._create_date > (SELECT dwh_history_timekeeping.var_datetime FROM dwh_history_timekeeping WHERE ((dwh_history_timekeeping.var_name)::text = 'lastSync'::text)))) UNION ALL SELECT tags_user_map.user_id AS entity_id, tags_user_map.tag_id AS parent_id, (15)::smallint AS entity_type, tags_user_map._create_date AS attach_date, NULL::timestamp with time zone AS move_date FROM tags_user_map WHERE (tags_user_map._create_date > (SELECT dwh_history_timekeeping.var_datetime FROM dwh_history_timekeeping WHERE ((dwh_history_timekeeping.var_name)::text = 'lastSync'::text)))) UNION ALL SELECT tags_user_group_map.group_id AS entity_id, tags_user_group_map.tag_id AS parent_id, (17)::smallint AS entity_type, tags_user_group_map._create_date AS attach_date, NULL::timestamp with time zone AS move_date FROM tags_user_group_map WHERE (tags_user_group_map._create_date > (SELECT dwh_history_timekeeping.var_datetime FROM dwh_history_timekeeping WHERE ((dwh_history_timekeeping.var_name)::text = 'lastSync'::text)));


ALTER TABLE public.dwh_add_tags_relations_history_view OWNER TO postgres;

--
-- Name: dwh_cluster_configuration_history_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW dwh_cluster_configuration_history_view AS
    SELECT vds_groups.vds_group_id AS cluster_id, vds_groups.name AS cluster_name, vds_groups.description AS cluster_description, vds_groups.storage_pool_id AS datacenter_id, vds_groups.cpu_name, vds_groups.compatibility_version, vds_groups._create_date AS create_date, vds_groups._update_date AS update_date FROM vds_groups WHERE ((vds_groups._create_date > (SELECT dwh_history_timekeeping.var_datetime FROM dwh_history_timekeeping WHERE ((dwh_history_timekeeping.var_name)::text = 'lastSync'::text))) OR (vds_groups._update_date > (SELECT history_timekeeping_1.var_datetime FROM dwh_history_timekeeping history_timekeeping_1 WHERE ((history_timekeeping_1.var_name)::text = 'lastSync'::text))));


ALTER TABLE public.dwh_cluster_configuration_history_view OWNER TO postgres;

--
-- Name: dwh_datacenter_configuration_history_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW dwh_datacenter_configuration_history_view AS
    SELECT storage_pool.id AS datacenter_id, storage_pool.name AS datacenter_name, storage_pool.description AS datacenter_description, (storage_pool.storage_pool_type)::smallint AS storage_type, storage_pool._create_date AS create_date, storage_pool._update_date AS update_date FROM storage_pool WHERE ((storage_pool._create_date > (SELECT dwh_history_timekeeping.var_datetime FROM dwh_history_timekeeping WHERE ((dwh_history_timekeeping.var_name)::text = 'lastSync'::text))) OR (storage_pool._update_date > (SELECT history_timekeeping_1.var_datetime FROM dwh_history_timekeeping history_timekeeping_1 WHERE ((history_timekeeping_1.var_name)::text = 'lastSync'::text))));


ALTER TABLE public.dwh_datacenter_configuration_history_view OWNER TO postgres;

--
-- Name: dwh_datacenter_history_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW dwh_datacenter_history_view AS
    SELECT storage_pool.id AS datacenter_id, (storage_pool.status)::smallint AS datacenter_status FROM storage_pool;


ALTER TABLE public.dwh_datacenter_history_view OWNER TO postgres;

--
-- Name: dwh_datacenter_storage_map_history_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW dwh_datacenter_storage_map_history_view AS
    SELECT storage_pool_iso_map.storage_pool_id AS datacenter_id, storage_pool_iso_map.storage_id AS storage_domain_id FROM storage_pool_iso_map;


ALTER TABLE public.dwh_datacenter_storage_map_history_view OWNER TO postgres;

--
-- Name: dwh_disk_vm_map_history_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW dwh_disk_vm_map_history_view AS
    SELECT image_vm_map.image_id AS vm_disk_id, image_vm_map.vm_id FROM image_vm_map WHERE (image_vm_map.active = true) UNION ALL SELECT image_vm_pool_map.image_guid AS vm_disk_id, image_vm_pool_map.vm_guid AS vm_id FROM image_vm_pool_map;


ALTER TABLE public.dwh_disk_vm_map_history_view OWNER TO postgres;

--
-- Name: dwh_host_configuration_full_check_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW dwh_host_configuration_full_check_view AS
    SELECT a.vds_id AS host_id, a.vds_unique_id AS host_unique_id, a.vds_name AS host_name, a.vds_group_id AS cluster_id, (a.vds_type)::smallint AS host_type, a.host_name AS fqn_or_ip, b.physical_mem_mb AS memory_size_mb, (c.swap_total)::integer AS swap_size_mb, b.cpu_model, (b.cpu_cores)::smallint AS number_of_cores, b.host_os, a.ip AS pm_ip_address, b.kernel_version, b.kvm_version, CASE substr((b.software_version)::text, 1, 3) WHEN '4.4'::text THEN (('2.1'::text || substr((b.software_version)::text, 4, length((b.software_version)::text))))::character varying WHEN '4.5'::text THEN (('2.2'::text || substr((b.software_version)::text, 4, length((b.software_version)::text))))::character varying WHEN '4.9'::text THEN (('2.3'::text || substr((b.software_version)::text, 4, length((b.software_version)::text))))::character varying ELSE b.software_version END AS vdsm_version, a.port AS vdsm_port, a._create_date AS create_date, a._update_date AS update_date FROM ((vds_static a JOIN vds_dynamic b ON ((a.vds_id = b.vds_id))) JOIN vds_statistics c ON ((c.vds_id = a.vds_id)));


ALTER TABLE public.dwh_host_configuration_full_check_view OWNER TO postgres;

--
-- Name: dwh_host_configuration_history_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW dwh_host_configuration_history_view AS
    SELECT a.vds_id AS host_id, a.vds_unique_id AS host_unique_id, a.vds_name AS host_name, a.vds_group_id AS cluster_id, (a.vds_type)::smallint AS host_type, a.host_name AS fqn_or_ip, b.physical_mem_mb AS memory_size_mb, (c.swap_total)::integer AS swap_size_mb, b.cpu_model, (b.cpu_cores)::smallint AS number_of_cores, b.host_os, a.ip AS pm_ip_address, b.kernel_version, b.kvm_version, b.software_version AS vdsm_version, a.port AS vdsm_port, a._create_date AS create_date, a._update_date AS update_date FROM ((vds_static a JOIN vds_dynamic b ON ((a.vds_id = b.vds_id))) JOIN vds_statistics c ON ((c.vds_id = a.vds_id))) WHERE ((a._create_date > (SELECT dwh_history_timekeeping.var_datetime FROM dwh_history_timekeeping WHERE ((dwh_history_timekeeping.var_name)::text = 'lastSync'::text))) OR (a._update_date > (SELECT history_timekeeping_1.var_datetime FROM dwh_history_timekeeping history_timekeeping_1 WHERE ((history_timekeeping_1.var_name)::text = 'lastSync'::text))));


ALTER TABLE public.dwh_host_configuration_history_view OWNER TO postgres;

--
-- Name: dwh_host_history_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW dwh_host_history_view AS
    SELECT b.vds_id AS host_id, (b.status)::smallint AS host_status, (c.usage_mem_percent)::smallint AS memory_usage_percent, (c.usage_cpu_percent)::smallint AS cpu_usage_percent, (c.ksm_cpu_percent)::smallint AS ksm_cpu_percent, (c.cpu_load)::integer AS cpu_load, (c.cpu_sys)::smallint AS system_cpu_usage_percent, (c.cpu_user)::smallint AS user_cpu_usage_percent, ((c.swap_total - c.swap_free))::integer AS swap_used_mb, (b.vm_active)::smallint AS vm_active, (b.vm_count)::smallint AS total_vms, b.vms_cores_count AS total_vms_vcpus FROM vds_dynamic b, vds_statistics c WHERE (b.vds_id = c.vds_id);


ALTER TABLE public.dwh_host_history_view OWNER TO postgres;

--
-- Name: dwh_host_interface_configuration_history_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW dwh_host_interface_configuration_history_view AS
    SELECT a.id AS host_interface_id, a.name AS host_interface_name, a.vds_id AS host_id, (a.type)::smallint AS host_interface_type, a.speed AS host_interface_speed_bps, a.mac_addr AS mac_address, a.network_name, a.addr AS ip_address, a.gateway, a.is_bond AS bond, a.bond_name, a.vlan_id, a._create_date AS create_date, a._update_date AS update_date FROM vds_interface a WHERE (((a._create_date > (SELECT dwh_history_timekeeping.var_datetime FROM dwh_history_timekeeping WHERE ((dwh_history_timekeeping.var_name)::text = 'lastSync'::text))) OR (a._update_date > (SELECT history_timekeeping_1.var_datetime FROM dwh_history_timekeeping history_timekeeping_1 WHERE ((history_timekeeping_1.var_name)::text = 'lastSync'::text)))) AND ((a.is_bond IS NULL) OR ((a.is_bond = true) AND ((a.name)::text IN (SELECT b.bond_name FROM vds_interface b WHERE ((b.is_bond IS NULL) AND (b.vds_id = a.vds_id)))))));


ALTER TABLE public.dwh_host_interface_configuration_history_view OWNER TO postgres;

--
-- Name: dwh_host_interface_history_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW dwh_host_interface_history_view AS
    SELECT vds_interface_statistics.id AS host_interface_id, (vds_interface_statistics.rx_rate)::smallint AS receive_rate_percent, (vds_interface_statistics.tx_rate)::smallint AS transmit_rate_percent FROM vds_interface_statistics;


ALTER TABLE public.dwh_host_interface_history_view OWNER TO postgres;

--
-- Name: dwh_remove_tags_relations_history_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW dwh_remove_tags_relations_history_view AS
    ((((SELECT tags.tag_id AS entity_id, tags.parent_id FROM tags UNION ALL SELECT tags_vds_map.vds_id AS entity_id, tags_vds_map.tag_id AS parent_id FROM tags_vds_map) UNION ALL SELECT tags_vm_pool_map.vm_pool_id AS entity_id, tags_vm_pool_map.tag_id AS parent_id FROM tags_vm_pool_map) UNION ALL SELECT tags_vm_map.vm_id AS entity_id, tags_vm_map.tag_id AS parent_id FROM tags_vm_map) UNION ALL SELECT tags_user_map.user_id AS entity_id, tags_user_map.tag_id AS parent_id FROM tags_user_map) UNION ALL SELECT tags_user_group_map.group_id AS entity_id, tags_user_group_map.tag_id AS parent_id FROM tags_user_group_map;


ALTER TABLE public.dwh_remove_tags_relations_history_view OWNER TO postgres;

--
-- Name: dwh_storage_domain_configuration_history_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW dwh_storage_domain_configuration_history_view AS
    SELECT storage_domain_static.id AS storage_domain_id, storage_domain_static.storage_name AS storage_domain_name, (storage_domain_static.storage_domain_type)::smallint AS storage_domain_type, (storage_domain_static.storage_type)::smallint AS storage_type, storage_domain_static._create_date AS create_date, storage_domain_static._update_date AS update_date FROM storage_domain_static WHERE ((storage_domain_static._create_date > (SELECT dwh_history_timekeeping.var_datetime FROM dwh_history_timekeeping WHERE ((dwh_history_timekeeping.var_name)::text = 'lastSync'::text))) OR (storage_domain_static._update_date > (SELECT history_timekeeping_1.var_datetime FROM dwh_history_timekeeping history_timekeeping_1 WHERE ((history_timekeeping_1.var_name)::text = 'lastSync'::text))));


ALTER TABLE public.dwh_storage_domain_configuration_history_view OWNER TO postgres;

--
-- Name: dwh_storage_domain_history_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW dwh_storage_domain_history_view AS
    SELECT storage_domain_dynamic.id AS storage_domain_id, storage_domain_dynamic.available_disk_size AS available_disk_size_gb, storage_domain_dynamic.used_disk_size AS used_disk_size_gb FROM storage_domain_dynamic;


ALTER TABLE public.dwh_storage_domain_history_view OWNER TO postgres;

--
-- Name: dwh_tags_details_history_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW dwh_tags_details_history_view AS
    SELECT tags.tag_id, tags.tag_name, tags.description AS tag_description, tags._create_date AS create_date, tags._update_date AS update_date FROM tags WHERE ((tags._create_date > (SELECT dwh_history_timekeeping.var_datetime FROM dwh_history_timekeeping WHERE ((dwh_history_timekeeping.var_name)::text = 'lastSync'::text))) OR (tags._update_date > (SELECT history_timekeeping_1.var_datetime FROM dwh_history_timekeeping history_timekeeping_1 WHERE ((history_timekeeping_1.var_name)::text = 'lastSync'::text))));


ALTER TABLE public.dwh_tags_details_history_view OWNER TO postgres;

--
-- Name: dwh_vm_configuration_history_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW dwh_vm_configuration_history_view AS
    SELECT a.vm_guid AS vm_id, a.vm_name, a.description AS vm_description, (a.vm_type)::smallint AS vm_type, a.vds_group_id AS cluster_id, a.vmt_guid AS template_id, b.vm_name AS template_name, (a.cpu_per_socket)::smallint AS cpu_per_socket, (a.num_of_sockets)::smallint AS number_of_sockets, a.mem_size_mb AS memory_size_mb, (a.os)::smallint AS operating_system, a.domain AS ad_domain, a.dedicated_vm_for_vds AS default_host, a.auto_startup AS high_availability, a.is_initialized AS initialized, a.is_stateless AS stateless, a.fail_back, a.is_auto_suspend AS auto_suspend, (a.usb_policy)::smallint AS usb_policy, a.time_zone, a._create_date AS create_date, a._update_date AS update_date FROM (vm_static a JOIN vm_static b ON ((a.vmt_guid = b.vm_guid))) WHERE ((((a.entity_type)::text = 'VM'::text) AND ((b.entity_type)::text = 'TEMPLATE'::text)) AND (((a._create_date > (SELECT dwh_history_timekeeping.var_datetime FROM dwh_history_timekeeping WHERE ((dwh_history_timekeeping.var_name)::text = 'lastSync'::text))) OR (a._update_date > (SELECT history_timekeeping_1.var_datetime FROM dwh_history_timekeeping history_timekeeping_1 WHERE ((history_timekeeping_1.var_name)::text = 'lastSync'::text)))) OR (b._update_date > (SELECT history_timekeeping_1.var_datetime FROM dwh_history_timekeeping history_timekeeping_1 WHERE ((history_timekeeping_1.var_name)::text = 'lastSync'::text)))));


ALTER TABLE public.dwh_vm_configuration_history_view OWNER TO postgres;

--
-- Name: dwh_vm_disk_configuration_history_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW dwh_vm_disk_configuration_history_view AS
    SELECT images.image_guid AS vm_disk_id, images.storage_id AS storage_domain_id, (images.internal_drive_mapping)::smallint AS vm_internal_drive_mapping, images.description AS vm_disk_description, ((images.size / 1048576))::integer AS vm_disk_size_mb, (images.volume_type)::smallint AS vm_disk_type, (images.volume_format)::smallint AS vm_disk_format, (images.disk_interface)::smallint AS vm_disk_interface, images._create_date AS create_date, images._update_date AS update_date FROM (images JOIN disk_image_dynamic ON ((images.image_guid = disk_image_dynamic.image_id))) WHERE ((images._create_date > (SELECT dwh_history_timekeeping.var_datetime FROM dwh_history_timekeeping WHERE ((dwh_history_timekeeping.var_name)::text = 'lastSync'::text))) OR (images._update_date > (SELECT history_timekeeping_1.var_datetime FROM dwh_history_timekeeping history_timekeeping_1 WHERE ((history_timekeeping_1.var_name)::text = 'lastSync'::text))));


ALTER TABLE public.dwh_vm_disk_configuration_history_view OWNER TO postgres;

--
-- Name: dwh_vm_disks_history_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW dwh_vm_disks_history_view AS
    SELECT images.image_guid AS vm_disk_id, (images.imagestatus)::smallint AS vm_disk_status, ((disk_image_dynamic.actual_size / 1048576))::integer AS vm_disk_actual_size_mb, disk_image_dynamic.read_rate AS read_rate_bytes_per_second, disk_image_dynamic.read_latency_seconds, disk_image_dynamic.write_rate AS write_rate_bytes_per_second, disk_image_dynamic.write_latency_seconds, disk_image_dynamic.flush_latency_seconds FROM (images JOIN disk_image_dynamic ON ((images.image_guid = disk_image_dynamic.image_id)));


ALTER TABLE public.dwh_vm_disks_history_view OWNER TO postgres;

--
-- Name: dwh_vm_history_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW dwh_vm_history_view AS
    SELECT c.vm_guid AS vm_id, (b.status)::smallint AS vm_status, (c.usage_cpu_percent)::smallint AS cpu_usage_percent, (c.usage_mem_percent)::smallint AS memory_usage_percent, (c.cpu_sys)::smallint AS system_cpu_usage_percent, (c.cpu_user)::smallint AS user_cpu_usage_percent, c.disks_usage, b.vm_last_up_time, b.vm_last_boot_time, b.vm_ip, b.guest_cur_user_name AS current_user_name, b.run_on_vds AS currently_running_on_host FROM vm_dynamic b, vm_statistics c WHERE (c.vm_guid = b.vm_guid);


ALTER TABLE public.dwh_vm_history_view OWNER TO postgres;

--
-- Name: dwh_vm_interface_configuration_history_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW dwh_vm_interface_configuration_history_view AS
    SELECT vm_interface.id AS vm_interface_id, vm_interface.name AS vm_interface_name, vm_interface.vm_guid AS vm_id, (vm_interface.type)::smallint AS vm_interface_type, vm_interface.speed AS vm_interface_speed_bps, vm_interface.mac_addr AS mac_address, vm_interface.network_name, vm_interface._create_date AS create_date, vm_interface._update_date AS update_date FROM vm_interface WHERE ((vm_interface._create_date > (SELECT dwh_history_timekeeping.var_datetime FROM dwh_history_timekeeping WHERE ((dwh_history_timekeeping.var_name)::text = 'lastSync'::text))) OR (vm_interface._update_date > (SELECT history_timekeeping_1.var_datetime FROM dwh_history_timekeeping history_timekeeping_1 WHERE ((history_timekeeping_1.var_name)::text = 'lastSync'::text))));


ALTER TABLE public.dwh_vm_interface_configuration_history_view OWNER TO postgres;

--
-- Name: dwh_vm_interface_history_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW dwh_vm_interface_history_view AS
    SELECT vm_interface_statistics.id AS vm_interface_id, (vm_interface_statistics.rx_rate)::smallint AS receive_rate_percent, (vm_interface_statistics.tx_rate)::smallint AS transmit_rate_percent FROM vm_interface_statistics;


ALTER TABLE public.dwh_vm_interface_history_view OWNER TO postgres;

--
-- Name: engine_license_usage; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE engine_license_usage (
    date timestamp with time zone NOT NULL,
    quarter character(7) NOT NULL,
    lic_desktops integer NOT NULL,
    max_used_desktops integer NOT NULL,
    lic_sockets integer NOT NULL,
    max_used_sockets integer NOT NULL
);


ALTER TABLE public.engine_license_usage OWNER TO postgres;

--
-- Name: schema_version_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE schema_version_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.schema_version_seq OWNER TO postgres;

--
-- Name: schema_version_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('schema_version_seq', 69, true);


SET default_with_oids = false;

--
-- Name: schema_version; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE schema_version (
    id integer DEFAULT nextval('schema_version_seq'::regclass) NOT NULL,
    version character varying(10) NOT NULL,
    script character varying(255) NOT NULL,
    checksum character varying(128),
    installed_by character varying(30) NOT NULL,
    started_at timestamp without time zone DEFAULT now(),
    ended_at timestamp without time zone,
    state character varying(15) NOT NULL,
    current boolean NOT NULL
);


ALTER TABLE public.schema_version OWNER TO postgres;

--
-- Name: server_vms; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW server_vms AS
    SELECT vms.vm_name, vms.vm_mem_size_mb, vms.nice_level, vms.vmt_guid, vms.vm_os, vms.vm_description, vms.vds_group_id, vms.vm_domain, vms.vm_creation_date, vms.auto_startup, vms.is_stateless, vms.dedicated_vm_for_vds, vms.fail_back, vms.default_boot_sequence, vms.vm_type, vms.hypervisor_type, vms.operation_mode, vms.vds_group_name, vms.selection_algorithm, vms.transparent_hugepages, vms.storage_pool_id, vms.storage_pool_name, vms.vds_group_description, vms.vmt_name, vms.vmt_mem_size_mb, vms.vmt_os, vms.vmt_creation_date, vms.vmt_child_count, vms.vmt_num_of_sockets, vms.vmt_cpu_per_socket, vms.vmt_num_of_cpus, vms.vmt_description, vms.status, vms.vm_ip, vms.vm_host, vms.vm_pid, vms.vm_last_up_time, vms.vm_last_boot_time, vms.guest_cur_user_name, vms.guest_last_login_time, vms.guest_cur_user_id, vms.guest_last_logout_time, vms.guest_os, vms.run_on_vds, vms.migrating_to_vds, vms.app_list, vms.display, vms.hibernation_vol_handle, vms.vm_pool_name, vms.vm_pool_id, vms.vm_guid, vms.num_of_monitors, vms.is_initialized, vms.is_auto_suspend, vms.num_of_sockets, vms.cpu_per_socket, vms.usb_policy, vms.acpi_enable, vms.session, vms.num_of_cpus, vms.display_ip, vms.display_type, vms.kvm_enable, vms.boot_sequence, vms.display_secure_port, vms.utc_diff, vms.last_vds_run_on, vms.client_ip, vms.guest_requested_memory, vms.time_zone, vms.cpu_user, vms.cpu_sys, vms.elapsed_time, vms.usage_network_percent, vms.usage_mem_percent, vms.usage_cpu_percent, vms.run_on_vds_name, vms.vds_group_cpu_name, vms.default_display_type, vms.priority, vms.iso_path, vms.origin, vms.vds_group_compatibility_version, vms.initrd_url, vms.kernel_url, vms.kernel_params, vms.pause_status, vms.exit_message, vms.exit_status, vms.migration_support, vms.predefined_properties, vms.userdefined_properties, vms.min_allocated_mem FROM vms WHERE (vms.vm_type = 1);


ALTER TABLE public.server_vms OWNER TO postgres;

--
-- Name: storage_domains_with_hosts_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW storage_domains_with_hosts_view AS
    SELECT storage_domain_static.id, storage_domain_static.storage, storage_domain_static.storage_name, storage_domain_dynamic.available_disk_size, storage_domain_dynamic.used_disk_size, fn_get_disk_commited_value_by_storage(storage_domain_static.id) AS commited_disk_size, storage_pool.name AS storage_pool_name, storage_domain_static.storage_type, storage_domain_static.storage_domain_type, storage_domain_static.storage_domain_format_type, fn_get_storage_domain_shared_status_by_domain_id(storage_domain_static.id, storage_domain_static.storage, storage_domain_static.storage_type) AS storage_domain_shared_status, vds_groups.vds_group_id, vds_static.vds_id, storage_pool_iso_map.storage_pool_id FROM (((((storage_domain_static JOIN storage_domain_dynamic ON ((storage_domain_static.id = storage_domain_dynamic.id))) LEFT JOIN storage_pool_iso_map ON ((storage_domain_static.id = storage_pool_iso_map.storage_id))) LEFT JOIN storage_pool ON ((storage_pool_iso_map.storage_pool_id = storage_pool.id))) LEFT JOIN vds_groups ON ((storage_pool_iso_map.storage_pool_id = vds_groups.storage_pool_id))) LEFT JOIN vds_static ON ((vds_groups.vds_group_id = vds_static.vds_group_id)));


ALTER TABLE public.storage_domains_with_hosts_view OWNER TO postgres;

--
-- Name: storage_pool_with_storage_domain; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW storage_pool_with_storage_domain AS
    SELECT storage_pool.id, storage_pool.name, storage_pool.description, storage_pool.storage_pool_type, storage_pool.status, storage_pool.master_domain_version, storage_pool.spm_vds_id, storage_pool.compatibility_version, storage_pool._create_date, storage_pool._update_date, storage_pool_iso_map.storage_id, storage_pool_iso_map.storage_pool_id, storage_pool_iso_map.owner, storage_domain_static.storage_type, storage_domain_static.storage_domain_type, storage_domain_static.storage_domain_format_type, storage_domain_static.storage_name, storage_domain_static.storage FROM ((storage_pool LEFT JOIN storage_pool_iso_map ON ((storage_pool.id = storage_pool_iso_map.storage_pool_id))) LEFT JOIN storage_domain_static ON ((storage_pool_iso_map.storage_id = storage_domain_static.id)));


ALTER TABLE public.storage_pool_with_storage_domain OWNER TO postgres;

--
-- Name: users_and_groups_to_vm_pool_map_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW users_and_groups_to_vm_pool_map_view AS
    SELECT p.vm_pool_id, p.vm_pool_name, per.ad_element_id AS user_id, tmap.start_time AS "from", tmap.end_time AS "to" FROM ((vm_pools p JOIN permissions per ON ((per.object_id = p.vm_pool_id))) LEFT JOIN time_lease_vm_pool_map tmap ON ((tmap.vm_pool_id = p.vm_pool_id)));


ALTER TABLE public.users_and_groups_to_vm_pool_map_view OWNER TO postgres;

--
-- Name: vdc_db_log_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vdc_db_log_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.vdc_db_log_seq OWNER TO postgres;

--
-- Name: vdc_db_log_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('vdc_db_log_seq', 1, false);


SET default_with_oids = true;

--
-- Name: vdc_db_log; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vdc_db_log (
    error_id bigint DEFAULT nextval('vdc_db_log_seq'::regclass) NOT NULL,
    occured_at timestamp with time zone DEFAULT ('now'::text)::timestamp without time zone NOT NULL,
    error_code character varying(16) NOT NULL,
    error_message character varying(2048),
    error_proc character varying(126),
    error_line integer
);


ALTER TABLE public.vdc_db_log OWNER TO postgres;

--
-- Name: vdc_users; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW vdc_users AS
    SELECT 'user'::text AS user_group, users_1.name, users_1.user_id, users_1.surname, users_1.domain, users_1.username, users_1.groups, users_1.department, users_1.role, users_1.user_icon_path, users_1.desktop_device, users_1.email, users_1.note, users_1.status, 0 AS vm_admin, users_1.session_count, users_1.last_admin_check_status, users_1.group_ids FROM users users_1 UNION SELECT 'group'::text AS user_group, ad_groups.name, ad_groups.id AS user_id, ''::character varying AS surname, ad_groups.domain, ''::character varying AS username, ''::character varying AS groups, ''::character varying AS department, ''::character varying AS role, ''::character varying AS user_icon_path, ''::character varying AS desktop_device, ''::character varying AS email, ''::character varying AS note, ad_groups.status, 1 AS vm_admin, 0 AS session_count, NULL::boolean AS last_admin_check_status, ''::text AS group_ids FROM ad_groups;


ALTER TABLE public.vdc_users OWNER TO postgres;

--
-- Name: vdc_users_with_tags; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW vdc_users_with_tags AS
    SELECT users_1.user_group, users_1.name, permissions.object_id AS vm_guid, users_1.user_id, users_1.surname, users_1.domain, users_1.username, users_1.groups, users_1.department, users_1.role, roles1.name AS mla_role, users_1.user_icon_path, users_1.desktop_device, users_1.email, users_1.note, users_1.status, users_1.vm_admin, tags_user_map_view_1.tag_name, tags_user_map_view_1.tag_id, users_1.session_count, users_1.last_admin_check_status, users_1.group_ids, pools.vm_pool_name FROM (((((vdc_users users_1 LEFT JOIN users_and_groups_to_vm_pool_map_view pools ON ((users_1.user_id = pools.user_id))) LEFT JOIN permissions ON ((users_1.user_id = permissions.ad_element_id))) LEFT JOIN tags ON ((tags.type = 1))) LEFT JOIN tags_user_map_view tags_user_map_view_1 ON ((users_1.user_id = tags_user_map_view_1.user_id))) LEFT JOIN roles roles1 ON ((roles1.id = permissions.role_id))) WHERE (users_1.user_group = 'user'::text) UNION SELECT users_2.user_group, users_2.name, permissions_1.object_id AS vm_guid, users_2.user_id, users_2.surname, users_2.domain, users_2.username, users_2.groups, users_2.department, users_2.role, roles2.name AS mla_role, users_2.user_icon_path, users_2.desktop_device, users_2.email, users_2.note, users_2.status, users_2.vm_admin, tags_user_group_map_view.tag_name, tags_user_group_map_view.tag_id, users_2.session_count, users_2.last_admin_check_status, users_2.group_ids, pools1.vm_pool_name FROM (((((vdc_users users_2 LEFT JOIN users_and_groups_to_vm_pool_map_view pools1 ON ((users_2.user_id = pools1.user_id))) LEFT JOIN permissions permissions_1 ON ((users_2.user_id = permissions_1.ad_element_id))) LEFT JOIN tags tags_1 ON ((tags_1.type = 1))) LEFT JOIN tags_user_group_map_view ON ((users_2.user_id = tags_user_group_map_view.group_id))) LEFT JOIN roles roles2 ON ((roles2.id = permissions_1.role_id))) WHERE (users_2.user_group = 'group'::text);


ALTER TABLE public.vdc_users_with_tags OWNER TO postgres;

--
-- Name: vds_groups_storage_domain; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW vds_groups_storage_domain AS
    SELECT vds_groups.vds_group_id, vds_groups.name, vds_groups.description, vds_groups.cpu_name, vds_groups._create_date, vds_groups._update_date, vds_groups.selection_algorithm, vds_groups.high_utilization, vds_groups.low_utilization, vds_groups.cpu_over_commit_duration_minutes, vds_groups.hypervisor_type, vds_groups.storage_pool_id, vds_groups.max_vds_memory_over_commit, vds_groups.compatibility_version, vds_groups.transparent_hugepages, vds_groups.migrate_on_error, storage_pool_iso_map.storage_id FROM (vds_groups LEFT JOIN storage_pool_iso_map ON ((vds_groups.storage_pool_id = storage_pool_iso_map.storage_pool_id)));


ALTER TABLE public.vds_groups_storage_domain OWNER TO postgres;

--
-- Name: vds_with_tags; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW vds_with_tags AS
    SELECT vds_groups.vds_group_id, vds_groups.name AS vds_group_name, vds_groups.description AS vds_group_description, vds_groups.selection_algorithm, vds_static.vds_id, vds_static.vds_name, vds_static.ip, vds_static.vds_unique_id, vds_static.host_name, vds_static.port, vds_static.vds_strength, vds_static.server_ssl_enabled, vds_static.vds_type, vds_static.pm_type, vds_static.pm_user, vds_static.pm_password, vds_static.pm_port, vds_static.pm_options, vds_static.pm_enabled, vds_dynamic.hooks, vds_dynamic.status, vds_dynamic.cpu_cores, vds_dynamic.cpu_model, vds_dynamic.cpu_speed_mh, vds_dynamic.if_total_speed, vds_dynamic.kvm_enabled, vds_dynamic.physical_mem_mb, vds_dynamic.pending_vcpus_count, vds_dynamic.pending_vmem_size, vds_dynamic.mem_commited, vds_dynamic.vm_active, vds_dynamic.vm_count, vds_dynamic.vm_migrating, vds_dynamic.vms_cores_count, vds_dynamic.cpu_over_commit_time_stamp, vds_dynamic.hypervisor_type, vds_dynamic.net_config_dirty, vds_groups.high_utilization, vds_groups.low_utilization, vds_groups.max_vds_memory_over_commit, vds_groups.cpu_over_commit_duration_minutes, storage_pool.id AS storage_pool_id, storage_pool.name AS storage_pool_name, tags_vds_map_view.tag_name, tags_vds_map_view.tag_id, vds_dynamic.reserved_mem, vds_dynamic.guest_overhead, vds_dynamic.software_version, vds_dynamic.version_name, vds_dynamic.build_name, vds_dynamic.previous_status, vds_statistics.cpu_idle, vds_statistics.cpu_load, vds_statistics.cpu_sys, vds_statistics.cpu_user, vds_statistics.usage_mem_percent, vds_statistics.usage_cpu_percent, vds_statistics.usage_network_percent, vds_statistics.mem_available, vds_statistics.mem_shared, vds_statistics.swap_free, vds_statistics.swap_total, vds_statistics.ksm_cpu_percent, vds_statistics.ksm_pages, vds_statistics.ksm_state, vds_dynamic.cpu_flags, vds_groups.cpu_name AS vds_group_cpu_name, vds_dynamic.cpu_sockets, vds_spm_id_map.vds_spm_id, vds_static.otp_validity, CASE WHEN (storage_pool.spm_vds_id = vds_static.vds_id) THEN CASE WHEN (storage_pool.status = 5) THEN 1 ELSE 2 END ELSE 0 END AS spm_status, vds_dynamic.supported_cluster_levels, vds_dynamic.supported_engines, vds_groups.compatibility_version AS vds_group_compatibility_version, vds_dynamic.host_os, vds_dynamic.kvm_version, vds_dynamic.spice_version, vds_dynamic.kernel_version, vds_dynamic.iscsi_initiator_name, vds_dynamic.transparent_hugepages_state, vds_dynamic.anonymous_hugepages, vds_dynamic.non_operational_reason, storage_pool_iso_map.storage_id FROM (((((((vds_groups JOIN vds_static ON ((vds_groups.vds_group_id = vds_static.vds_group_id))) JOIN vds_dynamic ON ((vds_static.vds_id = vds_dynamic.vds_id))) JOIN vds_statistics ON ((vds_static.vds_id = vds_statistics.vds_id))) LEFT JOIN storage_pool ON ((vds_groups.storage_pool_id = storage_pool.id))) LEFT JOIN tags_vds_map_view ON ((vds_static.vds_id = tags_vds_map_view.vds_id))) LEFT JOIN vds_spm_id_map ON ((vds_static.vds_id = vds_spm_id_map.vds_id))) LEFT JOIN storage_pool_iso_map ON ((storage_pool_iso_map.storage_pool_id = storage_pool.id)));


ALTER TABLE public.vds_with_tags OWNER TO postgres;

--
-- Name: vm_template_image_map; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm_template_image_map (
    it_guid uuid NOT NULL,
    vmt_guid uuid NOT NULL,
    internal_drive_mapping character varying(50) NOT NULL
);


ALTER TABLE public.vm_template_image_map OWNER TO postgres;

--
-- Name: vm_templates; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm_templates (
    vmt_guid uuid NOT NULL,
    name character varying(40) NOT NULL,
    mem_size_mb integer NOT NULL,
    os integer DEFAULT 0 NOT NULL,
    creation_date timestamp with time zone NOT NULL,
    child_count integer DEFAULT 0 NOT NULL,
    num_of_sockets integer DEFAULT 1 NOT NULL,
    cpu_per_socket integer DEFAULT 1 NOT NULL,
    description character varying(4000),
    vds_group_id uuid NOT NULL,
    domain character varying(40),
    num_of_monitors integer NOT NULL,
    status integer NOT NULL,
    usb_policy integer,
    time_zone character varying(40),
    is_auto_suspend boolean DEFAULT false,
    fail_back boolean DEFAULT false NOT NULL,
    vm_type integer DEFAULT 0 NOT NULL,
    hypervisor_type integer DEFAULT 0 NOT NULL,
    operation_mode integer DEFAULT 0 NOT NULL,
    nice_level integer DEFAULT 0 NOT NULL,
    default_boot_sequence integer DEFAULT 0 NOT NULL,
    default_display_type integer DEFAULT 0 NOT NULL,
    priority integer DEFAULT 0 NOT NULL,
    auto_startup boolean,
    is_stateless boolean,
    iso_path character varying(4000) DEFAULT ''::character varying,
    initrd_url character varying(4000),
    kernel_url character varying(4000),
    kernel_params character varying(4000),
    origin integer DEFAULT 0,
    _update_date timestamp with time zone DEFAULT now()
);


ALTER TABLE public.vm_templates OWNER TO postgres;

--
-- Name: vm_templates_storage_domain; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW vm_templates_storage_domain AS
    SELECT vm_templates.vm_guid AS vmt_guid, vm_templates.vm_name AS name, vm_templates.mem_size_mb, vm_templates.os, vm_templates.creation_date, vm_templates.child_count, vm_templates.num_of_sockets, vm_templates.cpu_per_socket, (vm_templates.num_of_sockets * vm_templates.cpu_per_socket) AS num_of_cpus, vm_templates.description, vm_templates.vds_group_id, vm_templates.domain, vm_templates.num_of_monitors, vm_templates.template_status AS status, vm_templates.usb_policy, vm_templates.time_zone, vm_templates.is_auto_suspend, vm_templates.fail_back, vds_groups.name AS vds_group_name, vm_templates.vm_type, vm_templates.hypervisor_type, vm_templates.operation_mode, vm_templates.nice_level, storage_pool.id AS storage_pool_id, storage_pool.name AS storage_pool_name, vm_templates.default_boot_sequence, vm_templates.default_display_type, vm_templates.priority, vm_templates.auto_startup, vm_templates.is_stateless, vm_templates.iso_path, vm_templates.origin, vm_templates.initrd_url, vm_templates.kernel_url, vm_templates.kernel_params, images.storage_id FROM ((((vm_static vm_templates JOIN vds_groups ON ((vm_templates.vds_group_id = vds_groups.vds_group_id))) LEFT JOIN storage_pool ON ((storage_pool.id = vds_groups.storage_pool_id))) JOIN image_vm_map vm_template_image_map ON ((vm_template_image_map.vm_id = vm_templates.vm_guid))) LEFT JOIN images ON ((images.image_guid = vm_template_image_map.image_id))) WHERE ((vm_templates.entity_type)::text = 'TEMPLATE'::text) UNION SELECT vm_templates_1.vm_guid AS vmt_guid, vm_templates_1.vm_name AS name, vm_templates_1.mem_size_mb, vm_templates_1.os, vm_templates_1.creation_date, vm_templates_1.child_count, vm_templates_1.num_of_sockets, vm_templates_1.cpu_per_socket, (vm_templates_1.num_of_sockets * vm_templates_1.cpu_per_socket) AS num_of_cpus, vm_templates_1.description, vm_templates_1.vds_group_id, vm_templates_1.domain, vm_templates_1.num_of_monitors, vm_templates_1.template_status AS status, vm_templates_1.usb_policy, vm_templates_1.time_zone, vm_templates_1.is_auto_suspend, vm_templates_1.fail_back, vds_groups_1.name AS vds_group_name, vm_templates_1.vm_type, vm_templates_1.hypervisor_type, vm_templates_1.operation_mode, vm_templates_1.nice_level, storage_pool_1.id AS storage_pool_id, storage_pool_1.name AS storage_pool_name, vm_templates_1.default_boot_sequence, vm_templates_1.default_display_type, vm_templates_1.priority, vm_templates_1.auto_startup, vm_templates_1.is_stateless, vm_templates_1.iso_path, vm_templates_1.origin, vm_templates_1.initrd_url, vm_templates_1.kernel_url, vm_templates_1.kernel_params, image_group_storage_domain_map.storage_domain_id AS storage_id FROM (((((vm_static vm_templates_1 JOIN vds_groups vds_groups_1 ON ((vm_templates_1.vds_group_id = vds_groups_1.vds_group_id))) LEFT JOIN storage_pool storage_pool_1 ON ((storage_pool_1.id = vds_groups_1.storage_pool_id))) JOIN image_vm_map vm_template_image_map_1 ON ((vm_template_image_map_1.vm_id = vm_templates_1.vm_guid))) JOIN images images_1 ON ((images_1.image_guid = vm_template_image_map_1.image_id))) JOIN image_group_storage_domain_map ON ((image_group_storage_domain_map.image_group_id = images_1.image_group_id))) WHERE ((vm_templates_1.entity_type)::text = 'TEMPLATE'::text);


ALTER TABLE public.vm_templates_storage_domain OWNER TO postgres;

--
-- Name: vms_with_tags; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW vms_with_tags AS
    SELECT vms.vm_name, vms.vm_mem_size_mb, vms.nice_level, vms.vmt_guid, vms.vm_os, vms.vm_description, vms.vds_group_id, vms.vm_domain, vms.vm_creation_date, vms.auto_startup, vms.is_stateless, vms.dedicated_vm_for_vds, vms.fail_back, vms.default_boot_sequence, vms.vm_type, vms.hypervisor_type, vms.operation_mode, vms.vds_group_name, vms.selection_algorithm, vms.storage_pool_id, vms.storage_pool_name, vms.vds_group_description, vms.vmt_name, vms.vmt_mem_size_mb, vms.vmt_os, vms.vmt_creation_date, vms.vmt_child_count, vms.vmt_num_of_sockets, vms.vmt_cpu_per_socket, vms.vmt_description, vms.status, vms.vm_ip, vms.vm_host, (vms.vmt_num_of_sockets * vms.vmt_cpu_per_socket) AS vmt_num_of_cpus, vms.vm_pid, vms.vm_last_up_time, vms.vm_last_boot_time, vms.guest_cur_user_name, vms.guest_last_login_time, vms.guest_cur_user_id, vms.guest_last_logout_time, vms.guest_os, vms.run_on_vds, vms.migrating_to_vds, vms.app_list, vms.display, vms.hibernation_vol_handle, vms.vm_pool_name, vms.vm_pool_id, vms.vm_guid, vms.num_of_monitors, vms.is_initialized, vms.is_auto_suspend, vms.num_of_sockets, vms.cpu_per_socket, vms.usb_policy, vms.acpi_enable, vms.session, (vms.num_of_sockets * vms.cpu_per_socket) AS num_of_cpus, vms.display_ip, vms.display_type, vms.kvm_enable, vms.boot_sequence, vms.display_secure_port, vms.utc_diff, vms.last_vds_run_on, vms.client_ip, vms.guest_requested_memory, vms.time_zone, vms.cpu_user, vms.cpu_sys, vms.elapsed_time, vms.usage_network_percent, vms.usage_mem_percent, vms.usage_cpu_percent, vms.run_on_vds_name, vms.vds_group_cpu_name, tags_vm_map_view.tag_name, tags_vm_map_view.tag_id, vms.default_display_type, vms.priority, vms.vds_group_compatibility_version, vms.initrd_url, vms.kernel_url, vms.kernel_params, vms.pause_status, vms.exit_status, vms.exit_message, vms.min_allocated_mem, storage_domain_static.id AS storage_id FROM ((((vms LEFT JOIN tags_vm_map_view ON ((vms.vm_guid = tags_vm_map_view.vm_id))) LEFT JOIN image_vm_map ON ((vms.vm_guid = image_vm_map.vm_id))) LEFT JOIN images ON ((images.image_guid = image_vm_map.image_id))) LEFT JOIN storage_domain_static ON ((storage_domain_static.id = images.storage_id)));


ALTER TABLE public.vms_with_tags OWNER TO postgres;

--
-- Data for Name: action_version_map; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO action_version_map (action_type, cluster_minimal_version, storage_pool_minimal_version) VALUES (2, '2.2', '2.2');
INSERT INTO action_version_map (action_type, cluster_minimal_version, storage_pool_minimal_version) VALUES (33, '2.2', '2.2');
INSERT INTO action_version_map (action_type, cluster_minimal_version, storage_pool_minimal_version) VALUES (36, '2.2', '2.2');
INSERT INTO action_version_map (action_type, cluster_minimal_version, storage_pool_minimal_version) VALUES (23, '2.2', '2.2');
INSERT INTO action_version_map (action_type, cluster_minimal_version, storage_pool_minimal_version) VALUES (39, '2.2', '2.2');
INSERT INTO action_version_map (action_type, cluster_minimal_version, storage_pool_minimal_version) VALUES (24, '2.2', '2.2');
INSERT INTO action_version_map (action_type, cluster_minimal_version, storage_pool_minimal_version) VALUES (960, '2.2', '2.2');
INSERT INTO action_version_map (action_type, cluster_minimal_version, storage_pool_minimal_version) VALUES (961, '2.2', '2.2');
INSERT INTO action_version_map (action_type, cluster_minimal_version, storage_pool_minimal_version) VALUES (915, '2.2', '2.2');
INSERT INTO action_version_map (action_type, cluster_minimal_version, storage_pool_minimal_version) VALUES (41, '3.1', '3.1');


--
-- Data for Name: ad_groups; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO ad_groups (id, name, status, domain, distinguishedname) VALUES ('eee00000-0000-0000-0000-123456789eee', 'Everyone', 1, '', '');


--
-- Data for Name: async_tasks; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: audit_log; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (1, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-06 15:42:51.735-05', 'USER_VDC_LOGIN', 30, 0, 'User admin@internal logged in.', false, NULL, '', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (2, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-06 15:49:59.579-05', 'USER_VDC_LOGIN', 30, 0, 'User admin@internal logged in.', false, NULL, '', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (3, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-06 15:50:00.342-05', 'USER_VDC_LOGOUT', 31, 0, 'User admin@internal logged out.', false, NULL, '', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (4, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-06 15:50:00.761-05', 'USER_VDC_LOGIN', 30, 0, 'User admin@internal logged in.', false, NULL, '', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (5, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-06 15:50:00.811-05', 'USER_VDC_LOGOUT', 31, 0, 'User admin@internal logged out.', false, NULL, '', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (6, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-06 15:50:00.87-05', 'USER_VDC_LOGIN', 30, 0, 'User admin@internal logged in.', false, NULL, '', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (7, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-06 15:50:00.917-05', 'USER_VDC_LOGOUT', 31, 0, 'User admin@internal logged out.', false, NULL, '', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (8, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-06 15:55:50.721-05', 'USER_UPDATE_STORAGE_POOL', 952, 0, 'Data Center Horde was updated by admin@internal', false, '8e4002ca-c7aa-11e1-8859-080027afa608', 'Horde', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (9, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-06 15:58:33.315-05', 'USER_UPDATE_STORAGE_POOL', 952, 0, 'Data Center Azeroth was updated by admin@internal', false, '8e4002ca-c7aa-11e1-8859-080027afa608', 'Azeroth', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (10, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-06 15:59:01.582-05', 'USER_UPDATE_VDS_GROUP', 811, 0, 'Host cluster Horde was updated by admin@internal', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (11, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-06 16:02:39.776-05', 'USER_UPDATE_STORAGE_POOL', 952, 0, 'Data Center Azeroth was updated by admin@internal', false, '8e4002ca-c7aa-11e1-8859-080027afa608', 'Azeroth', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (12, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-06 16:07:17.363-05', 'USER_UPDATE_STORAGE_POOL', 952, 0, 'Data Center Azeroth was updated by admin@internal', false, '8e4002ca-c7aa-11e1-8859-080027afa608', 'Azeroth', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (13, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-08 02:31:10.16-05', 'USER_VDC_LOGIN', 30, 0, 'User admin@internal logged in.', false, NULL, '', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (15, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, '2a6c2702-c8d0-11e1-b9c5-080027afa608', 'ovirtnode01', '2012-07-08 02:40:19.112-05', 'USER_ADD_VDS', 42, 0, 'Host ovirtnode01 was added by admin@internal.', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (16, '00000000-0000-0000-0000-000000000000', NULL, '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, '2a6c2702-c8d0-11e1-b9c5-080027afa608', 'ovirtnode01', '2012-07-08 02:40:21.976-05', 'VDS_DETECTED', 13, 0, 'Detected new Host ovirtnode01. Host state was set to Up.', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (17, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, '2a6c2702-c8d0-11e1-b9c5-080027afa608', 'ovirtnode01', '2012-07-08 02:44:43.547-05', 'USER_VDS_MAINTENANCE', 600, 0, 'Host ovirtnode01 was switched to Maintenance mode by admin@internal.', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (18, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, '2a6c2702-c8d0-11e1-b9c5-080027afa608', 'ovirtnode01', '2012-07-08 03:10:06.273-05', 'VDS_ACTIVATE', 16, 0, 'Host ovirtnode01 was activated by admin@internal.', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (19, '00000000-0000-0000-0000-000000000000', NULL, '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, '2a6c2702-c8d0-11e1-b9c5-080027afa608', 'ovirtnode01', '2012-07-08 03:10:06.376-05', 'VDS_DETECTED', 13, 0, 'Detected new Host ovirtnode01. Host state was set to Up.', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (20, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-08 03:10:47.048-05', 'NETWORK_ADD_NETWORK', 942, 0, 'Network privatenet0 was added to data center: Azeroth ', false, '8e4002ca-c7aa-11e1-8859-080027afa608', 'Azeroth', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (21, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-08 03:10:47.112-05', 'NETWORK_ATTACH_NETWORK_TO_VDS_GROUP', 946, 0, 'Network privatenet0 attached to Cluster Horde', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (22, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-08 03:11:32.17-05', 'NETWORK_DETACH_NETWORK_TO_VDS_GROUP', 948, 0, 'Network privatenet0 detached from Cluster Horde', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (23, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-08 03:11:41.702-05', 'NETWORK_ATTACH_NETWORK_TO_VDS_GROUP', 946, 0, 'Network privatenet0 attached to Cluster Horde', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (24, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, '2a6c2702-c8d0-11e1-b9c5-080027afa608', 'ovirtnode01', '2012-07-08 03:13:29.928-05', 'USER_VDS_MAINTENANCE', 600, 0, 'Host ovirtnode01 was switched to Maintenance mode by admin@internal.', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (25, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-14 15:19:45.132-05', 'USER_VDC_LOGIN', 30, 0, 'User admin@internal logged in.', false, NULL, '', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (26, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, '2a6c2702-c8d0-11e1-b9c5-080027afa608', 'ovirtnode01', '2012-07-14 15:20:07.17-05', 'USER_REMOVE_VDS', 44, 0, 'Host ovirtnode01 was removed by admin@internal.', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (27, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-14 16:12:13.763-05', 'USER_VDC_LOGIN', 30, 0, 'User admin@internal logged in.', false, NULL, '', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (28, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-15 00:48:05.182-05', 'USER_VDC_LOGIN', 30, 0, 'User admin@internal logged in.', false, NULL, '', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (29, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-15 01:34:16.13-05', 'USER_VDC_LOGOUT', 31, 0, 'User admin@internal logged out.', false, NULL, '', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (30, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-15 03:04:18.31-05', 'USER_VDC_LOGIN', 30, 0, 'User admin@internal logged in.', false, NULL, '', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (31, '00000000-0000-0000-0000-000000000000', NULL, '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-15 04:01:45.435-05', 'VDS_ALERT_FENCING_IS_NOT_CONFIGURED', 9000, 10, 'Power Management is not configured for Host durotar.', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (32, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-15 04:01:45.443-05', 'USER_ADD_VDS', 42, 0, 'Host durotar was added by admin@internal.', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (33, '00000000-0000-0000-0000-000000000000', NULL, '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-15 04:01:49.033-05', 'VDS_DETECTED', 13, 0, 'Detected new Host durotar. Host state was set to Up.', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (34, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-15 04:02:19.452-05', 'NETWORK_UPDATE_DISPLAY_TO_VDS_GROUP', 1100, 0, 'Update Display Network (ovirtmgmt) for Cluster Horde. (User: admin@internal)', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (35, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-15 04:05:16.093-05', 'NETWORK_ADD_NETWORK', 942, 0, 'Network Gadgetzan was added to data center: Azeroth ', false, '8e4002ca-c7aa-11e1-8859-080027afa608', 'Azeroth', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (36, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-15 04:05:16.152-05', 'NETWORK_ATTACH_NETWORK_TO_VDS_GROUP', 946, 0, 'Network Gadgetzan attached to Cluster Horde', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (37, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-15 04:07:42.234-05', 'NETWORK_DETACH_NETWORK_TO_VDS_GROUP', 948, 0, 'Network Gadgetzan detached from Cluster Horde', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (38, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-15 04:07:56.642-05', 'NETWORK_REMOVE_NETWORK', 944, 0, 'Network Gadgetzan was removed from data center: Azeroth', false, '8e4002ca-c7aa-11e1-8859-080027afa608', 'Azeroth', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (39, '00000000-0000-0000-0000-000000000000', NULL, '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-15 04:10:12.406-05', 'VDS_FAILURE', 12, 2, 'Host durotar is non-responsive.', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (40, '00000000-0000-0000-0000-000000000000', NULL, '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-15 04:10:12.432-05', 'VDS_ALERT_FENCING_OPERATION_SKIPPED', 9003, 10, 'Power Management Restart operation skipped on Host durotar because it is not configured.', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (41, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-15 04:11:42.152-05', 'USER_VDS_MAINTENANCE', 600, 0, 'Host durotar was switched to Maintenance mode by admin@internal.', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (42, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-15 04:13:31.059-05', 'VDS_ACTIVATE', 16, 0, 'Host durotar was activated by admin@internal.', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (43, '00000000-0000-0000-0000-000000000000', NULL, '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-15 04:13:31.173-05', 'VDS_DETECTED', 13, 0, 'Detected new Host durotar. Host state was set to Up.', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (44, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-15 04:14:38.22-05', 'USER_VDS_MAINTENANCE', 600, 0, 'Host durotar was switched to Maintenance mode by admin@internal.', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (45, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-15 04:14:48.845-05', 'VDS_ACTIVATE', 16, 0, 'Host durotar was activated by admin@internal.', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (46, '00000000-0000-0000-0000-000000000000', NULL, '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-15 04:14:50.012-05', 'VDS_DETECTED', 13, 0, 'Detected new Host durotar. Host state was set to Up.', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (47, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-15 04:15:22.691-05', 'NETWORK_ADD_NETWORK', 942, 0, 'Network gadgetzan was added to data center: Azeroth ', false, '8e4002ca-c7aa-11e1-8859-080027afa608', 'Azeroth', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (48, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-15 04:15:22.739-05', 'NETWORK_ATTACH_NETWORK_TO_VDS_GROUP', 946, 0, 'Network gadgetzan attached to Cluster Horde', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (49, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-15 04:15:53.261-05', 'USER_VDS_MAINTENANCE', 600, 0, 'Host durotar was switched to Maintenance mode by admin@internal.', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (50, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-15 16:51:05.657-05', 'USER_VDC_LOGIN', 30, 0, 'User admin@internal logged in.', false, NULL, '', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (51, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-15 16:52:56.844-05', 'VDS_ACTIVATE', 16, 0, 'Host durotar was activated by admin@internal.', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (52, '00000000-0000-0000-0000-000000000000', NULL, '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-15 16:52:57.517-05', 'VDS_DETECTED', 13, 0, 'Detected new Host durotar. Host state was set to Up.', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (53, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-15 16:55:00.679-05', 'USER_ADD_STORAGE_DOMAIN', 956, 0, 'Storage Domain orgrimmar was added by admin@internal', false, NULL, '', 'd9949950-675a-494a-a244-3fb4cacb0549', 'orgrimmar', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (54, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, 'Unavailable', '2012-07-15 16:55:24.343-05', 'SYSTEM_CHANGE_STORAGE_POOL_STATUS_PROBLEMATIC_SEARCHING_NEW_SPM', 986, 1, 'Data Center is being initialized, please wait for initialization to complete.', false, '8e4002ca-c7aa-11e1-8859-080027afa608', 'Azeroth', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (55, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-15 16:55:42.281-05', 'USER_ADD_STORAGE_DOMAIN', 956, 0, 'Storage Domain undercity was added by admin@internal', false, NULL, '', '9e5afe5e-0655-43bf-b8c4-75568061feff', 'undercity', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (56, '00000000-0000-0000-0000-000000000000', NULL, '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-15 16:55:44.725-05', 'IRS_HOSTED_ON_VDS', 204, 0, 'Storage Pool Manager runs on Host durotar (Address: 192.168.1.22).', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (57, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-15 16:55:44.808-05', 'USER_ACTIVATED_STORAGE_DOMAIN', 966, 0, 'Storage Domain orgrimmar (Data Center Azeroth) was activated by admin@internal', false, '8e4002ca-c7aa-11e1-8859-080027afa608', 'Azeroth', 'd9949950-675a-494a-a244-3fb4cacb0549', 'orgrimmar', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (58, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-15 16:55:44.831-05', 'USER_ATTACH_STORAGE_DOMAIN_TO_POOL', 962, 0, 'Storage Domain orgrimmar was attached to Data Center Azeroth by admin@internal', false, '8e4002ca-c7aa-11e1-8859-080027afa608', 'Azeroth', 'd9949950-675a-494a-a244-3fb4cacb0549', 'orgrimmar', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (59, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-15 16:56:23.64-05', 'USER_ADD_STORAGE_DOMAIN', 956, 0, 'Storage Domain silvermoon was added by admin@internal', false, NULL, '', 'e5099757-c150-467e-9575-cbcd2ebc8954', 'silvermoon', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (60, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-15 16:56:30.84-05', 'USER_ATTACH_STORAGE_DOMAIN_TO_POOL', 962, 0, 'Storage Domain silvermoon was attached to Data Center Azeroth by admin@internal', false, '8e4002ca-c7aa-11e1-8859-080027afa608', 'Azeroth', 'e5099757-c150-467e-9575-cbcd2ebc8954', 'silvermoon', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (61, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-15 16:56:45.396-05', 'USER_REMOVE_STORAGE_DOMAIN', 960, 0, 'Storage Domain undercity was removed by admin@internal', false, NULL, '', '9e5afe5e-0655-43bf-b8c4-75568061feff', 'undercity', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (62, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-15 16:56:55.117-05', 'USER_FORCE_REMOVE_STORAGE_DOMAIN', 981, 0, 'Storage Domain silvermoon was forcibly removed by admin@internal', false, '8e4002ca-c7aa-11e1-8859-080027afa608', 'Azeroth', 'e5099757-c150-467e-9575-cbcd2ebc8954', 'silvermoon', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (63, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-15 16:57:47.556-05', 'USER_ADD_STORAGE_DOMAIN', 956, 0, 'Storage Domain undercity was added by admin@internal', false, NULL, '', 'c2520583-257a-424a-91a3-5a528264e225', 'undercity', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (64, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-15 16:57:54.776-05', 'USER_ATTACH_STORAGE_DOMAIN_TO_POOL', 962, 0, 'Storage Domain undercity was attached to Data Center Azeroth by admin@internal', false, '8e4002ca-c7aa-11e1-8859-080027afa608', 'Azeroth', 'c2520583-257a-424a-91a3-5a528264e225', 'undercity', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (65, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-15 16:58:18.039-05', 'USER_ADD_STORAGE_DOMAIN', 956, 0, 'Storage Domain silvermoon was added by admin@internal', false, NULL, '', '11c256fe-ab06-4e41-ada1-4beab8d951ac', 'silvermoon', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (66, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-15 16:58:25.27-05', 'USER_ATTACH_STORAGE_DOMAIN_TO_POOL', 962, 0, 'Storage Domain silvermoon was attached to Data Center Azeroth by admin@internal', false, '8e4002ca-c7aa-11e1-8859-080027afa608', 'Azeroth', '11c256fe-ab06-4e41-ada1-4beab8d951ac', 'silvermoon', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (67, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-15 16:58:39.186-05', 'USER_ACTIVATED_STORAGE_DOMAIN', 966, 0, 'Storage Domain undercity (Data Center Azeroth) was activated by admin@internal', false, '8e4002ca-c7aa-11e1-8859-080027afa608', 'Azeroth', 'c2520583-257a-424a-91a3-5a528264e225', 'undercity', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (68, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-15 16:58:49.365-05', 'USER_ACTIVATED_STORAGE_DOMAIN', 966, 0, 'Storage Domain silvermoon (Data Center Azeroth) was activated by admin@internal', false, '8e4002ca-c7aa-11e1-8859-080027afa608', 'Azeroth', '11c256fe-ab06-4e41-ada1-4beab8d951ac', 'silvermoon', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (69, '00000000-0000-0000-0000-000000000000', NULL, '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-15 16:59:11.536-05', 'REFRESH_REPOSITORY_FILE_LIST_SUCCEEDED', 998, 0, 'Succeeded to refresh Iso domain : undercity (ISO file type)', false, NULL, '', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (70, '00000000-0000-0000-0000-000000000000', NULL, '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-15 16:59:11.56-05', 'REFRESH_REPOSITORY_FILE_LIST_SUCCEEDED', 998, 0, 'Succeeded to refresh Iso domain : undercity (Floppy file type)', false, NULL, '', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (71, '00000000-0000-0000-0000-000000000000', NULL, '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-15 16:59:13.673-05', 'REFRESH_REPOSITORY_FILE_LIST_SUCCEEDED', 998, 0, 'Succeeded to refresh Iso domain : undercity (ISO file type)', false, NULL, '', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (72, '00000000-0000-0000-0000-000000000000', NULL, '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-15 16:59:13.7-05', 'REFRESH_REPOSITORY_FILE_LIST_SUCCEEDED', 998, 0, 'Succeeded to refresh Iso domain : undercity (Floppy file type)', false, NULL, '', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (73, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-15 17:12:42.72-05', 'USER_VDC_LOGIN', 30, 0, 'User admin@internal logged in.', false, NULL, '', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (78, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '4077e5f5-d143-4841-a06a-aaf8042c1b39', 'winxp', '00000000-0000-0000-0000-000000000000', 'Blank', NULL, NULL, '2012-07-15 17:15:03.489-05', 'USER_ADD_VM', 34, 0, 'VM winxp was created by admin@internal.', false, '8e4002ca-c7aa-11e1-8859-080027afa608', 'Azeroth', 'd9949950-675a-494a-a244-3fb4cacb0549', 'orgrimmar', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (79, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '4077e5f5-d143-4841-a06a-aaf8042c1b39', 'winxp', '00000000-0000-0000-0000-000000000000', 'Blank', NULL, NULL, '2012-07-15 17:15:23.256-05', 'NETWORK_ADD_VM_INTERFACE', 932, 0, 'Interface vnic0 (rtl8139) was added to VM winxp. (User: admin@internal)', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (80, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '4077e5f5-d143-4841-a06a-aaf8042c1b39', 'winxp', '00000000-0000-0000-0000-000000000000', 'Blank', NULL, NULL, '2012-07-15 17:15:51.601-05', 'USER_ADD_DISK_TO_VM', 78, 0, 'Add-Disk operation of Disk 1 was initiated on VM winxp by admin@internal.', false, '8e4002ca-c7aa-11e1-8859-080027afa608', 'Azeroth', 'd9949950-675a-494a-a244-3fb4cacb0549', 'orgrimmar', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (74, '00000000-0000-0000-0000-000000000000', NULL, '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-15 17:13:56.569-05', 'REFRESH_REPOSITORY_FILE_LIST_SUCCEEDED', 998, 0, 'Succeeded to refresh Iso domain : undercity (ISO file type)', false, NULL, '', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (75, '00000000-0000-0000-0000-000000000000', NULL, '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-15 17:13:56.592-05', 'REFRESH_REPOSITORY_FILE_LIST_SUCCEEDED', 998, 0, 'Succeeded to refresh Iso domain : undercity (Floppy file type)', false, NULL, '', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (76, '00000000-0000-0000-0000-000000000000', NULL, '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-15 17:13:58.688-05', 'REFRESH_REPOSITORY_FILE_LIST_SUCCEEDED', 998, 0, 'Succeeded to refresh Iso domain : undercity (ISO file type)', false, NULL, '', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (77, '00000000-0000-0000-0000-000000000000', NULL, '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-15 17:13:58.712-05', 'REFRESH_REPOSITORY_FILE_LIST_SUCCEEDED', 998, 0, 'Succeeded to refresh Iso domain : undercity (Floppy file type)', false, NULL, '', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (81, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '4077e5f5-d143-4841-a06a-aaf8042c1b39', 'winxp', '00000000-0000-0000-0000-000000000000', 'Blank', NULL, NULL, '2012-07-15 17:15:58.705-05', 'USER_ADD_DISK_TO_VM_FINISHED_SUCCESS', 97, 0, 'Disk 1 was successfully added to VM winxp.', false, '8e4002ca-c7aa-11e1-8859-080027afa608', 'Azeroth', 'd9949950-675a-494a-a244-3fb4cacb0549', 'orgrimmar', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (92, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '7894db01-d1aa-4fc1-bb3c-2eec9704b35d', 'sl62', '00000000-0000-0000-0000-000000000000', 'Blank', 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-15 17:56:41.555-05', 'USER_RUN_VM', 32, 0, 'VM sl62 started on Host durotar', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (95, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-15 21:56:57.552-05', 'USER_VDC_LOGIN', 30, 0, 'User admin@internal logged in.', false, NULL, '', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (97, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '7894db01-d1aa-4fc1-bb3c-2eec9704b35d', 'sl62', '00000000-0000-0000-0000-000000000000', 'Blank', 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-15 21:57:45.96-05', 'USER_EJECT_VM_DISK', 528, 0, 'CD was ejected from VM sl62 by admin@internal', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (98, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '4077e5f5-d143-4841-a06a-aaf8042c1b39', 'winxp', '00000000-0000-0000-0000-000000000000', 'Blank', 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-15 21:58:19.278-05', 'USER_EJECT_VM_DISK', 528, 0, 'CD was ejected from VM winxp by admin@internal', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (102, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-16 00:08:19.323-05', 'USER_VDC_LOGIN', 30, 0, 'User admin@internal logged in.', false, NULL, '', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (104, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '329b46ff-80f7-4b35-a1cc-5dac80e2a43e', 'rh73', '00000000-0000-0000-0000-000000000000', 'Blank', NULL, NULL, '2012-07-16 00:12:02.893-05', 'USER_ADD_VM', 34, 0, 'VM rh73 was created by admin@internal.', false, '8e4002ca-c7aa-11e1-8859-080027afa608', 'Azeroth', 'd9949950-675a-494a-a244-3fb4cacb0549', 'orgrimmar', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (105, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '329b46ff-80f7-4b35-a1cc-5dac80e2a43e', 'rh73', '00000000-0000-0000-0000-000000000000', 'Blank', NULL, NULL, '2012-07-16 00:12:18.128-05', 'NETWORK_ADD_VM_INTERFACE', 932, 0, 'Interface vnic0 (e1000) was added to VM rh73. (User: admin@internal)', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (106, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '329b46ff-80f7-4b35-a1cc-5dac80e2a43e', 'rh73', '00000000-0000-0000-0000-000000000000', 'Blank', NULL, NULL, '2012-07-16 00:12:31.699-05', 'USER_ADD_DISK_TO_VM', 78, 0, 'Add-Disk operation of Disk 1 was initiated on VM rh73 by admin@internal.', false, '8e4002ca-c7aa-11e1-8859-080027afa608', 'Azeroth', 'd9949950-675a-494a-a244-3fb4cacb0549', 'orgrimmar', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (107, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '329b46ff-80f7-4b35-a1cc-5dac80e2a43e', 'rh73', '00000000-0000-0000-0000-000000000000', 'Blank', NULL, NULL, '2012-07-16 00:12:41.002-05', 'USER_ADD_DISK_TO_VM_FINISHED_SUCCESS', 97, 0, 'Disk 1 was successfully added to VM rh73.', false, '8e4002ca-c7aa-11e1-8859-080027afa608', 'Azeroth', 'd9949950-675a-494a-a244-3fb4cacb0549', 'orgrimmar', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (108, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '329b46ff-80f7-4b35-a1cc-5dac80e2a43e', 'rh73', '00000000-0000-0000-0000-000000000000', 'Blank', 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-16 00:12:48.293-05', 'USER_STARTED_VM', 153, 0, 'VM rh73 was started by admin@internal (Host: durotar).', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (82, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '4077e5f5-d143-4841-a06a-aaf8042c1b39', 'winxp', '00000000-0000-0000-0000-000000000000', 'Blank', 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-15 17:16:24.872-05', 'USER_STARTED_VM', 153, 0, 'VM winxp was started by admin@internal (Host: durotar).', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (83, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '4077e5f5-d143-4841-a06a-aaf8042c1b39', 'winxp', '00000000-0000-0000-0000-000000000000', 'Blank', 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-15 17:17:25.959-05', 'USER_RUN_VM', 32, 0, 'VM winxp started on Host durotar', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (84, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-15 17:47:48.397-05', 'USER_VDC_LOGOUT', 31, 0, 'User admin@internal logged out.', false, NULL, '', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (85, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-15 17:47:48.413-05', 'USER_VDC_LOGOUT', 31, 0, 'User admin@internal logged out.', false, NULL, '', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (86, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-15 17:54:28.204-05', 'USER_VDC_LOGIN', 30, 0, 'User admin@internal logged in.', false, NULL, '', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (87, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '7894db01-d1aa-4fc1-bb3c-2eec9704b35d', 'sl62', '00000000-0000-0000-0000-000000000000', 'Blank', NULL, NULL, '2012-07-15 17:55:09.103-05', 'USER_ADD_VM', 34, 0, 'VM sl62 was created by admin@internal.', false, '8e4002ca-c7aa-11e1-8859-080027afa608', 'Azeroth', 'd9949950-675a-494a-a244-3fb4cacb0549', 'orgrimmar', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (88, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '7894db01-d1aa-4fc1-bb3c-2eec9704b35d', 'sl62', '00000000-0000-0000-0000-000000000000', 'Blank', NULL, NULL, '2012-07-15 17:55:20.674-05', 'NETWORK_ADD_VM_INTERFACE', 932, 0, 'Interface vnic0 (Red Hat VirtIO) was added to VM sl62. (User: admin@internal)', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (89, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '7894db01-d1aa-4fc1-bb3c-2eec9704b35d', 'sl62', '00000000-0000-0000-0000-000000000000', 'Blank', NULL, NULL, '2012-07-15 17:55:32.759-05', 'USER_ADD_DISK_TO_VM', 78, 0, 'Add-Disk operation of Disk 1 was initiated on VM sl62 by admin@internal.', false, '8e4002ca-c7aa-11e1-8859-080027afa608', 'Azeroth', 'd9949950-675a-494a-a244-3fb4cacb0549', 'orgrimmar', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (90, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '7894db01-d1aa-4fc1-bb3c-2eec9704b35d', 'sl62', '00000000-0000-0000-0000-000000000000', 'Blank', NULL, NULL, '2012-07-15 17:55:38.934-05', 'USER_ADD_DISK_TO_VM_FINISHED_SUCCESS', 97, 0, 'Disk 1 was successfully added to VM sl62.', false, '8e4002ca-c7aa-11e1-8859-080027afa608', 'Azeroth', 'd9949950-675a-494a-a244-3fb4cacb0549', 'orgrimmar', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (91, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '7894db01-d1aa-4fc1-bb3c-2eec9704b35d', 'sl62', '00000000-0000-0000-0000-000000000000', 'Blank', 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-15 17:55:41.037-05', 'USER_STARTED_VM', 153, 0, 'VM sl62 was started by admin@internal (Host: durotar).', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (93, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-15 18:47:48.731-05', 'USER_VDC_LOGOUT', 31, 0, 'User admin@internal logged out.', false, NULL, '', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (94, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-15 18:47:48.742-05', 'USER_VDC_LOGOUT', 31, 0, 'User admin@internal logged out.', false, NULL, '', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (96, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '7894db01-d1aa-4fc1-bb3c-2eec9704b35d', 'sl62', '00000000-0000-0000-0000-000000000000', 'Blank', 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-15 21:57:18.977-05', 'USER_CHANGE_DISK_VM', 38, 0, 'CD SL-62-x86_64-2012-02-06-Everything-DVD2.iso was inserted to VM sl62 by admin@internal', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (99, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-15 22:47:48.087-05', 'USER_VDC_LOGOUT', 31, 0, 'User admin@internal logged out.', false, NULL, '', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (100, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-15 22:47:48.098-05', 'USER_VDC_LOGOUT', 31, 0, 'User admin@internal logged out.', false, NULL, '', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (101, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-15 22:50:35.403-05', 'USER_VDC_LOGIN', 30, 0, 'User admin@internal logged in.', false, NULL, '', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (103, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-16 00:11:11.831-05', 'USER_VDC_LOGIN', 30, 0, 'User admin@internal logged in.', false, NULL, '', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (109, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '329b46ff-80f7-4b35-a1cc-5dac80e2a43e', 'rh73', '00000000-0000-0000-0000-000000000000', 'Blank', 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-16 00:13:48.792-05', 'USER_RUN_VM', 32, 0, 'VM rh73 started on Host durotar', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (110, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '329b46ff-80f7-4b35-a1cc-5dac80e2a43e', 'rh73', '00000000-0000-0000-0000-000000000000', 'Blank', 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-16 00:19:47.476-05', 'USER_STOP_VM', 33, 0, 'VM rh73 stopped by admin@internal (Host: durotar).', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (111, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '329b46ff-80f7-4b35-a1cc-5dac80e2a43e', 'rh73', '00000000-0000-0000-0000-000000000000', 'Blank', 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-16 00:19:55.696-05', 'USER_STARTED_VM', 153, 0, 'VM rh73 was started by admin@internal (Host: durotar).', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (112, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '329b46ff-80f7-4b35-a1cc-5dac80e2a43e', 'rh73', '00000000-0000-0000-0000-000000000000', 'Blank', 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-16 00:20:56.864-05', 'USER_RUN_VM', 32, 0, 'VM rh73 started on Host durotar', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (113, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, NULL, '2012-07-16 00:22:41.09-05', 'USER_VDC_LOGIN', 30, 0, 'User admin@internal logged in.', false, NULL, '', NULL, '', '00000000-0000-0000-0000-000000000000', '');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (114, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '329b46ff-80f7-4b35-a1cc-5dac80e2a43e', 'rh73', '00000000-0000-0000-0000-000000000000', 'Blank', 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-16 00:27:41.766-05', 'USER_CHANGE_DISK_VM', 38, 0, 'CD valhalla-i386-disc2.iso was inserted to VM rh73 by admin@internal', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (115, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '329b46ff-80f7-4b35-a1cc-5dac80e2a43e', 'rh73', '00000000-0000-0000-0000-000000000000', 'Blank', 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-16 00:33:55.291-05', 'USER_INITIATED_SHUTDOWN_VM', 73, 0, 'VM shutdown initiated by admin@internal on VM rh73 (Host: durotar).', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (116, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '329b46ff-80f7-4b35-a1cc-5dac80e2a43e', 'rh73', '00000000-0000-0000-0000-000000000000', 'Blank', 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-16 00:37:17.501-05', 'USER_STOP_VM', 33, 0, 'VM rh73 stopped by admin@internal (Host: durotar).', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (117, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '329b46ff-80f7-4b35-a1cc-5dac80e2a43e', 'rh73', '00000000-0000-0000-0000-000000000000', 'Blank', 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-16 00:37:24.651-05', 'USER_STARTED_VM', 153, 0, 'VM rh73 was started by admin@internal (Host: durotar).', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (118, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '329b46ff-80f7-4b35-a1cc-5dac80e2a43e', 'rh73', '00000000-0000-0000-0000-000000000000', 'Blank', 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-16 00:38:26.587-05', 'USER_RUN_VM', 32, 0, 'VM rh73 started on Host durotar', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (119, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '329b46ff-80f7-4b35-a1cc-5dac80e2a43e', 'rh73', '00000000-0000-0000-0000-000000000000', 'Blank', 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-16 00:44:00.543-05', 'USER_STOP_VM', 33, 0, 'VM rh73 stopped by admin@internal (Host: durotar).', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (120, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '329b46ff-80f7-4b35-a1cc-5dac80e2a43e', 'rh73', '00000000-0000-0000-0000-000000000000', 'Blank', 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-16 00:44:18.81-05', 'USER_STARTED_VM', 153, 0, 'VM rh73 was started by admin@internal (Host: durotar).', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (121, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '329b46ff-80f7-4b35-a1cc-5dac80e2a43e', 'rh73', '00000000-0000-0000-0000-000000000000', 'Blank', 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-16 00:45:20.773-05', 'USER_RUN_VM', 32, 0, 'VM rh73 started on Host durotar', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (122, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '329b46ff-80f7-4b35-a1cc-5dac80e2a43e', 'rh73', '00000000-0000-0000-0000-000000000000', 'Blank', 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-16 00:51:36.349-05', 'USER_CHANGE_DISK_VM', 38, 0, 'CD valhalla-i386-disc2.iso was inserted to VM rh73 by admin@internal', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (123, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '329b46ff-80f7-4b35-a1cc-5dac80e2a43e', 'rh73', '00000000-0000-0000-0000-000000000000', 'Blank', 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-16 00:58:47.956-05', 'USER_EJECT_VM_DISK', 528, 0, 'CD was ejected from VM rh73 by admin@internal', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (124, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '4077e5f5-d143-4841-a06a-aaf8042c1b39', 'winxp', '00000000-0000-0000-0000-000000000000', 'Blank', 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-16 01:05:49.843-05', 'USER_INITIATED_SHUTDOWN_VM', 73, 0, 'VM shutdown initiated by admin@internal on VM winxp (Host: durotar).', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (125, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '7894db01-d1aa-4fc1-bb3c-2eec9704b35d', 'sl62', '00000000-0000-0000-0000-000000000000', 'Blank', 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-16 01:05:53.946-05', 'USER_INITIATED_SHUTDOWN_VM', 73, 0, 'VM shutdown initiated by admin@internal on VM sl62 (Host: durotar).', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (128, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-16 01:06:46.676-05', 'USER_VDS_MAINTENANCE', 600, 0, 'Host durotar was switched to Maintenance mode by admin@internal.', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (126, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '329b46ff-80f7-4b35-a1cc-5dac80e2a43e', 'rh73', '00000000-0000-0000-0000-000000000000', 'Blank', 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-16 01:05:57.549-05', 'USER_INITIATED_SHUTDOWN_VM', 73, 0, 'VM shutdown initiated by admin@internal on VM rh73 (Host: durotar).', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (127, 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin@internal', '329b46ff-80f7-4b35-a1cc-5dac80e2a43e', 'rh73', '00000000-0000-0000-0000-000000000000', 'Blank', 'b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', '2012-07-16 01:06:32.57-05', 'USER_STOPPED_VM_INSTEAD_OF_SHUTDOWN', 76, 0, 'VM rh73 was stopped ungracefully by admin@internal (Host: durotar).', false, NULL, '', NULL, '', '99408929-82cf-4dc7-a532-9d998063fa95', 'Horde');
INSERT INTO audit_log (audit_log_id, user_id, user_name, vm_id, vm_name, vm_template_id, vm_template_name, vds_id, vds_name, log_time, log_type_name, log_type, severity, message, processed, storage_pool_id, storage_pool_name, storage_domain_id, storage_domain_name, vds_group_id, vds_group_name) VALUES (129, '00000000-0000-0000-0000-000000000000', NULL, '00000000-0000-0000-0000-000000000000', NULL, NULL, NULL, NULL, 'Unavailable', '2012-07-16 01:06:52.458-05', 'SYSTEM_CHANGE_STORAGE_POOL_STATUS_PROBLEMATIC', 980, 1, 'Invalid status on Data Center Azeroth. Setting status to Non-Responsive.', false, '8e4002ca-c7aa-11e1-8859-080027afa608', 'Azeroth', NULL, '', '00000000-0000-0000-0000-000000000000', '');


--
-- Data for Name: bookmarks; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: business_entity_snapshot; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: custom_actions; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: disk_image_dynamic; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO disk_image_dynamic (image_id, read_rate, write_rate, actual_size, read_latency_seconds, write_latency_seconds, flush_latency_seconds) VALUES ('f24895b2-d15f-4947-9196-998c0051ce23', 0, 0, 3668627456, 0.000000000, 0.000000000, 0.000000000);
INSERT INTO disk_image_dynamic (image_id, read_rate, write_rate, actual_size, read_latency_seconds, write_latency_seconds, flush_latency_seconds) VALUES ('9a3a6414-3cf4-4c58-979e-d8104ae8e111', 0, 272, 6405931008, 0.000000000, 0.000659880, 0.000179411);
INSERT INTO disk_image_dynamic (image_id, read_rate, write_rate, actual_size, read_latency_seconds, write_latency_seconds, flush_latency_seconds) VALUES ('563e1ea2-f82d-4b9e-880a-2140362f4d8c', 0, 0, 2698620928, 0.000000000, 0.000000000, 0.000000000);


--
-- Data for Name: disks; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO disks (disk_id, status, internal_drive_mapping, active_image_id, disk_type, disk_interface, wipe_after_delete, propagate_errors) VALUES ('66889b47-b5c6-409d-bc0d-a73497e4b444', 'OK', 1, 'f24895b2-d15f-4947-9196-998c0051ce23', 'System', 'IDE', false, 'Off');
INSERT INTO disks (disk_id, status, internal_drive_mapping, active_image_id, disk_type, disk_interface, wipe_after_delete, propagate_errors) VALUES ('5f0e2bac-7bfb-4e83-b6a9-8ba5c296eff5', 'OK', 1, '9a3a6414-3cf4-4c58-979e-d8104ae8e111', 'System', 'VirtIO', false, 'Off');
INSERT INTO disks (disk_id, status, internal_drive_mapping, active_image_id, disk_type, disk_interface, wipe_after_delete, propagate_errors) VALUES ('2030b77d-2e45-41cc-9884-ffa2f7e2515a', 'OK', 1, '563e1ea2-f82d-4b9e-880a-2140362f4d8c', 'System', 'IDE', false, 'Off');


--
-- Data for Name: dwh_history_timekeeping; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO dwh_history_timekeeping (var_name, var_value, var_datetime) VALUES ('lastSync', NULL, '2000-01-01 00:00:00-06');
INSERT INTO dwh_history_timekeeping (var_name, var_value, var_datetime) VALUES ('lastFullHostCheck', NULL, '2000-01-01 00:00:00-06');


--
-- Data for Name: engine_license_usage; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: event_map; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO event_map (event_up_name, event_down_name) VALUES ('VDC_STOP', 'VDC_START');
INSERT INTO event_map (event_up_name, event_down_name) VALUES ('IRS_FAILURE', 'UNASSIGNED');
INSERT INTO event_map (event_up_name, event_down_name) VALUES ('IRS_DISK_SPACE_LOW', 'UNASSIGNED');
INSERT INTO event_map (event_up_name, event_down_name) VALUES ('IRS_DISK_SPACE_LOW_ERROR', 'UNASSIGNED');
INSERT INTO event_map (event_up_name, event_down_name) VALUES ('VDS_FAILURE', 'VDS_ACTIVATE');
INSERT INTO event_map (event_up_name, event_down_name) VALUES ('USER_VDS_MAINTENANCE', 'VDS_ACTIVATE');
INSERT INTO event_map (event_up_name, event_down_name) VALUES ('USER_VDS_MAINTENANCE_MIGRATION_FAILED', 'USER_VDS_MAINTENANCE');
INSERT INTO event_map (event_up_name, event_down_name) VALUES ('VDS_ACTIVATE_FAILED', 'VDS_ACTIVATE');
INSERT INTO event_map (event_up_name, event_down_name) VALUES ('VDS_RECOVER_FAILED', 'VDS_RECOVER');
INSERT INTO event_map (event_up_name, event_down_name) VALUES ('VDS_SLOW_STORAGE_RESPONSE_TIME', 'VDS_ACTIVATE');
INSERT INTO event_map (event_up_name, event_down_name) VALUES ('VDS_APPROVE_FAILED', 'VDS_APPROVE');
INSERT INTO event_map (event_up_name, event_down_name) VALUES ('VDS_INSTALL_FAILED', 'VDS_INSTALL');
INSERT INTO event_map (event_up_name, event_down_name) VALUES ('VM_FAILURE', 'UNASSIGNED');
INSERT INTO event_map (event_up_name, event_down_name) VALUES ('VM_MIGRATION_START', 'VM_MIGRATION_DONE');
INSERT INTO event_map (event_up_name, event_down_name) VALUES ('VM_MIGRATION_FAILED', 'UNASSIGNED');
INSERT INTO event_map (event_up_name, event_down_name) VALUES ('VM_MIGRATION_FAILED_FROM_TO', 'UNASSIGNED');
INSERT INTO event_map (event_up_name, event_down_name) VALUES ('VM_NOT_RESPONDING', 'UNASSIGNED');


--
-- Data for Name: event_notification_hist; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: event_notification_methods; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO event_notification_methods (method_id, method_type) VALUES (0, 'Email     ');


--
-- Data for Name: event_subscriber; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: image_group_storage_domain_map; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: image_templates; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO image_templates (it_guid, creation_date, size, os, os_version, bootable, description, internal_drive_mapping) VALUES ('00000000-0000-0000-0000-000000000000', '2008-04-01 00:00:00-05', 85899345920, '-', '-', false, 'Blanc Image Template', '1');


--
-- Data for Name: image_vm_map; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO image_vm_map (image_id, vm_id, active) VALUES ('00000000-0000-0000-0000-000000000000', '00000000-0000-0000-0000-000000000000', true);
INSERT INTO image_vm_map (image_id, vm_id, active) VALUES ('f24895b2-d15f-4947-9196-998c0051ce23', '4077e5f5-d143-4841-a06a-aaf8042c1b39', true);
INSERT INTO image_vm_map (image_id, vm_id, active) VALUES ('9a3a6414-3cf4-4c58-979e-d8104ae8e111', '7894db01-d1aa-4fc1-bb3c-2eec9704b35d', true);
INSERT INTO image_vm_map (image_id, vm_id, active) VALUES ('563e1ea2-f82d-4b9e-880a-2140362f4d8c', '329b46ff-80f7-4b35-a1cc-5dac80e2a43e', true);


--
-- Data for Name: image_vm_pool_map; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: images; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO images (image_guid, creation_date, size, it_guid, internal_drive_mapping, description, parentid, imagestatus, lastmodified, app_list, storage_id, vm_snapshot_id, volume_type, volume_format, disk_type, image_group_id, disk_interface, boot, wipe_after_delete, propagate_errors, _create_date, _update_date) VALUES ('9a3a6414-3cf4-4c58-979e-d8104ae8e111', '2012-07-16 12:55:53-05', 21474836480, '00000000-0000-0000-0000-000000000000', '1', '_ActiveImage_sl62_Sun Jul 15 17:55:32 CDT 2012', '00000000-0000-0000-0000-000000000000', 1, '2012-07-16 12:55:53-05', '', 'd9949950-675a-494a-a244-3fb4cacb0549', 'ea20fbc5-80b0-4072-a45c-b4bf1d2de676', 2, 5, 1, '5f0e2bac-7bfb-4e83-b6a9-8ba5c296eff5', 2, true, false, 0, '2012-07-15 17:55:32.671826-05', '2012-07-16 01:06:05.408858-05');
INSERT INTO images (image_guid, creation_date, size, it_guid, internal_drive_mapping, description, parentid, imagestatus, lastmodified, app_list, storage_id, vm_snapshot_id, volume_type, volume_format, disk_type, image_group_id, disk_interface, boot, wipe_after_delete, propagate_errors, _create_date, _update_date) VALUES ('563e1ea2-f82d-4b9e-880a-2140362f4d8c', '2012-07-16 19:12:52-05', 10737418240, '00000000-0000-0000-0000-000000000000', '1', '_ActiveImage_rh73_Mon Jul 16 00:12:31 CDT 2012', '00000000-0000-0000-0000-000000000000', 1, '2012-07-16 19:12:52-05', '', 'd9949950-675a-494a-a244-3fb4cacb0549', 'd9a2d837-4695-4cdb-a5c6-7728964bdd86', 2, 5, 1, '2030b77d-2e45-41cc-9884-ffa2f7e2515a', 0, true, false, 0, '2012-07-16 00:12:31.614581-05', '2012-07-16 01:06:31.688304-05');
INSERT INTO images (image_guid, creation_date, size, it_guid, internal_drive_mapping, description, parentid, imagestatus, lastmodified, app_list, storage_id, vm_snapshot_id, volume_type, volume_format, disk_type, image_group_id, disk_interface, boot, wipe_after_delete, propagate_errors, _create_date, _update_date) VALUES ('f24895b2-d15f-4947-9196-998c0051ce23', '2012-07-16 12:16:13-05', 21474836480, '00000000-0000-0000-0000-000000000000', '1', '_ActiveImage_winxp_Sun Jul 15 17:15:51 CDT 2012', '00000000-0000-0000-0000-000000000000', 1, '2012-07-16 12:16:13-05', '', 'd9949950-675a-494a-a244-3fb4cacb0549', '561215fe-935b-409a-9d7a-610a82ae8484', 2, 5, 1, '66889b47-b5c6-409d-bc0d-a73497e4b444', 0, true, false, 0, '2012-07-15 17:15:51.468173-05', '2012-07-16 01:05:57.269286-05');


--
-- Data for Name: lun_storage_server_connection_map; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: luns; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: network; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO network (id, name, description, type, addr, subnet, gateway, vlan_id, stp, storage_pool_id) VALUES ('00000000-0000-0000-0000-000000000009', 'ovirtmgmt', 'Management Network', NULL, NULL, NULL, NULL, NULL, false, '8e4002ca-c7aa-11e1-8859-080027afa608');
INSERT INTO network (id, name, description, type, addr, subnet, gateway, vlan_id, stp, storage_pool_id) VALUES ('97e47cfb-d7f0-4eb3-910e-2b81af541e12', 'tolbarad', 'Private Internal Network', NULL, NULL, NULL, NULL, NULL, true, '8e4002ca-c7aa-11e1-8859-080027afa608');
INSERT INTO network (id, name, description, type, addr, subnet, gateway, vlan_id, stp, storage_pool_id) VALUES ('cf06331e-351b-473a-bfae-96bc2d281ec2', 'gadgetzan', 'Main VM Network', NULL, NULL, NULL, NULL, NULL, false, '8e4002ca-c7aa-11e1-8859-080027afa608');


--
-- Data for Name: network_cluster; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO network_cluster (network_id, cluster_id, status, is_display) VALUES ('00000000-0000-0000-0000-000000000009', '99408929-82cf-4dc7-a532-9d998063fa95', 1, true);
INSERT INTO network_cluster (network_id, cluster_id, status, is_display) VALUES ('97e47cfb-d7f0-4eb3-910e-2b81af541e12', '99408929-82cf-4dc7-a532-9d998063fa95', 1, false);
INSERT INTO network_cluster (network_id, cluster_id, status, is_display) VALUES ('cf06331e-351b-473a-bfae-96bc2d281ec2', '99408929-82cf-4dc7-a532-9d998063fa95', 1, false);


--
-- Data for Name: permissions; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO permissions (id, role_id, ad_element_id, object_id, object_type_id) VALUES ('8eb9de4c-c7aa-11e1-996c-080027afa608', 'def00009-0000-0000-0000-def000000009', 'eee00000-0000-0000-0000-123456789eee', '00000000-0000-0000-0000-000000000000', 4);
INSERT INTO permissions (id, role_id, ad_element_id, object_id, object_type_id) VALUES ('8f5e0c7e-c7aa-11e1-8474-080027afa608', '00000000-0000-0000-0000-000000000001', 'fdfc627c-d875-11e0-90f0-83df133b58cc', 'aaa00000-0000-0000-0000-123456789aaa', 1);


--
-- Data for Name: repo_file_meta_data; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO repo_file_meta_data (repo_domain_id, repo_file_name, size, date_created, last_refreshed, file_type) VALUES ('c2520583-257a-424a-91a3-5a528264e225', 'WinXP-Pro-SP3.iso', 0, NULL, 1342417968259, 1);
INSERT INTO repo_file_meta_data (repo_domain_id, repo_file_name, size, date_created, last_refreshed, file_type) VALUES ('c2520583-257a-424a-91a3-5a528264e225', 'openSUSE-11.3-DVD-x86_64.iso', 0, NULL, 1342417968259, 1);
INSERT INTO repo_file_meta_data (repo_domain_id, repo_file_name, size, date_created, last_refreshed, file_type) VALUES ('c2520583-257a-424a-91a3-5a528264e225', 'valhalla-i386-disc3.iso', 0, NULL, 1342417968259, 1);
INSERT INTO repo_file_meta_data (repo_domain_id, repo_file_name, size, date_created, last_refreshed, file_type) VALUES ('c2520583-257a-424a-91a3-5a528264e225', 'SL-62-x86_64-2012-02-06-Everything-DVD2.iso', 0, NULL, 1342417968259, 1);
INSERT INTO repo_file_meta_data (repo_domain_id, repo_file_name, size, date_created, last_refreshed, file_type) VALUES ('c2520583-257a-424a-91a3-5a528264e225', 'valhalla-i386-disc2.iso', 0, NULL, 1342417968259, 1);
INSERT INTO repo_file_meta_data (repo_domain_id, repo_file_name, size, date_created, last_refreshed, file_type) VALUES ('c2520583-257a-424a-91a3-5a528264e225', 'OpenSUSE-11.1-x86_64.iso', 0, NULL, 1342417968259, 1);
INSERT INTO repo_file_meta_data (repo_domain_id, repo_file_name, size, date_created, last_refreshed, file_type) VALUES ('c2520583-257a-424a-91a3-5a528264e225', 'valhalla-i386-disc1.iso', 0, NULL, 1342417968259, 1);
INSERT INTO repo_file_meta_data (repo_domain_id, repo_file_name, size, date_created, last_refreshed, file_type) VALUES ('c2520583-257a-424a-91a3-5a528264e225', 'SL-62-x86_64-2012-02-06-Everything-DVD1.iso', 0, NULL, 1342417968259, 1);
INSERT INTO repo_file_meta_data (repo_domain_id, repo_file_name, size, date_created, last_refreshed, file_type) VALUES ('c2520583-257a-424a-91a3-5a528264e225', 'win7_ult_x64.iso', 0, NULL, 1342417968259, 1);


--
-- Data for Name: roles; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO roles (id, name, description, is_readonly, role_type) VALUES ('00000000-0000-0000-0001-000000000001', 'UserRole', 'Standard User Role', true, 2);
INSERT INTO roles (id, name, description, is_readonly, role_type) VALUES ('00000000-0000-0000-0001-000000000002', 'PowerUserRole', 'User Role, allowed to create/manage Vms and Templates', true, 2);
INSERT INTO roles (id, name, description, is_readonly, role_type) VALUES ('def00006-0000-0000-0000-def000000006', 'UserVmManager', 'User Role, with permission for any operation on Vms', true, 2);
INSERT INTO roles (id, name, description, is_readonly, role_type) VALUES ('def00008-0000-0000-0000-def000000008', 'TemplateAdmin', 'Administrator Role, permission for all operations on a specific Template', true, 1);
INSERT INTO roles (id, name, description, is_readonly, role_type) VALUES ('def00009-0000-0000-0000-def000000009', 'UserTemplateBasedVm', 'User Role, with permissions only to use Templates', true, 2);
INSERT INTO roles (id, name, description, is_readonly, role_type) VALUES ('00000000-0000-0000-0000-000000000001', 'SuperUser', 'System Administrators with permission for all operations', true, 1);
INSERT INTO roles (id, name, description, is_readonly, role_type) VALUES ('def00001-0000-0000-0000-def000000001', 'ClusterAdmin', 'Administrator Role, permission for all the objects underneath a specific Cluster', true, 1);
INSERT INTO roles (id, name, description, is_readonly, role_type) VALUES ('def00002-0000-0000-0000-def000000002', 'DataCenterAdmin', 'Administrator Role, permission for all the objects underneath a specific Data Center, except Storage', true, 1);
INSERT INTO roles (id, name, description, is_readonly, role_type) VALUES ('def00003-0000-0000-0000-def000000003', 'StorageAdmin', 'Administrator Role, permission for all operations on a specific Storage Domain', true, 1);
INSERT INTO roles (id, name, description, is_readonly, role_type) VALUES ('def00004-0000-0000-0000-def000000004', 'HostAdmin', 'Administrator Role, permission for all operations on a specific Host', true, 1);
INSERT INTO roles (id, name, description, is_readonly, role_type) VALUES ('def00005-0000-0000-0000-def000000005', 'NetworkAdmin', 'Administrator Role, permission for all operations on a specific Logical Network', true, 1);
INSERT INTO roles (id, name, description, is_readonly, role_type) VALUES ('def00007-0000-0000-0000-def000000007', 'VmPoolAdmin', 'Administrator Role, permission for all operations on a specific VM Pool', true, 1);


--
-- Data for Name: roles_groups; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0000-000000000001', 1);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0000-000000000001', 2);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0000-000000000001', 3);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0000-000000000001', 4);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0000-000000000001', 5);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0000-000000000001', 6);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0000-000000000001', 7);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0000-000000000001', 8);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0000-000000000001', 9);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0000-000000000001', 10);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0000-000000000001', 11);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0000-000000000001', 12);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0000-000000000001', 100);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0000-000000000001', 101);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0000-000000000001', 102);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0000-000000000001', 103);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0000-000000000001', 104);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0000-000000000001', 200);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0000-000000000001', 201);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0000-000000000001', 202);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0000-000000000001', 203);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0000-000000000001', 204);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0000-000000000001', 300);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0000-000000000001', 301);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0000-000000000001', 302);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0000-000000000001', 303);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0000-000000000001', 400);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0000-000000000001', 401);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0000-000000000001', 402);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0000-000000000001', 403);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0000-000000000001', 500);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0000-000000000001', 501);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0000-000000000001', 502);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0000-000000000001', 600);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0000-000000000001', 601);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0000-000000000001', 602);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0000-000000000001', 603);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0000-000000000001', 700);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0000-000000000001', 701);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0000-000000000001', 702);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0000-000000000001', 703);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0001-000000000001', 4);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0001-000000000001', 5);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0001-000000000001', 7);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0001-000000000001', 303);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0001-000000000002', 1);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0001-000000000002', 2);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0001-000000000002', 3);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0001-000000000002', 4);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0001-000000000002', 5);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0001-000000000002', 6);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0001-000000000002', 7);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0001-000000000002', 8);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0001-000000000002', 9);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0001-000000000002', 10);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0001-000000000002', 11);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0001-000000000002', 12);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0001-000000000002', 200);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0001-000000000002', 201);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0001-000000000002', 202);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0001-000000000002', 203);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0001-000000000002', 204);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0001-000000000002', 300);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0001-000000000002', 301);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0001-000000000002', 302);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0001-000000000002', 303);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00001-0000-0000-0000-def000000001', 1);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00001-0000-0000-0000-def000000001', 2);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00001-0000-0000-0000-def000000001', 3);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00001-0000-0000-0000-def000000001', 4);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00001-0000-0000-0000-def000000001', 5);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00001-0000-0000-0000-def000000001', 6);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00001-0000-0000-0000-def000000001', 7);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00001-0000-0000-0000-def000000001', 8);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00001-0000-0000-0000-def000000001', 9);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00001-0000-0000-0000-def000000001', 10);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00001-0000-0000-0000-def000000001', 11);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00001-0000-0000-0000-def000000001', 12);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00001-0000-0000-0000-def000000001', 300);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00001-0000-0000-0000-def000000001', 301);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00001-0000-0000-0000-def000000001', 302);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00001-0000-0000-0000-def000000001', 303);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00001-0000-0000-0000-def000000001', 100);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00001-0000-0000-0000-def000000001', 101);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00001-0000-0000-0000-def000000001', 102);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00001-0000-0000-0000-def000000001', 103);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00001-0000-0000-0000-def000000001', 104);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00001-0000-0000-0000-def000000001', 400);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00001-0000-0000-0000-def000000001', 401);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00001-0000-0000-0000-def000000001', 402);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00001-0000-0000-0000-def000000001', 403);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00002-0000-0000-0000-def000000002', 1);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00002-0000-0000-0000-def000000002', 2);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00002-0000-0000-0000-def000000002', 3);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00002-0000-0000-0000-def000000002', 4);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00002-0000-0000-0000-def000000002', 5);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00002-0000-0000-0000-def000000002', 6);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00002-0000-0000-0000-def000000002', 7);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00002-0000-0000-0000-def000000002', 8);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00002-0000-0000-0000-def000000002', 9);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00002-0000-0000-0000-def000000002', 10);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00002-0000-0000-0000-def000000002', 11);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00002-0000-0000-0000-def000000002', 12);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00002-0000-0000-0000-def000000002', 200);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00002-0000-0000-0000-def000000002', 201);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00002-0000-0000-0000-def000000002', 202);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00002-0000-0000-0000-def000000002', 203);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00002-0000-0000-0000-def000000002', 204);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00002-0000-0000-0000-def000000002', 300);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00002-0000-0000-0000-def000000002', 301);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00002-0000-0000-0000-def000000002', 302);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00002-0000-0000-0000-def000000002', 303);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00002-0000-0000-0000-def000000002', 100);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00002-0000-0000-0000-def000000002', 101);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00002-0000-0000-0000-def000000002', 102);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00002-0000-0000-0000-def000000002', 103);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00002-0000-0000-0000-def000000002', 104);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00002-0000-0000-0000-def000000002', 400);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00002-0000-0000-0000-def000000002', 401);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00002-0000-0000-0000-def000000002', 402);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00002-0000-0000-0000-def000000002', 403);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00002-0000-0000-0000-def000000002', 700);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00002-0000-0000-0000-def000000002', 701);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00002-0000-0000-0000-def000000002', 702);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00002-0000-0000-0000-def000000002', 703);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00003-0000-0000-0000-def000000003', 600);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00003-0000-0000-0000-def000000003', 601);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00003-0000-0000-0000-def000000003', 602);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00003-0000-0000-0000-def000000003', 603);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00004-0000-0000-0000-def000000004', 100);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00004-0000-0000-0000-def000000004', 101);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00004-0000-0000-0000-def000000004', 102);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00004-0000-0000-0000-def000000004', 103);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00004-0000-0000-0000-def000000004', 104);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00004-0000-0000-0000-def000000004', 600);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00004-0000-0000-0000-def000000004', 601);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00004-0000-0000-0000-def000000004', 602);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00004-0000-0000-0000-def000000004', 603);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00005-0000-0000-0000-def000000005', 104);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00005-0000-0000-0000-def000000005', 103);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00005-0000-0000-0000-def000000005', 403);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00006-0000-0000-0000-def000000006', 1);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00006-0000-0000-0000-def000000006', 2);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00006-0000-0000-0000-def000000006', 3);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00006-0000-0000-0000-def000000006', 4);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00006-0000-0000-0000-def000000006', 5);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00006-0000-0000-0000-def000000006', 6);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00006-0000-0000-0000-def000000006', 7);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00006-0000-0000-0000-def000000006', 8);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00006-0000-0000-0000-def000000006', 9);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00006-0000-0000-0000-def000000006', 10);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00006-0000-0000-0000-def000000006', 11);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00006-0000-0000-0000-def000000006', 12);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00007-0000-0000-0000-def000000007', 300);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00007-0000-0000-0000-def000000007', 301);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00007-0000-0000-0000-def000000007', 302);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00007-0000-0000-0000-def000000007', 303);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00008-0000-0000-0000-def000000008', 200);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00008-0000-0000-0000-def000000008', 201);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00008-0000-0000-0000-def000000008', 202);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00008-0000-0000-0000-def000000008', 203);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00008-0000-0000-0000-def000000008', 204);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('def00009-0000-0000-0000-def000000009', 1);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0000-000000000001', 800);
INSERT INTO roles_groups (role_id, action_group_id) VALUES ('00000000-0000-0000-0001-000000000002', 502);


--
-- Data for Name: roles_relations; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: schema_version; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (1, '03000000', 'upgrade/03_00_0000_add_schema_version.sql', '0', 'postgres', '2012-07-06 15:38:34.575652', '2012-07-06 15:38:34.575652', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (2, '03000010', 'upgrade/03_00_0010_add_group_ids_to_users.sql', '134a5cda68ff78a8ee6c5dd52021d8c6', 'postgres', '2012-07-06 15:38:34.841158', '2012-07-06 15:38:34.865454', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (3, '03000020', 'upgrade/03_00_0020_sync_vdc_options_for_v_2_2.sql', 'cd7489fc727824552e93abdf6fed0dac', 'postgres', '2012-07-06 15:38:34.883505', '2012-07-06 15:38:34.939766', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (4, '03000030', 'upgrade/03_00_0030_change_storage_format_type_to_str.sql', '6bfded79aa68ed713bb171b73347965f', 'postgres', '2012-07-06 15:38:34.957741', '2012-07-06 15:38:35.005568', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (5, '03000040', 'upgrade/03_00_0040_change_vm_dynamic_vm_ip_type.sql', 'e53ab476dd8e9f4ffc34763c1af6b4d2', 'postgres', '2012-07-06 15:38:35.023427', '2012-07-06 15:38:35.046442', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (6, '03000050', 'upgrade/03_00_0050_make_blank_template_pulic.sql', 'ea6d296b7c111a2e0b534d04705e74db', 'postgres', '2012-07-06 15:38:35.062876', '2012-07-06 15:38:35.082875', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (7, '03000060', 'upgrade/03_00_0060_add_group_everyone.sql', 'dcbbd9ac86497d12ed94f33bd83a9106', 'postgres', '2012-07-06 15:38:35.10102', '2012-07-06 15:38:35.121804', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (8, '03000070', 'upgrade/03_00_0070_add_ldap_options.sql', 'a963ec31e1b8dbaf2b57cb3eddaac21d', 'postgres', '2012-07-06 15:38:35.139233', '2012-07-06 15:38:35.159919', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (9, '03000080', 'upgrade/03_00_0080_modify_ldap_security_authentication_option.sql', 'ecf3388d0f79b9a46d8f8e6f46ad9081', 'postgres', '2012-07-06 15:38:35.176035', '2012-07-06 15:38:35.201205', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (10, '03000090', 'upgrade/03_00_0090_add_FenceQuietTimeBetweenOperationsInSec_to_config.sql', 'd3da3582d0b8dfd1c8e8d71307183d3e', 'postgres', '2012-07-06 15:38:35.219865', '2012-07-06 15:38:35.241397', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (11, '03000100', 'upgrade/03_00_0100_add_device_size_to_luns.sql', '7d5ea403964625620682e28528e13205', 'postgres', '2012-07-06 15:38:35.261738', '2012-07-06 15:38:35.289876', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (12, '03000110', 'upgrade/03_00_0110_add_reporting_redirect_options.sql', '7ecd0f77b0da50075a9daedc73d0bd43', 'postgres', '2012-07-06 15:38:35.319548', '2012-07-06 15:38:35.340895', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (13, '03000120', 'upgrade/03_00_0120_add_update_date_to_vm_templates.sql', '6584113b71bb9690ad3e4172c9b638e3', 'postgres', '2012-07-06 15:38:35.358408', '2012-07-06 15:38:35.389835', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (14, '03000130', 'upgrade/03_00_0130_change_dwh_history_timekeeping_date_type.sql', '7d6575c9706b4317d670e2512d7825aa', 'postgres', '2012-07-06 15:38:35.405292', '2012-07-06 15:38:35.432826', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (15, '03000140', 'upgrade/03_00_0140_modify_rhevhlocalfstype_option.sql', '9fab6dfc8876ae2e4c8f5bed3e34ac24', 'postgres', '2012-07-06 15:38:35.449918', '2012-07-06 15:38:35.469673', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (16, '03000150', 'upgrade/03_00_0150_update_roles.sql', 'dd7f5e70f6018748a2316c6cc0439b77', 'postgres', '2012-07-06 15:38:35.487197', '2012-07-06 15:38:35.51501', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (17, '03000160', 'upgrade/03_00_0160_change_fence_mapping_for_drac5.sql', '3a5bc082807166fe682da5c46e6acffe', 'postgres', '2012-07-06 15:38:35.532877', '2012-07-06 15:38:35.554188', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (18, '03000170', 'upgrade/03_00_0170_fix_ldap_servers_version.sql', 'd4a64b296f57a3f36fb890f0b8b312bf', 'postgres', '2012-07-06 15:38:35.577913', '2012-07-06 15:38:35.598677', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (19, '03000180', 'upgrade/03_00_0180_add_guest_disk_size.sql', 'fe6599ec2e6b59280a3f93986e445023', 'postgres', '2012-07-06 15:38:35.616994', '2012-07-06 15:38:35.639913', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (20, '03000190', 'upgrade/03_00_0190_add_latency_vm_disks.sql', '01624a2a2add97685aa6f8a8ca551030', 'postgres', '2012-07-06 15:38:35.657401', '2012-07-06 15:38:35.682946', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (21, '03000200', 'upgrade/03_00_0200_upgrade_per_domain_configuration.sql', '5b9be11112dbeb2b947da2497f4d54a2', 'postgres', '2012-07-06 15:38:35.705814', '2012-07-06 15:38:35.734535', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (22, '03000210', 'upgrade/03_00_0210_add_ProductRPMVersion_to_config.sql', '3d1f0aa626833807c05c6dd9e2708aa3', 'postgres', '2012-07-06 15:38:35.759679', '2012-07-06 15:38:35.780083', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (23, '03000220', 'upgrade/03_00_0220_add_MaxAuditLogMessageLength_to_config.sql', '5fe0b392517b6cbf467456d0de21685b', 'postgres', '2012-07-06 15:38:35.805422', '2012-07-06 15:38:35.83087', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (24, '03000230', 'upgrade/03_00_0230_add_minimal_history_etl_version_vdc_options.sql', 'a445d436acf5cac9f16901b8b38500f0', 'postgres', '2012-07-06 15:38:35.848334', '2012-07-06 15:38:35.867551', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (25, '03000240', 'upgrade/03_00_0240_add_sysprep_user_password_to_vdc_options.sql', 'b8a31b1be54ae7e76ac3044f0c0da38f', 'postgres', '2012-07-06 15:38:35.885213', '2012-07-06 15:38:35.908883', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (26, '03000250', 'upgrade/03_00_0250_update_BootstrapUrl_vdc_options.sql', 'd378cc047ef775d4e3774b5884f2c185', 'postgres', '2012-07-06 15:38:35.927402', '2012-07-06 15:38:35.945101', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (27, '03000260', 'upgrade/03_00_0260_change_app_list_type_to_text.sql', 'b2eb516a44d9a68727ffa899b4c5f463', 'postgres', '2012-07-06 15:38:35.96252', '2012-07-06 15:38:35.988998', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (28, '03000270', 'upgrade/03_00_0270_change_users_group_ids_field_to_text.sql', '52a822350fbb283aef9a36a9454d9b7e', 'postgres', '2012-07-06 15:38:36.007376', '2012-07-06 15:38:36.030077', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (29, '03000280', 'upgrade/03_00_0280_change_blank_template_default_display_type_to_spice.sql', 'ef601e207388c22fcdad41d62a78dfb7', 'postgres', '2012-07-06 15:38:36.047039', '2012-07-06 15:38:36.066438', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (30, '03000290', 'upgrade/03_00_0290_adding_ilo3_agent_support.sql', 'c1cacd696e7a3b9692760b62444992df', 'postgres', '2012-07-06 15:38:36.083981', '2012-07-06 15:38:36.108137', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (31, '03000300', 'upgrade/03_00_0300_add_local_admin_user.sql', '153b10e84844b7e0f882f1751bc1f175', 'postgres', '2012-07-06 15:38:36.128081', '2012-07-06 15:38:36.157833', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (32, '03000310', 'upgrade/03_00_0310_upgrade_remove_default_security_auth.sql', '9baf6de50d440cf772d361f84ef936dc', 'postgres', '2012-07-06 15:38:36.175989', '2012-07-06 15:38:36.19867', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (33, '03000320', 'upgrade/03_00_0320_update_EmulateMachine_config.sql', '19a9dfa8c206495deffa9eb04d049292', 'postgres', '2012-07-06 15:38:36.21582', '2012-07-06 15:38:36.235222', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (34, '03000330', 'upgrade/03_00_0330_add_configuration_action_group_to_super_user_role.sql', '3ce7b989d0a60997ced61880b770ee0f', 'postgres', '2012-07-06 15:38:36.253916', '2012-07-06 15:38:36.272997', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (35, '03000340', 'upgrade/03_00_0340_add_openssl_locking_options.sql', '87b7edd865fc0e4393491b03016e599a', 'postgres', '2012-07-06 15:38:36.289964', '2012-07-06 15:38:36.310782', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (36, '03000350', 'upgrade/03_00_0350_make_MaxMemForVmPerCluster.sql', '081f7521113ca299cc043e6e84a84048', 'postgres', '2012-07-06 15:38:36.327868', '2012-07-06 15:38:36.350192', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (37, '03000360', 'upgrade/03_00_0360_upgrade_default_vds_group_thp.sql', '83c2bb9b40415fe75b376a92bd4161bb', 'postgres', '2012-07-06 15:38:36.368868', '2012-07-06 15:38:36.388019', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (38, '03000370', 'upgrade/03_00_0370_add_server_connection_timeout_option.sql', '418720ebd9fc1e4af87194d92a77e13d', 'postgres', '2012-07-06 15:38:36.40586', '2012-07-06 15:38:36.424812', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (39, '03000380', 'upgrade/03_00_0380_add_otp_validity_to_vds_static.sql', 'eeaa26a093dc33dc6ac5eb86131f00b3', 'postgres', '2012-07-06 15:38:36.441876', '2012-07-06 15:38:36.465306', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (40, '03000390', 'upgrade/03_00_0390_add_firewall_rules_option.sql', 'f84bddd2875e2256feeab1ec3784de63', 'postgres', '2012-07-06 15:38:36.482424', '2012-07-06 15:38:36.502337', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (41, '03000400', 'upgrade/03_00_0400_change_oVirtISOsRepositoryPath_value.sql', 'fdaffff6a60ace686c3799adbf9956bd', 'postgres', '2012-07-06 15:38:36.522084', '2012-07-06 15:38:36.542275', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (42, '03000410', 'upgrade/03_00_0410_add_disks_usage.sql', '6e56398bc15899dda06129529059f20e', 'postgres', '2012-07-06 15:38:36.559823', '2012-07-06 15:38:36.601463', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (43, '03000420', 'upgrade/03_00_0420_config_json.sql', 'c99cc1c991138f41668c66a1e8c6099d', 'postgres', '2012-07-06 15:38:36.651752', '2012-07-06 15:38:36.677444', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (44, '03000430', 'upgrade/03_00_0430_add_add_config_CustomPublicConfig_AppsWebSite.sql', 'a451bca16d5a764172481d1966d1fd94', 'postgres', '2012-07-06 15:38:36.695445', '2012-07-06 15:38:36.715891', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (45, '03000440', 'upgrade/03_00_0440_fixing_ilo3_agent_default_params.sql', 'aba9c319f9ee52e0011ff09c5a307e66', 'postgres', '2012-07-06 15:38:36.733263', '2012-07-06 15:38:36.752349', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (46, '03000450', 'upgrade/03_00_0450_change_fence_mapping_for_drac5.sql', '354081349f42e82cf85d9adb4d007fbb', 'postgres', '2012-07-06 15:38:36.775074', '2012-07-06 15:38:36.794795', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (47, '03000460', 'upgrade/03_00_0460_add_defaultthreadpoolsize_options.sql', '7e6f328d99e62368b5f7967d3c046eb6', 'postgres', '2012-07-06 15:38:36.811296', '2012-07-06 15:38:36.83275', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (48, '03000470', 'upgrade/03_00_0470_modify_etl_minimal_version.sql', '6d599868ec87684a71901992f07e5e91', 'postgres', '2012-07-06 15:38:36.863864', '2012-07-06 15:38:36.882874', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (49, '03000480', 'upgrade/03_00_0480_add_configs_VdsLowFreeSpace.sql', 'fd54c83aecbdce566c14d5b1407fe950', 'postgres', '2012-07-06 15:38:36.899734', '2012-07-06 15:38:36.919871', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (50, '03000490', 'upgrade/03_00_0490_modify_configs_VdsLowFreeSpace.sql', 'f65888d9c0197992d3155e2ebec03fc3', 'postgres', '2012-07-06 15:38:36.937083', '2012-07-06 15:38:36.957793', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (51, '03000500', 'upgrade/03_00_0500_modify_AsyncTaskZombieTaskLifeInMinutes.sql', 'b94eaa31e0e4ab08293badc3d41eb56f', 'postgres', '2012-07-06 15:38:36.97492', '2012-07-06 15:38:36.993859', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (52, '03000510', 'upgrade/03_00_0510_modify_etl_minimal_version.sql', '7086978cbbbb8519a842b80ebb8b0b72', 'postgres', '2012-07-06 15:38:37.010895', '2012-07-06 15:38:37.030533', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (53, '03000520', 'upgrade/03_00_0520_add_configs_IsNeedSupportForOldVgAPI.sql', '3271debf3fe3ebdc768fbe05a0254f8a', 'postgres', '2012-07-06 15:38:37.047891', '2012-07-06 15:38:37.068057', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (54, '03000530', 'upgrade/03_00_0530_update_EmulatedMachine_config_to_pc.sql', 'dc61f2ce2bc84b02fd511d46dd9e31d5', 'postgres', '2012-07-06 15:38:37.084926', '2012-07-06 15:38:37.104862', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (55, '03010010', 'upgrade/03_01_0010_change_action_parameters_type.sql', 'd150d7c28ce61440d020afe2c3ea3464', 'postgres', '2012-07-06 15:38:37.121864', '2012-07-06 15:38:37.178756', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (56, '03010020', 'upgrade/03_01_0020_add_config_value_default_size_for_sparse.sql', '91b3b5e021ff6d10e17dc2c37a91472a', 'postgres', '2012-07-06 15:38:37.20996', '2012-07-06 15:38:37.229818', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (57, '03010030', 'upgrade/03_01_0030_change_vds_static_pm_password_to_text.sql', 'd2912fe7077d1a5b96ce526d55d9ad95', 'postgres', '2012-07-06 15:38:37.246798', '2012-07-06 15:38:37.270997', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (58, '03010040', 'upgrade/03_01_0040_add_AddPermission_to_PowerUserRole.sql', '90bba693f2c0dcd8ec7d0dc96257414d', 'postgres', '2012-07-06 15:38:37.290672', '2012-07-06 15:38:37.311062', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (59, '03010050', 'upgrade/03_01_0050_add_disks_table.sql', '77da7152ca6a23a5ce26e7a23a8900b0', 'postgres', '2012-07-06 15:38:37.328084', '2012-07-06 15:38:37.357811', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (60, '03010060', 'upgrade/03_01_0060_add_cancel_migration_to_action_version_map.sql', '4adceafcd1bbac7eb71b5679f71e08c4', 'postgres', '2012-07-06 15:38:37.375059', '2012-07-06 15:38:37.391897', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (61, '03010070', 'upgrade/03_01_0070_populate_disks_table.sql', 'a014d985d59fc0896c7cfd689bc552ac', 'postgres', '2012-07-06 15:38:37.408287', '2012-07-06 15:38:37.429725', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (62, '03010080', 'upgrade/03_01_0080_add_config_value_management_network.sql', '5fde7636f7f1dfd4e84dfb0cf9e64a3c', 'postgres', '2012-07-06 15:38:37.446956', '2012-07-06 15:38:37.468162', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (63, '03010081', 'upgrade/03_01_0081_update_SignLockFile_config.sql', 'b97ffee6e25fbdfc82989122720c2bfa', 'postgres', '2012-07-06 15:38:37.485237', '2012-07-06 15:38:37.505301', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (64, '03010090', 'upgrade/03_01_0090_add_template_columns_to_vm_static.sql', '7ee271c5d6276f6c4aeb50e9b0f8970a', 'postgres', '2012-07-06 15:38:37.52293', '2012-07-06 15:38:37.592139', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (65, '03010100', 'upgrade/03_01_0100_migrate_templates_to_vm_static.sql', '02ebb9da540d41ca258e317f458d5172', 'postgres', '2012-07-06 15:38:37.614036', '2012-07-06 15:38:37.643413', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (66, '03010110', 'upgrade/03_01_0110_add_vds_spm_priority_col.sql', '4e8ba0896b2a3be8426bc34c5f2966ae', 'postgres', '2012-07-06 15:38:37.660455', '2012-07-06 15:38:37.758375', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (67, '03010120', 'upgrade/03_01_0120_set_ear_lib_path.sql', '62b0433ff58fa997d59039c4307a35b8', 'postgres', '2012-07-06 15:38:37.775679', '2012-07-06 15:38:37.79742', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (68, '03010130', 'upgrade/03_01_0130_update_network_name.sql', '999b6721cf0cad644d8d500e438130da', 'postgres', '2012-07-06 15:38:37.816209', '2012-07-06 15:38:37.834357', 'INSTALLED', false);
INSERT INTO schema_version (id, version, script, checksum, installed_by, started_at, ended_at, state, current) VALUES (69, '03010250', 'upgrade/03_01_0250_add_default_origin_type.sql', '1c7c3e121e0f1559e519c5bbfdc5ccfa', 'postgres', '2012-07-06 15:38:37.851156', '2012-07-06 15:38:37.870531', 'INSTALLED', true);


--
-- Data for Name: stateless_vm_image_map; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: storage_domain_dynamic; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO storage_domain_dynamic (id, available_disk_size, used_disk_size) VALUES ('c2520583-257a-424a-91a3-5a528264e225', 69, 24);
INSERT INTO storage_domain_dynamic (id, available_disk_size, used_disk_size) VALUES ('11c256fe-ab06-4e41-ada1-4beab8d951ac', 88, 5);
INSERT INTO storage_domain_dynamic (id, available_disk_size, used_disk_size) VALUES ('d9949950-675a-494a-a244-3fb4cacb0549', 413, 34);


--
-- Data for Name: storage_domain_static; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO storage_domain_static (id, storage, storage_name, storage_domain_type, storage_type, storage_domain_format_type, _create_date, _update_date) VALUES ('d9949950-675a-494a-a244-3fb4cacb0549', '97ff8fbe-7974-4917-8547-06a06e17626d', 'orgrimmar', 0, 1, '0', '2012-07-15 16:54:58.558578-05', '2012-07-15 16:55:02.753064-05');
INSERT INTO storage_domain_static (id, storage, storage_name, storage_domain_type, storage_type, storage_domain_format_type, _create_date, _update_date) VALUES ('c2520583-257a-424a-91a3-5a528264e225', '21d54212-5101-4b1b-ac19-ed81b85a2726', 'undercity', 2, 1, '0', '2012-07-15 16:57:45.541751-05', NULL);
INSERT INTO storage_domain_static (id, storage, storage_name, storage_domain_type, storage_type, storage_domain_format_type, _create_date, _update_date) VALUES ('11c256fe-ab06-4e41-ada1-4beab8d951ac', '4900c5ef-4e98-4a97-b3ad-1b8b117d3b4e', 'silvermoon', 3, 1, '0', '2012-07-15 16:58:16.027133-05', NULL);


--
-- Data for Name: storage_pool; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO storage_pool (id, name, description, storage_pool_type, storage_pool_format_type, status, master_domain_version, spm_vds_id, compatibility_version, _create_date, _update_date) VALUES ('8e4002ca-c7aa-11e1-8859-080027afa608', 'Azeroth', 'Lok''tar Ogar', 1, '0', 4, 1, NULL, '3.0', '2012-07-06 15:38:34.274861-05', '2012-07-16 01:06:52.453428-05');


--
-- Data for Name: storage_pool_iso_map; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO storage_pool_iso_map (storage_id, storage_pool_id, status, owner) VALUES ('d9949950-675a-494a-a244-3fb4cacb0549', '8e4002ca-c7aa-11e1-8859-080027afa608', 0, 0);
INSERT INTO storage_pool_iso_map (storage_id, storage_pool_id, status, owner) VALUES ('c2520583-257a-424a-91a3-5a528264e225', '8e4002ca-c7aa-11e1-8859-080027afa608', 0, 0);
INSERT INTO storage_pool_iso_map (storage_id, storage_pool_id, status, owner) VALUES ('11c256fe-ab06-4e41-ada1-4beab8d951ac', '8e4002ca-c7aa-11e1-8859-080027afa608', 0, 0);


--
-- Data for Name: storage_server_connections; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO storage_server_connections (id, connection, user_name, password, iqn, port, portal, storage_type) VALUES ('97ff8fbe-7974-4917-8547-06a06e17626d', '192.168.1.21:/zvol/orgrimmar', NULL, NULL, NULL, NULL, NULL, 1);
INSERT INTO storage_server_connections (id, connection, user_name, password, iqn, port, portal, storage_type) VALUES ('21d54212-5101-4b1b-ac19-ed81b85a2726', '192.168.1.21:/zvol/undercity', NULL, NULL, NULL, NULL, NULL, 1);
INSERT INTO storage_server_connections (id, connection, user_name, password, iqn, port, portal, storage_type) VALUES ('4900c5ef-4e98-4a97-b3ad-1b8b117d3b4e', '192.168.1.21:/zvol/silvermoon', NULL, NULL, NULL, NULL, NULL, 1);


--
-- Data for Name: tags; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: tags_user_group_map; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: tags_user_map; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: tags_vds_map; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: tags_vm_map; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: tags_vm_pool_map; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: time_lease_vm_pool_map; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: user_sessions; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: users; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO users (user_id, name, surname, domain, username, groups, department, role, user_icon_path, desktop_device, email, note, status, session_count, last_admin_check_status, group_ids) VALUES ('fdfc627c-d875-11e0-90f0-83df133b58cc', 'admin', NULL, 'internal', 'admin@internal', '', NULL, '', '', '', NULL, '', 1, 0, true, '');


--
-- Data for Name: vdc_db_log; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: vdc_options; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (1, 'AuthenticationMethod', 'LDAP', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (6, 'UserRefreshRate', '3600', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (7, 'LDAPServerPort', '389', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (8, 'LDAPQueryTimeout', '30', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (9, 'SASL_QOP', 'auth-conf', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (10, 'LdapQueryPageSize', '1000', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (11, 'MaxLDAPQueryPartsNumber', '100', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (13, 'DefaultWorkgroup', 'WORKGROUP', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (22, 'ProductKey', '', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (23, 'ProductKey2003', '', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (24, 'ProductKey2003x64', '', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (25, 'ProductKey2008', '', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (26, 'ProductKey2008x64', '', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (27, 'ProductKey2008R2', '', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (28, 'ProductKeyWindow7', '', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (29, 'ProductKeyWindow7x64', '', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (30, 'FreeSpaceLow', '10', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (31, 'FreeSpaceCriticalLowInGB', '5', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (32, 'AsyncTaskPollingRate', '10', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (33, 'StorageDomainFalureTimeoutInMinutes', '5', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (34, 'StoragePoolRefreshTimeInSeconds', '10', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (35, 'SPMFailOverAttempts', '3', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (36, 'SpmCommandFailOverRetries', '3', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (37, 'SANWipeAfterDelete', 'false', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (38, 'NumberOfVmsForTopSizeVms', '10', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (39, 'StoragePoolNonOperationalResetTimeoutInMin', '3', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (40, 'MaxNumberOfHostsInStoragePool', '250', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (41, 'MaxStorageVdsTimeoutCheckSec', '30', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (42, 'MaxStorageVdsDelayCheckSec', '5', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (43, 'vdsTimeout', '180', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (44, 'ServerRebootTimeout', '300', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (45, 'VdsRefreshRate', '2', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (46, 'MaxVdsMemOverCommit', '200', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (47, 'MaxVdsMemOverCommitForServers', '150', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (49, 'EnableUSBAsDefault', 'true', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (52, 'NetConsolePort', '', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (53, 'VdsRecoveryTimeoutInMintues', '3', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (54, 'VDSAttemptsToResetCount', '2', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (55, 'TimeoutToResetVdsInSeconds', '60', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (58, 'BlockMigrationOnSwapUsagePercentage', '0', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (59, 'WaitForVdsInitInSec', '60', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (64, 'CertificateFingerPrint', '73 18 22 44 5d 98 b0 5d c0 f7 36 7d f8 1d 85 da e1 3c f1 c6', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (74, 'SSHInactivityTimoutSeconds', '600', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (76, 'SpiceSecureChannels', 'smain,sinputs', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (77, 'EnableVdsLoadBalancing', 'true', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (78, 'VdsLoadBalancingeIntervalInMinutes', '1', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (79, 'HighUtilizationForEvenlyDistribute', '75', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (80, 'LowUtilizationForEvenlyDistribute', '0', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (81, 'HighUtilizationForPowerSave', '75', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (82, 'LowUtilizationForPowerSave', '20', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (83, 'UtilizationThresholdInPercent', '80', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (84, 'CpuOverCommitDurationMinutes', '2', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (85, 'SpmVCpuConsumption', '1', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (86, 'EnableSpiceRootCertificateValidation', 'true', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (89, 'VdcVersion', '3.0.0.0', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (90, 'AuditLogCleanupTime', '03:35:35', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (91, 'AuditLogAgingThreashold', '30', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (92, 'SearchResultsLimit', '100', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (93, 'LogXmlRpcData', 'false', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (95, 'MaxMacsCountInPool', '100000', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (96, 'MaxVmNameLengthWindows', '15', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (97, 'MaxVmNameLengthNonWindows', '64', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (98, 'MaxVdsNameLength', '255', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (188, 'LogDBCommands', 'false', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (3, 'DomainName', '', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (15, 'SysPrepXPPath', '/usr/share/ovirt-engine/sysprep/sysprep.xp', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (4, 'AdUserName', '', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (56, 'oVirtISOsRepositoryPath', '/usr/share/rhev-hypervisor', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (73, 'CAEngineKey', '/etc/pki/ovirt-engine/private/ca.pem', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (70, 'CertAlias', 'engine', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (61, 'CertificateFileName', '/etc/pki/ovirt-engine/certs/engine.cer', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (63, 'CACertificatePath', '/etc/pki/ovirt-engine/ca.pem', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (69, 'keystoreUrl', '/etc/pki/ovirt-engine/.keystore', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (71, 'TruststoreUrl', '/etc/pki/ovirt-engine/.keystore', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (65, 'CABaseDirectory', '/etc/pki/ovirt-engine', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (21, 'SysPrepWindows7x64Path', '/usr/share/ovirt-engine/sysprep/sysprep.w7x64', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (51, 'OrganizationName', 'FooBar', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (57, 'VdcBootStrapUrl', 'http://ovirt.azeroth.net:8080/Components/vds/', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (17, 'SysPrep2K8Path', '/usr/share/ovirt-engine/sysprep/sysprep.2k8x86', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (67, 'keystorePass', 'mypass', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (75, 'SSLEnabled', 'false', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (18, 'SysPrep2K8x64Path', '/usr/share/ovirt-engine/sysprep/sysprep.2k8', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (14, 'VirtualMachineDomainName', 'ovirt.azeroth.net', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (88, 'DataDir', '/usr/share/ovirt-engine', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (50, 'UseSecureConnectionWithServers', 'false', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (12, 'LocalAdminPassword', 'iWb0lioIxYcUZcCkkWrpevbDOyfGJMph/jmQIq02CJYWSgYGCrmGpUYzcCM+fcD71b0bGe7VLnpm
+ErjvI6ICGYJV6JNMp2KzGOXy7od0+cXCpzWWnNLDECNOG3QtHNhs2TWaNySy7sLIerZZX8tGa17
8h2kELC9O9rvtupIUqw=', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (66, 'TruststorePass', 'mypass', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (16, 'SysPrep2K3Path', '/usr/share/ovirt-engine/sysprep/sysprep.2k3', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (87, 'ConfigDir', '/etc/ovirt-engine', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (68, 'SignScriptName', 'SignReq.sh', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (19, 'SysPrep2K8R2Path', '/usr/share/ovirt-engine/sysprep/sysprep.2k8', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (72, 'PublicURLPort', '8080', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (20, 'SysPrepWindows7Path', '/usr/share/ovirt-engine/sysprep/sysprep.w7', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (48, 'InstallVds', 'false', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (99, 'NumberOfFailedRunsOnVds', '3', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (100, 'TimeToReduceFailedRunOnVdsInMinutes', '30', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (101, 'MaxRerunVmOnVdsCount', '3', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (102, 'ValidNumOfMonitors', '1,2,4', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (103, 'NumberVmRefreshesBeforeSave', '5', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (104, 'VMMinMemorySizeInMB', '256', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (105, 'AutoSuspendTimeInMinutes', '30', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (106, 'VmGracefulShutdownMessage', 'The oVirt Enterprise Virtualization Engine Manager is shutting down this Virtual Machine', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (107, 'SpiceReleaseCursorKeys', 'shift+f12', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (108, 'SpiceToggleFullScreenKeys', 'shift+f11', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (109, 'SpiceUsbAutoShare', 'true', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (110, 'RDPLoginWithFQN', 'true', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (111, 'VncKeyboardLayout', 'en-us', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (112, 'MaxDiskSize', '16384', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (115, 'PowerClientGUI', 'false', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (116, 'PowerClientAutoApprovePatterns', '', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (117, 'PowerClientDedicatedVmLaunchOnVdsWhilePowerClientStarts', 'false', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (118, 'PowerClientAutoMigrateToPowerClientOnConnect', 'false', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (119, 'PowerClientAutoMigrateFromPowerClientToVdsWhenConnectingFromRegularClient', 'false', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (120, 'PowerClientAllowRunningGuestsWithoutTools', 'false', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (121, 'PowerClientAutoRegistrationDefaultVdsGroupID', '99408929-82CF-4DC7-A532-9D998063FA95', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (122, 'PowerClientSpiceDynamicCompressionManagement', 'false', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (123, 'PowerClientAutoAdjustMemory', 'false', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (124, 'PowerClientAutoAdjustMemoryGeneralReserve', '768', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (125, 'PowerClientAutoAdjustMemoryBaseOnAvailableMemory', 'false', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (126, 'PowerClientAutoAdjustMemoryLog', 'false', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (131, 'ENMailDomain', '', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (132, 'ENMailIsBodyHtml', 'true', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (134, 'ENMailUseDefaultCredentials', 'false', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (135, 'VM32BitMaxMemorySizeInMB', '20480', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (137, 'EnableSwapCheck', 'true', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (138, 'SendSMPOnRunVm', 'true', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (139, 'NicDHCPDelayGraceInMS', '60', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (140, 'OvfVirtualSystemType', 'ENGINE', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (141, 'VdsSelectionAlgorithm', 'None', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (143, 'SelectCommandTimeout', '120', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (144, 'CipherSuite', 'DEFAULT', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (145, 'AutoMode', 'PerServer', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (146, 'VmGracefulShutdownTimeout', '30', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (147, 'VmPriorityMaxValue', '100', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (150, 'SearchesRefreshRateInSeconds', '1', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (151, 'UseVdsBrokerInProc', 'true', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (152, 'RenewGuestIpOnVdsSubnetChangeOnParseError', 'false', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (153, 'RenewGuestIpOnVdsSubnetChange', 'false', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (154, 'DebugTimerLogging', 'true', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (156, 'AgentAppName', 'RHEV-Agent', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (158, 'GuestToolsSetupIsoPrefix', 'RHEV-toolsSetup_', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (159, 'VcpuConsumptionPercentage', '10', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (160, 'VdsCertificateValidityInYears', '5', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (161, 'DiskConfigurationList', 'System,Sparse,COW,true;Data,Preallocated,RAW,false;Shared,Preallocated,RAW,false;Swap,Preallocated,RAW,false;Temp,Sparse,COW,false', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (162, 'CbcCheckOnVdsChange', 'false', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (163, 'CBCCertificateScriptName', '/usr/share/vdsm-reg/vdsm-gen-cert', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (164, 'CBCCloseCertificateScriptName', '/usr/share/vdsm-reg/vdsm-complete', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (165, 'PowerClientAutoInstallCertificateOnApprove', 'true', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (166, 'PowerClientMaxNumberOfConcurrentVMs', '1', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (167, 'PowerClientAllowUsingAsIRS', 'false', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (168, 'PowerClientRunVmShouldVerifyPendingVMsAsWell', 'false', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (169, 'PowerClientLogDetection', 'false', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (170, 'PowerClientAutoAdjustMemorySpicePerSessionReserve', '0', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (171, 'PowerClientAutoAdjustMemorySpicePerMonitorReserve', '0', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (172, 'PowerClientAutoAdjustMemoryMaxMemory', '2048', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (173, 'PowerClientAutoAdjustMemoryModulus', '64', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (174, 'oVirtUploadPath', '/data/updates/ovirt-node-image.iso', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (175, 'oVirtUpgradeScriptName', '/usr/share/vdsm-reg/vdsm-upgrade', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (176, 'AsyncTaskStatusCacheRefreshRateInSeconds', '30', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (177, 'AsyncTaskStatusCachingTimeInMinutes', '1', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (178, 'VdsFenceOptions', '', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (180, 'VdsFenceOptionTypes', 'secure=bool,port=int,slot=int', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (181, 'FenceStopStatusRetries', '3', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (182, 'FenceStopStatusDelayBetweenRetriesInSec', '60', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (183, 'FenceStartStatusRetries', '3', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (184, 'FenceStartStatusDelayBetweenRetriesInSec', '60', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (185, 'FindFenceProxyRetries', '3', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (186, 'FindFenceProxyDelayBetweenRetriesInSec', '30', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (187, 'MaxVmsInPool', '1000', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (114, 'DisableFenceAtStartupInSec', '300', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (157, 'SpiceDriverNameInGuest', '{"windows": "RHEV-Spice", "linux" : "xorg-x11-drv-qxl" }', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (142, 'AdUserId', '', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (113, 'AsyncTaskZombieTaskLifeInMinutes', '3000', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (148, 'ScriptsPath', '/usr/share/ovirt-engine', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (149, 'BootstrapInstallerFileName', '/usr/share/ovirt-engine/scripts/vds_installer.py', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (189, 'LockPolicy', 'ON', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (190, 'LockRenewalIntervalSec', '5', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (191, 'LeaseTimeSec', '60', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (192, 'AutoRepoDomainRefreshTime', '60', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (193, 'IoOpTimeoutSec', '10', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (194, 'LeaseRetries', '3', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (196, 'SQLServerPagingSyntax', ' WHERE RowNum BETWEEN %1$s AND %2$s', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (197, 'SQLServerPagingType', 'Range', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (198, 'SQLServerSearchTemplate', 'SELECT * FROM (SELECT *, ROW_NUMBER() OVER(%1$s) as RowNum FROM (%2$s)) as T1) as T2 %3$s', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (200, 'PostgresPagingType', 'Offset', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (202, 'SQLServerLikeSyntax', 'LIKE', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (203, 'PostgresLikeSyntax', 'ILIKE', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (204, 'SQLServerI18NPrefix', 'N', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (205, 'PostgresI18NPrefix', '', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (206, 'SupportedVDSMVersions', '4.5,4.9', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (207, 'SupportedClusterLevels', '2.2,3.0', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (208, 'ImagesSyncronizationTimeout', '0', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (209, 'LicenseCertificateFingerPrint', '5f 38 41 89 b1 33 49 0c 24 13 6b b3 e5 ba 9e c7 fd 83 80 3b', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (210, 'StoragePoolNameSizeLimit', '40', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (211, 'StorageDomainNameSizeLimit', '50', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (214, 'AsyncPollingCyclesBeforeRefreshSuspend', '30', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (216, 'UserSessionTimeOutInterval', '30', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (219, 'UseRtl8139_pv', 'true', '2.2');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (220, 'EmulatedMachine', 'rhel5.5.0', '2.2');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (221, 'LimitNumberOfNetworkInterfaces', 'true', '2.2');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (222, 'DesktopAudioDeviceType', 'default,ac97', '2.2');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (225, 'MaxNumOfVmCpus', '16', '2.2');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (226, 'MaxNumOfVmSockets', '16', '2.2');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (227, 'MaxNumOfCpuPerSocket', '16', '2.2');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (228, 'LocalStorageEnabled', 'false', '2.2');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (229, 'SupportCustomProperties', 'false', '2.2');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (230, 'SupportGetDevicesVisibility', 'false', '2.2');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (231, 'SupportStorageFormat', 'false', '2.2');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (232, 'SupportedStorageFormats', '0', '2.2');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (233, 'UserDefinedVMProperties', '', '3.0');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (234, 'PredefinedVMProperties', 'sap_agent=^(true|false)$;sndbuf=^[0-9]+$;vhost=^(([a-zA-Z0-9_]*):(true|false))(,(([a-zA-Z0-9_]*):(true|false)))*$;viodiskcache=^(none|writeback|writethrough)$', '3.0');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (235, 'UseRtl8139_pv', 'false', '3.0');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (237, 'LimitNumberOfNetworkInterfaces', 'false', '3.0');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (238, 'DesktopAudioDeviceType', 'WindowsXP,ac97,RHEL4,ac97,RHEL3,ac97,Windows2003x64,ac97,RHEL4x64,ac97,RHEL3x64,ac97,OtherLinux,ac97,Other,ac97,default,ich6', '3.0');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (241, 'MaxNumOfVmCpus', '64', '3.0');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (242, 'MaxNumOfVmSockets', '16', '3.0');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (243, 'MaxNumOfCpuPerSocket', '16', '3.0');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (244, 'LocalStorageEnabled', 'true', '3.0');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (245, 'SupportCustomProperties', 'true', '3.0');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (246, 'SupportGetDevicesVisibility', 'true', '3.0');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (247, 'SupportStorageFormat', 'true', '3.0');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (248, 'SupportedStorageFormats', '0,2', '3.0');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (249, 'UknownTaskPrePollingLapse', '60000', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (250, 'PredefinedVMProperties', '', '2.2');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (251, 'UserDefinedVMProperties', '', '2.2');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (195, 'DBEngine', 'Postgres', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (155, 'DebugSearchLogging', 'false', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (213, 'DefaultTimeZone', '(GMT) GMT Standard Time', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (212, 'IsMultilevelAdministrationOn', 'true', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (60, 'LogPhysicalMemoryThresholdInMB', '1024', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (199, 'PostgresPagingSyntax', 'OFFSET (%1$s -1) LIMIT %2$s', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (201, 'PostgresSearchTemplate', 'SELECT * FROM (%2$s) %1$s) as T1 %3$s', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (223, 'ServerCPUList', '2:Intel Xeon w/o XD/NX:vmx,sse2:qemu64,-nx,+sse2; 3:Intel Xeon:vmx,sse2,nx:qemu64,+sse2; 4:Intel Conroe Family:vmx,sse2,nx,cx16,ssse3:qemu64,+sse2,+cx16,+ssse3; 5:Intel Penryn Family:vmx,sse2,nx,cx16,ssse3,sse4_1:qemu64,+sse2,+cx16,+ssse3,+sse4.1; 6:Intel Nehalem Family:vmx,sse2,nx,cx16,ssse3,sse4_1,sse4_2,popcnt:qemu64,+sse2,+cx16,+ssse3,+sse4.1,+sse4.2,+popcnt; 2:AMD Opteron G1 w/o NX:svm,sse2:qemu64,-nx,+sse2; 3:AMD Opteron G1:svm,sse2,nx:qemu64,+sse2; 4:AMD Opteron G2:svm,sse2,nx,cx16:qemu64,+sse2,+cx16; 5:AMD Opteron G3:svm,sse2,nx,cx16,sse4a,misalignsse,popcnt,abm:qemu64,+sse2,+cx16,+sse4a,+misalignsse,+popcnt,+abm;', '2.2');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (239, 'ServerCPUList', '3:Intel Conroe Family:vmx,nx,model_Conroe:Conroe; 4:Intel Penryn Family:vmx,nx,model_Penryn:Penryn; 5:Intel Nehalem Family:vmx,nx,model_Nehalem:Nehalem; 6:Intel Westmere Family:aes,vmx,nx,model_Westmere:Westmere; 2:AMD Opteron G1:svm,nx,model_Opteron_G1:Opteron_G1; 3:AMD Opteron G2:svm,nx,model_Opteron_G2:Opteron_G2; 4:AMD Opteron G3:svm,nx,model_Opteron_G3:Opteron_G3;', '3.0');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (224, 'VdsFenceType', 'alom,apc,bladecenter,drac5,eps,ilo,ipmilan,rsa,rsb,wti,cisco_ucs', '2.2');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (5, 'AdUserPassword', '', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (253, 'FenceQuietTimeBetweenOperationsInSec', '180', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (254, 'RedirectServletReportsPage', '', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (255, 'RedirectServletReportsPageError', 'Reports not installed, please contact your administrator', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (218, 'RhevhLocalFSPath', '/data/images/rhev', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (240, 'VdsFenceType', 'alom,apc,bladecenter,drac5,eps,ilo,ilo3,ipmilan,rsa,rsb,wti,cisco_ucs', '3.0');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (256, 'LdapServers', '', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (258, 'MaxAuditLogMessageLength', '10000', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (260, 'SysPrepDefaultUser', '', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (261, 'SysPrepDefaultPassword', '', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (215, 'AsyncPollingCyclesBeforeCallbackCleanup', '30', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (2, 'LDAPSecurityAuthentication', '', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (259, 'MinimalETLVersion', '3.0.0', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (217, 'ENGINEEARLib', '/usr/share/jboss-as/standalone/deployments/engine.ear', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (257, 'ProductRPMVersion', '3.0.0_0001-1.6.fc16', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (236, 'EmulatedMachine', 'rhel6.2.0', '3.0');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (262, 'FenceAgentMapping', 'ilo3=ipmilan', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (264, 'AdminUser', 'admin', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (265, 'AdminDomain', 'internal', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (268, 'SignCertTimeoutInSeconds', '30', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (269, 'VM64BitMaxMemorySizeInMB', '524288', '3.0');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (270, 'VM64BitMaxMemorySizeInMB', '262144', '2.2');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (271, 'ConnectToServerTimeoutInSeconds', '20', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (272, 'IPTablesConfig', '# oVirt default firewall configuration. Automatically generated by vdsm bootstrap script.
*filter
:INPUT ACCEPT [0:0]
:FORWARD ACCEPT [0:0]
:OUTPUT ACCEPT [0:0]
-A INPUT -m state --state ESTABLISHED,RELATED -j ACCEPT
-A INPUT -p icmp -j ACCEPT
-A INPUT -i lo -j ACCEPT
# vdsm
-A INPUT -p tcp --dport 54321 -j ACCEPT
# libvirt tls
-A INPUT -p tcp --dport 16514 -j ACCEPT
# SSH
-A INPUT -p tcp --dport 22 -j ACCEPT
# guest consoles
-A INPUT -p tcp -m multiport --dports 5634:6166 -j ACCEPT
# migration
-A INPUT -p tcp -m multiport --dports 49152:49216 -j ACCEPT
# snmp
-A INPUT -p udp --dport 161 -j ACCEPT
# Reject any other input traffic
-A INPUT -j REJECT --reject-with icmp-host-prohibited
-A FORWARD -m physdev ! --physdev-is-bridged -j REJECT --reject-with icmp-host-prohibited
COMMIT
', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (273, 'CustomPublicConfig_AppsWebSite', 'http://marketplace.redhat.com/rhev?origin=engine-$EngineVersion', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (263, 'FenceAgentDefaultParams', 'ilo3:lanplus,power_wait=4', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (179, 'VdsFenceOptionMapping', 'alom:secure=secure,port=ipport;apc:secure=secure,port=ipport,slot=port;bladecenter:secure=secure,port=ipport,slot=port;drac5:secure=secure,slot=port;eps:slot=port;ilo:secure=ssl,port=ipport;ipmilan:;rsa:secure=secure,port=ipport;rsb:;wti:secure=secure,port=ipport,slot=port;cisco_ucs:secure=ssl,slot=port;ilo3:', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (274, 'DefaultMinThreadPoolSize', '50', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (275, 'DefaultMaxThreadPoolSize', '500', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (276, 'VdsLocalDisksLowFreeSpace', '1000', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (277, 'VdsLocalDisksCriticallyLowFreeSpace', '500', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (278, 'IsNeedSupportForOldVgAPI', 'true', '2.2');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (279, 'IsNeedSupportForOldVgAPI', 'false', '3.0');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (280, 'InitStorageSparseSizeInGB', '1', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (281, 'ManagementNetwork', 'ovirtmgmt', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (267, 'SignLockFile', '/var/lock/ovirt-engine/.openssl.exclusivelock', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (282, 'OriginType', 'OVIRT', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (94, 'MacPoolRanges', '00:1A:4A:A8:01:00-00:1A:4A:A8:01:FF', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (62, 'CertificatePassword', 'cDbsI4mO5QpNFrwzFIyhcLWySPWZCwlENbdHR8S7o7wrVqEW0go6Pd0EX8CcpHw99jF8kNaLgCaX
TyHVXT4Z83p1gwLxDAKrKKmQRabU6dx6GqJK45UWHkd2Ll5SctsV7gNTB5JGT9hcUvwTbkvHv/Ut
Ech5ZeRb9YY3hhYIZSU=', 'general');
INSERT INTO vdc_options (option_id, option_name, option_value, version) VALUES (266, 'AdminPassword', 'UUQeem57P5CV/XJCX9QT9qMTTQUNE09ahiHMxb/ABhRLHhjiX3PBz5vQMps9CE9rZ9HVfObbfHd8
r+1Ef41AH07lEYHPX62cCJ47FvXaWmW9+bAfISdGcd8BMygBVPLzIRmMrr9C5JNF+O1dt4KCXVyU
FLl3RxjSk6sgU1u3aKQ=', 'general');


--
-- Data for Name: vds_dynamic; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO vds_dynamic (vds_id, status, cpu_cores, cpu_model, cpu_speed_mh, if_total_speed, kvm_enabled, physical_mem_mb, mem_commited, vm_active, vm_count, vm_migrating, reserved_mem, guest_overhead, software_version, version_name, build_name, previous_status, cpu_flags, cpu_over_commit_time_stamp, hypervisor_type, vms_cores_count, pending_vcpus_count, cpu_sockets, net_config_dirty, supported_cluster_levels, supported_engines, host_os, kvm_version, spice_version, kernel_version, iscsi_initiator_name, transparent_hugepages_state, anonymous_hugepages, hooks, _update_date, non_operational_reason, pending_vmem_size) VALUES ('b3c8097c-ce5b-11e1-8365-080027afa608', 2, 8, 'Intel(R) Xeon(R) CPU           E5540  @ 2.53GHz', 2527, NULL, true, 36140, 0, 0, 0, 0, 256, 65, '4.9.113.1', 'Snow Man', NULL, 3, 'fpu,vme,de,pse,tsc,msr,pae,mce,cx8,apic,mtrr,pge,mca,cmov,pat,pse36,clflush,dts,acpi,mmx,fxsr,sse,sse2,ss,ht,tm,pbe,syscall,nx,rdtscp,lm,constant_tsc,arch_perfmon,pebs,bts,rep_good,xtopology,nonstop_tsc,aperfmperf,pni,dtes64,monitor,ds_cpl,vmx,est,tm2,ssse3,cx16,xtpr,pdcm,dca,sse4_1,sse4_2,popcnt,lahf_lm,ida,dts,tpr_shadow,vnmi,flexpriority,ept,vpid,model_486,model_pentium,model_pentium2,model_pentium3,model_pentiumpro,model_qemu32,model_cpu64-rhel5,model_cpu64-rhel6,model_kvm32,model_coreduo,model_kvm64,model_core2duo,model_n270,model_Conroe,model_Penryn,model_Nehalem,model_Opteron_G1', '2012-07-16 01:06:23.599-05', 0, 0, 0, 2, false, '3.0', NULL, 'RHEL - 6.2 - 1.1', '0.12.1.2 - 2.209.el6_2.4', '0.8.2 - 5.el6', '2.6.32 - 220.23.1.el6.x86_64', 'iqn.2012-07.net.azeroth:durotar', 2, 430, '{}', '2012-07-17 00:30:13.411298-05', 0, 0);


--
-- Data for Name: vds_groups; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO vds_groups (vds_group_id, name, description, cpu_name, _create_date, _update_date, selection_algorithm, high_utilization, low_utilization, cpu_over_commit_duration_minutes, hypervisor_type, storage_pool_id, max_vds_memory_over_commit, compatibility_version, transparent_hugepages, migrate_on_error) VALUES ('99408929-82cf-4dc7-a532-9d998063fa95', 'Horde', 'For The Horde', 'Intel Nehalem Family', '2012-07-06 15:38:34.274861-05', '2012-07-06 15:59:01.560915-05', 0, 75, 0, 2, 0, '8e4002ca-c7aa-11e1-8859-080027afa608', 100, '3.0', true, 1);


--
-- Data for Name: vds_interface; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO vds_interface (id, name, network_name, vds_id, mac_addr, is_bond, bond_name, bond_type, bond_opts, vlan_id, speed, addr, subnet, gateway, boot_protocol, type, _create_date, _update_date) VALUES ('04a88321-fda2-4ff5-b86a-d981ed1bfd90', 'bond3', NULL, 'b3c8097c-ce5b-11e1-8365-080027afa608', '00:00:00:00:00:00', true, NULL, NULL, NULL, NULL, NULL, '', '', NULL, 0, 0, '2012-07-15 04:01:48.852778-05', '2012-07-15 16:52:57.487844-05');
INSERT INTO vds_interface (id, name, network_name, vds_id, mac_addr, is_bond, bond_name, bond_type, bond_opts, vlan_id, speed, addr, subnet, gateway, boot_protocol, type, _create_date, _update_date) VALUES ('1bb638ec-47a1-475e-a8e6-ca037bde10de', 'bond4', NULL, 'b3c8097c-ce5b-11e1-8365-080027afa608', '00:00:00:00:00:00', true, NULL, NULL, NULL, NULL, NULL, '', '', NULL, 0, 0, '2012-07-15 04:01:48.850388-05', '2012-07-15 16:52:57.4894-05');
INSERT INTO vds_interface (id, name, network_name, vds_id, mac_addr, is_bond, bond_name, bond_type, bond_opts, vlan_id, speed, addr, subnet, gateway, boot_protocol, type, _create_date, _update_date) VALUES ('6c5c3f3b-48f9-4024-bae2-6aae47a25468', 'eth0', NULL, 'b3c8097c-ce5b-11e1-8365-080027afa608', '00:21:28:83:B5:16', NULL, 'bond0', NULL, NULL, NULL, 1000, '', '', NULL, NULL, 0, '2012-07-15 04:01:48.847688-05', '2012-07-15 16:52:57.490378-05');
INSERT INTO vds_interface (id, name, network_name, vds_id, mac_addr, is_bond, bond_name, bond_type, bond_opts, vlan_id, speed, addr, subnet, gateway, boot_protocol, type, _create_date, _update_date) VALUES ('5a85d09c-be9c-4d05-8efd-827709f89a08', 'eth2', NULL, 'b3c8097c-ce5b-11e1-8365-080027afa608', '00:21:28:83:B5:18', NULL, 'bond1', NULL, NULL, NULL, 1000, '', '', NULL, NULL, 0, '2012-07-15 04:01:48.844987-05', '2012-07-15 16:52:57.491447-05');
INSERT INTO vds_interface (id, name, network_name, vds_id, mac_addr, is_bond, bond_name, bond_type, bond_opts, vlan_id, speed, addr, subnet, gateway, boot_protocol, type, _create_date, _update_date) VALUES ('c89a8334-2689-4977-9d06-715fc6772e94', 'eth1', NULL, 'b3c8097c-ce5b-11e1-8365-080027afa608', '00:21:28:83:B5:17', NULL, 'bond0', NULL, NULL, NULL, 1000, '', '', NULL, NULL, 0, '2012-07-15 04:01:48.842239-05', '2012-07-15 16:52:57.492401-05');
INSERT INTO vds_interface (id, name, network_name, vds_id, mac_addr, is_bond, bond_name, bond_type, bond_opts, vlan_id, speed, addr, subnet, gateway, boot_protocol, type, _create_date, _update_date) VALUES ('887db344-5e12-48f2-b0cb-3b8ada3a1f32', 'eth3', NULL, 'b3c8097c-ce5b-11e1-8365-080027afa608', '00:21:28:83:B5:19', NULL, 'bond1', NULL, NULL, NULL, 1000, '', '', NULL, NULL, 0, '2012-07-15 04:01:48.80791-05', '2012-07-15 16:52:57.494003-05');
INSERT INTO vds_interface (id, name, network_name, vds_id, mac_addr, is_bond, bond_name, bond_type, bond_opts, vlan_id, speed, addr, subnet, gateway, boot_protocol, type, _create_date, _update_date) VALUES ('13339e77-71aa-4a3a-8042-e7267a57dff7', 'bond2', NULL, 'b3c8097c-ce5b-11e1-8365-080027afa608', '00:00:00:00:00:00', true, NULL, NULL, NULL, NULL, NULL, '', '', NULL, 0, 0, '2012-07-15 04:01:48.859185-05', '2012-07-15 16:52:57.494972-05');
INSERT INTO vds_interface (id, name, network_name, vds_id, mac_addr, is_bond, bond_name, bond_type, bond_opts, vlan_id, speed, addr, subnet, gateway, boot_protocol, type, _create_date, _update_date) VALUES ('8f676077-8538-46a4-b766-492a0fd92d9d', 'bond1', 'gadgetzan', 'b3c8097c-ce5b-11e1-8365-080027afa608', '00:21:28:83:B5:18', true, NULL, NULL, 'mode=5 miimon=250', NULL, NULL, '', '', '0.0.0.0', 0, 0, '2012-07-15 04:01:48.857062-05', '2012-07-15 16:52:57.503315-05');
INSERT INTO vds_interface (id, name, network_name, vds_id, mac_addr, is_bond, bond_name, bond_type, bond_opts, vlan_id, speed, addr, subnet, gateway, boot_protocol, type, _create_date, _update_date) VALUES ('0545e0cc-12da-4b79-93b4-0bdd11b4d604', 'bond0', 'ovirtmgmt', 'b3c8097c-ce5b-11e1-8365-080027afa608', '00:21:28:83:B5:16', true, NULL, NULL, 'mode=6 miimon=250', NULL, NULL, '192.168.1.22', '255.255.255.0', '192.168.1.1', 0, 0, '2012-07-15 04:01:48.85489-05', '2012-07-15 16:52:57.504384-05');


--
-- Data for Name: vds_interface_statistics; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO vds_interface_statistics (id, vds_id, rx_rate, tx_rate, rx_drop, tx_drop, iface_status) VALUES ('04a88321-fda2-4ff5-b86a-d981ed1bfd90', 'b3c8097c-ce5b-11e1-8365-080027afa608', 0, 0, 0, 0, 2);
INSERT INTO vds_interface_statistics (id, vds_id, rx_rate, tx_rate, rx_drop, tx_drop, iface_status) VALUES ('1bb638ec-47a1-475e-a8e6-ca037bde10de', 'b3c8097c-ce5b-11e1-8365-080027afa608', 0, 0, 0, 0, 2);
INSERT INTO vds_interface_statistics (id, vds_id, rx_rate, tx_rate, rx_drop, tx_drop, iface_status) VALUES ('6c5c3f3b-48f9-4024-bae2-6aae47a25468', 'b3c8097c-ce5b-11e1-8365-080027afa608', 0, 0, 0, 0, 1);
INSERT INTO vds_interface_statistics (id, vds_id, rx_rate, tx_rate, rx_drop, tx_drop, iface_status) VALUES ('5a85d09c-be9c-4d05-8efd-827709f89a08', 'b3c8097c-ce5b-11e1-8365-080027afa608', 0, 0, 0, 0, 1);
INSERT INTO vds_interface_statistics (id, vds_id, rx_rate, tx_rate, rx_drop, tx_drop, iface_status) VALUES ('c89a8334-2689-4977-9d06-715fc6772e94', 'b3c8097c-ce5b-11e1-8365-080027afa608', 0, 0, 0, 0, 1);
INSERT INTO vds_interface_statistics (id, vds_id, rx_rate, tx_rate, rx_drop, tx_drop, iface_status) VALUES ('887db344-5e12-48f2-b0cb-3b8ada3a1f32', 'b3c8097c-ce5b-11e1-8365-080027afa608', 0, 0, 0, 0, 1);
INSERT INTO vds_interface_statistics (id, vds_id, rx_rate, tx_rate, rx_drop, tx_drop, iface_status) VALUES ('13339e77-71aa-4a3a-8042-e7267a57dff7', 'b3c8097c-ce5b-11e1-8365-080027afa608', 0, 0, 0, 0, 2);
INSERT INTO vds_interface_statistics (id, vds_id, rx_rate, tx_rate, rx_drop, tx_drop, iface_status) VALUES ('8f676077-8538-46a4-b766-492a0fd92d9d', 'b3c8097c-ce5b-11e1-8365-080027afa608', 0, 0, 0, 0, 1);
INSERT INTO vds_interface_statistics (id, vds_id, rx_rate, tx_rate, rx_drop, tx_drop, iface_status) VALUES ('0545e0cc-12da-4b79-93b4-0bdd11b4d604', 'b3c8097c-ce5b-11e1-8365-080027afa608', 0, 0, 0, 0, 1);


--
-- Data for Name: vds_spm_id_map; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO vds_spm_id_map (storage_pool_id, vds_spm_id, vds_id) VALUES ('8e4002ca-c7aa-11e1-8859-080027afa608', 1, 'b3c8097c-ce5b-11e1-8365-080027afa608');


--
-- Data for Name: vds_static; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO vds_static (vds_id, vds_name, ip, vds_unique_id, host_name, port, vds_group_id, server_ssl_enabled, vds_type, vds_strength, pm_type, pm_user, pm_password, pm_port, pm_options, pm_enabled, _create_date, _update_date, otp_validity, vds_spm_priority) VALUES ('b3c8097c-ce5b-11e1-8365-080027afa608', 'durotar', NULL, NULL, '192.168.1.22', 54321, '99408929-82cf-4dc7-a532-9d998063fa95', false, 0, 100, NULL, NULL, NULL, NULL, 'port,secure=false', false, '2012-07-15 04:01:45.121343-05', NULL, NULL, 5);


--
-- Data for Name: vds_statistics; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO vds_statistics (vds_id, cpu_idle, cpu_load, cpu_sys, cpu_user, usage_mem_percent, usage_cpu_percent, usage_network_percent, mem_available, mem_shared, swap_free, swap_total, ksm_cpu_percent, ksm_pages, ksm_state) VALUES ('b3c8097c-ce5b-11e1-8365-080027afa608', 0, 0, 0, 0, 0, 0, 0, 34527, 0, 4094, 4094, 0, 100, false);


--
-- Data for Name: vm_dynamic; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO vm_dynamic (vm_guid, status, vm_ip, vm_host, vm_pid, vm_last_up_time, vm_last_boot_time, guest_cur_user_name, guest_cur_user_id, guest_last_login_time, guest_last_logout_time, guest_os, run_on_vds, migrating_to_vds, app_list, display, acpi_enable, session, display_ip, display_type, kvm_enable, display_secure_port, utc_diff, last_vds_run_on, client_ip, guest_requested_memory, hibernation_vol_handle, boot_sequence, exit_status, pause_status, exit_message) VALUES ('4077e5f5-d143-4841-a06a-aaf8042c1b39', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 5900, true, 0, '192.168.1.22', 1, true, -1, -2, NULL, '', NULL, NULL, 1, 0, 0, NULL);
INSERT INTO vm_dynamic (vm_guid, status, vm_ip, vm_host, vm_pid, vm_last_up_time, vm_last_boot_time, guest_cur_user_name, guest_cur_user_id, guest_last_login_time, guest_last_logout_time, guest_os, run_on_vds, migrating_to_vds, app_list, display, acpi_enable, session, display_ip, display_type, kvm_enable, display_secure_port, utc_diff, last_vds_run_on, client_ip, guest_requested_memory, hibernation_vol_handle, boot_sequence, exit_status, pause_status, exit_message) VALUES ('7894db01-d1aa-4fc1-bb3c-2eec9704b35d', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 5901, true, 0, '192.168.1.22', 1, true, -1, -2, NULL, '', NULL, NULL, 1, 0, 0, NULL);
INSERT INTO vm_dynamic (vm_guid, status, vm_ip, vm_host, vm_pid, vm_last_up_time, vm_last_boot_time, guest_cur_user_name, guest_cur_user_id, guest_last_login_time, guest_last_logout_time, guest_os, run_on_vds, migrating_to_vds, app_list, display, acpi_enable, session, display_ip, display_type, kvm_enable, display_secure_port, utc_diff, last_vds_run_on, client_ip, guest_requested_memory, hibernation_vol_handle, boot_sequence, exit_status, pause_status, exit_message) VALUES ('329b46ff-80f7-4b35-a1cc-5dac80e2a43e', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 5902, true, 0, '192.168.1.22', 1, true, -1, 0, NULL, '', NULL, NULL, 1, 0, 0, NULL);


--
-- Data for Name: vm_interface; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO vm_interface (id, network_name, vm_guid, vmt_guid, mac_addr, name, speed, type, _create_date, _update_date) VALUES ('59f4d014-4699-4215-aedb-009ee2fe141a', 'gadgetzan', '4077e5f5-d143-4841-a06a-aaf8042c1b39', NULL, '00:1a:4a:a8:01:00', 'vnic0', 100, 1, '2012-07-15 17:15:23.241032-05', NULL);
INSERT INTO vm_interface (id, network_name, vm_guid, vmt_guid, mac_addr, name, speed, type, _create_date, _update_date) VALUES ('f414581a-589d-4ca9-a2c8-bf85519537e5', 'gadgetzan', '7894db01-d1aa-4fc1-bb3c-2eec9704b35d', NULL, '00:1a:4a:a8:01:01', 'vnic0', 1000, 3, '2012-07-15 17:55:20.669684-05', NULL);
INSERT INTO vm_interface (id, network_name, vm_guid, vmt_guid, mac_addr, name, speed, type, _create_date, _update_date) VALUES ('7c433314-fda0-48e7-9f9d-c2f3e14a3071', 'gadgetzan', '329b46ff-80f7-4b35-a1cc-5dac80e2a43e', NULL, '00:1a:4a:a8:01:02', 'vnic0', 1000, 2, '2012-07-16 00:12:18.121967-05', NULL);


--
-- Data for Name: vm_interface_statistics; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO vm_interface_statistics (id, vm_id, rx_rate, tx_rate, rx_drop, tx_drop, iface_status) VALUES ('7c433314-fda0-48e7-9f9d-c2f3e14a3071', '329b46ff-80f7-4b35-a1cc-5dac80e2a43e', 0, 0, 0, 0, 0);
INSERT INTO vm_interface_statistics (id, vm_id, rx_rate, tx_rate, rx_drop, tx_drop, iface_status) VALUES ('59f4d014-4699-4215-aedb-009ee2fe141a', '4077e5f5-d143-4841-a06a-aaf8042c1b39', 0, 0, 0, 0, 0);
INSERT INTO vm_interface_statistics (id, vm_id, rx_rate, tx_rate, rx_drop, tx_drop, iface_status) VALUES ('f414581a-589d-4ca9-a2c8-bf85519537e5', '7894db01-d1aa-4fc1-bb3c-2eec9704b35d', 0, 0, 0, 0, 0);


--
-- Data for Name: vm_pool_map; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: vm_pools; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: vm_static; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO vm_static (vm_guid, vm_name, mem_size_mb, vmt_guid, os, description, vds_group_id, domain, creation_date, num_of_monitors, is_initialized, is_auto_suspend, num_of_sockets, cpu_per_socket, usb_policy, time_zone, is_stateless, fail_back, _create_date, _update_date, dedicated_vm_for_vds, auto_startup, vm_type, hypervisor_type, operation_mode, nice_level, default_boot_sequence, default_display_type, priority, iso_path, origin, initrd_url, kernel_url, kernel_params, migration_support, userdefined_properties, predefined_properties, min_allocated_mem, entity_type, child_count, template_status) VALUES ('00000000-0000-0000-0000-000000000000', 'Blank', 512, '00000000-0000-0000-0000-000000000000', 0, 'Blank template', '99408929-82cf-4dc7-a532-9d998063fa95', '', '2008-04-01 00:00:00-05', 1, NULL, false, 1, 1, NULL, NULL, NULL, false, '2012-07-06 15:38:37.627114-05', '2012-07-06 15:38:35.368955-05', NULL, NULL, 0, 0, 0, 0, 0, 1, 0, '', 0, NULL, NULL, NULL, 0, NULL, NULL, 0, 'TEMPLATE', 0, 0);
INSERT INTO vm_static (vm_guid, vm_name, mem_size_mb, vmt_guid, os, description, vds_group_id, domain, creation_date, num_of_monitors, is_initialized, is_auto_suspend, num_of_sockets, cpu_per_socket, usb_policy, time_zone, is_stateless, fail_back, _create_date, _update_date, dedicated_vm_for_vds, auto_startup, vm_type, hypervisor_type, operation_mode, nice_level, default_boot_sequence, default_display_type, priority, iso_path, origin, initrd_url, kernel_url, kernel_params, migration_support, userdefined_properties, predefined_properties, min_allocated_mem, entity_type, child_count, template_status) VALUES ('4077e5f5-d143-4841-a06a-aaf8042c1b39', 'winxp', 2048, '00000000-0000-0000-0000-000000000000', 1, 'winxp foo', '99408929-82cf-4dc7-a532-9d998063fa95', '', '2012-07-15 17:15:03.353-05', 1, true, false, 1, 2, 0, 'GMT Standard Time', false, false, '2012-07-15 17:15:03.357564-05', NULL, NULL, false, 0, 0, 0, 0, 1, 1, 1, 'WinXP-Pro-SP3.iso', 3, '', '', '', 0, NULL, NULL, 2048, 'VM', 0, NULL);
INSERT INTO vm_static (vm_guid, vm_name, mem_size_mb, vmt_guid, os, description, vds_group_id, domain, creation_date, num_of_monitors, is_initialized, is_auto_suspend, num_of_sockets, cpu_per_socket, usb_policy, time_zone, is_stateless, fail_back, _create_date, _update_date, dedicated_vm_for_vds, auto_startup, vm_type, hypervisor_type, operation_mode, nice_level, default_boot_sequence, default_display_type, priority, iso_path, origin, initrd_url, kernel_url, kernel_params, migration_support, userdefined_properties, predefined_properties, min_allocated_mem, entity_type, child_count, template_status) VALUES ('7894db01-d1aa-4fc1-bb3c-2eec9704b35d', 'sl62', 2048, '00000000-0000-0000-0000-000000000000', 19, 'sl62 foo', '99408929-82cf-4dc7-a532-9d998063fa95', '', '2012-07-15 17:55:09.068-05', 1, true, false, 2, 2, 0, '', false, false, '2012-07-15 17:55:09.068968-05', NULL, NULL, false, 1, 0, 0, 0, 1, 1, 1, 'SL-62-x86_64-2012-02-06-Everything-DVD1.iso', 3, '', '', '', 0, NULL, NULL, 2048, 'VM', 0, NULL);
INSERT INTO vm_static (vm_guid, vm_name, mem_size_mb, vmt_guid, os, description, vds_group_id, domain, creation_date, num_of_monitors, is_initialized, is_auto_suspend, num_of_sockets, cpu_per_socket, usb_policy, time_zone, is_stateless, fail_back, _create_date, _update_date, dedicated_vm_for_vds, auto_startup, vm_type, hypervisor_type, operation_mode, nice_level, default_boot_sequence, default_display_type, priority, iso_path, origin, initrd_url, kernel_url, kernel_params, migration_support, userdefined_properties, predefined_properties, min_allocated_mem, entity_type, child_count, template_status) VALUES ('329b46ff-80f7-4b35-a1cc-5dac80e2a43e', 'rh73', 1024, '00000000-0000-0000-0000-000000000000', 5, 'rh72 foo', '99408929-82cf-4dc7-a532-9d998063fa95', '', '2012-07-16 00:12:02.855-05', 1, true, false, 1, 2, 0, '', false, false, '2012-07-16 00:12:02.856439-05', NULL, NULL, false, 1, 0, 0, 0, 1, 1, 1, 'valhalla-i386-disc1.iso', 3, '', '', '', 0, NULL, NULL, 1024, 'VM', 0, NULL);


--
-- Data for Name: vm_statistics; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO vm_statistics (vm_guid, cpu_user, cpu_sys, elapsed_time, usage_network_percent, usage_mem_percent, usage_cpu_percent, disks_usage) VALUES ('4077e5f5-d143-4841-a06a-aaf8042c1b39', 0, 0, 0, 0, 0, 0, NULL);
INSERT INTO vm_statistics (vm_guid, cpu_user, cpu_sys, elapsed_time, usage_network_percent, usage_mem_percent, usage_cpu_percent, disks_usage) VALUES ('7894db01-d1aa-4fc1-bb3c-2eec9704b35d', 0, 0, 0, 0, 0, 0, NULL);
INSERT INTO vm_statistics (vm_guid, cpu_user, cpu_sys, elapsed_time, usage_network_percent, usage_mem_percent, usage_cpu_percent, disks_usage) VALUES ('329b46ff-80f7-4b35-a1cc-5dac80e2a43e', 0, 0, 0, 0, 0, 0, NULL);


--
-- Data for Name: vm_template_image_map; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO vm_template_image_map (it_guid, vmt_guid, internal_drive_mapping) VALUES ('00000000-0000-0000-0000-000000000000', '00000000-0000-0000-0000-000000000000', '1');


--
-- Data for Name: vm_templates; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO vm_templates (vmt_guid, name, mem_size_mb, os, creation_date, child_count, num_of_sockets, cpu_per_socket, description, vds_group_id, domain, num_of_monitors, status, usb_policy, time_zone, is_auto_suspend, fail_back, vm_type, hypervisor_type, operation_mode, nice_level, default_boot_sequence, default_display_type, priority, auto_startup, is_stateless, iso_path, initrd_url, kernel_url, kernel_params, origin, _update_date) VALUES ('00000000-0000-0000-0000-000000000000', 'Blank', 512, 0, '2008-04-01 00:00:00-05', 0, 1, 1, 'Blank template', '99408929-82cf-4dc7-a532-9d998063fa95', '', 1, 0, NULL, NULL, false, false, 0, 0, 0, 0, 0, 1, 0, NULL, NULL, '', NULL, NULL, NULL, 0, '2012-07-06 15:38:35.368955-05');


--
-- Name: engine_license_usage_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY engine_license_usage
    ADD CONSTRAINT engine_license_usage_pkey PRIMARY KEY (date);


--
-- Name: pk_action_version_map; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY action_version_map
    ADD CONSTRAINT pk_action_version_map PRIMARY KEY (action_type);


--
-- Name: pk_ad_group_id; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY ad_groups
    ADD CONSTRAINT pk_ad_group_id PRIMARY KEY (id);


--
-- Name: pk_async_tasks; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY async_tasks
    ADD CONSTRAINT pk_async_tasks PRIMARY KEY (task_id);


--
-- Name: pk_audit_log; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY audit_log
    ADD CONSTRAINT pk_audit_log PRIMARY KEY (audit_log_id);


--
-- Name: pk_bookmarks; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY bookmarks
    ADD CONSTRAINT pk_bookmarks PRIMARY KEY (bookmark_id);


--
-- Name: pk_custom_actions; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY custom_actions
    ADD CONSTRAINT pk_custom_actions PRIMARY KEY (action_name, tab);


--
-- Name: pk_disk_image_dynamic; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY disk_image_dynamic
    ADD CONSTRAINT pk_disk_image_dynamic PRIMARY KEY (image_id);


--
-- Name: pk_disks; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY disks
    ADD CONSTRAINT pk_disks PRIMARY KEY (disk_id);


--
-- Name: pk_event_map; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY event_map
    ADD CONSTRAINT pk_event_map PRIMARY KEY (event_up_name);


--
-- Name: pk_event_notification_methods; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY event_notification_methods
    ADD CONSTRAINT pk_event_notification_methods PRIMARY KEY (method_id);


--
-- Name: pk_event_subscriber; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY event_subscriber
    ADD CONSTRAINT pk_event_subscriber PRIMARY KEY (subscriber_id, event_up_name, method_id, tag_name);


--
-- Name: pk_id; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY business_entity_snapshot
    ADD CONSTRAINT pk_id PRIMARY KEY (id);


--
-- Name: pk_image_group_storage_domain_map; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY image_group_storage_domain_map
    ADD CONSTRAINT pk_image_group_storage_domain_map PRIMARY KEY (image_group_id, storage_domain_id);


--
-- Name: pk_image_templates; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY image_templates
    ADD CONSTRAINT pk_image_templates PRIMARY KEY (it_guid);


--
-- Name: pk_image_vm_map; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY image_vm_map
    ADD CONSTRAINT pk_image_vm_map PRIMARY KEY (image_id, vm_id);


--
-- Name: pk_image_vm_pool_map; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY image_vm_pool_map
    ADD CONSTRAINT pk_image_vm_pool_map PRIMARY KEY (image_guid);


--
-- Name: pk_images; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY images
    ADD CONSTRAINT pk_images PRIMARY KEY (image_guid);


--
-- Name: pk_lun_storage_server_connection_map; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY lun_storage_server_connection_map
    ADD CONSTRAINT pk_lun_storage_server_connection_map PRIMARY KEY (lun_id, storage_server_connection);


--
-- Name: pk_luns; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY luns
    ADD CONSTRAINT pk_luns PRIMARY KEY (lun_id);


--
-- Name: pk_network; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY network
    ADD CONSTRAINT pk_network PRIMARY KEY (id);


--
-- Name: pk_network_cluster; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY network_cluster
    ADD CONSTRAINT pk_network_cluster PRIMARY KEY (network_id, cluster_id);


--
-- Name: pk_permissions_id; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY permissions
    ADD CONSTRAINT pk_permissions_id PRIMARY KEY (id);


--
-- Name: pk_repo_file_meta_data; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY repo_file_meta_data
    ADD CONSTRAINT pk_repo_file_meta_data PRIMARY KEY (repo_domain_id, repo_file_name);


--
-- Name: pk_roles_groups; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY roles_groups
    ADD CONSTRAINT pk_roles_groups PRIMARY KEY (role_id, action_group_id);


--
-- Name: pk_roles_id; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY roles
    ADD CONSTRAINT pk_roles_id PRIMARY KEY (id);


--
-- Name: pk_roles_relations; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY roles_relations
    ADD CONSTRAINT pk_roles_relations PRIMARY KEY (role_id, role_container_id);


--
-- Name: pk_stateless_vm_image_map; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY stateless_vm_image_map
    ADD CONSTRAINT pk_stateless_vm_image_map PRIMARY KEY (image_guid);


--
-- Name: pk_storage; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY storage_domain_static
    ADD CONSTRAINT pk_storage PRIMARY KEY (id);


--
-- Name: pk_storage_domain_dynamic; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY storage_domain_dynamic
    ADD CONSTRAINT pk_storage_domain_dynamic PRIMARY KEY (id);


--
-- Name: pk_storage_domain_pool_map; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY storage_pool_iso_map
    ADD CONSTRAINT pk_storage_domain_pool_map PRIMARY KEY (storage_id, storage_pool_id);


--
-- Name: pk_storage_pool; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY storage_pool
    ADD CONSTRAINT pk_storage_pool PRIMARY KEY (id);


--
-- Name: pk_storage_server; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY storage_server_connections
    ADD CONSTRAINT pk_storage_server PRIMARY KEY (id);


--
-- Name: pk_tags_id; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY tags
    ADD CONSTRAINT pk_tags_id PRIMARY KEY (tag_id);


--
-- Name: pk_tags_user_group_map; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY tags_user_group_map
    ADD CONSTRAINT pk_tags_user_group_map PRIMARY KEY (tag_id, group_id);


--
-- Name: pk_tags_user_map; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY tags_user_map
    ADD CONSTRAINT pk_tags_user_map PRIMARY KEY (tag_id, user_id);


--
-- Name: pk_tags_vds_map; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY tags_vds_map
    ADD CONSTRAINT pk_tags_vds_map PRIMARY KEY (tag_id, vds_id);


--
-- Name: pk_tags_vm_map; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY tags_vm_map
    ADD CONSTRAINT pk_tags_vm_map PRIMARY KEY (tag_id, vm_id);


--
-- Name: pk_tags_vm_pool_map; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY tags_vm_pool_map
    ADD CONSTRAINT pk_tags_vm_pool_map PRIMARY KEY (tag_id, vm_pool_id);


--
-- Name: pk_time_user_vm_pool_map; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY time_lease_vm_pool_map
    ADD CONSTRAINT pk_time_user_vm_pool_map PRIMARY KEY (vm_pool_id, id);


--
-- Name: pk_user_sessions; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY user_sessions
    ADD CONSTRAINT pk_user_sessions PRIMARY KEY (user_id, session_id);


--
-- Name: pk_users; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY users
    ADD CONSTRAINT pk_users PRIMARY KEY (user_id);


--
-- Name: pk_vdc_db_log; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vdc_db_log
    ADD CONSTRAINT pk_vdc_db_log PRIMARY KEY (error_id);


--
-- Name: pk_vdc_options; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vdc_options
    ADD CONSTRAINT pk_vdc_options PRIMARY KEY (option_id);


--
-- Name: pk_vds_dynamic; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vds_dynamic
    ADD CONSTRAINT pk_vds_dynamic PRIMARY KEY (vds_id);


--
-- Name: pk_vds_groups; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vds_groups
    ADD CONSTRAINT pk_vds_groups PRIMARY KEY (vds_group_id);


--
-- Name: pk_vds_interface; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vds_interface
    ADD CONSTRAINT pk_vds_interface PRIMARY KEY (id);


--
-- Name: pk_vds_interface_statistics; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vds_interface_statistics
    ADD CONSTRAINT pk_vds_interface_statistics PRIMARY KEY (id);


--
-- Name: pk_vds_spm_id_map; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vds_spm_id_map
    ADD CONSTRAINT pk_vds_spm_id_map PRIMARY KEY (storage_pool_id, vds_spm_id);


--
-- Name: pk_vds_static; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vds_static
    ADD CONSTRAINT pk_vds_static PRIMARY KEY (vds_id);


--
-- Name: pk_vds_statistics; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vds_statistics
    ADD CONSTRAINT pk_vds_statistics PRIMARY KEY (vds_id);


--
-- Name: pk_vm_dynamic; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm_dynamic
    ADD CONSTRAINT pk_vm_dynamic PRIMARY KEY (vm_guid);


--
-- Name: pk_vm_interface; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm_interface
    ADD CONSTRAINT pk_vm_interface PRIMARY KEY (id);


--
-- Name: pk_vm_interface_statistics; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm_interface_statistics
    ADD CONSTRAINT pk_vm_interface_statistics PRIMARY KEY (id);


--
-- Name: pk_vm_pool_map; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm_pool_map
    ADD CONSTRAINT pk_vm_pool_map PRIMARY KEY (vm_guid);


--
-- Name: pk_vm_pools; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm_pools
    ADD CONSTRAINT pk_vm_pools PRIMARY KEY (vm_pool_id);


--
-- Name: pk_vm_static; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm_static
    ADD CONSTRAINT pk_vm_static PRIMARY KEY (vm_guid);


--
-- Name: pk_vm_statistics; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm_statistics
    ADD CONSTRAINT pk_vm_statistics PRIMARY KEY (vm_guid);


--
-- Name: pk_vm_template_image_map; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm_template_image_map
    ADD CONSTRAINT pk_vm_template_image_map PRIMARY KEY (it_guid, vmt_guid);


--
-- Name: pk_vm_templates; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm_templates
    ADD CONSTRAINT pk_vm_templates PRIMARY KEY (vmt_guid);


--
-- Name: schema_version_primary_key; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY schema_version
    ADD CONSTRAINT schema_version_primary_key PRIMARY KEY (id);


--
-- Name: uq_command_id_entity_id; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY business_entity_snapshot
    ADD CONSTRAINT uq_command_id_entity_id UNIQUE (command_id, entity_id, entity_type, snapshot_type);


--
-- Name: idx_audit_log_log_time; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX idx_audit_log_log_time ON audit_log USING btree (log_time);


--
-- Name: idx_audit_log_storage_domain_name; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX idx_audit_log_storage_domain_name ON audit_log USING btree (storage_domain_name);


--
-- Name: idx_audit_log_storage_pool_name; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX idx_audit_log_storage_pool_name ON audit_log USING btree (storage_pool_name);


--
-- Name: idx_audit_log_user_name; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX idx_audit_log_user_name ON audit_log USING btree (user_name);


--
-- Name: idx_audit_log_vds_name; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX idx_audit_log_vds_name ON audit_log USING btree (vds_name);


--
-- Name: idx_audit_log_vm_name; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX idx_audit_log_vm_name ON audit_log USING btree (vm_name);


--
-- Name: idx_audit_log_vm_template_name; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX idx_audit_log_vm_template_name ON audit_log USING btree (vm_template_name);


--
-- Name: idx_business_entity_snapshot_command_id; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX idx_business_entity_snapshot_command_id ON business_entity_snapshot USING btree (command_id);


--
-- Name: idx_combined_ad_role_object; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE UNIQUE INDEX idx_combined_ad_role_object ON permissions USING btree (ad_element_id, role_id, object_id);


--
-- Name: idx_permissions_ad_element_id; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX idx_permissions_ad_element_id ON permissions USING btree (ad_element_id);


--
-- Name: idx_permissions_object_id; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX idx_permissions_object_id ON permissions USING btree (object_id);


--
-- Name: idx_permissions_role_id; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX idx_permissions_role_id ON permissions USING btree (role_id);


--
-- Name: idx_repo_file_file_type; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX idx_repo_file_file_type ON repo_file_meta_data USING btree (file_type);


--
-- Name: idx_roles_groups_action_group_id; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX idx_roles_groups_action_group_id ON roles_groups USING btree (action_group_id);


--
-- Name: idx_vds_interface_vds_id; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX idx_vds_interface_vds_id ON vds_interface USING btree (vds_id);


--
-- Name: idx_vm_dynamic_run_on_vds; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX idx_vm_dynamic_run_on_vds ON vm_dynamic USING btree (run_on_vds);


--
-- Name: idx_vm_interface_vm_vmt_guid; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX idx_vm_interface_vm_vmt_guid ON vm_interface USING btree (vm_guid, vmt_guid);


--
-- Name: idx_vm_static_vm_name; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX idx_vm_static_vm_name ON vm_static USING btree (vm_name);


--
-- Name: ix_vdc_options; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX ix_vdc_options ON vdc_options USING btree (option_name);


--
-- Name: fk_disk_active_image; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY disks
    ADD CONSTRAINT fk_disk_active_image FOREIGN KEY (active_image_id) REFERENCES images(image_guid) ON DELETE SET NULL;


--
-- Name: fk_disk_image_dynamic_images; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY disk_image_dynamic
    ADD CONSTRAINT fk_disk_image_dynamic_images FOREIGN KEY (image_id) REFERENCES images(image_guid) ON DELETE CASCADE;


--
-- Name: fk_event_notification_hist_audit_log; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY event_notification_hist
    ADD CONSTRAINT fk_event_notification_hist_audit_log FOREIGN KEY (audit_log_id) REFERENCES audit_log(audit_log_id) ON DELETE CASCADE;


--
-- Name: fk_event_notification_users; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY event_notification_hist
    ADD CONSTRAINT fk_event_notification_users FOREIGN KEY (subscriber_id) REFERENCES users(user_id) ON DELETE CASCADE;


--
-- Name: fk_event_subscriber_event_map; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY event_subscriber
    ADD CONSTRAINT fk_event_subscriber_event_map FOREIGN KEY (event_up_name) REFERENCES event_map(event_up_name) ON DELETE CASCADE;


--
-- Name: fk_event_subscriber_event_notification_methods; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY event_subscriber
    ADD CONSTRAINT fk_event_subscriber_event_notification_methods FOREIGN KEY (method_id) REFERENCES event_notification_methods(method_id) ON DELETE CASCADE;


--
-- Name: fk_event_subscriber_users; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY event_subscriber
    ADD CONSTRAINT fk_event_subscriber_users FOREIGN KEY (subscriber_id) REFERENCES users(user_id) ON DELETE CASCADE;


--
-- Name: fk_image_group_storage_domain_map_storage_domain_static; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY image_group_storage_domain_map
    ADD CONSTRAINT fk_image_group_storage_domain_map_storage_domain_static FOREIGN KEY (storage_domain_id) REFERENCES storage_domain_static(id) ON DELETE CASCADE;


--
-- Name: fk_image_vm_map_vm_static; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY image_vm_map
    ADD CONSTRAINT fk_image_vm_map_vm_static FOREIGN KEY (vm_id) REFERENCES vm_static(vm_guid) ON DELETE CASCADE;


--
-- Name: fk_images_storage_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY images
    ADD CONSTRAINT fk_images_storage_id FOREIGN KEY (storage_id) REFERENCES storage_domain_static(id);


--
-- Name: fk_lun_storage_server_connection_map_luns; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY lun_storage_server_connection_map
    ADD CONSTRAINT fk_lun_storage_server_connection_map_luns FOREIGN KEY (lun_id) REFERENCES luns(lun_id) ON DELETE CASCADE;


--
-- Name: fk_lun_storage_server_connection_map_storage_server_connections; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY lun_storage_server_connection_map
    ADD CONSTRAINT fk_lun_storage_server_connection_map_storage_server_connections FOREIGN KEY (storage_server_connection) REFERENCES storage_server_connections(id) ON DELETE CASCADE;


--
-- Name: fk_network_cluster_network; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY network_cluster
    ADD CONSTRAINT fk_network_cluster_network FOREIGN KEY (network_id) REFERENCES network(id) ON DELETE CASCADE;


--
-- Name: fk_network_cluster_vds_groups; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY network_cluster
    ADD CONSTRAINT fk_network_cluster_vds_groups FOREIGN KEY (cluster_id) REFERENCES vds_groups(vds_group_id) ON DELETE CASCADE;


--
-- Name: fk_network_storage_pool; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY network
    ADD CONSTRAINT fk_network_storage_pool FOREIGN KEY (storage_pool_id) REFERENCES storage_pool(id) ON DELETE SET NULL;


--
-- Name: fk_permissions_roles; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY permissions
    ADD CONSTRAINT fk_permissions_roles FOREIGN KEY (role_id) REFERENCES roles(id) ON DELETE CASCADE;


--
-- Name: fk_repo_file_meta_data_storage_domain_static; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY repo_file_meta_data
    ADD CONSTRAINT fk_repo_file_meta_data_storage_domain_static FOREIGN KEY (repo_domain_id) REFERENCES storage_domain_static(id) ON DELETE CASCADE;


--
-- Name: fk_roles_groups_action_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY roles_groups
    ADD CONSTRAINT fk_roles_groups_action_id FOREIGN KEY (role_id) REFERENCES roles(id) ON DELETE CASCADE;


--
-- Name: fk_roles_relations_container_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY roles_relations
    ADD CONSTRAINT fk_roles_relations_container_id FOREIGN KEY (role_container_id) REFERENCES roles(id);


--
-- Name: fk_roles_relations_role_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY roles_relations
    ADD CONSTRAINT fk_roles_relations_role_id FOREIGN KEY (role_id) REFERENCES roles(id);


--
-- Name: fk_stateless_vm_static; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY stateless_vm_image_map
    ADD CONSTRAINT fk_stateless_vm_static FOREIGN KEY (vm_guid) REFERENCES vm_static(vm_guid) ON DELETE CASCADE;


--
-- Name: fk_storage_domain_dynamic_storage_domain_static; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY storage_domain_dynamic
    ADD CONSTRAINT fk_storage_domain_dynamic_storage_domain_static FOREIGN KEY (id) REFERENCES storage_domain_static(id);


--
-- Name: fk_storage_domain_pool_map_storage_domain_static; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY storage_pool_iso_map
    ADD CONSTRAINT fk_storage_domain_pool_map_storage_domain_static FOREIGN KEY (storage_id) REFERENCES storage_domain_static(id) ON DELETE CASCADE;


--
-- Name: fk_storage_domain_pool_map_storage_pool; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY storage_pool_iso_map
    ADD CONSTRAINT fk_storage_domain_pool_map_storage_pool FOREIGN KEY (storage_pool_id) REFERENCES storage_pool(id) ON DELETE CASCADE;


--
-- Name: fk_tags_vm_pool_map_tag; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY tags_vm_pool_map
    ADD CONSTRAINT fk_tags_vm_pool_map_tag FOREIGN KEY (tag_id) REFERENCES tags(tag_id) ON DELETE CASCADE;


--
-- Name: fk_tags_vm_pool_map_vm_pool; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY tags_vm_pool_map
    ADD CONSTRAINT fk_tags_vm_pool_map_vm_pool FOREIGN KEY (vm_pool_id) REFERENCES vm_pools(vm_pool_id) ON DELETE CASCADE;


--
-- Name: fk_users; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY user_sessions
    ADD CONSTRAINT fk_users FOREIGN KEY (user_id) REFERENCES users(user_id) ON DELETE CASCADE;


--
-- Name: fk_vds_groups_storage_pool_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY vds_groups
    ADD CONSTRAINT fk_vds_groups_storage_pool_id FOREIGN KEY (storage_pool_id) REFERENCES storage_pool(id) ON DELETE SET NULL;


--
-- Name: fk_vds_groups_vm_pools; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY vm_pools
    ADD CONSTRAINT fk_vds_groups_vm_pools FOREIGN KEY (vds_group_id) REFERENCES vds_groups(vds_group_id);


--
-- Name: fk_vds_interface_statistics_vds_static; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY vds_interface_statistics
    ADD CONSTRAINT fk_vds_interface_statistics_vds_static FOREIGN KEY (vds_id) REFERENCES vds_static(vds_id) ON DELETE CASCADE;


--
-- Name: fk_vds_interface_vds_interface; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY vds_interface
    ADD CONSTRAINT fk_vds_interface_vds_interface FOREIGN KEY (vds_id) REFERENCES vds_static(vds_id) ON DELETE CASCADE;


--
-- Name: fk_vds_spm_id_map_storage_pool; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY vds_spm_id_map
    ADD CONSTRAINT fk_vds_spm_id_map_storage_pool FOREIGN KEY (storage_pool_id) REFERENCES storage_pool(id) ON DELETE CASCADE;


--
-- Name: fk_vds_spm_id_map_vds_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY vds_spm_id_map
    ADD CONSTRAINT fk_vds_spm_id_map_vds_id FOREIGN KEY (vds_id) REFERENCES vds_static(vds_id) ON DELETE CASCADE;


--
-- Name: fk_vds_static_vm_static; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY vm_static
    ADD CONSTRAINT fk_vds_static_vm_static FOREIGN KEY (dedicated_vm_for_vds) REFERENCES vds_static(vds_id);


--
-- Name: fk_vm_interface_statistics_vm_static; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY vm_interface_statistics
    ADD CONSTRAINT fk_vm_interface_statistics_vm_static FOREIGN KEY (vm_id) REFERENCES vm_static(vm_guid) ON DELETE CASCADE;


--
-- Name: fk_vm_interface_vm_static; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY vm_interface
    ADD CONSTRAINT fk_vm_interface_vm_static FOREIGN KEY (vm_guid) REFERENCES vm_static(vm_guid) ON DELETE CASCADE;


--
-- Name: image_templates_images; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY images
    ADD CONSTRAINT image_templates_images FOREIGN KEY (it_guid) REFERENCES image_templates(it_guid);


--
-- Name: image_templates_vm_template_image_map; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY vm_template_image_map
    ADD CONSTRAINT image_templates_vm_template_image_map FOREIGN KEY (it_guid) REFERENCES image_templates(it_guid);


--
-- Name: tags_user_group_map_tag; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY tags_user_group_map
    ADD CONSTRAINT tags_user_group_map_tag FOREIGN KEY (tag_id) REFERENCES tags(tag_id);


--
-- Name: tags_user_map_tag; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY tags_user_map
    ADD CONSTRAINT tags_user_map_tag FOREIGN KEY (tag_id) REFERENCES tags(tag_id);


--
-- Name: tags_user_map_user; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY tags_user_map
    ADD CONSTRAINT tags_user_map_user FOREIGN KEY (user_id) REFERENCES users(user_id);


--
-- Name: tags_user_map_user_group; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY tags_user_group_map
    ADD CONSTRAINT tags_user_map_user_group FOREIGN KEY (group_id) REFERENCES ad_groups(id);


--
-- Name: tags_vds_map_tag; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY tags_vds_map
    ADD CONSTRAINT tags_vds_map_tag FOREIGN KEY (tag_id) REFERENCES tags(tag_id);


--
-- Name: tags_vds_map_vds; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY tags_vds_map
    ADD CONSTRAINT tags_vds_map_vds FOREIGN KEY (vds_id) REFERENCES vds_static(vds_id);


--
-- Name: tags_vm_map_tag; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY tags_vm_map
    ADD CONSTRAINT tags_vm_map_tag FOREIGN KEY (tag_id) REFERENCES tags(tag_id);


--
-- Name: tags_vm_map_vm; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY tags_vm_map
    ADD CONSTRAINT tags_vm_map_vm FOREIGN KEY (vm_id) REFERENCES vm_static(vm_guid) ON DELETE CASCADE;


--
-- Name: vds_groups_vds_static; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY vds_static
    ADD CONSTRAINT vds_groups_vds_static FOREIGN KEY (vds_group_id) REFERENCES vds_groups(vds_group_id);


--
-- Name: vds_groups_vm_static; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY vm_static
    ADD CONSTRAINT vds_groups_vm_static FOREIGN KEY (vds_group_id) REFERENCES vds_groups(vds_group_id);


--
-- Name: vds_groups_vm_templates; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY vm_templates
    ADD CONSTRAINT vds_groups_vm_templates FOREIGN KEY (vds_group_id) REFERENCES vds_groups(vds_group_id);


--
-- Name: vds_static_vds_dynamic; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY vds_dynamic
    ADD CONSTRAINT vds_static_vds_dynamic FOREIGN KEY (vds_id) REFERENCES vds_static(vds_id);


--
-- Name: vds_static_vds_statistics; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY vds_statistics
    ADD CONSTRAINT vds_static_vds_statistics FOREIGN KEY (vds_id) REFERENCES vds_static(vds_id);


--
-- Name: vds_static_vm_dynamic_m; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY vm_dynamic
    ADD CONSTRAINT vds_static_vm_dynamic_m FOREIGN KEY (migrating_to_vds) REFERENCES vds_static(vds_id);


--
-- Name: vds_static_vm_dynamic_r; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY vm_dynamic
    ADD CONSTRAINT vds_static_vm_dynamic_r FOREIGN KEY (run_on_vds) REFERENCES vds_static(vds_id);


--
-- Name: vm_guid_pools; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY vm_pool_map
    ADD CONSTRAINT vm_guid_pools FOREIGN KEY (vm_guid) REFERENCES vm_static(vm_guid) ON DELETE CASCADE;


--
-- Name: vm_pool_map_image; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY image_vm_pool_map
    ADD CONSTRAINT vm_pool_map_image FOREIGN KEY (vm_guid) REFERENCES vm_pool_map(vm_guid) ON DELETE CASCADE;


--
-- Name: vm_pools_vm; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY vm_pool_map
    ADD CONSTRAINT vm_pools_vm FOREIGN KEY (vm_pool_id) REFERENCES vm_pools(vm_pool_id);


--
-- Name: vm_static_vm_dynamic; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY vm_dynamic
    ADD CONSTRAINT vm_static_vm_dynamic FOREIGN KEY (vm_guid) REFERENCES vm_static(vm_guid) ON DELETE CASCADE;


--
-- Name: vm_static_vm_statistics; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY vm_statistics
    ADD CONSTRAINT vm_static_vm_statistics FOREIGN KEY (vm_guid) REFERENCES vm_static(vm_guid) ON DELETE CASCADE;


--
-- Name: vm_templates_vm_static; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY vm_static
    ADD CONSTRAINT vm_templates_vm_static FOREIGN KEY (vmt_guid) REFERENCES vm_static(vm_guid);


--
-- Name: vm_templates_vm_template_image_map; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY vm_template_image_map
    ADD CONSTRAINT vm_templates_vm_template_image_map FOREIGN KEY (vmt_guid) REFERENCES vm_templates(vmt_guid);


--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- PostgreSQL database dump complete
--

