%define promisc_name vdsm-hook-promisc
%define vdsm_name vdsm

Summary: Network interface promiscuous mode support for Red-Hat VDSM
Name: vdsm-hook-promisc
Source: %{promisc_name}.tar.gz
Version: 1.0
Vendor: Red-Had
Release: 1%{?dist}
License: GPLv2+
Group: Applications/System
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}
ExclusiveArch: x86_64
Requires: vdsm

%description
VDSM promiscuous mode let user define a VM interface that will capture
all network traffic.

%prep
%setup -c -q

%build

%install
rm -rf $RPM_BUILD_ROOT

make -C %{_builddir}/%{name}-%{version} PREFIX="%{buildroot}" \
    LIBEXECDIR=%{_libexecdir}/%{vdsm_name} \
    install

%clean
rm -rf $RPM_BUILD_ROOT

%files
%attr (755,vdsm,kvm) %{_libexecdir}/vdsm/hooks/after_vm_start/50_promisc
%attr (755,vdsm,kvm) %{_libexecdir}/vdsm/hooks/after_vm_destroy/50_promisc
%attr (440,root,root) %{_sysconfdir}/sudoers.d/50_vdsm_hook_promisc
%attr (755,vdsm,kvm) %{_libexecdir}/vdsm/hooks/after_vm_migrate_destination/50_promisc
%attr (755,vdsm,kvm) %{_libexecdir}/vdsm/hooks/after_vm_migrate_source/50_promisc

%post
# update sudoers
tmp_sudoers=$(mktemp)
cp -a /etc/sudoers $tmp_sudoers
/bin/sed -i -e "/# vdsm-hook-promisc/,/# end vdsm-hook-promisc/d" $tmp_sudoers

cat >> $tmp_sudoers <<EOF
# vdsm-hook-promisc customizations
#include /etc/sudoers.d/50_vdsm_hook_promisc
# end vdsm-hook-promisc customizations
EOF

cp -a $tmp_sudoers /etc/sudoers
rm -f $tmp_sudoers


%postun
if [ "$1" -eq 0 ]; then
    # remove updated sudoers
    tmp_sudoers=$(mktemp)
    cp -a /etc/sudoers $tmp_sudoers
    /bin/sed -i -e "/# vdsm-hook-promisc/,/# end vdsm-hook-promisc/d" $tmp_sudoers
    cp -a $tmp_sudoers /etc/sudoers
    rm -f $tmp_sudoers
fi
exit 0

%doc

%changelog
